/*
 * Decompiled with CFR 0.152.
 */
package org.kd.anniversaries;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.Arrays;
import java.util.List;
import org.kd.anniversaries.StaticData;
import org.kd.anniversaries.Year;
import org.kd.anniversaries.Year1971;
import org.kd.anniversaries.Year1976;
import org.kd.anniversaries.Year1981;
import org.kd.anniversaries.Year1986;
import org.kd.anniversaries.Year1991;
import org.kd.anniversaries.Year1996;
import org.kd.anniversaries.Year2001;
import org.kd.anniversaries.Year2006;
import org.kd.anniversaries.Year2011;
import org.kd.anniversaries.Year2016;
import org.kd.anniversaries.Year2021;
import org.kd.common.BasicC64Screen;
import org.kd.common.C64Colors;
import org.kd.common.C64Helper;
import org.kd.common.TravellingLogo;

public class Scene1c64
extends BasicC64Screen {
    private final long startAnniversariesDisplay = 4099L;
    SpriteBatch batch2;
    BitmapFont normalFont;
    private ShapeRenderer shapeRenderer;
    private TravellingLogo logoSprite;
    private Music gravitationRamos;
    private int bottomLimit = 170;
    private Year2021 year2021;
    private Year2016 year2016;
    private Year2011 year2011;
    private Year2006 year2006;
    private Year2001 year2001;
    private Year1996 year1996;
    private Year1991 year1991;
    private Year1986 year1986;
    private Year1981 year1981;
    private Year1976 year1976;
    private Year1971 year1971;
    private long outroBeginFrame;
    private Music thanksForWatching;

    public Scene1c64(String id) {
        super(id);
    }

    @Override
    public void create() {
        super.create();
        this.year2021 = new Year2021(4099L);
        this.year2016 = new Year2016(this.year2021.getEndFrame());
        this.year2011 = new Year2011(this.year2016.getEndFrame());
        this.year2006 = new Year2006(this.year2011.getEndFrame());
        this.year2001 = new Year2001(this.year2006.getEndFrame());
        this.year1996 = new Year1996(this.year2001.getEndFrame());
        this.year1991 = new Year1991(this.year1996.getEndFrame());
        this.year1986 = new Year1986(this.year1991.getEndFrame());
        this.year1981 = new Year1981(this.year1986.getEndFrame());
        this.year1976 = new Year1976(this.year1981.getEndFrame());
        this.year1971 = new Year1971(this.year1976.getEndFrame());
        this.outroBeginFrame = this.year1971.getEndFrame() + 300L;
        this.createMusic();
        this.batch2 = new SpriteBatch(2);
        this.normalFont = C64Helper.createFont(16, "C64_Pro_Mono-STYLE.ttf");
        this.normalFont.setColor(C64Colors.LIGHT_BLUE.toBadlogicColor());
        Texture logoTxtr = new Texture(Gdx.files.internal("anniversaries/logo.png"));
        this.logoSprite = new TravellingLogo(logoTxtr, 800.0f, 110.0f, 1000.0f, 50.0f);
        this.logoSprite.colorize(C64Colors.LIGHT_BLUE);
        this.logoSprite.spriteSpeed = 300.0f;
        this.shapeRenderer = new ShapeRenderer();
    }

    @Override
    public void update(float delta) {
        long frame = Gdx.graphics.getFrameId();
        if (frame >= 330L) {
            this.logoSprite.move(delta, 800);
            if (frame >= 500L && (this.logoSprite.getX() < -355.0f || this.logoSprite.getX() > 260.0f)) {
                this.logoSprite.changeDirection();
            }
        }
        if (frame > 3255L) {
            System.out.println("\n".repeat(50) + " Elapsed time " + C64Helper.countElapsedTime() + " Frame: " + frame);
        }
    }

    @Override
    public void render() {
        Sprite ls;
        super.render();
        long frame = Gdx.graphics.getFrameId();
        if (frame == 3570L) {
            this.borderColor = C64Colors.BLACK;
        }
        if (frame > 3570L && frame < 4097L) {
            this.hideBottomPart();
        }
        this.batch2.begin();
        this.textWall(StaticData.messages1, frame, 800, 1811);
        this.textWall(StaticData.messages2, frame, 1850, 2922);
        this.textWall(StaticData.messages3, frame, 3000, 3600);
        if (frame > 3670L) {
            boolean extraCondition;
            this.logoSprite.colorize(C64Colors.WHITE);
            if (frame % 5L == 0L && this.logoSprite.getSprite().getY() > 10.0f) {
                Sprite sprite = this.logoSprite.getSprite();
                sprite.setY(sprite.getY() - 1.0f);
            }
            boolean bl = extraCondition = frame > 3702L || frame % 2L == 1L;
            if (this.bottomLimit < 550 && extraCondition) {
                ++this.bottomLimit;
            }
        }
        if (frame > 3790L) {
            this.conditionallyColorizeLogo(frame);
        }
        if (frame > 4099L && frame <= this.year1971.getEndFrame() + 300L) {
            this.displayAnniversary(frame);
        }
        if (frame > 10L) {
            this.logoSprite.draw(this.batch2, 800, 600);
            this.gravitationRamos.play();
        }
        if (frame > this.year1971.getEndFrame() && (ls = this.logoSprite.getSprite()).getY() < 500.0f) {
            ls.setY(ls.getY() + 2.0f);
        }
        if (frame > this.outroBeginFrame) {
            this.outro();
        }
        this.batch2.end();
    }

    private void outro() {
        this.backgroundScreenPng = "c64.png";
        this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
        this.blinkingCursor = true;
        long frame = Gdx.graphics.getFrameId();
        if (frame > this.outroBeginFrame + 200L) {
            this.borderColor = C64Colors.LIGHT_BLUE;
            this.logoSprite.colorize(C64Colors.BLUE);
        }
        this.textWall(StaticData.outroMessages1, frame, Math.round(this.outroBeginFrame + 300L), Math.round(this.outroBeginFrame + 700L));
        this.textWall(StaticData.outroMessages2, frame, Math.round(this.outroBeginFrame + 750L), Math.round(this.outroBeginFrame + 1200L));
        this.textWall(StaticData.outroMessages3, frame, Math.round(this.outroBeginFrame + 1200L), Math.round(this.outroBeginFrame + 1650L));
        if (frame == this.outroBeginFrame + 1200L) {
            this.gravitationRamos.stop();
            this.thanksForWatching.play();
        } else if (frame > this.outroBeginFrame + 1650L) {
            Gdx.app.exit();
            System.out.println("\n".repeat(50) + "End demo: " + C64Helper.countElapsedTime() + " frame = " + frame);
            this.dispose();
            System.exit(0);
        }
    }

    private void hideBottomPart() {
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(this.borderColor.toBadlogicColor());
        this.shapeRenderer.rect(0.0f, 0.0f, 800.0f, this.bottomLimit);
        this.shapeRenderer.end();
    }

    private void displayAnniversary(long frame) {
        this.blinkingCursor = false;
        List<Year> allYears = Arrays.asList(this.year2021, this.year2016, this.year2011, this.year2006, this.year2001, this.year1996, this.year1991, this.year1986, this.year1981, this.year1976, this.year1971);
        for (int i = 0; i < allYears.size() - 1; ++i) {
            if (frame <= allYears.get((int)i).startingFrame || frame >= allYears.get((int)(i + 1)).startingFrame) continue;
            this.borderColor = C64Colors.DARK_GRAY;
            allYears.get(i).sayItOnce();
            allYears.get(i).draw(frame, this);
        }
        if (frame > this.year1971.startingFrame && frame <= this.year1971.getEndFrame()) {
            this.year1971.sayItOnce();
            this.year1971.draw(frame, this);
        }
    }

    private void conditionallyColorizeLogo(long frame) {
        if (frame > this.outroBeginFrame + 200L) {
            return;
        }
        if (frame % 1200L < 150L) {
            this.logoSprite.colorize(C64Colors.YELLOW);
        } else if (frame % 1200L < 300L) {
            this.logoSprite.colorize(C64Colors.RED);
        } else if (frame % 1200L < 450L) {
            this.logoSprite.colorize(C64Colors.LIGHT_GRAY);
        } else if (frame % 1200L < 600L) {
            this.logoSprite.colorize(C64Colors.LIGHT_BLUE);
        } else if (frame % 1200L < 750L) {
            this.logoSprite.colorize(C64Colors.PURPLE);
        } else if (frame % 1200L < 900L) {
            this.logoSprite.colorize(C64Colors.CYAN);
        } else if (frame % 1200L < 1050L) {
            this.logoSprite.colorize(C64Colors.PINK);
        } else {
            this.logoSprite.colorize(C64Colors.WHITE);
        }
    }

    private void textWall(List<String> messages, long frame, int veryInitialFrame, int endFrame) {
        for (int i = 0; i < messages.size(); ++i) {
            int fontSize = 22 * (i + 1);
            this.drawMessage(this.batch2, this.normalFont, frame, veryInitialFrame + 150 * i, endFrame, messages.get(i), fontSize);
        }
    }

    private void drawMessage(SpriteBatch batch, BitmapFont font, long currentFrame, int startFrame, int endFrame, String msg, int shiftY) {
        if (currentFrame > (long)startFrame && currentFrame < (long)endFrame) {
            font.draw((Batch)batch, msg, 81.0f, (float)(406 - shiftY));
        }
    }

    private void flySprites(List<Sprite> spriteGroup) {
        for (int i = 0; i < spriteGroup.size(); ++i) {
            Sprite s = spriteGroup.get(i);
            this.flyCaptionSprite(s, i);
        }
    }

    private void createMusic() {
        this.gravitationRamos = Gdx.audio.newMusic(Gdx.files.internal("anniversaries/Gravitation.mp3"));
        this.gravitationRamos.setLooping(false);
        this.gravitationRamos.setVolume(2.0f);
        this.thanksForWatching = Gdx.audio.newMusic(Gdx.files.internal("anniversaries/Thanks for watching.mp3"));
    }

    private void flyCaptionSprite(Sprite s, int i) {
        s.draw(this.batch2);
        s.setX(s.getX() + (float)(i + 1));
        s.setY(s.getY() - (float)(i - 1));
        s.setScale(s.getScaleX() + 0.01f, s.getScaleY() + 0.01f);
        s.setAlpha(1.0f);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.batch2.dispose();
        this.gravitationRamos.dispose();
    }
}

