#include <ddlib.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>
#include <unistd.h>

#define INTERVAL 10000	/* ten second interval */

void die(struct dif *d)
{
  //exit(1);
  pid_t pid;
  kill(pid, SIGKILL);
  dd_close(d);
}

main(int argc,char *argv[]) {
  struct dif *d;
  char ddpath[255];
  int rc, i;
  char keypress;
  struct itimerval it_val;

  // get dd env
  strncpy(ddpath, getenv("DAYDREAM"), 255);

  d = dd_initdoor(argv[1]);

  it_val.it_value.tv_sec = INTERVAL/1000;
  it_val.it_value.tv_usec = (INTERVAL*1000) % 1000000;
  it_val.it_interval = it_val.it_value;
  if (setitimer(ITIMER_REAL, &it_val, NULL) == -1) {
    perror("error calling setitimer()");
    exit(1);
  }

  dd_sendstring(d,"Press <esc> or <tab> twice within 10 seconds to continue...\n");
  for (i=0; i<=1; i++)
  {
    keypress = 0;
    while (!(keypress == 27 || keypress == 9))
    {
      keypress = getchar();
    }
  }
  dd_close(d);
};
