
(*
** Additional keyboard unit
**
** Added:
** - new getekey-function (keyboardhandler)
** - new input-function (makes use of new getekey + esc fixed)
**
** By Bas van Gaalen
*)

unit keyboard;

interface

uses u_misc;

type
  scrsavetype=procedure;
  getkeytype=record
    clockon:boolean;
    scrsavetime:word;
    colattr,xpos,ypos:byte;
  end;

var
  keyhandlerproc:function(key:word):boolean;
  scrsaveproc:scrsavetype;
  keybehave:getkeytype;

function getekey:word;

procedure waitkey(stoptime:word);

function input(
  xi,yi:byte;
  var editline:str80;
  allowed:charset;
  maxlen,
  color,
  endcolor:byte;
  uppcase:casetype;
  endpos:byte):word;

{----------------------------------------------------------------------------}

implementation

uses dos,u_txt,u_kb;

procedure clock(deadline:longint; var escape:boolean);
var savescr:pointer; hour,min,sec,hsec:word; total:longint; dot:char;
  function lz(w:word; maxlen:byte):string; var s:string; begin
    str(w:0,s); while length(s)<maxlen do s:='0'+s; lz:=s; end;
begin
  gettime(hour,min,sec,hsec);
  if deadline<>0 then begin
    total:=hour*3600+min*60+sec;
    if total>deadline then begin
      setscr; scrsaveproc; getscr; escape:=true; end;
  end;
  if hsec<50 then dot:=':' else dot:='.';
  dspat(lz(hour,2)+':'+lz(min,2)+dot+lz(sec,2),keybehave.xpos,keybehave.ypos,keybehave.colattr);
end;

procedure waitkey(stoptime:word);
var sst,stop,total:longint; key,hour,min,sec,hsec:word; escape:boolean;
begin
  gettime(hour,min,sec,hsec);
  if keybehave.scrsavetime<>0 then
    sst:=hour*3600+min*60+sec+keybehave.scrsavetime
  else sst:=0;
  if stoptime<>0 then stop:=hour*3600+min*60+sec+stoptime else stop:=0;
  escape:=false;
  repeat
    if keybehave.clockon then clock(sst,escape);
    if stop<>0 then begin
      gettime(hour,min,sec,hsec);
      total:=hour*3600+min*60+sec;
      if total>stop then escape:=true;
    end;
    if keypressed then begin
      key:=ord(readkey);
      if key=0 then key:=ord(readkey) shl 8;
      if addr(keyhandlerproc)<>nil then escape:=not keyhandlerproc(key);
      { keyhandlerproc returns 'true' if a valid key was pressed:
        escape should be the other way around: hence the 'not'. }
    end;
  until escape;
  clearkeybuf;
end;

function getekey:word;
var sst:longint; key,hour,min,sec,hsec:word; x,y:byte; kp,escape:boolean;
begin
  x:=getx; y:=gety;
  if keybehave.scrsavetime<>0 then begin
    gettime(hour,min,sec,hsec);
    sst:=hour*3600+min*60+sec+keybehave.scrsavetime;
  end else sst:=0;
  escape:=false;
  repeat
    if keybehave.clockon then clock(sst,escape);
    if keypressed then begin
      key:=ord(readkey);
      if key=0 then key:=ord(readkey) shl 8;
      if addr(keyhandlerproc)<>nil then escape:=not keyhandlerproc(key);
      { keyhandlerproc returns 'true' if a valid key was pressed:
        escape should be the other way around: hence the 'not'. }
      if not escape then key:=0;
    end;
  until escape;
  getekey:=key;
  placecursor(x,y);
end;

function input;
var last,old,tmp,prtstr:str80; key,cshape:word; i,tab,curpos:byte; first,esc:boolean;
begin
  tmp:=editline; old:=#255; last:=tmp; esc:=false; first:=true; curpos:=length(tmp);
  cshape:=getcursorshape;
  fillattr(xi+maxlen,yi,xi+maxlen,yi,color and $f or (getattr(xi+maxlen,yi) and $f0));
  if inputbehave.initinsert then setinskey else clearinskey;
  repeat
    if getinskey then halfcursor else linecursor;
    if old<>tmp then begin
      fillchar(prtstr,sizeof(prtstr),#177); { <- hardcoded pad-char }
      prtstr[0]:=chr(maxlen);
      move(tmp[1],prtstr[1],length(tmp));
      dspat(prtstr,xi,yi,color);
      old:=tmp;
    end;
    placecursor(xi+curpos,yi);
    key:=getekey;
    case key of
      crsrcr,
      crsrtab,
      crsrstab,
      crsrup,
      crsrdown:begin
        esc:=true;
        if inputbehave.persistant or (key=crsrcr) then editline:=tmp else editline:=last;
        input:=key;
      end;
      crsresc:begin esc:=true; editline:=last; input:=key; end;
      crsrchome:begin fillchar(tmp,maxlen,#0); curpos:=0; end;
      crsrbs:if curpos>0 then begin delete(tmp,curpos,1); dec(curpos); end;
      crsrhome:curpos:=0;
      crsrend:curpos:=length(tmp);
      crsrright:if curpos<length(tmp) then inc(curpos);
      crsrleft:if curpos>0 then dec(curpos);
      crsrdel:delete(tmp,curpos+1,1);
      else begin
        if chr(key) in allowed then begin
          if first and inputbehave.destructive then begin
            fillchar(tmp,maxlen,#0); curpos:=0; end;
          if ((uppcase=efirst) and (curpos=0)) or
             ((uppcase=efirst) and (tmp[curpos]=' ')) or
             ((uppcase=ofirst) and (curpos=0)) or
             (uppcase=all) then key:=ord(upcase(chr(key)));
          if getinskey then begin                         { write key to tmp }
            if length(tmp)<maxlen then begin
              insert(chr(key),tmp,curpos+1); inc(curpos); end;
          end { insert }
          else begin
            if curpos=length(tmp) then begin
              if length(tmp)<maxlen then begin tmp:=tmp+chr(key); inc(curpos); end; end
            else begin inc(curpos); tmp[curpos]:=chr(key); end;
          end; { overwrite }
        end; { key in allowed }
      end; { key not in case }
    end; { case }
    if (first=true) and
       ((key=crsrhome) or (key=crsrend) or (key=crsrbs) or
        (key=crsrright) or (key=crsrleft) or (key=crsrdel) or
        (key=crsrchome) or (chr(key) in allowed)) then first:=false;
  until esc;

  setcursorshape(cshape);
  case endpos of
    pos_le:tab:=0;
    pos_mi:tab:=(maxlen-length(editline)) div 2;
    pos_ri:tab:=maxlen-length(editline);
  end;
  filltext(' ',xi,yi,xi+maxlen,yi,endcolor);
  dspat(editline,xi+tab,yi,endcolor);
end;

begin
  with keybehave do begin
    clockon:=false;
    scrsavetime:=0;
    colattr:=lightgray;
    xpos:=1; ypos:=1;
  end;
  keyhandlerproc:=nil;
end.
