*****************************************************************************
* CCS-MON 								    *
* by Per Hkan Sundell							    *
* (C) 1989,1990,1991,1992
*****************************************************************************
	INCLUDE	exec/libraries.i
	INCLUDE	exec/memory.i
	INCLUDE	exec/types.i


CCSROMBase	equ	$F00000
CCSCustomBase	equ	$F20000
CCSRAMStart	equ	$0F0000
CCSRAMEnd	equ	$100000
CCSLibBase	equ	CCSRAMStart-_LVOUnused
CCSStackSize	equ	$1000
	Section	Code,Code

	bra.s	Start2				;This line only on the
						;testversions!
Start1:	
	movem.l	a0-a1,CCSLibBase+ccs_M68000Regs	;ENTRY FR. RESET
	movem.l	$0080.w,a0/a0
	lea	Start1a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start1a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	CCSLibBase+ccs_M68000Regs,a0-a1
	move.w	(a7)+,CCSLibBase+ccs_M68000Regs+m68_SR		;SR
	move.l	a5,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	addq.l	#4,a7
	move.w	#1000,CCSLibBase+ccs_StartUp		;Startcode 1000
	bra	Start5

Start2:
	movem.l	a0-a1,CCSLibBase+ccs_M68000Regs		;ENTRY FR. JSR
	movem.l	$0080.w,a0/a0
	lea	Start2a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start2a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	CCSLibBase+ccs_M68000Regs,a0-a1
	move.w	(a7)+,CCSLibBase+ccs_M68000Regs+m68_SR		;SR
	addq.l	#4,a7
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_SSP		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,CCSLibBase+ccs_M68000Regs
	move.w	#1001,CCSLibBase+ccs_StartUp		;Startcode 1001
	move.w	CCSLibBase+ccs_M68000Regs+m68_SR,d0
	and.w	#$2000,d0			;SUPERVISOR
	bne.s	Start2b				;OR USER-MODE ?
	move.l	(a7)+,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_A7		;USP
	bra	Start6
Start2b:
	move.l	CCSLibBase+ccs_M68000Regs+m68_SSP,a7
	move.l	(a7)+,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_SSP		;SSP
	bra	Start6

Start3:
	movem.l	a0-a1,CCSLibBase+ccs_M68000Regs		;ENTRY FR. RTS
	movem.l	$0080.w,a0/a0
	lea	Start3a(pc),a1
	movem.l	a1/a1,$0080.w
	trap	#0
Start3a:move.w	#$2700,SR
	move.l	a0,$0080.w
	movem.l	CCSLibBase+ccs_M68000Regs,a0-a1
	move.w	(a7)+,CCSLibBase+ccs_M68000Regs+m68_SR		;SR
	addq.l	#4,a7
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_SSP		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,CCSLibBase+ccs_M68000Regs
	move.w	#1002,CCSLibBase+ccs_StartUp		;Startcode 1002
	move.w	CCSLibBase+ccs_M68000Regs+m68_SR,d0
	and.w	#$2000,d0			;SUPERVISOR
	bne.s	Start3b				;OR USER-MODE ?
	move.l	(a7)+,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_A7		;USP
	bra.s	Start6
Start3b:
	move.l	CCSLibBase+ccs_M68000Regs+m68_SSP,a7
	move.l	(a7)+,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_SSP		;SSP
	bra.s	Start6

Start4:	move.w	#$2700,SR			;ENTRY FR. NMI-IRQ
	move.w	(a7)+,CCSLibBase+ccs_M68000Regs+m68_SR		;SR
	move.l	(a7)+,CCSLibBase+ccs_M68000Regs+m68_PC		;PC
	move.w	#1003,CCSLibBase+ccs_StartUp		;Startcode 1003
Start5:	move.l	a7,CCSLibBase+ccs_M68000Regs+m68_SSP		;SSP
	move.l	USP,a7
	movem.l	a0-a7/d0-d7,CCSLibBase+ccs_M68000Regs
Start6:	lea	CCSLibBase,a6
	lea	CCSRAMEnd,a7
	move.l	a7,ccs_StackBase(a6)
	bsr	MakePrefs
	bsr	ReadAgnus	;Read The Agnus Hardware regs.
	bsr	ReadCIA		;Read The CIA regs.
	move.w	#$7fff,$dff09a	;INTENA
	move.w	#$07ff,$dff096	;DMACON
	bsr	MakeLibrary
	jsr	_LVOExchangeRam(a6)
	move.l	a6,$0004.w
	bsr	FindROMFont
	bsr	FindROMKeymap
	bsr	FindAgnusChip
	bsr	FindScreenLastLine
	bsr	SaveExitPar
	bsr	MakePointer
	bsr	MakeCursor
	lea	AdressErrorIRQ(pc),a0
	move.l	a0,$000c.W		;ADRESS ERROR EXCEPTION
	lea	LevelOneIRQ(pc),a0
	move.l	a0,$0064.W		;LEVEL 1 IRQ
	lea	LevelTwoIRQ(pc),a0
	move.l	a0,$0068.W		;LEVEL 2 IRQ
	lea	LevelThreeIRQ(pc),a0
	move.l	a0,$006c.W		;LEVEL 3 IRQ
	lea	LevelFourIRQ(pc),a0
	move.l	a0,$0070.W		;LEVEL 4 IRQ
	lea	LevelFiveIRQ(pc),a0
	move.l	a0,$0074.W		;LEVEL 5 IRQ
	lea	LevelSixIRQ(pc),a0
	move.l	a0,$0078.W		;LEVEL 6 IRQ
	lea	LevelSevenIRQ(pc),a0
	move.l	a0,$007c.W		;LEVEL 7 IRQ
	move.b	#$00,$bfe301
	move.b	#$03,$bfe201
	move.b	#$fc,$bfe001
	move.b	#$7f,$bfed01		;CIAA ICR
	move.b	#$88,$bfed01

	move.b	#$00,$bfee01		;CIAA CRA
	move.b	#$08,$bfef01
	move.b	#$ff,$bfd300
	move.b	#$ff,$bfd100
	move.b	#$c0,$bfd200
	move.b	#$00,ccs_CIABIRQReq(a6)
	move.b	#$04,ccs_CIABIRQEna(a6)		;Enable ALRM
	move.b	#$00,ccs_CIAAIRQReq(a6)
	move.b	#$08,ccs_CIAAIRQEna(a6)		;Enable SP
	move.b	#$7f,$bfdd00
	move.b	#$84,$bfdd00		;ALRM
	tst.b	$bfdd00
	move.b	#$00,$bfde00
	move.b	#$80,$bfdf00
	move.w	#$7fff,$dff09c
	move.l	ccs_CIARegs(a6),a0
	move.b	$2c(a0),d0	;Keyboard Irq request
	or.b	$bfed01,d0
	and.b	#$08,d0
	beq.s	Start7
	move.w	#$8008,$dff09c
	or.b	#$08,ccs_CIAAIRQReq(a6)
Start7:	move.w	#$e028,$dff09a	;INTENA
	move.w	#$2000,SR
	lea	ccs_ScreenDev(a6),a0
	tst.w	sb_CursorY(a0)
	bne.s	Start8
	moveq	#$0c,d0
	jsr	_LVOWriteChar(a6)
Start8:	moveq	#'*',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'B',d0
	cmp.w	#1003,ccs_StartUp(a6)
	beq.s	Start9
	moveq	#'R',d0
	cmp.w	#1002,ccs_StartUp(a6)
	beq.s	Start9
	lea	StartText(pc),a0
	jsr	_LVOWriteString(a6)
	moveq	#'*',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'S',d0
	cmp.w	#1001,ccs_StartUp(a6)
	beq.s	Start9
	moveq	#'C',d0
	cmp.w	#1000,ccs_StartUp(a6)
	bne.s	Loop
Start9:
	jsr	_LVOWriteChar(a6)
	bsr	RegisterCom
Loop	lea	CCSLibBase,a6
	bsr	ShowCursor
.1	bsr	SetCursor		;Pointer
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	.1
	bsr	RemCursor
Loop2
	cmp.b	#$7f,d0		;DEL
	beq	Delkey
	cmp.b	#$1b,d0		;Esc
	beq	EscSeq
	cmp.b	#$9b,d0		;CSI
	beq	ANSI
	cmp.b	#$0d,d0		;Return
	beq	ExecuteCom
	jsr	_LVOWriteChar(a6)
	bra	Loop
EscSeq
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq	EscSeq
	cmp.b	#$5b,d0		;[
	beq	ANSI
	bra	Loop2
ANSI
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
	move.l	4(a0),d6
	lea	ErrorHandler0,a0
	move.l	a0,$142(a6)
	cmp.b	#$01,d0		;KEYPAD & CURSOR SPECIAL
	beq	ANSI10
	cmp.b	#$5A,d0		;CURSOR BACKWARD TAB
	beq	ANSI1
	cmp.b	#$3f,d0		;HELP KEY
	beq	ANSI2
	cmp.b	#$7e,d0		;FUNCTION KEY
	beq	ANSI3
	bra	Loop

ANSI1					;Backward TAB
	subq.w	#1,$5e(a6)
	and.w	#$0078,$5e(a6)
	cmp.w	#$0078,$5e(a6)
	bne	Loop
	move.w	#$0048,$5e(a6)
	moveq	#1,d6			;CuUp
	bra	ANSI10

ANSI2					;HELP
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	ANSI2
	cmp.b	#$7e,d0
	bne	Loop
	bra	HelpScreen

ANSI3					;FUNCTION KEY
	cmp.b	#0,d6			;F1
	beq	Editor
	bra	Loop
ANSI10					;KEYPAD SPECIAL
	cmp.b	#0,d6
	beq.s	ANSI10_0
	cmp.b	#1,d6
	beq.s	ANSI10_1
	cmp.b	#2,d6
	beq.s	ANSI10_2
	cmp.b	#3,d6
	beq.s	ANSI10_3
	cmp.b	#4,d6
	beq.s	ANSI10_4
	cmp.b	#5,d6
	beq	ANSI10_5
	cmp.b	#6,d6
	beq	ANSI10_6
	cmp.b	#7,d6
	beq	ANSI10_7
	cmp.b	#9,d6
	beq	ANSI10_9
	cmp.b	#10,d6
	beq	ANSI10_10
	cmp.b	#15,d6
	beq	ANSI10_15
	bra	Loop

ANSI10_0				;Home
	clr.w	$5e(a6)
	bra	Loop

ANSI10_1				;CRSR UP
	tst.w	$5c(a6)
	bne.s	ANSI10_1a
	jsr	_LVOScrollDown(a6)
	bsr	TestForComUp
	bra	Loop
ANSI10_1a
	subq.w	#1,$5c(a6)
	bra	Loop

ANSI10_2				;PAGE UP
	bra	TestForComUpII

ANSI10_3				;CRSR LEFT
	tst.w	$5e(a6)
	bne.s	ANSI10_3a
	move.w	#$004f,$5e(a6)
	moveq	#$01,d6			;CuUp
	bra	ANSI10
ANSI10_3a
	subq.w	#1,$5e(a6)
	bra	Loop

ANSI10_4				;CRSR RIGHT
	cmp.w	#$004f,$5e(a6)
	bne.s	ANSI10_4a
	clr.w	$5e(a6)
	moveq	#$06,d6			;CuDo
	bra	ANSI10
ANSI10_4a
	addq.w	#1,$5e(a6)
	bra	Loop

ANSI10_5				;END
	move.w	#$004f,$5e(a6)
	bra	Loop

ANSI10_6				;CRSR DOWN
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0		;CRSR DOWN
	bne.s	ANSI10_6a
	bsr	TestForComDown
	move.w	$14c(a6),d0
	subq.w	#3,d0
	cmp.w	$5c(a6),d0
	beq.s	ANSI10_6a
	jsr	_LVOScrollUp(a6)
	bra	Loop
ANSI10_6a
	addq.w	#1,$5c(a6)
	bra	Loop

ANSI10_7				;PAGE DOWN
	bra	TestForComDownII

ANSI10_9				;DEL
	bra	Delkey

ANSI10_10				;SHFT HOME
	clr.w	$5c(a6)
	clr.w	$5e(a6)
	bra	Loop

ANSI10_15				;SHFT END
	move.w	$14c(a6),d0		;TOTAL NR OF LINES
	subq.w	#2,d0
	move.w	d0,$5c(a6)
	move.w	#$004f,$5e(a6)
	bra	Loop

Delkey
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	Delkey1
	bsr	CalcYAddr
Delkey1
	move.w	$5e(a6),d1
	move.l	$17c(a6),a0
	add.w	d1,a0
Delkey2
	cmp.w	#$004f,d1
	beq.s	Delkey3
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	bra.s	Delkey2
Delkey3
	move.b	#$20,(a0)
	move.w	$5e(a6),d1
	move.l	$178(a6),a0
	add.w	d1,a0
Delkey4
	cmp.w	#$004f,d1
	beq.s	Delkey5
	move.b	$0051(a0),$0050(a0)
	move.b	$00a1(a0),$00a0(a0)
	move.b	$00f1(a0),$00f0(a0)
	move.b	$0141(a0),$0140(a0)
	move.b	$0191(a0),$0190(a0)
	move.b	$01e1(a0),$01e0(a0)
	move.b	$0231(a0),$0230(a0)
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	bra.s	Delkey4
Delkey5
	clr.b	(a0)
	clr.b	$0050(a0)
	clr.b	$00a0(a0)
	clr.b	$00f0(a0)
	clr.b	$0140(a0)
	clr.b	$0190(a0)
	clr.b	$01e0(a0)
	clr.b	$0230(a0)
	bra	Loop

StartText
	dc.b	12
	dc.b	"                           CCS-MON  V0.60",10
	dc.b	"                        BY PER HKAN SUNDELL",10
	dc.b	"              (C) 1990,1991,1992 Future Computer Systems AB"
	dc.b	10,0
	even

*****************************************************************************
HelpScreen
	move.l	$5c(a6),-(a7)		;Save Cursor Pos.
	move.w	$14a(a6),-(a7)		;Save Screen Scrollvalue
	addq.b	#1,$1a8(a6)		;Turn on Infoline
	bsr	MakeScreenBackup
	move.l	$150(a6),-(a7)		;Save Text Start
	move.l	$154(a6),-(a7)		;Save Text End
	move.l	$158(a6),-(a7)		;Save Text Linenr
	lea	HelpText1(pc),a0
	lea	HelpText1End(pc),a1
	moveq	#$00,d0
	move.l	a0,$150(a6)		;Start Text
	move.l	a1,$154(a6)		;End Text
	move.l	d0,$158(a6)		;Line nr
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)	;Top Line=Current Line
	clr.w	$166(a6)		;Clear Column nr
	clr.w	$16e(a6)		;Clear Column start
HelpScreen1
	bsr	UpdateTextII
	bsr	HelpScreen9	;Info text
HelpScreen2
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	HelpScreen2
	cmp.b	#$9b,d0			;CSI code
	beq.s	HelpScreen4
HelpScreen3				;Exit
	move.l	(a7)+,$158(a6)		;Restore Text Linenr
	move.l	(a7)+,$154(a6)		;Restore Text End
	move.l	(a7)+,$150(a6)		;Restore Text Start
	bsr	MakeScreenBackup
	move.w	(a7)+,$14a(a6)		;Restore Screen Scrollvalue
	bsr	RestoreScreen
	move.l	(a7)+,$5c(a6)		;Restore Cursor Pos.
	bsr	CalcYAddr
	clr.w	$68(a6)			;Empty Keyboard
	clr.b	$1a8(a6)		;No infoline
	bra	Loop
HelpScreen4
	moveq	#$00,d6
HelpScreenNum1
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	HelpScreenNum1
	cmp.b	#$39,d0
	bhi.s	HelpScreenNum2
	cmp.b	#$2f,d0
	bls.s	HelpScreenNum2
	and.w	#$000f,d0
	mulu	#10,d6
	add.w	d0,d6
	bra.s	HelpScreenNum1
HelpScreenNum2
	cmp.b	#$01,d0		;KEYPAD & CURSOR SPECIAL
	beq	HelpScreenNum3
	bra	HelpScreen3
HelpScreenNum3
	cmp.b	#1,d6
	beq.s	HelpScreen5
	cmp.b	#6,d6
	beq.s	HelpScreen6
	cmp.b	#2,d6
	beq	HelpScreen8
	cmp.b	#7,d6
	beq	HelpScreen7
	bra	HelpScreen3
HelpScreen5			;Cursor Up
	move.l	$170(a6),d0	;Top Line
	cmp.l	$150(a6),d0	;Text Start
	beq	HelpScreen2
	jsr	_LVOScrollDown(a6)
	bsr	GotoPrecCurLine
	move.l	$15c(a6),-(a7)		;Last line
	move.l	$170(a6),$15c(a6)	;Top line
	bsr	GotoPrecCurLine
	move.l	$15c(a6),$170(a6)
	move.l	(a7)+,$15c(a6)
	addq.b	#1,$75(a6)
HelpScreen5a
	tst.b	$75(a6)
	bne.s	HelpScreen5a
	clr.w	$5c(a6)		;Top Line
	bsr	UpdateLine
	bsr	HelpScreen9	;Info text
	bra	HelpScreen2

HelpScreen6			;Cursor Down
	move.l	$15c(a6),d1
	bsr	GotoNextCurLine
	move.l	$15c(a6),d0
	cmp.l	$154(a6),d0
	beq	HelpScreen6b
	bsr	GotoNextTopLine
	jsr	_LVOScrollUp(a6)
	move.w	$14c(a6),d0	;ScreenLastLine
	subq.w	#3,d0
	move.w	d0,$5c(a6)
	addq.b	#1,$75(a6)
HelpScreen6a
	tst.b	$75(a6)
	bne.s	HelpScreen6a
	bsr	UpdateLine
	bsr	HelpScreen9	;Info text
	bra	HelpScreen2
HelpScreen6b
	move.l	d1,$15c(a6)
	bra	HelpScreen2

HelpScreen7			;Page Down
	move.w	$14c(a6),d2	;ScreenLastLine
	subq.w	#3,d2
HelpScreen7a
	move.l	$15c(a6),d1
	bsr	GotoNextCurLine
	move.l	$15c(a6),d0
	cmp.l	$154(a6),d0
	beq	HelpScreen1
	bsr	GotoNextTopLine
	dbf	d2,HelpScreen7a
	bra	HelpScreen1

HelpScreen8			;Page Up
	move.w	$14c(a6),d2	;ScreenLastLine
	subq.w	#3,d2
HelpScreen8a
	move.l	$170(a6),d0	;Top Line
	cmp.l	$150(a6),d0	;Text Start
	beq	HelpScreen1
	bsr	GotoPrecTopLine
	dbf	d2,HelpScreen8a
	bra	HelpScreen1

HelpScreen9			;Show Info
	move.w	$14c(a6),d0	;ScreenLastLine
	subq.w	#2,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
	lea	HelpInfoText(pc),a0
	jsr	_LVOWriteString(a6)
	jsr	_LVOClearToEOL(a6)
	rts

HelpText1
	dc.b	"* A <addr> <mnemonics>",9,9,9,9,9,";Assemble",10
	dc.b	"* B <addr>",9,9,9,9,9,9,";Breakpoint",10
	dc.b	"* C <startaddr> <endaddr> <compareaddr>",9,9,9,";Compare",10
	dc.b	"* D <startaddr> [<endaddr>]",9,9,9,9,";Disassemble",10
	dc.b	"* , <addr> <words> <mnemonics>",9,9,9,9,";Edit Disassemble",10
	dc.b	"* E <startaddr> <endaddr> <exchangeaddr>",9,9,";Exchange"
	dc.b	10
	dc.b	"* F <startaddr> <endaddr> <bytes>",9,9,9,";Fill Memory",10
	dc.b	"* F <startaddr> <endaddr> ",34,"<string>",34,9,9
	dc.b	9,";Fill Memory",10
	dc.b	"* G [<addr>]",9,9,9,9,9,9,";Go Program (JMP)",10
	dc.b	"* H <startaddr> <endaddr> <bytes>",9,9,9,";Hunt Memory",10
	dc.b	"* H <startaddr> <endaddr> ",34,"<string>",34,9,9
	dc.b	9,";Hunt Memory",10
	dc.b	"* I <startaddr> [<endaddr>]",9,9,9,9,";Interpret",10
	dc.b	"* ' <addr> <chars>",9,9,9,9,9,";Edit Memory in text",10
	dc.b	"* J [<addr>]",9,9,9,9,9,9,";Jump Program (JSR)",10
	dc.b	"* L ",34,"<filename>",34," <startaddr> [<endaddr>]",9,9
	dc.b	";Load file",10
	dc.b	"* L <drive> <blocknr> <number> <startaddr>",9,9
	dc.b	";Load blocks",10
	dc.b	"* M <startaddr> [<endaddr>]",9,9,9,9,";Memory",10
	dc.b	"* : <addr> <bytes>",9,9,9,9,9,";Edit Memory",10
	dc.b	"* N <startaddr> <endaddr> <abslow> <abshigh> <newabs>"
	dc.b	9,";New Locator",10
	dc.b	"* Q [<addr>]",9,9,9,9,9,9,";Quicktrace",10
	dc.b	"* R ",9,9,9,9,9,9,9,";Register",10
	dc.b	"* ; <register> ...",9,9,9,9,9,";Edit Register",10
	dc.b	"* S ",34,"<filename>",34," <startaddr> <endaddr>",9,9,9
	dc.b	";Save file",10
	dc.b	"* S <drive> <blocknr> <number> <startaddr>",9,9
	dc.b	";Save blocks",10
	dc.b	"* T <startaddr> <endaddr> <transferaddr>",9,9,";Transfer",10
	dc.b	"* W [<addr>]",9,9,9,9,9,9,";Walktrace",10
	dc.b	"* X",9,9,9,9,9,9,9,";Exit mon",10
	dc.b	"* CD [",34,"<directory>",34,"]",9,9,9,9,9,";Change Directory",10
	*dc.b	"* COPY ",34,"<filename>",34,32,34,"<filename>",34,9,9,9
	*dc.b	";Copy file",10
	dc.b	"* CLOSE",9,9,9,9,9,9,9,";Close textfile",10
	dc.b	"* DATE [<Day-Mon-Year>] [<Hour:Min:Sec>]",9,9,";Time",10
	dc.b	"* DELETE ",34,"<filename>",34,9,9,9,9,9,";Delete File",10
	dc.b	"* DIR [",34,"<directory>",34,"]",9,9,9,9,9,";Directory",10
	dc.b	"* DISKCOPY ",34,"<drive>",34,32,34,"<drive>",34,9,9,9,9
	dc.b	";Copy Disk",10
	dc.b	"* FILENOTE ",34,"<filename>",34,32,34,"<comment>",34,9,9,9
	dc.b	";Set comment",10
	dc.b	"* FORMAT ",34,"<drive>",34,32,34,"<name>",34,9,9,9,9
	dc.b	";Format Disk",10
	dc.b	"* HUNTDIS <startaddr> <endaddr> ",34,"<string>",34,9,9
	dc.b	";Hunt Disassemble",10
	dc.b	"* INFO",9,9,9,9,9,9,9,";Info",10
	dc.b	"* INSTALL ",34,"<drive>",34,9,9,9,9,9,";Install disk",10
	dc.b	"* LOADSEG ",34,"<filename>",34," <addr>",9,9,9,9,";Load segment",10
	dc.b	"* MAKEDIR ",34,"<filename>",34,9,9,9,9,9
	dc.b	";Create Directory",10
	dc.b	"* MERGE ",34,"<filename>",34,9,9,9,9,9,";Merge textfile",10
	dc.b	"* NEW",9,9,9,9,9,9,9,";Clear textbuffer",10
	dc.b	"* OPEN ",34,"<filename>",34,9,9,9,9,9,";Open textfile",10
	dc.b	"* PROTECT ",34,"<filename>",34,32,34,"<protect>",34,9,9,9
	dc.b	";Protect File",10
	dc.b	"* RENAME ",34,"<filename>",34,32,34,"<filename>",34,9,9,9
	dc.b	";Rename File",10
	dc.b	"* RELABEL ",34,"<drive>",34,32,34,"<name>",34,9,9,9,9
	dc.b	";Relabel Disk",10
	dc.b	"* SAVE [",34,"<filename>","]",9,9,9,9,9,";Save textfile",10
	dc.b	"* SHOWSEG <addr>",9,9,9,9,9,";Show segmentlist",10
	dc.b	"* TYPE ",34,"<filename>",34,9,9,9,9,9,";Type file",10
	dc.b	"* WORKBUF [<startaddr> <endaddr>]",9,9,9,";Workbuffer",10
HelpText1End
HelpInfoText
	dc.b "Scroll with CRSR UP/DOWN and PAGE UP/DOWN",0
	even

UpdateTextII				;Place First Line on Top
	movem.l	d1-d2/a0-a3,-(a7)	;of Screen
	move.l	$170(a6),a0		;Top Line Addr
	move.l	$154(a6),a1
	move.l	a0,$15c(a6)		;Last Line Addr
	clr.w	$5c(a6)
UpdateTextII1
	cmp.l	a0,a1
	beq.s	UpdateTextII6
	clr.w	$5e(a6)
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq.s	UpdateTextII6
	move.l	a0,$15c(a6)		;Last Line Addr
UpdateTextII2
	cmp.l	a0,a1
	beq.s	UpdateTextII6
	move.b	(a0)+,d0
	cmp.b	#$0a,d0			;LF
	beq.s	UpdateTextII5
	cmp.b	#$09,d0
	bne.s	UpdateTextII3
	jsr	_LVOClearToTAB(a6)
UpdateTextII3
	jsr	_LVOWriteChar(a6)
	tst.w	$5e(a6)
	bne.s	UpdateTextII2
UpdateTextII4
	cmp.l	a0,a1
	beq.s	UpdateTextII6
	move.b	(a0)+,d0
	cmp.b	#$0a,d0
	bne.s	UpdateTextII4
	bra.s	UpdateTextII1
UpdateTextII5
	jsr	_LVOClearToEOL(a6)
	jsr	_LVOWriteChar(a6)
	bra.s	UpdateTextII1
UpdateTextII6
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq.s	UpdateTextII8
	tst.w	$5e(a6)
	bne.s	UpdateTextII7
	jsr	_LVOClearLine(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateTextII6
UpdateTextII7
	jsr	_LVOClearToEOL(a6)
	clr.w	$5e(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateTextII6
UpdateTextII8
	movem.l	(a7)+,d1-d2/a0-a3
	rts
*****************************************************************************

TestForComUp
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#2,d1
TestForComUp1
	move.w	$14c(a6),d2
	subq.w	#2,d2
	sub.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComUp1a
	sub.w	$14c(a6),d2
TestForComUp1a
	lsl.w	#4,d2
	move.w	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComUp2
	cmp.b	#":",d0
	beq.s	TestForComUp3
	cmp.b	#",",d0
	beq.s	TestForComUp4
	dbf	d1,TestForComUp1
	rts
TestForComUp2
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	lea	-$40(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	InterpretCom1
	clr.w	$5c(a6)		;Cursor Y position
	rts
TestForComUp3
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	lea	-$10(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	MemoryCom2
	clr.w	$5c(a6)		;Cursor Y position
	rts
TestForComUp4
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	lea	-$28(a1),a0
TestForComUp5
	move.l	a1,-(a7)
	bsr	DisassembleComFindInstr
	move.l	(a7)+,a1
	cmpa.l	a0,a1
	bhi.s	TestForComUp5
	move.l	a0,d0
	move.l	a1,d1
	btst	#31,d1
	bne.s	TestForComUp5a
	eor.l	d1,d0
	bmi.s	TestForComUp5
TestForComUp5a
	lea	Preferences,a6
	move.l	$98(a6),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	DisassembleCom1
	clr.w	$5c(a6)		;Cursor Y position
	tst.w	$68(a6)
	beq.s	TestForComUp6
	move.w	#$0004,$68(a6)
TestForComUp6
	rts

TestForComDown
	moveq	#$00,d7
	move.w	$14c(a6),d1	;ScreenLastLine
	subq.w	#3,d1
TestForComDown1
	move.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComDown1a
	sub.w	$14c(a6),d2
TestForComDown1a
	lsl.w	#4,d2
	move.l	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComDown2
	cmp.b	#":",d0
	beq.s	TestForComDown3
	cmp.b	#",",d0
	beq.s	TestForComDown4
	dbf	d1,TestForComDown1
	rts
TestForComDown2
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	lea	$40(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)		;Cursor X position
	bsr	InterpretCom1
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts
TestForComDown3
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	lea	$10(a0),a0
	sub.l	a1,a1
	clr.w	$5e(a6)			;Cursor X position
	bsr	MemoryCom2
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts
TestForComDown4
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	bsr	DisassembleComFindInstr
	sub.l	a1,a1
	clr.w	$5e(a6)			;Cursor X position
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)		;Cursor Y position
	rts

TestForComUpII
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#2,d1
TestForComUpII1
	move.w	$14c(a6),d2
	subq.w	#2,d2
	sub.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComUpII1a
	sub.w	$14c(a6),d2
TestForComUpII1a
	lsl.w	#4,d2
	move.w	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComUpII2
	cmp.b	#":",d0
	beq.s	TestForComUpII3
	cmp.b	#",",d0
	beq	TestForComUpII4
	dbf	d1,TestForComUpII1
	bra	Loop
TestForComUpII2
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII2a
	subq.w	#2,$5c(a6)
	sub.l	a1,a1
	lea	-$40(a0),a0
	move.l	a0,-(a7)
	bsr	InterpretCom1
	move.l	(a7)+,a0
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII2a
	clr.w	$5c(a6)
	bra	Loop
TestForComUpII3
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII3a
	subq.w	#2,$5c(a6)
	sub.l	a1,a1
	lea	-$10(a0),a0
	move.l	a0,-(a7)
	bsr	MemoryCom2
	move.l	(a7)+,a0
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII3a
	clr.w	$5c(a6)
	bra	Loop
TestForComUpII4
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
TestForComUpII4a
	move.l	$76(a6),a2
	lea	-$168(a1),a0
TestForComUpII5
	movem.l	a1/a2,-(a7)
	bsr	DisassembleComFindInstr
	movem.l	(a7)+,a1/a2
	move.l	a0,d0
	sub.l	$98(a6),d0
	move.b	d0,(a2)+
	cmpa.l	a0,a1
	bhi.s	TestForComUpII5
	move.l	a0,d0
	move.l	a1,d1
	btst	#31,d1
	bne.s	TestForComUpII5a
	eor.l	d1,d0
	bmi.s	TestForComUpII5
TestForComUpII5a
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
TestForComUpII5b
	subq.w	#2,$5c(a6)
	move.b	-(a2),d0
	ext.w	d0
	sub.w	d0,a0
	sub.l	a1,a1
	movem.l	a0/a2,-(a7)
	bsr	DisassembleCom1
	movem.l	(a7)+,a0/a2
	cmp.w	#$0001,$5c(a6)
	bne.s	TestForComUpII5b
	clr.w	$5c(a6)
	bra	Loop

TestForComDownII
	moveq	#$00,d7
	move.w	$14c(a6),d1		;ScreenLastLine
	subq.w	#3,d1
TestForComDownII1
	move.w	d1,d2
	add.w	$14a(a6),d2
	cmp.w	$14c(a6),d2
	blt.s	TestForComDownII1a
	sub.w	$14c(a6),d2
TestForComDownII1a
	lsl.w	#4,d2
	move.l	d2,d3
	lsl.w	#2,d2
	add.w	d2,d3
	move.l	$04(a6),a5
	add.w	d3,a5
	move.b	(a5),d0
	cmp.b	#"'",d0
	beq.s	TestForComDownII2
	cmp.b	#":",d0
	beq.s	TestForComDownII3
	cmp.b	#",",d0
	beq.s	TestForComDownII4
	dbf	d1,TestForComDownII1
	bra	Loop
TestForComDownII2
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII2a
	lea	$40(a0),a0
	sub.l	a1,a1
	move.l	a0,-(a7)
	bsr	InterpretCom1
	move.l	(a7)+,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII2a
	bra	Loop
TestForComDownII3
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII3a
	lea	$10(a0),a0
	sub.l	a1,a1
	move.l	a0,-(a7)
	bsr	MemoryCom2
	move.l	(a7)+,a0
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII3a
	bra	Loop
TestForComDownII4
	clr.w	$68(a6)			;Empty Keyboard
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	bsr	DisassembleComFindInstr
	clr.w	$5c(a6)
	clr.w	$5e(a6)
TestForComDownII4a
	sub.l	a1,a1
	bsr	DisassembleCom1
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	TestForComDownII4a
	bra	Loop

Editor					;Source text editor
	move.l	$5c(a6),-(a7)
	move.w	$14a(a6),-(a7)
	addq.b	#1,$1a8(a6)
	move.l	a7,$1e0(a6)
	move.b	#$01,$1e5(a6)
	bsr	MakeScreenBackup
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	move.l	$150(a6),d0
	cmp.l	$154(a6),d0
	bne.s	Editor1
	move.b	#$01,$1e4(a6)
Editor1
	bsr	UpdateText
	bsr	UpdateLine
Editor2
	bsr	ShowCursor
Editor3
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	Editor3
	bsr	RemCursor
Editor3a
	cmp.b	#$9b,d0
	beq	Editor4			;CSI
	cmp.b	#$1b,d0
	beq	EditorEscSeq
	cmp.b	#$7f,d0
	beq	Editor15		;Delete
	cmp.b	#$08,d0
	beq	Editor14		;Backspace
	cmp.b	#$0c,d0
	beq	Editor1			;Clear Screen
	cmp.b	#$0d,d0
	beq.s	Editor3b		;Return
	move.l	d0,d1
	bsr	GetFreeWorkBuf
	tst.l	d0
	beq.s	Editor2
	move.l	d1,d0
	bsr	InsCharBuffer
	bra	Editor14a		;Memory Save Label
Editor3b				;New Line ,Line Feed
	bsr	GetFreeWorkBuf
	tst.l	d0
	beq	Editor2
	moveq	#$0a,d0
	bsr	InsCharBuffer
	bsr	InsCurrentLine
	bsr	UpdateText
	clr.w	$166(a6)
	bra	Editor6
EditorEscSeq
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	EditorEscSeq
	cmp.b	#$5b,d0			;"["
	beq.s	Editor4
	bra	Editor3a
Editor4
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
Editor4a
	move.l	4(a0),d6
	cmp.b	#$01,d0		;KEYPAD & CURSOR SPECIAL
	beq	EditorNum3
	cmp.b	#$5a,d0		;CBT
	beq	Editor11
	cmp.b	#$7e,d0		;FUNCTION KEYS
	beq	Editor16
	bra	Editor2
EditorNum3
	cmp.b	#30,d6		;NUM LOCK
	beq	Editor20
	cmp.b	#41,d6		;RIGHT MOBUT pressed
	beq	EditorMenu
	cmp.b	#44,d6		;RIGHT ALT KEY pressed
	beq	EditorKeyMenu
	cmp.b	#48,d6		;CAPS LOCK pressed
	beq	Editor20
	cmp.b	#49,d6		;CAPS LOCK released
	beq	Editor20
	cmp.b	#39,d6
	bhi	EditorNum5
	cmp.b	#17,d6		;SHIFT KEYPAD
	bhi	EditorNum4
	cmp.b	#9,d6
	bls	EditorNum4
	bsr	StartMarking
	sub.b	#10,d6
	bra	EditorNum5
EditorNum4
	bsr	EndMarking
EditorNum5
	cmp.b	#1,d6		;UP
	beq	Editor5
	cmp.b	#6,d6		;DOWN
	beq	Editor6
	cmp.b	#3,d6		;LEFT
	beq	Editor8
	cmp.b	#4,d6		;RIGHT
	beq	Editor7
	cmp.b	#2,d6		;PG UP
	beq	Editor9
	cmp.b	#7,d6		;PG DOWN
	beq	Editor10
	cmp.b	#0,d6		;HOME
	beq	Editor13
	cmp.b	#5,d6		;END
	beq	Editor12
	cmp.b	#9,d6		;DEL
	beq	Editor15
	cmp.b	#22,d6		;CTRL PG UP
	beq	Editor17
	cmp.b	#27,d6		;CTRL PG DOWN
	beq	Editor18
	bra	Editor2
Editor5			;CRSR UP
	bsr	RememberMark
	bsr	InsCurrentLine
	tst.w	$5c(a6)
	bne.s	Editor5a
	tst.l	$158(a6)
	beq	Editor2
	jsr	_LVOScrollDown(a6)
	addq.w	#1,$1ba(a6)		;Rem Line Y
	bsr	GotoPrecCurLine
	move.l	$15c(a6),$170(a6)
	bsr	ContMarkingII
	tst.l	d0
	bne	Editor1
	bra	Editor6a
Editor5a
	subq.w	#1,$5c(a6)
	bsr	GotoPrecCurLine
	bra	Editor13b		;Memory Save Label

Editor6				;CRSR DOWN
	bsr	RememberMark
	bsr	InsCurrentLine
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#3,d0
	cmp.w	$5c(a6),d0
	bne	Editor6c
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor2
	move.l	d0,d2
	bsr	GotoNextTopLine
	jsr	_LVOScrollUp(a6)
	subq.w	#1,$1ba(a6)		;Rem Line Y
	bsr	ContMarkingII
	move.l	d2,d0
	bne	Editor1
Editor6a				;Memory Save Label
	addq.b	#1,$75(a6)
Editor6b
	tst.b	$75(a6)
	bne	Editor6b
	bsr	UpdateLine
	bsr	ContMarkingIII
	bsr	WriteCursorInfo
	bra	Editor2
Editor6c
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor2
	addq.w	#1,$5c(a6)
	bra	Editor13b		;Memory Save Label

Editor7				;CRSR RIGHT
	bsr	RememberMark
	move.w	$16c(a6),d1		;Index
	cmp.w	$164(a6),d1		;Line Length
	beq	Editor2
	move.l	$160(a6),a0		;Buffert address
	cmp.b	#$0a,0(a0,d1.w)
	beq	Editor2
	addq.w	#1,$16c(a6)		;Next Index
	bra	Editor13a

Editor8				;CRSR LEFT
	bsr	RememberMark
	tst.w	$16c(a6)		;Index
	beq	Editor2
	subq.w	#1,$16c(a6)		;Prec Index
	bra	Editor13a

Editor9				;Page Up
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	move.w	$14c(a6),d2		;ScreenLastLine
	subq.w	#3,d2
Editor9a
	move.l	$150(a6),a0		;Text Start Addr
	cmp.l	$170(a6),a0		;Top TextLine Addr
	beq	Editor1
	bsr	GotoPrecTopLine
	bsr	GotoPrecCurLine
	bsr	ContMarkingII
	dbf	d2,Editor9a
	bra	Editor1

Editor10				;Page Down
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	move.w	$14c(a6),d2		;ScreenLastLine
	subq.w	#3,d2
Editor10a
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor1
	bsr	GotoNextTopLine
	bsr	ContMarkingII
	dbf	d2,Editor10a
	bra	Editor1

Editor11				;Backward Tab
	bsr	EndMarking
	move.w	$166(a6),d0
	beq	Editor2
	subq.w	#1,d0
	and.w	#$fff8,d0
	move.w	d0,d1
Editor11a
	subq.w	#1,$16c(a6)
	bsr	CalColumnNr
	cmp.w	$166(a6),d1
	bne	Editor11a
	bra	Editor13a		;Memory Save Label

Editor12				;END
	bsr	RememberMark
	move.w	$164(a6),d0
	beq	Editor2
	move.l	$160(a6),a0		;Line Buffer Addr
	cmp.b	#$0a,-1(a0,d0.w)
	bne.s	Editor12a
	subq.w	#1,d0
Editor12a
	move.w	d0,$16c(a6)
	bra	Editor13a

Editor13				;HOME
	bsr	RememberMark
	clr.w	$16c(a6)
Editor13a				;Memory Save Label
	bsr	CalColumnNr
	bsr	CalCursorX
Editor13b				;Memory Save Label
	bsr	ContMarking
	tst.l	d0
	bne	Editor1
	bsr	WriteCursorInfo
	bra	Editor2

Editor14				;Backspace
	bsr	EndMarking
	tst.w	$16c(a6)		;Index
	beq	Editor14b		;First Column
	subq.w	#1,$16c(a6)		;Prec Index
	bsr	RemCharBuffer
Editor14a				;Memory Save Label
	bsr	CalColumnNr
	bsr	CalCursorX
	tst.l	d0
	bne	Editor1
	bsr	UpdateLine
	bsr	WriteCursorInfo
	bra	Editor2
Editor14b
	tst.l	$158(a6)
	beq	Editor2
	tst.w	$5c(a6)
	bne	Editor14c
	bsr	GotoPrecTopLine
Editor14c
	subq.l	#1,$15c(a6)	;Textbuffer adress
	addq.w	#1,$168(a6)	;Old linelength
	move.w	#$1234,$16a(a6)	;Buffer changes
	move.l	$15c(a6),d2
	bsr	InsCurrentLine
	bsr	GotoPrecCurLineII
	sub.l	$15c(a6),d2
	move.w	d2,$16c(a6)
	bsr	CalColumnNr
	bsr	CalCursorX
	bra	Editor1

Editor15				;Delete
	bsr	EndMarking
	move.w	$16c(a6),d1		;Index
	cmp.w	$164(a6),d1		;Line Length
	beq	Editor2			;EOL not deleted
	move.l	$160(a6),a0		;Buffert address
	cmp.b	#$0a,0(a0,d1.w)
	beq	Editor2			;EOL not deleted
	bsr	RemCharBuffer
	bsr	UpdateLine
	bsr	WriteCursorInfo
	bra	Editor2

Editor16				;Function Keys
	cmp.b	#0,d6			;F1
	beq	EditorQuit
	cmp.b	#1,d6			;F2
	beq	Editor19
	bra	Editor2

Editor17				;CTRL Page Up
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
Editor17a
	move.l	$150(a6),a0		;Text Start Addr
	cmp.l	$170(a6),a0		;Top TextLine Addr
	beq	Editor1
	bsr	GotoPrecTopLine
	bsr	GotoPrecCurLine
	bra	Editor17a

Editor18				;CTRL Page Down
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
Editor18a
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	Editor1
	bsr	GotoNextTopLine
	bra	Editor18a

Editor19				;F2 (Copy to buffert)
	clr.w	$68(a6)			;Empty Keyboard
	bsr	InsCurrentLine
	cmp.w	#$0001,$1b2(a6)
	bne	Editor19a
	bsr	CopyToCutBuffer
	bsr	EndMarking
Editor19a
	bra	Editor1	

Editor20				;Num Lock
	bsr	WriteCursorInfo
	bra	Editor2

EditorQuit
	bsr	InsCurrentLine
	bsr	MakeScreenBackup
	move.l	$1e0(a6),a7
	clr.b	$1e5(a6)
	move.w	(a7)+,$14a(a6)
	bsr	RestoreScreen
	move.l	(a7)+,$5c(a6)
	bsr	CalcYAddr
	clr.b	$1a8(a6)		;No infoline
	bra	Loop

ReadCSIPar				;Reads parameter to the Command
					;sequence.
					;A0=Parlist , D0out=End Char
	movem.l	d1-d4,-(a7)
	moveq	#$00,d2			;String index
.1
	moveq	#$00,d1			;Parameter
	moveq	#$00,d3
	moveq	#$00,d4			;Nr of pars
.2
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	.2
	cmp.b	#$39,d0
	bhi.s	.3
	cmp.b	#$2f,d0
	bls.s	.3
	moveq	#$01,d3
	and.w	#$000f,d0
	mulu	#10,d1
	add.w	d0,d1
	bra.s	.2
.3
	add.w	d3,d4
	move.l	d1,4(a0,d2.w)
	addq.w	#4,d2
	cmp.b	#';',d0
	beq.s	.1
	move.l	d4,(a0)			;Nr of Parameters
	movem.l	(a7)+,d1-d4
	rts

EditorKeyMenu
	bsr	ReadMousePosition
	move.l	d0,-(a7)
	move.l	#$00010000,d0
	bsr	WriteMousePosition
	bra	EditorMenu1
EditorMenu
	bsr	ReadMousePosition
	move.l	d0,-(a7)
EditorMenu1
	lea	EditorMenuHeadInfo(pc),a0
	bsr	MenuSystem
	tst.l	d0
	beq	EditorMenu2
EdMe1:	lea	EdMe1(pc),a0
	add.l	d0,a0
	bsr	InsCurrentLine
	bsr	RememberMarked
	jsr	(a0)
	bsr	RestoreScreen
	bsr	RestoreAllMarked
EditorMenu2
	move.l	(a7)+,d0
	bsr	WriteMousePosition
	bra	Editor2

EditorMenuHeadInfo
	dc.l	EditorMenuHeadText1		;0
	dc.l	EditorMenuHead1			;4
	dc.l	EditorMenuHead2			;8
	dc.l	EditorMenuHeadKeys		;C
EditorMenuHeadText1
	dc.b	"FILE       EDIT       SEARCH     RUN    "
	dc.b	"     DEBUG      UTILITY             HELP",0
	even
EditorMenuHead1
	dc.b	0,11,22,33,45,56,68,80
	even
EditorMenuHeadKeys
	dc.b	'F',02,00,'E',13,00,'S',24,00,'R',35,00
	dc.b	'D',47,00,'U',58,00,'H',76,00,00
	even
EditorMenuHead2
	dc.l	EditorMenuInfo1
	dc.l	EditorMenuText1
	dc.l	EditorMenuKeys1
	dc.l	EditorMenuInfo2
	dc.l	EditorMenuText2
	dc.l	EditorMenuKeys2
	dc.l	EditorMenuInfo3
	dc.l	EditorMenuText3
	dc.l	EditorMenuKeys3
	dc.l	EditorMenuInfo4
	dc.l	EditorMenuText4
	dc.l	EditorMenuKeys4
	dc.l	EditorMenuInfo5
	dc.l	EditorMenuText5
	dc.l	EditorMenuKeys5
	dc.l	EditorMenuInfo6
	dc.l	EditorMenuText6
	dc.l	EditorMenuKeys6
	dc.l	EditorMenuInfo7
	dc.l	EditorMenuText7
	dc.l	EditorMenuKeys7
*************************************************************************
*	dc.b	x1,y1,x2,y2		;box coords			*
*	dc.b	"text",0		;text				*
* or	dc.b	255			;for line +---+			*
*	dc.b	0			;end				*
*************************************************************************
EditorMenuText1:
	dc.b	0,1,12,12
	dc.b	"New",0
	dc.b	"Open file",0
	dc.b	"Merge file",0
	dc.b	"Save",0
	dc.b	"Save as",0
	dc.b	"Delete",0
	dc.b	255
	dc.b	"Print",0
	dc.b	255
	dc.b	"Exit",0
	dc.b	0

EditorMenuKeys1
	dc.b	'N',01,02,'O',01,03,'M',01,04,'S',01,05
	dc.b	'A',01,06,'D',01,07,'P',01,09,'E',01,11,00

EditorMenuText2
	dc.b	11,1,25,11
	dc.b	"Undo",0
	dc.b	"Redo",0
	dc.b	255
	dc.b	"Cut",0
	dc.b	"Copy",0
	dc.b	"Paste",0
	dc.b	"Clear",0
	dc.b	255
	dc.b	"Clear Buffer",0
	dc.b	0

EditorMenuKeys2
	dc.b	'U',12,02,'R',12,03,'C',12,05,'O',12,06
	dc.b	'P',12,07,'L',12,08,'B',12,10,00

EditorMenuText3
	dc.b	22,1,40,5
	dc.b	"Find",0
	dc.b	"Repeat last find",0
	dc.b	"Change",0
	dc.b	0

EditorMenuKeys3
	dc.b	'F',23,02,'R',23,03,'C',23,03,00

EditorMenuText4
	dc.b	33,1,48,9
	dc.b	"Start",0
	dc.b	"Restart",0
	dc.b	"Continue",0
	dc.b	255
	dc.b	"Compile only",0
	dc.b	255
	dc.b	"Make exe-file",0
	dc.b	0

EditorMenuKeys4
	dc.b	'S',34,02,'R',34,03,'C',34,04,'O',34,06
	dc.b	'M',34,08,00

EditorMenuText5
	dc.b	45,1,68,7
	dc.b	"Add breakpoint",0
	dc.b	"Delete breakpoint",0
	dc.b	"Show breakpoint",0
	dc.b	255
	dc.b	"Clear all breakpoints",0
	dc.b	0

EditorMenuKeys5
	dc.b	'A',46,02,'D',46,03,'S',46,04,'C',46,06,00

EditorMenuText6
	dc.b	56,1,72,6
	dc.b	"Calculator",0
	dc.b	"Date & Time",0
	dc.b	255
	dc.b	"Print Errors",0
	dc.b	0

EditorMenuKeys6
	dc.b	'C',57,02,'D',57,03,'P',57,05,00

EditorMenuText7
	dc.b	68,1,79,2
	dc.b	0

EditorMenuKeys7
	dc.b	00
	even

EditorMenuInfo1
	dc.l	EditorNew-EdMe1		;New
	dc.l	EditorOpen-EdMe1	;Open file
	dc.l	EditorMerge-EdMe1	;Merge file
	dc.l	EditorSave-EdMe1	;Save
	dc.l	EditorSaveAs-EdMe1	;Save as
	dc.l	EditorDelete-EdMe1	;Delete
	dc.l	-1			;--------
	dc.l	EditorPrint-EdMe1	;Print
	dc.l	-1			;--------
	dc.l	EditorExit-EdMe1	;Exit

EditorMenuInfo2
	dc.l	0			;Undo
	dc.l	0			;Redo
	dc.l	-1			;--------
	dc.l	EditorCut-EdMe1		;Cut
	dc.l	EditorCopy-EdMe1	;Copy
	dc.l	EditorPaste-EdMe1	;Paste
	dc.l	EditorClear-EdMe1	;Clear
	dc.l	-1			;--------
	dc.l	EditorClearBuf-EdMe1	;Clear Buffer

EditorMenuInfo3
	dc.l	EditorFind-EdMe1	;Find
	dc.l	EditorRepeat-EdMe1	;Repeat last find
	dc.l	EditorChange-EdMe1	;Change

EditorMenuInfo4
	dc.l	0			;Start
	dc.l	0			;Restart
	dc.l	0			;Continue
	dc.l	-1			;--------
	dc.l	EditorCompile-EdMe1	;Compile only
	dc.l	-1			;--------
	dc.l	EditorMake-EdMe1	;Make exe-file

EditorMenuInfo5
	dc.l	0			;Add breakpoint
	dc.l	0			;Delete breakpoint
	dc.l	0			;Show breakpoints
	dc.l	-1			;--------
	dc.l	0			;Clear all breakpoints

EditorMenuInfo6
	dc.l	EditorCalculator-EdMe1	;Calculator
	dc.l	EditorDate-EdMe1	;Date & Time
	dc.l	-1			;--------
	dc.l	0			;Print Errors

EditorMenuInfo7
	dc.l	0			;Help

WindowSaveAs
	dc.b	43,9
	dc.l	WindowSaveAs1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowSaveAs1
	dc.b	1			;Input Line
	dc.b	15,1,40,3		;Box
	dc.b	4,2,"Save file :",0
WindowSaveAs2
	dc.b	2			;Yes Gadget (Return)
	dc.b	2,4,8,6			;Box
	dc.b	4,5,"Yes",0
WindowSaveAs3
	dc.b	3			;Gadget (Space)
	dc.b	16,4,21,6		;Box
	dc.b	18,5,"No",0
WindowSaveAs4
	dc.b	4			;Cancel Gadget (Esc)
	dc.b	28,4,37,6		;Box
	dc.b	30,5,"Cancel",0
	even

WindowOpen
	dc.b	43,9
	dc.l	WindowOpen1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowOpen1
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	4,2,"Open file :",0
	even

WindowMerge
	dc.b	43,9
	dc.l	WindowMerge1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowMerge1
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	3,2,"Merge file :",0
	even

WindowDelete
	dc.b	43,9
	dc.l	WindowDelete1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowDelete1
	dc.b	1			;Input Line
	dc.b	15,1,40,3
	dc.b	2,2,"Delete file :",0
	even

WindowPrint
	dc.b	29,12
	dc.l	WindowPrint1
	dc.l	WindowPrint2
	dc.l	WindowPrint3
	dc.l	WindowPrint4
	dc.l	WindowPrint5
	dc.l	0
	dc.b	0
WindowPrint1
	dc.b	5			;Choice gadget (X) (Space)
	dc.b	4,2			;Coords of X
	dc.b	2,3,0			;Unchoosed gadgets
	dc.b	3,2,"( )  Print document",0
WindowPrint2
	dc.b	5			;Choice gadget
	dc.b	4,4			;Coords
	dc.b	1,3,0			;Unchoosed
	dc.b	3,4,"( )  Print marked text",0
WindowPrint3
	dc.b	5			;Choice gadget
	dc.b	4,6			;Coords
	dc.b	1,2,0			;Unchoosed
	dc.b	3,6,"( )  Print directory",0
WindowPrint4
	dc.b	2			;Yes Gadget
	dc.b	3,8,8,10		;Box
	dc.b	5,9,"Ok",0
WindowPrint5
	dc.b	4			;Cancel Gadget
	dc.b	14,8,23,10		;Box
	dc.b	16,9,"Cancel",0
	even

WindowFind
	dc.b	46,13
	dc.l	WindowFind1
	dc.l	WindowFind2
	dc.l	WindowFind3
	dc.l	WindowFind4
	dc.l	WindowFind5
	dc.l	0
	dc.b	0
WindowFind1
	dc.b	1
	dc.b	14,1,43,3
	dc.b	2,2,"Find What :",0
WindowFind2
	dc.b	5
	dc.b	3,5
	dc.b	0
	dc.b	2,5,"( ) Whole word",0
WindowFind3
	dc.b	5
	dc.b	3,7
	dc.b	0
	dc.b	2,7,"( ) Match upper/lower case",0
WindowFind4
	dc.b	2
	dc.b	2,9,7,11
	dc.b	4,10,"Ok",0
WindowFind5
	dc.b	4
	dc.b	27,9,36,11
	dc.b	29,10,"Cancel",0
	even

WindowChange
	dc.b	46,17
	dc.l	WindowFind1
	dc.l	WindowChange2
	dc.l	WindowChange3
	dc.l	WindowChange4
	dc.l	WindowChange5
	dc.l	WindowChange6
	dc.l	WindowChange7
	dc.l	0
	dc.b	0
WindowChange2
	dc.b	1
	dc.b	14,4,43,6
	dc.b	2,5,"Change to :",0
WindowChange3
	dc.b	5
	dc.b	3,9
	dc.b	0
	dc.b	2,9,"( ) Whole word",0
WindowChange4
	dc.b	5
	dc.b	3,11
	dc.b	0
	dc.b	2,11,"( ) Match upper/lower case",0
WindowChange5
	dc.b	2
	dc.b	2,13,20,15
	dc.b	4,14,"Find and verify",0
WindowChange6
	dc.b	3
	dc.b	21,13,34,15
	dc.b	23,14,"Change all",0
WindowChange7
	dc.b	4
	dc.b	35,13,44,15
	dc.b	37,14,"Cancel",0
	even

WindowCompile
	dc.b	53,18
	dc.l	WindowCompile1
	dc.l	WindowCompile2
	dc.l	WindowCompile3
	dc.l	WindowCompile4
	dc.l	WindowCompile5
	dc.l	WindowCompile6
	dc.l	WindowCompile7
	dc.l	WindowCompile8
	dc.l	0
	dc.b	4,5,"Compiling options",0
	dc.b	34,5,"Output options",0
	dc.b	8,10,"compiling",0
	dc.b	0
WindowCompile1
	dc.b	1
	dc.b	25,1,50,3
	dc.b	4,2,"Compiling document :",0
WindowCompile2
	dc.b	5
	dc.b	5,7
	dc.b	0
	dc.b	4,7,"( ) Check error",0
WindowCompile3
	dc.b	5
	dc.b	5,8
	dc.b	0
	dc.b	4,8,"( ) Mark errors",0
WindowCompile4
	dc.b	5
	dc.b	5,9
	dc.b	0
	dc.b	4,9,"( ) Save document before",0
WindowCompile5
	dc.b	5
	dc.b	35,7
	dc.b	6,0
	dc.b	34,7,"( ) Memory",0
WindowCompile6
	dc.b	5
	dc.b	35,8
	dc.b	5,0
	dc.b	34,8,"( ) Exefile",0
WindowCompile7
	dc.b	2
	dc.b	2,13,22,15
	dc.b	4,14,"Start compilation",0
WindowCompile8
	dc.b	4
	dc.b	30,13,39,15
	dc.b	32,14,"Cancel",0
	even

WindowMake
	dc.b	43,9
	dc.l	WindowMake1
	dc.l	WindowSaveAs2
	dc.l	WindowSaveAs3
	dc.l	WindowSaveAs4
	dc.l	0
	dc.b	0
WindowMake1
	dc.b	1			;Input Line
	dc.b	17,1,40,3
	dc.b	2,2,"Make exe-file :",0
	even

WindowCalculator
	dc.b	47,11
	dc.l	WindowCalculator1
	dc.l	WindowCalculator2
	dc.l	WindowCalculator3
	dc.l	WindowCalculator4
	dc.l	WindowCalculator5
	dc.l	WindowCalculator6
	dc.l	WindowCalculator7
	dc.l	0
	dc.b	0
WindowCalculator1
	dc.b	1
	dc.b	2,4,44,6
	dc.b	2,2,"Calculator",0
WindowCalculator2
	dc.b	5
	dc.b	16,1
	dc.b	3,4,0
	dc.b	15,1,"( ) Decimal",0
WindowCalculator3
	dc.b	5
	dc.b	16,2
	dc.b	2,4,0
	dc.b	15,2,"( ) Hexadecimal",0
WindowCalculator4
	dc.b	5
	dc.b	16,3
	dc.b	2,3,0
	dc.b	15,3,"( ) Binary",0
WindowCalculator5
	dc.b	2
	dc.b	35,1,40,3
	dc.b	37,2,"Ok",0
WindowCalculator6
	dc.b	3
	dc.b	3,7,22,9
	dc.b	5,8,"Send to document",0
WindowCalculator7
	dc.b	4
	dc.b	28,7,35,9
	dc.b	30,8,"Exit",0
	even

WindowDate
	dc.b	31,14
	dc.l	WindowDate1
	dc.l	WindowDate2
	dc.l	WindowDate3
	dc.l	WindowDate4
	dc.l	WindowDate5
	dc.l	0
	dc.b	4,11,"time",0
	dc.b	15,11,"date",0
	dc.b	0
WindowDate1
	dc.b	1
	dc.b	16,1,27,3
	dc.b	2,2,"Current time",0
WindowDate2
	dc.b	1
	dc.b	16,5,27,7
	dc.b	2,6,"Current date",0
WindowDate3
	dc.b	3
	dc.b	2,9,9,12
	dc.b	4,10,"Send",0
WindowDate4
	dc.b	3
	dc.b	13,9,20,12
	dc.b	15,10,"Send",0
WindowDate5
	dc.b	2
	dc.b	22,9,27,12
	dc.b	24,10,"Ok",0
	even

EditorNew
	tst.b	$1e4(a6)
	bne	EditorNew3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
EditorNew1
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorNew4
	beq	EditorNew2
	cmp.b	#$02,d0
	beq	EditorNew2
	cmp.b	#$03,d0
	beq	EditorNew3
	cmp.b	#$04,d0
	beq	EditorNew4
	bra	EditorNew4
EditorNew2				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorNew1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorNew3				;No
	move.l	$19c(a6),a0
	clr.b	(a0)
	move.l	$150(a6),a0
	move.l	a0,$154(a6)
	move.l	a0,$186(a6)
	clr.l	$158(a6)
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	bsr	UpdateText
	bsr	UpdateLine
	bsr	EndMarking
	move.b	#$01,$1e4(a6)		;Text is unchanged
EditorNew4				;Cancel
	rts

EditorOpen
	tst.b	$1e4(a6)
	bne	EditorOpen3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
EditorOpen1
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorOpen7
	beq	EditorOpen2
	cmp.b	#$02,d0
	beq	EditorOpen2
	cmp.b	#$03,d0
	beq	EditorOpen3
	cmp.b	#$04,d0
	beq	EditorOpen7
	bra	EditorOpen7
EditorOpen2				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorOpen1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorOpen3
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
	lea	WindowOpen(pc),a0
	bsr	OpenWindow
EditorOpen4
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorOpen7
	beq	EditorOpen5
	cmp.b	#$02,d0
	beq	EditorOpen5
	cmp.b	#$03,d0
	beq	EditorOpen6
	cmp.b	#$04,d0
	beq	EditorOpen7
	bra	EditorOpen7
EditorOpen5				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorOpen4
	move.l	$150(a6),a1
	move.l	$182(a6),a2
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	clr.l	$158(a6)		;Textline nr
	bsr	GotoCurrentLine
	move.l	$15c(a6),$170(a6)
	clr.w	$166(a6)
	clr.w	$16e(a6)
	bsr	UpdateText
	bsr	UpdateLine
	bsr	EndMarking
	move.b	#$01,$1e4(a6)		;Text is unchanged
EditorOpen6				;No
	move.l	$076(a6),a0
	move.l	$19c(a6),a1
	jsr	_LVOCopyString(a6)
EditorOpen7				;Cancel
	rts

EditorMerge:
	lea	WindowMerge(pc),a0
	bsr	OpenWindow
	move.l	$076(a6),a0
	clr.b	(a0)
EditorMerge1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorMerge3
	beq	EditorMerge2
	cmp.b	#$02,d0
	beq	EditorMerge2
	cmp.b	#$03,d0
	beq	EditorMerge3
	cmp.b	#$04,d0
	beq	EditorMerge3
	bra	EditorMerge3
EditorMerge2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorMerge1
	move.l	$154(a6),a1
	move.l	$182(a6),a2
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	bsr	LoadCurrentBuffer
	bsr	UpdateText
	bsr	UpdateLine
	clr.b	$1e4(a6)		;Text not saved
EditorMerge3:				;Cancel
	rts

EditorSave:
	move.l	$19c(a6),a0
	tst.b	(a0)
	beq	EditorSaveAs
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
	rts

EditorSaveAs:
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
EditorSaveAs1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorSaveAs4
	beq	EditorSaveAs2
	cmp.b	#$02,d0
	beq	EditorSaveAs2
	cmp.b	#$03,d0
	beq	EditorSaveAs3
	cmp.b	#$04,d0
	beq	EditorSaveAs4
	bra	EditorSaveAs4
EditorSaveAs2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorSaveAs1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorSaveAs3:				;No
	move.l	$076(a6),a0
	move.l	$19c(a6),a1
	jsr	_LVOCopyString(a6)
EditorSaveAs4:				;Cancel
	rts

EditorDelete:
	move.l	$076(a6),a0
	clr.b	(a0)
	lea	WindowDelete(pc),a0
	bsr	OpenWindow
EditorDelete1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorDelete3
	beq	EditorDelete2
	cmp.b	#$02,d0
	beq	EditorDelete2
	cmp.b	#$03,d0
	beq	EditorDelete3
	cmp.b	#$04,d0
	beq	EditorDelete3
	bra	EditorDelete3
EditorDelete2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorDelete1
	bsr	DeleteFile
EditorDelete3:				;Cancel
	rts

EditorPrint:
	lea	WindowPrint(pc),a0
	bsr	OpenWindow
	link	a5,#-20
	move.l	a7,a0
	clr.l	(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$04,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorExit:
	tst.b	$1e4(a6)
	bne	EditorExit3
	lea	WindowSaveAs(pc),a0
	bsr	OpenWindow
	move.l	$19c(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
EditorExit1:
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	tst.l	d0
	bmi	EditorExit4
	beq	EditorExit2
	cmp.b	#$02,d0
	beq	EditorExit2
	cmp.b	#$03,d0
	beq	EditorExit3
	cmp.b	#$04,d0
	beq	EditorExit4
	bra	EditorExit4
EditorExit2:				;Yes
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorExit1
	move.l	$150(a6),a1
	move.l	$154(a6),a2
	bsr	SaveFile
	move.b	#$01,$1e4(a6)
EditorExit3:				;No
	bsr	MakeScreenBackup
	move.l	$1e0(a6),a7
	clr.b	$1e5(a6)		;Editor non-active
	move.w	(a7)+,$14a(a6)
	bsr	RestoreScreen
	move.l	(a7)+,$5c(a6)
	bsr	CalcYAddr
	clr.b	$1a8(a6)		;No infoline
	bra	Loop
EditorExit4:				;Cancel
	rts

EditorCut:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorCut1
	bsr	GotoAbsolute
	bsr	CopyToCutBuffer
	bsr	DeleteMarked
	bsr	LoadCurrentBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorCut1:
	rts

EditorCopy:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorCopy1
	bsr	CopyToCutBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorCopy1:
	rts

EditorPaste:
	move.l	$186(a6),a0
	cmp.l	$154(a6),a0
	beq	EditorPaste1		;Nothing in buffer
	bsr	PasteBuffer
	move.l	$15c(a6),a0
	add.w	$16c(a6),a0
	add.l	$186(a6),a0
	sub.l	$154(a6),a0
	bsr	GotoAbsolute
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorPaste1:
	rts

EditorClear:
	bsr	GetMarkedAddr
	tst.l	d0
	bmi	EditorClear1
	bsr	GotoAbsolute
	bsr	DeleteMarked
	bsr	LoadCurrentBuffer
	bsr	EndMarking
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorClear1:
	rts

EditorClearBuf:
	move.l	$154(a6),$186(a6)
	bsr	WriteCursorInfo
	rts

EditorFind:
	move.l	$1ea(a6),a0
	move.l	$076(a6),a1
	jsr	_LVOCopyString(a6)
	lea	WindowFind(pc),a0
	bsr	OpenWindow
EditorFind1:
	link	a5,#-20
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$01,d0
	bsr	EditWindow
	move.l	4(a0),d1
	move.l	8(a0),d2
	and.l	#$1,d1
	and.l	#$2,d2
	or.l	d2,d1
	unlk	a5
	tst.l	d0
	bmi	EditorFind4
	beq	EditorFind2
	cmp.b	#$04,d0
	beq	EditorFind2
	cmp.b	#$05,d0
	beq	EditorFind4
	bra	EditorFind4
EditorFind2:
	move.l	$076(a6),a0
	tst.b	(a0)
	beq	EditorFind1
	move.l	$076(a6),a0
	move.l	$1ea(a6),a1
	jsr	_LVOCopyString(a6)
	move.l	$150(a6),$1e6(a6)
	move.l	$1ea(a6),a0
	move.l	d1,d0
	move.w	d0,$1ee(a6)
	bsr	SearchText
	cmp.l	#$ffffffff,d0
	beq	EditorFind4
	move.l	d0,$1aa(a6)
	addq.l	#1,a0
EditorFind3:
	addq.l	#1,d0
	tst.b	(a0)+
	bne	EditorFind3
	move.l	d0,$1ae(a6)
	move.w	#$0001,$1b2(a6)
	move.l	$1aa(a6),a0
	bsr	GotoAbsolute
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorFind4:
	rts

EditorRepeat:
	move.l	$1ea(a6),a0
	moveq	#$00,d0
	move.w	$1ee(a6),d0
	bsr	SearchText
	cmp.l	#$ffffffff,d0
	beq	EditorRepeat2
	move.l	d0,$1aa(a6)
	addq.l	#1,a0
EditorRepeat1:
	addq.l	#1,d0
	tst.b	(a0)+
	bne	EditorRepeat1
	move.l	d0,$1ae(a6)
	move.w	#$0001,$1b2(a6)
	move.l	$1aa(a6),a0
	bsr	GotoAbsolute
	bsr	UpdateText
	bsr	UpdateLine
	bsr	RememberMarked
EditorRepeat2:
	rts

EditorChange:
	lea	WindowChange(pc),a0
	bsr	OpenWindow
	link	a5,#-28
	move.l	a7,a0
	move.l	$076(a6),(a0)
	move.l	$076(a6),4(a0)
	add.l	#80,4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	bsr	UpdateWindow
	moveq	#$05,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorCompile:
	lea	WindowCompile(pc),a0
	bsr	OpenWindow
	link	a5,#-32
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	clr.l	28(a0)
	bsr	UpdateWindow
	moveq	#$07,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorMake:
	lea	WindowMake(pc),a0
	bsr	OpenWindow
	link	a5,#-16
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	bsr	UpdateWindow
	moveq	#$02,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorCalculator:
	lea	WindowCalculator(pc),a0
	bsr	OpenWindow
	link	a5,#-28
	move.l	a7,a0
	move.l	$076(a6),(a0)
	clr.l	4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	clr.l	20(a0)
	clr.l	24(a0)
	bsr	UpdateWindow
	moveq	#$01,d0
	bsr	EditWindow
	unlk	a5
	rts

EditorDate:
	lea	WindowDate(pc),a0
	bsr	OpenWindow
	link	a5,#-20
	move.l	a7,a0
	move.l	$076(a6),(a0)
	move.l	$076(a6),4(a0)
	add.l	#80,4(a0)
	clr.l	8(a0)
	clr.l	12(a0)
	clr.l	16(a0)
	bsr	UpdateWindow
	moveq	#$05,d0
	bsr	EditWindow
	unlk	a5
	rts

*****************************************************************************

MenuSystem:					;Handles Menu System
						;A0=MenuHeadInfo
						;D0out=Routine selected
	movem.l	d1-d7/a0-a5,-(a7)
	move.l	$05c(a6),-(a7)
	move.l	a0,$1d0(a6)
	move.w	#$ffff,$1c8(a6)
	move.w	#$ffff,$1ca(a6)
	clr.l	$1cc(a6)
	bsr	RememberMarked
	bsr	ShowMenuHeader
MenuSystem1:
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq.s	MenuSystem2
	cmp.b	#$9b,d0
	beq	MenuSystem7
	cmp.b	#$1b,d0
	bne	MenuSystem8
	bsr	RevMenuHeadItem
	move.l	$1d0(a6),a0
	move.l	8(a0),a0
	move.w	$1c8(a6),d0
	bmi	MenuSystemError
	mulu	#$000c,d0
	add.w	d0,a0
	move.l	4(a0),a0
	bsr	RemoveMenu
	move.w	#$ffff,$1c8(a6)
	move.w	#$ffff,$1ca(a6)
	clr.l	$1cc(a6)
	move.l	#$00010000,d0
	bsr	WriteMousePosition
	bra	MenuSystem1
MenuSystem2:
	bsr	ReadMousePosition
	move.l	d0,d1
	swap	d1
	tst.w	d1
	bne	MenuSystem5
	move.l	$1d0(a6),a0
	move.l	4(a0),a0
	addq.l	#1,a0
	moveq	#$ffffffff,d1
MenuSystem3:
	addq.l	#1,d1
	cmp.b	(a0)+,d0
	bhi.s	MenuSystem3
	bsr	RevMenuSubItem
	move.w	#$ffff,$1ca(a6)
	clr.l	$1cc(a6)
	cmp.w	$1c8(a6),d1
	beq	MenuSystem1
	bsr	RevMenuHeadItem
	move.l	$1d0(a6),a0
	move.l	8(a0),a0
	move.w	$1c8(a6),d0
	bmi	MenuSystem4
	mulu	#$000c,d0
	add.w	d0,a0
	move.l	4(a0),a0
	bsr	RemoveMenu
MenuSystem4:	
	move.w	d1,$1c8(a6)
	bsr	RevMenuHeadItem
	move.l	$1d0(a6),a0
	move.l	8(a0),a0
	move.w	$1c8(a6),d0
	mulu	#$000c,d0
	add.w	d0,a0
	move.l	4(a0),a0
	bsr	ShowMenu
	bra	MenuSystem1
MenuSystem5:
	move.w	$1c8(a6),d0
	bmi	MenuSystem1
	move.l	$1d0(a6),a0
	move.l	8(a0),a0			;MenuHead2
	mulu	#$000c,d0
	add.w	d0,a0
	move.l	(a0)+,a2			;MenuInfo
	move.l	(a0)+,a1			;MenuText
	bsr	ReadMousePosition
	cmp.b	(a1),d0
	bls	MenuSystem6
	cmp.b	2(a1),d0
	bhi	MenuSystem6
	beq	MenuSystem6
	swap	d0
	cmp.b	1(a1),d0
	bls	MenuSystem6
	cmp.b	3(a1),d0
	bhi	MenuSystem6
	beq	MenuSystem6
	sub.b	1(a1),d0
	subq.b	#1,d0
	and.w	#$00ff,d0
	cmp.w	$1ca(a6),d0
	beq	MenuSystem1
	move.l	d0,d1
	mulu	#$0004,d0
	adda.w	d0,a2
	cmp.l	#-1,(a2)
	beq	MenuSystem6
	move.l	(a2),$1cc(a6)
	bsr	RevMenuSubItem
	move.w	d1,$1ca(a6)
	bsr	RevMenuSubItem
	bra	MenuSystem1
MenuSystem6:
	bsr	RevMenuSubItem
	move.w	#$ffff,$1ca(a6)
	clr.l	$1cc(a6)
	bra	MenuSystem1
MenuSystem7:
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
	cmp.b	#$01,d0
	bne	MenuSystemError
	move.l	4(a0),d0
	cmp.b	#43,d0			;Right MOBUT Released
	beq	MenuSystem1
	cmp.b	#45,d0			;Right ALT Released
	beq	MenuSystem1
	cmp.b	#41,d0			;Right MOBUT Pressed
	beq	MenuSystemExit
	bra	MenuSystemError
MenuSystem8:
	and.w	#$005f,d0
	move.w	$1c8(a6),d1
	bpl	MenuSystem10
	move.l	$1d0(a6),a0
	move.l	$0c(a0),a0
MenuSystem9:
	move.b	(a0)+,d1
	beq	MenuSystemError
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	cmp.b	d1,d0
	bne	MenuSystem9
	moveq	#$00,d0
	move.b	d3,d0
	swap	d0
	move.b	d2,d0
	bsr	WriteMousePosition
	bra	MenuSystem1
MenuSystem10:
	move.l	$1d0(a6),a0
	move.l	8(a0),a0
	mulu	#$000c,d1
	add.w	d1,a0
	move.l	(a0)+,a2
	move.l	(a0)+,a1
	move.l	(a0),a0
MenuSystem11:
	move.b	(a0)+,d1
	beq	MenuSystemError
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	cmp.b	d1,d0
	bne	MenuSystem11
	bsr	RevMenuSubItem
	moveq	#$00,d0
	move.b	d3,d0
	swap	d0
	move.b	d2,d0
	bsr	WriteMousePosition
	move.b	d3,d0
	sub.b	1(a1),d0
	subq.b	#1,d0
	and.w	#$00ff,d0
	move.w	d0,$1ca(a6)
	mulu	#$0004,d0
	adda.w	d0,a2
	move.l	(a2),$1cc(a6)
	bsr	RevMenuSubItem
	bra	MenuSystemExit
MenuSystemError:
	clr.l	$1cc(a6)
MenuSystemExit:
	bsr	RestoreScreen
	bsr	RestoreAllMarked
	move.l	$1cc(a6),d0
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d1-d7/a0-a5
	rts

ShowMenuHeader:					;Shows the Menu Header
						;A0=MenuHeadText
	move.l	a0,-(a7)
	move.l	$05c(a6),-(a7)
	move.b	$074(a6),-(a7)
	move.w	#$0000,$05c(a6)
	move.w	#$0000,$05e(a6)
	move.b	#$ff,$074(a6)			;Inverse
	move.l	$1d0(a6),a0			;Menu Head Info
	move.l	(a0),a0
	bsr	WriteBitmapString
	move.b	#$00,$074(a6)			;No Inverse
	move.b	(a7)+,$074(a6)
	move.l	(a7)+,$05c(a6)
	move.l	(a7)+,a0
	rts

RevMenuHeadItem:			;Reverses Menu Head Item
	movem.l	d0-d1/a0,-(a7)
	move.l	$05c(a6),-(a7)
	move.w	$1c8(a6),d0
	bmi.s	RevMenuHeadItem1	;No Item Selected
	move.w	#$0000,$05c(a6)
	move.l	$1d0(a6),a0
	move.l	4(a0),a0		;MenuHead1
	add.w	d0,a0
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	(a0)+,d0
	move.b	(a0),d1
	subq.w	#1,d1
	bsr	ReverseMenuLine
RevMenuHeadItem1:
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d1/a0
	rts

RevMenuSubItem:				;Reverses Menu Sub Item
	movem.l	d0-d1/a0,-(a7)
	move.l	$05c(a6),-(a7)
	move.w	$1c8(a6),d0
	bmi	RevMenuSubItem1
	move.l	$1d0(a6),a0
	move.l	8(a0),a0		;MenuHead2
	mulu	#$000c,d0
	add.w	d0,a0
	move.l	4(a0),a0
	move.w	$1ca(a6),d0
	bmi	RevMenuSubItem1
	moveq	#$00,d1
	move.b	1(a0),d1
	add.w	d1,d0
	addq.w	#1,d0
	move.w	d0,$05c(a6)
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	(a0),d0
	move.b	2(a0),d1
	addq.w	#1,d0
	subq.w	#1,d1
	bsr	ReverseMenuLine
RevMenuSubItem1:
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d1/a0
	rts

ReverseMenuLine:			;Reverses a line
					;D0/D1=x1/x2
	movem.l	d0-d2/a0,-(a7)
	move.w	d0,d2
	bsr	CalcYAddr
	move.l	$178(a6),a0
	add.w	d2,a0
ReverseMenuLine1:
	eor.b	#$ff,(a0)
	eor.b	#$ff,$0050(a0)
	eor.b	#$ff,$00a0(a0)
	eor.b	#$ff,$00f0(a0)
	eor.b	#$ff,$0140(a0)
	eor.b	#$ff,$0190(a0)
	eor.b	#$ff,$01e0(a0)
	eor.b	#$ff,$0230(a0)
	addq.l	#1,a0
	addq.w	#1,d2
	cmp.w	d1,d2
	bls.s	ReverseMenuLine1
	movem.l	(a7)+,d0-d2/a0
	rts

DrawMenuSelBox:				;Draws a select box on bitmap.
					;D0/D1=x1/y1 , D2/D3=x2/y2
	movem.l	d0-d5/a0-a2,-(a7)
	move.l	$05c(a6),-(a7)		;X & Y on stack
	move.w	d1,d5
	lea	DrawMenuSelBoxData(pc),a2
	bra	DrawMenuBigBox1

DrawMenuBigBox:				;Draws a cleared box on bitmap.
					;D0/D1=x1/y1 , D2/D3=x2/y2
	movem.l	d0-d5/a0-a2,-(a7)
	move.l	$05c(a6),-(a7)		;X & Y on stack
	move.w	d1,d5
	lea	DrawMenuBigBoxData(pc),a2
DrawMenuBigBox1:
	move.l	a2,a1
	move.w	d0,d4
	cmp.w	d5,d1
	beq.s	DrawMenuBigBox2
	lea	$0018(a1),a1
	cmp.w	d5,d3
	bhi.s	DrawMenuBigBox2
	lea	$0018(a1),a1
DrawMenuBigBox2:
	move.w	d5,$05c(a6)		;Y
	move.w	d4,$05e(a6)		;X
	bsr	CalcYAddr
	move.l	$178(a6),a0		;Bitmap
	adda.w	d4,a0
	move.b	(a1)+,(a0)
	move.b	(a1)+,$0050(a0)
	move.b	(a1)+,$00a0(a0)
	move.b	(a1)+,$00f0(a0)
	move.b	(a1)+,$0140(a0)
	move.b	(a1)+,$0190(a0)
	move.b	(a1)+,$01e0(a0)
	move.b	(a1)+,$0230(a0)
	addq.w	#1,d4
	addq.l	#1,a0
DrawMenuBigBox3:
	cmp.w	d4,d2
	bls.s	DrawMenuBigBox4
	move.b	(a1)+,(a0)
	move.b	(a1)+,$0050(a0)
	move.b	(a1)+,$00a0(a0)
	move.b	(a1)+,$00f0(a0)
	move.b	(a1)+,$0140(a0)
	move.b	(a1)+,$0190(a0)
	move.b	(a1)+,$01e0(a0)
	move.b	(a1)+,$0230(a0)
	subq.l	#8,a1
	addq.w	#1,d4
	addq.l	#1,a0	
	bra.s	DrawMenuBigBox3
DrawMenuBigBox4:
	addq.l	#8,a1
	move.b	(a1)+,(a0)
	move.b	(a1)+,$0050(a0)
	move.b	(a1)+,$00a0(a0)
	move.b	(a1)+,$00f0(a0)
	move.b	(a1)+,$0140(a0)
	move.b	(a1)+,$0190(a0)
	move.b	(a1)+,$01e0(a0)
	move.b	(a1)+,$0230(a0)
	addq.w	#1,d5
	cmp.w	d3,d5
	bls	DrawMenuBigBox1
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d5/a0-a2
	rts

DrawMenuBigBoxData:
	dc.b	$00,$00,$00,$3f,$30,$30,$30,$30
	dc.b	$00,$00,$00,$ff,$00,$00,$00,$00
	dc.b	$00,$00,$00,$fc,$0c,$0c,$0c,$0c
	dc.b	$30,$30,$30,$30,$30,$30,$30,$30
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
	dc.b	$30,$30,$30,$30,$3f,$00,$00,$00
	dc.b	$00,$00,$00,$00,$ff,$00,$00,$00
	dc.b	$0c,$0c,$0c,$0c,$fc,$00,$00,$00
	
DrawMenuSelBoxData:
	dc.b	$00,$00,$7f,$60,$67,$66,$66,$66
	dc.b	$00,$00,$ff,$00,$ff,$00,$00,$00
	dc.b	$00,$00,$fe,$06,$e6,$66,$66,$66
	dc.b	$66,$66,$66,$66,$66,$66,$66,$66
	dc.b	$00,$00,$00,$00,$00,$00,$00,$00
	dc.b	$66,$66,$66,$66,$66,$66,$66,$66
	dc.b	$66,$66,$66,$67,$60,$7f,$00,$00
	dc.b	$00,$00,$00,$ff,$00,$ff,$00,$00
	dc.b	$66,$66,$66,$e6,$06,$fe,$00,$00
	
DrawMenuLineData:
	dc.b	$30,$30,$30,$3f,$30,$30,$30,$30
	dc.b	$00,$00,$00,$ff,$00,$00,$00,$00
	dc.b	$0c,$0c,$0c,$fc,$0c,$0c,$0c,$0c

DrawMenuLine:				;Draws a line on bitmap.
					;D0/D1=x1/x2
	movem.l	d0-d5/a0-a2,-(a7)
	move.l	$05c(a6),-(a7)		;X & Y on stack
	lea	DrawMenuLineData(pc),a1
	move.w	d0,d4
	move.w	d1,d2
	moveq	#$00,d3
	move.w	$05c(a6),d3
	move.l	d3,d5
	bra	DrawMenuBigBox2

ShowMenu:				;Shows a menu window
					;A0=EditorMenuText
	movem.l	d0-d5/a0,-(a7)
	move.l	$05c(a6),-(a7)
	clr.l	d0
	clr.l	d1
	clr.l	d2
	clr.l	d3
	move.b	(a0)+,d0		;x1
	move.b	(a0)+,d1		;y1
	move.b	(a0)+,d2		;x2
	move.b	(a0)+,d3		;y2
	move.w	d0,d4
	move.w	d1,d5
	bsr	DrawMenuBigBox
ShowMenu1:
	addq.w	#1,d5
	cmp.w	d5,d3
	bls.s	ShowMenu3
	tst.b	(a0)
	beq.s	ShowMenu3
	move.w	d5,$05c(a6)		;Y
	move.w	d4,d0
	addq.w	#1,d0
	move.w	d0,$05e(a6)		;X
	move.b	(a0),d0
	cmp.b	#$ff,d0
	bne.s	ShowMenu2
	addq.l	#1,a0
	move.w	d4,d0
	move.w	d2,d1
	bsr	DrawMenuLine
	bra.s	ShowMenu1
ShowMenu2:
	bsr	WriteBitmapString
	move.l	d0,a0
	bra.s	ShowMenu1
ShowMenu3:
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d5/a0
	rts

RemoveMenu:					;Removes a menu window
						;A0=EditorMenuText
	movem.l	d0-d7/a0-a4,-(a7)
	move.l	$05c(a6),-(a7)
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6
	moveq	#$00,d7
	move.b	(a0)+,d4		;x1
	move.b	(a0)+,d5		;y1
	move.b	(a0)+,d6		;x2
	move.b	(a0)+,d7		;y2
	movem.l	d4-d7,-(a7)
	move.l	$010(a6),a3
	move.l	$00c(a6),a4
RemoveMenu1:
	move.w	d5,$05c(a6)
	bsr	CalcYAddr
	move.l	$178(a6),a1		;Bitmap
	add.w	d4,a1
	move.l	$17c(a6),a2		;Charmap
	add.w	d4,a2
	move.w	d4,d3
RemoveMenu2:
	move.b	(a2)+,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	d0,d1
	bpl.s	RemoveMenu3
	sub.b	#$0020,d1
	bmi.s	RemoveMenu4
	moveq	#-1,d2
	add.b	#$0040,d1
	bra.s	RemoveMenu4
RemoveMenu3:
	sub.b	#$0020,d1
	bpl.s	RemoveMenu4
	moveq	#-1,d2
	add.b	#$0040,d1
RemoveMenu4:
	add.w	d1,d1
	add.w	d1,d1
	move.w	00(a3,d1.w),d1
	lsr.w	#3,d1
	lea	0(a4,d1.w),a0
	tst.b	d2
	beq.s	RemoveMenu5
	move.b	$00c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d2,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d2,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d2,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d2,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d2,d0
	move.b	d0,$0230(a1)
	move.b	(a0),d0
	eor.b	d2,d0
	move.b	d0,(a1)+
	bra.s	RemoveMenu6
RemoveMenu5:
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
	move.b	(a0),(a1)+
RemoveMenu6:
	addq.w	#1,d3
	cmp.w	d6,d3
	bls	RemoveMenu2
	addq.w	#1,d5
	cmp.w	d7,d5
	bls	RemoveMenu1
	movem.l	(a7)+,d0-d3
	bsr	RestoreMarked
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d7/a0-a4
	rts

*****************************************************************************

*****************************************************************************

OpenWindow:				;Opens a window
					;A0=Window
	movem.l	d1-d3/a0-a1,-(a7)
	move.l	a0,$1d8(a6)
	moveq	#80,d0
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	move.b	(a0)+,d2		;X width
	sub.b	d2,d0
	lsr.b	#1,d0
	add.b	d0,d2
	subq.b	#1,d2
	move.w	$14c(a6),d1
	subq.w	#1,d1
	move.b	(a0)+,d3
	sub.b	d3,d1
	lsr.b	#1,d1
	add.b	d1,d3
	subq.b	#1,d3
	move.b	d0,$1d4(a6)
	move.b	d1,$1d5(a6)
	move.b	d2,$1d6(a6)
	move.b	d3,$1d7(a6)
	bsr	DrawMenuBigBox
OpenWindow1:
	move.l	(a0)+,d0
	beq	OpenWindow6
	move.l	d0,a1
	move.b	(a1)+,d0
	cmp.b	#$01,d0
	beq	OpenWindow2
	cmp.b	#$02,d0
	beq	OpenWindow3
	cmp.b	#$03,d0
	beq	OpenWindow3
	cmp.b	#$04,d0
	beq	OpenWindow3
	cmp.b	#$05,d0
	beq	OpenWindow4
	bra	OpenWindow1
OpenWindow2:
	move.l	a0,-(a7)
	move.l	a1,a0
	moveq	#$00,d0
	bsr	OpenWindowBox
	move.l	d0,a0
	bsr	OpenWindowText
	move.l	(a7)+,a0
	bra	OpenWindow1
OpenWindow3:
	move.l	a0,-(a7)
	move.l	a1,a0
	moveq	#$01,d0
	bsr	OpenWindowBox
	move.l	d0,a0
	bsr	OpenWindowText
	move.l	(a7)+,a0
	bra	OpenWindow1
OpenWindow4:
	move.l	a0,-(a7)
	move.l	a1,a0
	addq.l	#2,a0
OpenWindow5:
	tst.b	(a0)+
	bne.s	OpenWindow5
	bsr	OpenWindowText
	move.l	(a7)+,a0
	bra	OpenWindow1
OpenWindow6:
	tst.b	(a0)
	beq	OpenWindow7
	bsr	OpenWindowText
	move.l	d0,a0
	bra	OpenWindow6
OpenWindow7:
	movem.l	(a7)+,d1-d3/a0-a1
	rts

OpenWindowText:
					;A0=Windowtext
	movem.l	d1/a0,-(a7)
	move.l	$05c(a6),-(a7)
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	add.b	$1d4(a6),d0
	add.b	$1d5(a6),d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
	bsr	WriteBitmapString
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d1/a0
	rts

OpenWindowBox:
					;A0=Windowbox,D0=Boxtype (0=Big)
	movem.l	d1-d4/a0,-(a7)
	move.w	d0,d4
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	$1d4(a6),d0
	move.b	$1d5(a6),d1
	move.l	d0,d2
	move.l	d1,d3
	add.b	(a0)+,d0
	add.b	(a0)+,d1
	add.b	(a0)+,d2
	add.b	(a0)+,d3
	tst.w	d4
	bne	OpenWindowBox1
	bsr	DrawMenuBigBox	
	bra	OpenWindowBox2
OpenWindowBox1:
	bsr	DrawMenuSelBox
OpenWindowBox2:
	move.l	a0,d0
	movem.l	(a7)+,d1-d4/a0
	rts

UpdateWindow:
					;A0=SelectinfoHead
	movem.l	d0/a0-a2,-(a7)
	move.l	a0,a1
	move.l	$1d8(a6),a2
	addq.l	#2,a2
UpdateWindow1:
	tst.l	(a2)
	beq	UpdateWindow4
	move.l	(a2)+,a0
	move.b	(a0)+,d0
	cmp.b	#$01,d0
	beq	UpdateWindow2
	cmp.b	#$05,d0
	beq	UpdateWindow3
	addq.l	#4,a1
	bra	UpdateWindow1
UpdateWindow2:
	clr.b	$1dc(a6)
	bsr	UpdateWindowInput
	addq.l	#4,a1
	bra	UpdateWindow1
UpdateWindow3:
	bsr	UpdateWindowChoice
	addq.l	#4,a1
	bra	UpdateWindow1
UpdateWindow4:
	movem.l	(a7)+,d0/a0-a2
	rts

UpdateWindowChoice:
					;A0=Choicegadget,A1=Selectinfo
	movem.l	d0-d1/a0-a1,-(a7)
	move.l	$05c(a6),-(a7)
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	$1d4(a6),d0
	move.b	$1d5(a6),d1
	add.b	(a0)+,d0
	add.b	(a0)+,d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
	moveq	#'X',d0
	tst.l	(a1)
	bne.s	UpdateWindowChoice1
	moveq	#' ',d0
UpdateWindowChoice1:
	bsr	WriteBitmapChar
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d1/a0-a1
	rts

UpdateWindowInput:
					;A0=Inputgadget,A1=Selectinfo
	movem.l	d0-d2/a0-a1,-(a7)
	move.l	$05c(a6),-(a7)
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.b	#1,d0
	addq.b	#1,d1
	sub.b	d0,d2
	add.b	$1d4(a6),d0
	add.b	$1d5(a6),d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
	moveq	#$00,d0
	move.b	$1dc(a6),d0
	move.l	(a1),a0
	add.l	d0,a0
UpdateWindowInput1:
	tst.b	d2
	beq	UpdateWindowInput3
	moveq	#' ',d0
	tst.b	(a0)
	beq	UpdateWindowInput2
	move.b	(a0)+,d0
UpdateWindowInput2:
	bsr	WriteBitmapChar
	subq.b	#1,d2
	bra	UpdateWindowInput1
UpdateWindowInput3:
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d2/a0-a1
	rts

UnSelWindowChoice:
					;A0=UnSelectList,A1=Selectinfohead
	movem.l	d0/a0-a4,-(a7)
	move.l	a0,a3
	move.l	a1,a4
	move.l	$1d8(a6),a2
	addq.l	#2,a2
UnSelWindowChoice1:
	moveq	#$00,d0
	move.b	(a3)+,d0
	beq	UnSelWindowChoice2
	subq.b	#1,d0
	lsl.l	#2,d0
	lea	0(a4,d0.l),a1
	clr.l	(a1)
	lea	0(a2,d0.l),a0
	move.l	(a0),a0
	addq.l	#1,a0
	bsr	UpdateWindowChoice
	bra	UnSelWindowChoice1
UnSelWindowChoice2:
	movem.l	(a7)+,d0/a0-a4
	rts

EditWindow:
					;A0=SelectinfoHead,D0=Selected gadget
	movem.l	d1-d7/a0-a5,-(a7)
	move.l	$05c(a6),-(a7)
	move.b	d0,$1de(a6)
	move.l	a0,a3
	move.l	$1d8(a6),a2
	addq.l	#2,a2
EditWindow1:
	moveq	#$00,d0
	move.b	$1de(a6),d0
	subq.b	#1,d0
	lsl.l	#2,d0
	lea	0(a2,d0.l),a4
	lea	0(a3,d0.l),a1
	move.l	(a4),a0
	move.b	(a0)+,d0
	cmp.b	#$01,d0
	beq	EditWindow2
	cmp.b	#$02,d0
	beq	EditWindow3
	cmp.b	#$03,d0
	beq	EditWindow3
	cmp.b	#$04,d0
	beq	EditWindow3
	cmp.b	#$05,d0
	beq	EditWindow4
	bra	EditWindow30
EditWindow2:
	bsr	UpdateWindowInput
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.b	#1,d0
	addq.b	#1,d1
	sub.b	d0,d2
	add.b	$1d4(a6),d0
	add.b	$1d5(a6),d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
	clr.b	$1dc(a6)
	clr.b	$1dd(a6)
	move.b	d2,$1df(a6)
	bra	EditWindow5
EditWindow3:
	addq.l	#4,a0
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	add.b	$1d4(a6),d0
	add.b	$1d5(a6),d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
	bra	EditWindow5
EditWindow4:
	bsr	UpdateWindowChoice
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	add.b	$1d4(a6),d0
	add.b	$1d5(a6),d1
	move.w	d0,$05e(a6)
	move.w	d1,$05c(a6)
EditWindow5:
	bsr	ShowCursor
EditWindow6:
	jsr	_LVOReadKeyboard(a6)
	tst.b	d0
	beq	EditWindow6
	bsr	RemCursor
	cmp.b	#$9b,d0			;CSI
	beq	EditWindow20
	cmp.b	#$0d,d0			;Return
	beq	EditWindow7
	cmp.b	#$1b,d0			;Esc
	beq	EditWindow8
	cmp.b	#$09,d0			;Tab
	beq	EditWindow9
	move.l	(a4),a0
	cmp.b	#$01,(a0)
	beq	EditWindow13
	cmp.b	#' ',d0			;Space (Select)
	beq	EditWindow10
	bra	EditWindow5
EditWindow7:				;Return (OK)
	move.l	(a4),a0
	cmp.b	#$04,(a0)
	beq	EditWindow8
	cmp.b	#$01,(a0)
	beq	EditWindow9
	clr.b	$1de(a6)
	bra	EditWindow30
EditWindow8:				;Escape (Cancel)
	move.b	#$ff,$1de(a6)
	bra	EditWindow30
EditWindow9:				;Tab (Next Gadget)
	addq.b	#1,$1de(a6)
	tst.l	4(a4)
	bne	EditWindow1
	move.b	#$01,$1de(a6)
	bra	EditWindow1
EditWindow10:				;Space (Select,Toggle)
	move.l	(a4),a0
	cmp.b	#$05,(a0)
	beq	EditWindow11
	bra	EditWindow30		;(Select)
EditWindow11:
	addq.l	#3,a0
	tst.b	(a0)
	bne	EditWindow12
	not.l	(a1)			;(Toggle)
	bra	EditWindow1
EditWindow12:
	move.l	#$ffffffff,(a1)		;(Select one choice)
	move.l	a3,a1
	bsr	UnSelWindowChoice	;(Unselect the other choices)
	bra	EditWindow1
EditWindow13:
	cmp.b	#$08,d0			;BackSpace
	beq	EditWindow17
	cmp.b	#$7f,d0			;Delete
	beq	EditWindow18
	move.l	(a1),a0
	move.l	d0,d1
	bsr	EditWindowInputLen
	cmp.b	#79,d0
	beq	EditWindow5
	move.l	d1,d0
	bsr	EditWindowInputIns
	bsr	EditWindowInputFor
	bra	EditWindow19
EditWindow14:
	move.l	$1c4(a6),a0
	move.l	4(a0),d0
	cmp.b	#3,d0			;CRSR Left
	beq	EditWindow16
	cmp.b	#4,d0			;CRSR Right
	beq	EditWindow15
	cmp.b	#9,d0			;Del
	beq	EditWindow18
	bra	EditWindow5
EditWindow15:				;Cursor forward
	move.l	(a1),a0
	moveq	#$00,d0
	move.b	$1dc(a6),d0
	add.b	$1dd(a6),d0
	tst.b	0(a0,d0.w)
	beq	EditWindow5
	bsr	EditWindowInputFor
	bra	EditWindow19
EditWindow16:				;Cursor backward
	move.b	$1dc(a6),d0
	add.b	$1dd(a6),d0
	beq	EditWindow5
	bsr	EditWindowInputBac
	bra	EditWindow19
EditWindow17:				;Backspace
	move.b	$1dc(a6),d0
	add.b	$1dd(a6),d0
	beq	EditWindow5
	bsr	EditWindowInputBac
	move.l	(a1),a0
	bsr	EditWindowInputDel
	bra	EditWindow19
EditWindow18:				;Delete
	move.l	(a1),a0
	moveq	#$00,d0
	move.b	$1dc(a6),d0
	add.b	$1dd(a6),d0
	tst.b	0(a0,d0.w)
	beq	EditWindow5
	bsr	EditWindowInputDel
EditWindow19:
	move.l	(a4),a0
	addq.l	#1,a0
	bsr	UpdateWindowInput
	bra	EditWindow5
EditWindow20:				;CSI
	move.l	$1c4(a6),a0
	bsr	ReadCSIPar
	cmp.b	#$01,d0
	bne	EditWindow5
	move.l	4(a0),d0
	cmp.b	#40,d0			;Left MOBUT Pressed
	beq	EditWindow21
	cmp.b	#41,d0			;Right MOBUT Pressed
	beq	EditWindow21
	move.l	(a4),a0
	cmp.b	#$01,(a0)
	beq	EditWindow14
	bra	EditWindow5
EditWindow21:
	bsr	EditWindowGetGadget
	tst.b	d0
	beq	EditWindow5
	move.b	$1de(a6),d1
	move.b	d0,$1de(a6)
	subq.b	#1,d0
	lsl.l	#2,d0
	lea	0(a2,d0.l),a4
	lea	0(a3,d0.l),a1
	move.l	(a4),a0
	move.b	(a0)+,d0
	cmp.b	#$01,d0
	beq	EditWindow22
	bra	EditWindow10
EditWindow22:
	cmp.b	$1de(a6),d1
	beq	EditWindow5
	bra	EditWindow1
EditWindow30:
	moveq	#$00,d0
	move.b	$1de(a6),d0
	ext.w	d0
	ext.l	d0
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d1-d7/a0-a5
	rts

EditWindowInputLen:
					;A0=String,D0out=Length
	movem.l	d1/a0-a1,-(a7)
	moveq	#$00,d1
	lea	79(a0),a1
EditWindowInputLen1:
	cmp.l	a0,a1
	beq	EditWindowInputLen2
	tst.b	(a0)+
	beq	EditWindowInputLen2
	addq.w	#1,d1
	bra	EditWindowInputLen1
EditWindowInputLen2:
	move.l	d1,d0
	movem.l	(a7)+,d1/a0-a1
	rts

EditWindowInputIns:			;A0=String,D0=Char
	movem.l	d1/a0-a2,-(a7)
	moveq	#$00,d1
	move.b	$1dc(a6),d1
	add.b	$1dd(a6),d1
	cmp.b	#$4f,d1
	beq	EditWindowInputIns3
	lea	0(a0,d1.w),a1
	lea	79(a0),a2
EditWindowInputIns1:
	cmp.l	a1,a2
	bls	EditWindowInputIns2
	move.b	-(a2),1(a2)
	bra	EditWindowInputIns1
EditWindowInputIns2:
	move.b	d0,(a1)
	clr.b	79(a0)
EditWindowInputIns3:
	movem.l	(a7)+,d1/a0-a2
	rts

EditWindowInputDel:			;A0=String
	movem.l	d1/a0-a2,-(a7)
	moveq	#$00,d1
	move.b	$1dc(a6),d1
	add.b	$1dd(a6),d1
	cmp.b	#79,d1
	beq	EditWindowInputDel3
	lea	0(a0,d1.w),a1
	lea	79(a0),a2
EditWindowInputDel1:
	cmp.l	a1,a2
	bls	EditWindowInputDel2
	move.b	1(a1),(a1)+
	bra	EditWindowInputDel1
EditWindowInputDel2:
	clr.b	79(a0)
EditWindowInputDel3:
	movem.l	(a7)+,d1/a0-a2
	rts

EditWindowInputFor:
	movem.l	d0-d1,-(a7)
	move.b	$1dc(a6),d0
	move.b	$1dd(a6),d1
	add.b	d1,d0
	cmp.b	#79,d0
	beq	EditWindowInputFor1
	addq.b	#1,d1
	addq.w	#1,$05e(a6)
	cmp.b	$1df(a6),d1
	bne	EditWindowInputFor1
	subq.b	#1,d1
	subq.w	#1,$05e(a6)
	addq.b	#1,$1dc(a6)
EditWindowInputFor1:
	move.b	d1,$1dd(a6)
	movem.l	(a7)+,d0-d1
	rts
	
EditWindowInputBac:
	movem.l	d0-d1,-(a7)
	move.b	$1dc(a6),d0
	move.b	$1dd(a6),d1
	subq.w	#1,$05e(a6)
	subq.b	#1,d1
	bpl	EditWindowInputBac1
	addq.w	#1,$05e(a6)
	addq.b	#1,d1
	tst.b	d0
	beq	EditWindowInputBac1
	subq.b	#1,d0
EditWindowInputBac1:
	move.b	d0,$1dc(a6)
	move.b	d1,$1dd(a6)
	movem.l	(a7)+,d0-d1
	rts

EditWindowGetGadget:
					;D0out=Selected gadget
	movem.l	d1-d6/a0-a1,-(a7)
	move.l	$1d8(a6),a1
	addq.l	#2,a1
	moveq	#$00,d5
	moveq	#$00,d6
EditWindowGetGadget1:
	tst.l	(a1)
	beq	EditWindowGetGadget4
	addq.l	#1,d5
	bsr	ReadMousePosition
	move.l	(a1)+,a0
	move.b	(a0)+,d1
	cmp.b	#$01,d1
	beq	EditWindowGetGadget2
	cmp.b	#$02,d1
	beq	EditWindowGetGadget2
	cmp.b	#$03,d1
	beq	EditWindowGetGadget2
	cmp.b	#$04,d1
	beq	EditWindowGetGadget2
	cmp.b	#$05,d1
	beq	EditWindowGetGadget3
	bra	EditWindowGetGadget4
EditWindowGetGadget2:
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	$1d4(a6),d1
	move.b	$1d5(a6),d2
	move.l	d1,d3
	move.l	d2,d4
	add.b	(a0)+,d1
	add.b	(a0)+,d2
	add.b	(a0)+,d3
	add.b	(a0)+,d4
	cmp.w	d0,d1
	bhi	EditWindowGetGadget1
	cmp.w	d3,d0
	bhi	EditWindowGetGadget1
	swap	d0
	cmp.w	d0,d2
	bhi	EditWindowGetGadget1
	cmp.w	d4,d0
	bhi	EditWindowGetGadget1
	move.l	d5,d6
	bra	EditWindowGetGadget4
EditWindowGetGadget3:
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	$1d4(a6),d1
	move.b	$1d5(a6),d2
	add.b	(a0)+,d1
	add.b	(a0)+,d2
	move.w	d1,d3
	subq.w	#1,d1
	addq.w	#1,d3
	cmp.w	d0,d1
	bhi	EditWindowGetGadget1
	cmp.w	d3,d0
	bhi	EditWindowGetGadget1
	swap	d0
	cmp.w	d0,d2
	bne	EditWindowGetGadget1
	move.l	d5,d6
EditWindowGetGadget4:
	move.l	d6,d0
	movem.l	(a7)+,d1-d6/a0-a1
	rts

*****************************************************************************

GotoAbsolute:				;Goes to specific adress in text
					;A0=Address
	movem.l	d0-d1/a0-a1,-(a7)
	bsr	LoadCurrentBuffer
GotoAbsolute1:
	cmp.l	$15c(a6),a0
	bhi	GotoAbsolute2
	beq	GotoAbsolute2
	bsr	GotoPrecCurLine
	subq.w	#1,$5c(a6)
	bpl	GotoAbsolute1
	clr.w	$5c(a6)
	move.l	$15c(a6),$170(a6)
	bra	GotoAbsolute1
GotoAbsolute2:
	move.l	$15c(a6),a1
	add.w	$164(a6),a1
	cmp.l	a0,a1
	bhi	GotoAbsolute3
	move.l	$158(a6),d1
	bsr	GotoNextCurLine
	cmp.l	$158(a6),d1
	beq	GotoAbsolute3
	addq.w	#1,$5c(a6)
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bhi	GotoAbsolute2
	subq.w	#1,$5c(a6)
	bsr	GotoNextTopLine
	bra	GotoAbsolute2
GotoAbsolute3:
	move.l	a0,d1
	sub.l	$15c(a6),d1
	move.w	d1,$16c(a6)
	bsr	CalColumnNr
	bsr	CalCursorX
	movem.l	(a7)+,d0-d1/a0-a1
	rts

InsCharBuffer:
	movem.l	d1-d2/a0,-(a7)
	move.l	$160(a6),a0		;Line Buffer Addr
	move.w	$164(a6),d1		;Line Length
	move.w	$16c(a6),d2		;Line Index
InsCharBuffer1:
	cmp.w	d1,d2
	beq.s	InsCharBuffer2
	subq.w	#1,d1
	move.b	0(a0,d1.w),1(a0,d1.w)
	bra.s	InsCharBuffer1
InsCharBuffer2:
	move.b	d0,0(a0,d2.w)
	addq.w	#1,d2
	move.w	d2,$16c(a6)
	addq.w	#1,$164(a6)
	addq.w	#1,$166(a6)		;Column
	move.w	#$1234,$16a(a6)		;Buffer Changed
	clr.b	$1e4(a6)		;Text not saved
	movem.l	(a7)+,d1-d2/a0
	rts

RemCharBuffer:
	movem.l	d1-d2/a0,-(a7)
	move.l	$160(a6),a0		;Line Buffer Addr
	move.w	$164(a6),d2		;Line Length
	move.w	$16c(a6),d1		;Line Index
RemCharBuffer1:
	cmp.w	d1,d2
	beq.s	RemCharBuffer2
	move.b	1(a0,d1.w),0(a0,d1.w)
	addq.w	#1,d1
	bra.s	RemCharBuffer1
RemCharBuffer2:
	subq.w	#1,$164(a6)
	move.w	#$1234,$16a(a6)		;Buffer Changed
	clr.b	$1e4(a6)		;Text not saved
	movem.l	(a7)+,d1-d2/a0
	rts

PasteBuffer:
	movem.l	d1/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$15c(a6),a0
	add.w	$16c(a6),a0
	move.l	$186(a6),a1
	move.l	a1,d1
	sub.l	$154(a6),d1
	move.l	a0,a2
	add.l	d1,a2
	add.l	d1,$154(a6)
	add.l	d1,$186(a6)
	bsr	CopyMemory
	move.l	$154(a6),a0
	move.l	$186(a6),a1
	move.l	$15c(a6),a2
	add.w	$16c(a6),a2
	bsr	CopyMemory
	movem.l	(a7)+,d1/a0-a2
	rts

GetMarkedAddr:
					;Out-A0=Begin,A1=End,D0=Active
	moveq	#$ffffffff,d0
	cmp.w	#$0001,$1b2(a6)
	bne	GetMarkedAddr2
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	beq	GetMarkedAddr2
	bhi	GetMarkedAddr1
	exg	a0,a1
GetMarkedAddr1:
	moveq	#$00,d0
GetMarkedAddr2:
	rts

DeleteMarked:
	movem.l	d1/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	bhi	DeleteMarked1
	exg	a0,a1
DeleteMarked1:
	move.l	a1,d1
	sub.l	a0,d1
	move.l	a0,a2
	move.l	a1,a0
	move.l	$186(a6),a1
	sub.l	d1,$186(a6)
	sub.l	d1,$154(a6)
	bsr	CopyMemory
	movem.l	(a7)+,d1/a0-a2
	rts

CopyToCutBuffer:			;Copies marked to buffer
	movem.l	d1-d3/a0-a2,-(a7)
	bsr	InsCurrentLine
	move.l	$1aa(a6),a0
	move.l	$1ae(a6),a1
	cmp.l	a0,a1
	bhi	CopyToCutBuffer1
	exg	a0,a1
CopyToCutBuffer1:
	move.l	$154(a6),a2		;Text End
	move.l	a1,d1
	sub.l	a0,d1
	add.l	a2,d1
	move.l	d1,$186(a6)		;New Cut End
	tst.l	d1
	beq	CopyToCutBuffer2
	bsr	CopyMemory
CopyToCutBuffer2:
	movem.l	(a7)+,d1-d3/a0-a2
	rts

InsCurrentLine:				;Inserts buffer into text
	movem.l	d1-d3/a0-a2,-(a7)
	cmp.w	#$1234,$16a(a6)
	bne	InsCurrentLine3
	move.w	$168(a6),d1		;Buffer old length
	move.w	$164(a6),d2		;Buffer length
	cmp.w	d1,d2
	beq	InsCurrentLine1		;No Transfer
	move.l	$15c(a6),a0		;TextLine Addr
	move.l	$186(a6),a1		;Cut End
	move.l	a0,a2
	add.w	d1,a0
	add.w	d2,a2	
	move.w	d2,d3
	sub.w	d1,d3
	ext.l	d3
	add.l	d3,$154(a6)		;New Text End
	add.l	d3,$186(a6)		;New Cut End
	bsr	CopyMemory
InsCurrentLine1:
	move.l	$15c(a6),a0
	move.l	$160(a6),a1
	move.w	$164(a6),d2		;Buffer length
InsCurrentLine2:
	tst.w	d2
	beq.s	InsCurrentLine3
	move.b	(a1)+,d0
	jsr	_LVOWriteMemByte(a6)
	subq.w	#1,d2
	bra.s	InsCurrentLine2
InsCurrentLine3:
	clr.w	$16a(a6)
	move.w	$164(a6),$168(a6)
	movem.l	(a7)+,d1-d3/a0-a2
	rts

SearchText:				;Searches Text for String
					;A0=String,D0=Options
					;Bit 0=Whole Word
					;Bit 1=Match upper/lower case
	movem.l	d1-d7/a0-a5,-(a7)
	move.l	d0,d1
	link	a5,#-160
	move.l	a7,a2
	lea	$0053ff,a3		;MemshiftBase
	move.l	$0086(a6),a4		;MemshiftBuffer
	moveq	#$ffffffff,d6
	moveq	#$4f,d2
SearchText1:
	move.b	0(a0,d2.w),0(a2,d2.w)
	dbf	d2,SearchText1
	moveq	#$4f,d2
SearchText2:
	move.b	0(a2,d2.w),80(a2,d2.w)
	dbf	d2,SearchText2
	btst	#1,d1
	bne	SearchText3
	lea	(a2),a0
	moveq	#$ffffffff,d3
	moveq	#$20,d4
	bsr	SearchTextChar
	lea	80(a2),a0
	moveq	#$ffffffdf,d3
	moveq	#$00,d4
	bsr	SearchTextChar
SearchText3:
	move.b	(a2),d3
	move.b	80(a2),d4
	beq	SearchText
	move.l	$1e6(a6),a0		;Start
	move.l	$154(a6),a1		;End
SearchText4:
	cmp.l	a0,a1
	bls	SearchText12
	cmpa.l	a3,a0
	bhi	SearchText5
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra	SearchText6
SearchText5:
	move.b	(a0)+,d0
SearchText6:
	cmp.b	d0,d3
	beq	SearchText7
	cmp.b	d0,d4
	bne	SearchText4
SearchText7:
	move.l	a0,d5
	btst	#0,d1
	beq	SearchText8
	subq.l	#1,a0
	cmp.l	$150(a6),a0
	beq	SearchText8
	subq.l	#1,a0
	jsr	_LVOReadMemByte(a6)
	cmp.b	#$0a,d0
	beq	SearchText8
	cmp.b	#$20,d0
	beq	SearchText8
	cmp.b	#$09,d0
	beq	SearchText8
	move.l	d5,a0
	bra	SearchText4
SearchText8:
	move.l	d5,a0
	moveq	#$00,d2
SearchText9:
	addq.w	#1,d2
	tst.b	0(a2,d2.w)
	beq	SearchText10
	cmp.l	a0,a1
	bls	SearchText12
	jsr	_LVOReadMemByte(a6)
	cmp.b	0(a2,d2.w),d0
	beq	SearchText9
	cmp.b	80(a2,d2.w),d0
	beq	SearchText9
	move.l	d5,a0
	bra	SearchText4
SearchText10:
	btst	#0,d1
	beq	SearchText11
	cmp.l	a0,a1
	bls	SearchText11
	jsr	_LVOReadMemByte(a6)
	cmp.b	#$0a,d0
	beq	SearchText11
	cmp.b	#$20,d0
	beq	SearchText11
	cmp.b	#$09,d0
	beq	SearchText11
	move.l	d5,a0
	bra	SearchText4
SearchText11:
	move.l	d5,$1e6(a6)
	move.l	d5,d6
	subq.l	#1,d6
SearchText12:
	move.l	d6,d0
	unlk	a5
	movem.l	(a7)+,d1-d7/a0-a5
	rts
SearchTextChar:
	moveq	#$4f,d2
SearchTextChar1:
	move.b	0(a0,d2.w),d0
	cmp.b	#$ff,d0
	beq	SearchTextChar3
	cmp.b	#$f7,d0
	beq	SearchTextChar3
	cmp.b	#$df,d0
	beq	SearchTextChar3
	cmp.b	#$d7,d0
	beq	SearchTextChar3
	cmp.b	#$bf,d0
	bhi	SearchTextChar2
	cmp.b	#$7a,d0
	bhi	SearchTextChar3
	cmp.b	#$60,d0
	bhi	SearchTextChar2
	cmp.b	#$5a,d0
	bhi	SearchTextChar3
	cmp.b	#$40,d0
	bls	SearchTextChar3
SearchTextChar2:
	and.b	d3,d0
	or.b	d4,d0
	move.b	d0,0(a0,d2.w)
SearchTextChar3:
	dbf	d2,SearchTextChar1
	rts

CopyMemory:				;Copies RAM Memory
					;A0=Begin,A1=End,A2=Dest.
	movem.l	d0-d2/a0-a5,-(a7)
	lea	$0053ff,a3		;MemshiftBase
	cmp.l	a2,a0
	bls.s	CopyMemory2		;Backwards
CopyMemory1:
	cmp.l	a0,a1
	beq	CopyMemory4
	sub.l	a4,a4
	sub.l	a5,a5
	move.l	a1,d0
	sub.l	a0,d0
	move.l	d0,d1
	cmp.l	a3,a2
	bhi.s	CopyMemory1a
	move.l	$0086(a6),a5
	move.l	a3,d0
	addq.l	#1,d0
	sub.l	a2,d0
	cmp.l	a3,a0
	bhi.s	CopyMemory1a
	move.l	a5,a4
	move.l	a3,d0
	addq.l	#1,d0
	sub.l	a0,d0
CopyMemory1a:
	cmp.l	d1,d0
	bls.s	CopyMemory1b
	move.l	d1,d0
CopyMemory1b:
	add.l	a4,a0
	add.l	a5,a2
	subq.l	#1,d0
	move.l	d0,d1
	swap	d1
CopyMemory1c:
	move	d0,d2
	and.w	#$0007,d0
	lsr.w	#3,d2
	beq.s	CopyMemory1e
	subq.w	#1,d2
CopyMemory1d:
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	move.b	(a0)+,(a2)+
	dbf	d2,CopyMemory1d
CopyMemory1e:
	move.b	(a0)+,(a2)+
	dbf	d0,CopyMemory1e
	dbf	d1,CopyMemory1c
	sub.l	a4,a0
	sub.l	a5,a2
	bra.s	CopyMemory1

CopyMemory2:
	add.l	a1,a2
	sub.l	a0,a2
	exg	a0,a1
	addq.l	#1,a3
CopyMemory3:
	cmp.l	a0,a1
	beq.s	CopyMemory4
	move.l	$0086(a6),a4
	move.l	a4,a5
	move.l	a0,d0
	sub.l	a1,d0
	move.l	d0,d1
	cmp.l	a3,a2
	bls.s	CopyMemory3a
	sub.l	a5,a5
	move.l	a2,d0
	sub.l	a3,d0
	cmp.l	a3,a0
	bls.s	CopyMemory3a
	sub.l	a4,a4
	move.l	a0,d0
	sub.l	a3,d0
CopyMemory3a:
	cmp.l	d1,d0
	bls.s	CopyMemory3b
	move.l	d1,d0
CopyMemory3b:
	add.l	a4,a0
	add.l	a5,a2
	subq.l	#1,d0
	move.l	d0,d1
	swap	d1
CopyMemory3c:
	move	d0,d2
	and.w	#$0007,d0
	lsr.w	#3,d2
	beq.s	CopyMemory3e
	subq.w	#1,d2
CopyMemory3d:
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	move.b	-(a0),-(a2)
	dbf	d2,CopyMemory3d
CopyMemory3e:
	move.b	-(a0),-(a2)
	dbf	d0,CopyMemory3e
	dbf	d1,CopyMemory3c
	sub.l	a4,a0
	sub.l	a5,a2
	bra.s	CopyMemory3
CopyMemory4:
	movem.l	(a7)+,d0-d2/a0-a5
	rts

UpdateText:				;Place First Line on Top
	movem.l	d1-d2/a0-a5,-(a7)	;of Screen
	move.l	$5c(a6),-(a7)
	clr.l	$5c(a6)			;CRSR TOP LEFT
	move.l	$170(a6),a0		;First Line Addr
	move.l	$154(a6),a1
	lea	$0053ff,a2		;MemshiftBase
	move.l	$0086(a6),a3		;MemshiftBuffer
	clr.b	$74(a6)			;No Inverse
	move.l	$01aa(a6),a4		;Mark Begin
	move.l	$01ae(a6),a5		;Mark End
	cmp.l	a4,a5
	bhi.s	UpdateTextMark
	exg	a4,a5
UpdateTextMark:
	cmp.l	a0,a4
	bhi.s	UpdateText1
	exg	a5,a4
	cmp.l	a4,a0
	bhi.s	UpdateText1
	move.b	#$ff,$74(a6)		;Inverse
UpdateText1:
	cmp.l	$15c(a6),a0		;Current Line Addr
	bne.s	UpdateText1a
	move.w	$5c(a6),(a7)
UpdateText1a:
	clr.w	$5e(a6)
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq	UpdateText3
	move.w	$16e(a6),d1		;Screen X base
	moveq	#$00,d2
UpdateText2:
	cmp.l	a0,a4
	bne.s	UpdateText2Mark
	exg	a5,a4
	cmp.l	a0,a4
	beq.s	UpdateText2Mark
	eor.b	#$ff,$74(a6)
UpdateText2Mark:
	cmp.l	a0,a1
	beq.s	UpdateText3
	cmpa.l	a2,a0
	bhi.s	UpdateText2a
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	UpdateText2b
UpdateText2a:
	move.b	(a0)+,d0
UpdateText2b:
	cmp.b	#$0a,d0			;LF
	beq.s	UpdateText2e
	cmp.w	d1,d2
	bge.s	UpdateText2c
	addq.w	#1,d2
	cmp.b	#$09,d0			;TAB
	bne.s	UpdateText2	
	addq.w	#7,d2
	and.w	#$7ff8,d2
	bra.s	UpdateText2
UpdateText2c:
	cmp.b	#$09,d0
	bne.s	UpdateText2ca
	jsr	_LVOClearToTAB(a6)
UpdateText2ca:
	jsr	_LVOWriteChar(a6)
	tst.w	$5e(a6)
	bne.s	UpdateText2
UpdateText2d:
	cmp.l	a0,a4
	bne.s	UpdateText2dMark
	exg	a5,a4
	cmp.l	a0,a4
	beq.s	UpdateText2dMark
	eor.b	#$ff,$74(a6)
UpdateText2dMark:
	cmp.l	a0,a1
	beq.s	UpdateText3
	jsr	_LVOReadMemByte(a6)
	cmp.b	#$0a,d0
	bne.s	UpdateText2d
	bra	UpdateText1
UpdateText2e:
	move.b	$74(a6),-(a7)
	clr.b	$74(a6)
	jsr	_LVOClearToEOL(a6)
	move.b	(a7)+,$74(a6)
	jsr	_LVOWriteChar(a6)
	bra	UpdateText1
UpdateText3:
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	beq.s	UpdateText4
	tst.w	$5e(a6)
	bne.s	UpdateText3a
	jsr	_LVOClearLine(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateText3
UpdateText3a:
	jsr	_LVOClearToEOL(a6)
	clr.w	$5e(a6)
	addq.w	#1,$5c(a6)
	bra.s	UpdateText3
UpdateText4:
	clr.b	$74(a6)			;No Inverse
	bsr	WriteCursorInfo
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1-d2/a0-a5
	rts

UpdateLine:
	movem.l	d1-d3/a0-a4,-(a7)
	move.l	$5c(a6),-(a7)
	clr.w	$5e(a6)
	move.l	$160(a6),a0		;Line Buffer
	move.l	$1aa(a6),a1		;Mark Begin
	move.l	$1ae(a6),a2		;Mark End
	lea	$0053ff,a3		;MemshiftBase
	move.l	$0086(a6),a4		;MemshiftBuffer
	cmp.l	a1,a2
	bhi.s	UpdateLineMark
	exg	a1,a2
UpdateLineMark:
	sub.l	$15c(a6),a1		;Real Line Addr
	sub.l	$15c(a6),a2
	add.l	a0,a1
	add.l	a0,a2
	move.w	$164(a6),d1
	addq.w	#1,d1
	moveq	#$00,d2
	move.w	$16e(a6),d3		;Screen X Base
	clr.b	$74(a6)			;No Inverse
	cmp.l	a0,a1
	bhi.s	UpdateLine1
	exg	a2,a1
	cmp.l	a1,a0
	bhi.s	UpdateLine1
	move.b	#$ff,$74(a6)		;Inverse
UpdateLine1:
	cmp.l	a0,a1
	bne.s	UpdateLine1Mark
	exg	a2,a1
	cmp.l	a0,a1
	beq.s	UpdateLine1Mark
	eor.b	#$ff,$74(a6)
UpdateLine1Mark:
	subq.w	#1,d1
	beq.s	UpdateLine4
	cmpa.l	a3,a0
	bhi.s	UpdateLine1a
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra.s	UpdateLine1b
UpdateLine1a:
	move.b	(a0)+,d0
UpdateLine1b:
	cmp.b	#$0a,d0
	beq.s	UpdateLine4
	cmp.w	d3,d2
	bge.s	UpdateLine2
	addq.w	#1,d2
	cmp.b	#$09,d0			;TAB
	bne.s	UpdateLine1	
	addq.w	#7,d2
	and.w	#$7ff8,d2
	bra.s	UpdateLine1
UpdateLine2:
	cmp.b	#$09,d0
	bne.s	UpdateLine3
	jsr	_LVOClearToTAB(a6)
UpdateLine3:
	jsr	_LVOWriteChar(a6)
	tst.w	$5e(a6)
	bne.s	UpdateLine1
	bra.s	UpdateLine5
UpdateLine4:
	move.b	$74(a6),-(a7)
	clr.b	$74(a6)
	jsr	_LVOClearToEOL(a6)
	move.b	(a7)+,$74(a6)
UpdateLine5:
	clr.b	$74(a6)			;No Inverse
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1-d3/a0-a4
	rts

StartMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,d0
	beq.s	StartMarking2
	move.l	#$ffffffff,$1aa(a6)
	move.l	#$ffffffff,$1ae(a6)
	bsr	UpdateText
	bsr	UpdateLine
StartMarking1:
	bsr	SetCursorMarkBegin
	move.w	#$0001,$01b2(a6)
StartMarking2:
	move.l	(a7)+,d0
	rts

ContMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarking1
	bsr	SetCursorMarkEnd
	bsr	UpdateLine
	move.w	$1ba(a6),d0
	cmp.w	$05c(a6),d0
	beq.s	ContMarking1
	move.l	$15c(a6),-(a7)
	move.l	$160(a6),-(a7)
	move.w	$164(a6),-(a7)
	move.w	$05c(a6),-(a7)
	move.l	$1b4(a6),$15c(a6)
	move.l	$1b4(a6),$160(a6)
	move.w	$1b8(a6),$164(a6)
	move.w	$1ba(a6),$05c(a6)
	bsr	UpdateLine
	move.w	(a7)+,$05c(a6)
	move.w	(a7)+,$164(a6)
	move.l	(a7)+,$160(a6)
	move.l	(a7)+,$15c(a6)
ContMarking1:
	move.l	(a7)+,d0
	rts

ContMarkingII:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarkingII1
	bsr	SetCursorMarkEnd
ContMarkingII1:
	move.l	(a7)+,d0
	rts

ContMarkingIII:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,$01b2(a6)
	bne.s	ContMarkingIII1
	move.w	$1ba(a6),d0
	cmp.w	$05c(a6),d0
	beq.s	ContMarkingIII1
	move.l	$15c(a6),-(a7)
	move.l	$160(a6),-(a7)
	move.w	$164(a6),-(a7)
	move.w	$05c(a6),-(a7)
	move.l	$1b4(a6),$160(a6)
	move.l	$1b4(a6),$15c(a6)
	move.w	$1b8(a6),$164(a6)
	move.w	$1ba(a6),$05c(a6)
	bsr	UpdateLine
	move.w	(a7)+,$05c(a6)
	move.w	(a7)+,$164(a6)
	move.l	(a7)+,$160(a6)
	move.l	(a7)+,$15c(a6)
ContMarkingIII1:
	move.l	(a7)+,d0
	rts

EndMarking:
	move.l	d0,-(a7)
	move.w	$01b2(a6),d0
	cmp.w	#$0001,d0
	bne.s	EndMarking1
	move.l	#$ffffffff,$1aa(a6)
	move.l	#$ffffffff,$1ae(a6)
	bsr	UpdateText
	bsr	UpdateLine
	move.w	#$0000,$01b2(a6)
EndMarking1:
	move.l	(a7)+,d0
	rts

RememberMark:
	move.l	d0,-(a7)
	move.w	$1b2(a6),d0
	cmp.w	#$0001,d0
	bne.s	RememberMark1
	move.l	$15c(a6),$1b4(a6)
	move.w	$164(a6),$1b8(a6)
	move.w	$05c(a6),$1ba(a6)
RememberMark1:
	move.l	(a7)+,d0
	rts

SetCursorMarkBegin:
	move.l	a0,-(a7)
	move.l	$15c(a6),a0		;Real Line Addr
	adda.w	$16c(a6),a0		;Line Index
	move.l	a0,$1aa(a6)		;Mark begin
	move.l	(a7)+,a0
	rts

SetCursorMarkEnd:
	move.l	a0,-(a7)
	move.l	$15c(a6),a0		;Real Line Addr
	adda.w	$16c(a6),a0		;Line Index
	move.l	a0,$1ae(a6)		;Mark begin
	move.l	(a7)+,a0
	rts

GotoPrecCurLineII:			;Searches for previous textline
	movem.l	d1-d2/a0-a3,-(a7)
	tst.l	$158(a6)
	beq.s	GotoPrecCurLineII1
	subq.l	#1,$158(a6)
GotoPrecCurLineII1:
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
GotoPrecCurLineII2:
	cmpa.l	a0,a1
	beq.s	GotoPrecCurLineII5
	cmpa.l	a2,a0
	bhi.s	GotoPrecCurLineII3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecCurLineII4
GotoPrecCurLineII3:
	move.b	-(a0),d0
GotoPrecCurLineII4:
	cmp.b	#$0a,d0
	bne.s	GotoPrecCurLineII2
	addq.l	#1,a0
GotoPrecCurLineII5:
	move.l	a0,$15c(a6)		;Current Line Addr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoPrecCurLine:			;Searches for previous textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$158(a6),d2
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
	move.l	d2,d1
	subq.l	#1,d2
	addq.l	#1,d1
	bra.s	GotoPrecCurLine2
GotoPrecCurLine1:
	subq.l	#1,d1
	move.l	a0,$15c(a6)		;Current Line Addr
	addq.l	#1,$15c(a6)
	cmp.l	d1,d2
	beq	GotoPrecCurLine5
GotoPrecCurLine2:
	cmp.l	a0,a1
	beq.s	GotoPrecCurLine4a
	cmpa.l	a2,a0
	bhi.s	GotoPrecCurLine3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecCurLine4
GotoPrecCurLine3:
	move.b	-(a0),d0
GotoPrecCurLine4:
	cmp.b	#$0a,d0
	beq.s	GotoPrecCurLine1
	bra.s	GotoPrecCurLine2
GotoPrecCurLine4a:
	subq.l	#1,d1
	move.l	a0,$15c(a6)
GotoPrecCurLine5:
	move.l	d1,$158(a6)		;Current Line nr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoPrecTopLine:			;Searches for previous toptextline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$170(a6),a0		;Text Current Line
	move.l	$150(a6),a1		;Text Start
	lea	$0053ff,a2
	addq.l	#1,a2
	move.l	$086(a6),a3
	moveq	#$00,d2
	move.l	d2,d1
	subq.l	#1,d2
	addq.l	#1,d1
	bra.s	GotoPrecTopLine2
GotoPrecTopLine1:
	subq.l	#1,d1
	move.l	a0,$170(a6)		;First Line Addr
	addq.l	#1,$170(a6)
	cmp.l	d1,d2
	beq.s	GotoPrecTopLine5
GotoPrecTopLine2:
	cmp.l	a0,a1
	beq.s	GotoPrecTopLine4a
	cmpa.l	a2,a0
	bhi.s	GotoPrecTopLine3
	adda.l	a3,a0
	move.b	-(a0),d0
	suba.l	a3,a0
	bra.s	GotoPrecTopLine4
GotoPrecTopLine3:
	move.b	-(a0),d0
GotoPrecTopLine4:
	cmp.b	#$0a,d0
	beq.s	GotoPrecTopLine1
	bra.s	GotoPrecTopLine2
GotoPrecTopLine4a:
	move.l	a0,$170(a6)
GotoPrecTopLine5:
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoNextCurLine:			;Searches for next textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$158(a6),d2
	move.l	$15c(a6),a0		;Text Current Line
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2
	move.l	$086(a6),a3
	move.l	d2,d1
	addq.l	#1,d2
	subq.l	#1,d1
GotoNextCurLine1:
	addq.l	#1,d1
	move.l	a0,$15c(a6)		;Current Line Addr
	cmp.l	d1,d2
	beq.s	GotoNextCurLine5
GotoNextCurLine2:
	cmp.l	a0,a1
	beq.s	GotoNextCurLine5
	cmpa.l	a2,a0
	bhi.s	GotoNextCurLine3
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoNextCurLine4
GotoNextCurLine3:
	move.b	(a0)+,d0
GotoNextCurLine4:
	cmp.b	#$0a,d0
	beq.s	GotoNextCurLine1
	bra.s	GotoNextCurLine2
GotoNextCurLine5:
	move.l	d1,$158(a6)		;Current Line nr
	bsr	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoNextTopLine:			;Searches for next toptextline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$170(a6),a0		;Text Current Line
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2
	move.l	$086(a6),a3
	moveq	#$00,d2
	move.l	d2,d1
	addq.l	#1,d2
	subq.l	#1,d1
GotoNextTopLine1:
	addq.l	#1,d1
	move.l	a0,$170(a6)		;First Line Addr
	cmp.l	d1,d2
	beq.s	GotoNextTopLine5
GotoNextTopLine2:
	cmp.l	a0,a1
	beq.s	GotoNextTopLine5
	cmpa.l	a2,a0
	bhi.s	GotoNextTopLine3
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoNextTopLine4
GotoNextTopLine3:
	move.b	(a0)+,d0
GotoNextTopLine4:
	cmp.b	#$0a,d0
	beq.s	GotoNextTopLine1
	bra.s	GotoNextTopLine2
GotoNextTopLine5:
	movem.l	(a7)+,d1-d2/a0-a3
	rts

GotoCurrentLine:			;Searches for current Textline
	movem.l	d1-d2/a0-a3,-(a7)
	move.l	$150(a6),a0		;Text Start
	move.l	$154(a6),a1		;Text End
	lea	$0053ff,a2		;MemshiftBase
	move.l	$086(a6),a3		;MemshiftBuffer
	move.l	$158(a6),d2		;Current Line nr
	moveq	#$ffffffff,d1
GotoCurrentLine1:
	move.l	a0,$15c(a6)		;Current Line Addr
	addq.l	#1,d1
	cmp.l	d1,d2
	beq.s	GotoCurrentLine3
GotoCurrentLine2:
	cmp.l	a0,a1
	beq.s	GotoCurrentLine3
	cmpa.l	a2,a0
	bhi.s	GotoCurrentLine2a
	adda.l	a3,a0
	move.b	(a0)+,d0
	suba.l	a3,a0
	bra.s	GotoCurrentLine2b
GotoCurrentLine2a:
	move.b	(a0)+,d0
GotoCurrentLine2b:
	cmp.b	#$0a,d0
	beq.s	GotoCurrentLine1
	bra.s	GotoCurrentLine2
GotoCurrentLine3:
	move.l	d1,$158(a6)		;Current Line nr
	bsr.s	LoadCurrentBuffer
	movem.l	(a7)+,d1-d2/a0-a3
	rts

LoadCurrentBuffer:			;Loads the current line into buffer
	movem.l	d1-d6/a0-a4,-(a7)
	moveq	#$00,d1			;Index count
	moveq	#$00,d2			;Column count
	moveq	#$ffffffff,d4		;Cursor - Index
	moveq	#$ffffffff,d5		;New Column nr
	moveq	#$00,d6
	move.l	$15c(a6),a0
	move.l	$154(a6),a1
	move.l	$160(a6),a2		;Buffer Addr
	lea	$0053ff,a3		;MemshiftBase
	move.l	$086(a6),a4		;MemshiftBuffer
	move.w	$166(a6),d3		;Column nr
LoadCurrentBuffer1:
	tst.w	d6
	bne.s	LoadCurrentBuffer1a
	move.w	d1,d4			;Index
	move.w	d2,d5			;New Column
	cmp.w	d3,d2
	blt.s	LoadCurrentBuffer1a
	moveq	#$01,d6
LoadCurrentBuffer1a:
	cmp.w	#$0200,d2
	beq.s	LoadCurrentBuffer4
	cmp.l	a0,a1
	beq.s	LoadCurrentBuffer4
	cmpa.l	a3,a0
	bhi.s	LoadCurrentBuffer2
	adda.l	a4,a0
	move.b	(a0)+,d0
	suba.l	a4,a0
	bra.s	LoadCurrentBuffer3
LoadCurrentBuffer2:
	move.b	(a0)+,d0
LoadCurrentBuffer3:
	move.b	d0,(a2)+
	addq.w	#1,d2
	cmp.b	#$09,d0
	bne.s	LoadCurrentBuffer3a
	addq.w	#7,d2
	and.w	#$7ff8,d2
LoadCurrentBuffer3a:
	addq.l	#1,d1
	cmp.b	#$0a,d0
	bne.s	LoadCurrentBuffer1
LoadCurrentBuffer4:
	move.w	d1,$164(a6)		;Buffer Length
	move.w	d1,$168(a6)		;Buffer Oldlength
	move.w	d4,$16c(a6)		;Buffer Index
	move.w	d5,$166(a6)		;Column nr
	bsr.s	CalCursorX
	clr.w	$16a(a6)		;Buffer Changed = No
	movem.l	(a7)+,d1-d6/a0-a4
	rts

CalColumnNr:				;Calculates the column nr
	movem.l	d0-d2/a0,-(a7)
	moveq	#$00,d0
	moveq	#$ffffffff,d1
	move.w	$16c(a6),d2		;Buffert index
	move.l	$160(a6),a0		;Buffert address
CalColumnNr1:
	addq.w	#1,d1
	cmp.w	d1,d2
	beq.s	CalColumnNr2
	addq.w	#1,d0
	cmp.b	#$09,(a0)+		;TAB
	bne.s	CalColumnNr1
	addq.w	#7,d0
	and.w	#$7ff8,d0
	bra.s	CalColumnNr1
CalColumnNr2:
	move.w	d0,$166(a6)
	movem.l	(a7)+,d0-d2/a0
	rts

CalCursorX:				;Calculates the X position
					;D0out: 0=Noscreenmove, 1=Screenmove
	movem.l	d1-d2,-(a7)
	move.w	$166(a6),d1
	move.w	$16e(a6),d2
CalCursorX1:
	cmp.w	d1,d2
	bhi.s	CalCursorX4
	beq.s	CalCursorX4
	add.w	#$004f,d2
	cmp.w	d1,d2
	bls.s	CalCursorX5
	sub.w	#$004f,d2
CalCursorX2:
	moveq	#$00,d0
	cmp.w	$16e(a6),d2
	beq.s	CalCursorX3
	moveq	#$01,d0
CalCursorX3:
	move.w	d2,$16e(a6)		;Column start
	sub.w	d2,d1
	move.w	d1,$5e(a6)		;Screen Cursor X
	movem.l	(a7)+,d1-d2
	rts
CalCursorX4:
	subq.w	#8,d2
	bcc.s	CalCursorX1
	moveq	#$00,d2
	bra.s	CalCursorX2
CalCursorX5:
	sub.w	#$0047,d2
	bra.s	CalCursorX1

WriteCursorInfo:			;Writes the Infoline
	movem.l	d1/a0,-(a7)
	move.l	$5c(a6),-(a7)		;Save Cursor X,Y
	move.w	$14c(a6),d0		;ScreenLastLine
	subq.w	#2,d0
	move.w	d0,$5c(a6)
	clr.w	$5e(a6)
	btst	#0,$6c(a6)
	beq.s	WriteCursorInfoCaps
	lea	WriteCursorInfoText5(pc),a0
	jsr	_LVOWriteString(a6)
WriteCursorInfoCaps:
	btst	#1,$6c(a6)
	beq.s	WriteCursorInfoNum
	lea	WriteCursorInfoText6(pc),a0
	jsr	_LVOWriteString(a6)
WriteCursorInfoNum:
	lea	WriteCursorInfoText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	#1000000000,d1
	move.l	$158(a6),d0
	addq.l	#1,d0			;Start with Line 1
	jsr	_LVOWriteDecNumberII(a6)
	lea	WriteCursorInfoText2(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	#10000,d1
	moveq	#$00,d0
	move.w	$166(a6),d0
	addq.l	#1,d0			;Start with Col 1
	jsr	_LVOWriteDecNumberII(a6)
	lea	WriteCursorInfoText3(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	#1000000000,d1
	bsr	GetFreeWorkBuf
	jsr	_LVOWriteDecNumberII(a6)
	lea	WriteCursorInfoText4(pc),a0
	jsr	_LVOWriteString(a6)
	moveq	#$4f,d1
	move.l	$19c(a6),a0
WriteCursorInfo1:
	move.b	(a0)+,d0
	beq.s	WriteCursorInfo2
	jsr	_LVOWriteASCIIChar(a6)
	dbf	d1,WriteCursorInfo1
WriteCursorInfo2:
	jsr	_LVOClearToEOL(a6)
	move.l	(a7)+,$5c(a6)
	movem.l	(a7)+,d1/a0
	rts
WriteCursorInfoText1:
	dc.b	"LINE:",0
WriteCursorInfoText2:
	dc.b	" COLUMN:",0
WriteCursorInfoText3:
	dc.b	" FREE:",0
WriteCursorInfoText4:
	dc.b	" NAME:",0
WriteCursorInfoText5:
	dc.b	"CAPS ",0
WriteCursorInfoText6:
	dc.b	"NUM ",0
	even

GetFreeWorkBuf:				;Get length of free workmem
	move.w	$168(a6),d0
	sub.w	$164(a6),d0
	ext.l	d0
	add.l	$182(a6),d0
	sub.l	$186(a6),d0
	rts

MakeScreenBackup:			;Copies the Charmap to buffert
	movem.l	d1-d3/a0-a1,-(a7)
	move.l	$4(a6),a0
	move.l	$174(a6),a1
	move.w	#$0293,d3
MakeScreenBackup1:
	move.l	(a0),d2
	move.l	(a1),d1
	move.l	d1,(a0)+
	move.l	d2,(a1)+
	dbf	d3,MakeScreenBackup1
	movem.l	(a7)+,d1-d3/a0-a1
	rts

RestoreScreen:				;Redraws the Screen
	movem.l	d1-d4/a0-a2,-(a7)
	move.l	(a6),a1
	move.l	$4(a6),a2
	moveq	#$20,d3
RestoreScreen1:
	moveq	#$4f,d4
RestoreScreen2:
	move.b	(a2)+,d0
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	d0,d1
	bpl.s	RestoreScreen3
	sub.b	#$0020,d1
	bmi.s	RestoreScreen4
	moveq	#-1,d2
	add.b	#$0040,d1
	bra.s	RestoreScreen4
RestoreScreen3:
	sub.b	#$0020,d1
	bpl.s	RestoreScreen4
	moveq	#-1,d2
	add.b	#$0040,d1
RestoreScreen4:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	tst.b	d2
	beq.s	RestoreScreen5
	move.b	$00c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d2,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d2,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d2,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d2,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d2,d0
	move.b	d0,$0230(a1)
	move.b	(a0),d0
	eor.b	d2,d0
	move.b	d0,(a1)+
	bra.s	RestoreScreen6
RestoreScreen5:
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
	move.b	(a0),(a1)+
RestoreScreen6:
	dbf	d4,RestoreScreen2
	lea	$0230(a1),a1
	dbf	d3,RestoreScreen1
	movem.l	(a7)+,d1-d4/a0-a2
	rts

RememberMarked:				;Remembers the markings
	movem.l	d1-d6/a0-a3,-(a7)
	move.l	(a6),a1
	move.l	$4(a6),a2
	move.l	$1f6(a6),a3
	moveq	#$20,d3
RememberMarked1:
	moveq	#$09,d4
RememberMarked2:
	moveq	#$07,d5
	moveq	#$00,d6
RememberMarked3:
	move.b	(a2)+,d0
	moveq	#$00,d1
	moveq	#-1,d2
	move.b	d0,d1
	bpl.s	RememberMarked4
	sub.b	#$0020,d1
	bmi.s	RememberMarked5
	moveq	#$00,d2
	add.b	#$0040,d1
	bra.s	RememberMarked5
RememberMarked4:
	sub.b	#$0020,d1
	bpl.s	RememberMarked5
	moveq	#$00,d2
	add.b	#$0040,d1
RememberMarked5:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	lsr.b	#1,d6
	move.b	(a1)+,d0
	eor.b	d2,d0
	cmp.b	(a0),d0
	bne.s	RememberMarked6
	or.b	#$80,d6
RememberMarked6:
	dbf	d5,RememberMarked3
	move.b	d6,(a3)+
	dbf	d4,RememberMarked2
	lea	$0230(a1),a1
	dbf	d3,RememberMarked1
	movem.l	(a7)+,d1-d6/a0-a3
	rts

RestoreMarked:				;Restores the markings
					;D0/D1=X1/Y1 , D2/D3=X2/Y2
	movem.l	d0-d5/a0-a2,-(a7)
	move.l	$05c(a6),-(a7)
	move.w	d0,d4
	move.w	d1,d5
RestoreMarked1:
	move.w	d5,$05c(a6)
	bsr	CalcYAddr
	move.l	$178(a6),a1		;Bitmap
	move.l	a1,d0
	sub.l	(a6),d0
	lsr.l	#6,d0
	move.l	$1f6(a6),a0
	add.l	d0,a0
	move.w	d4,d1
RestoreMarked2:
	move.w	d1,d0
	lsr.w	#3,d0
	btst	d1,0(a0,d0.w)
	beq	RestoreMarked3
	lea	0(a1,d1.w),a2
	moveq	#-1,d0
	eor.b	d0,(a2)
	eor.b	d0,$050(a2)
	eor.b	d0,$0a0(a2)
	eor.b	d0,$0f0(a2)
	eor.b	d0,$140(a2)
	eor.b	d0,$190(a2)
	eor.b	d0,$1e0(a2)
	eor.b	d0,$230(a2)
RestoreMarked3:
	addq.w	#1,d1
	cmp.w	d2,d1
	bls	RestoreMarked2
	addq.w	#1,d5
	cmp.w	d3,d5
	bls	RestoreMarked1
	move.l	(a7)+,$05c(a6)
	movem.l	(a7)+,d0-d5/a0-a2
	rts

RestoreAllMarked:
	movem.l	d0-d3,-(a7)
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$4f,d2
	moveq	#$00,d3
	move.w	$14c(a6),d3
	subq.w	#2,d3
	bsr	RestoreMarked
	movem.l	(a7)+,d0-d3
	rts

WriteBitmapChar:
	movem.l	d1/a0-a1,-(a7)
	moveq	#$00,d1
	move.b	d0,d1
	bpl.s	WriteBitmapChar1
	sub.b	#$20,d1
	bpl	WriteBitmapCharSpec
	bra.s	WriteBitmapChar2
WriteBitmapChar1:
	sub.b	#$20,d1
	bmi	WriteBitmapCharSpec
WriteBitmapChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteBitmapChar3
	bsr	CalcYAddr
WriteBitmapChar3:
	move.w	$5e(a6),d1
	move.l	$178(a6),a1
	add.w	d1,a1
	move.b	$74(a6),d1
	move.b	(a0),d0
	eor.b	d1,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d1,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d1,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d1,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d1,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d1,d0
	move.b	d0,$0230(a1)
	addq.w	#1,$5e(a6)
WriteBitmapCharSpec:
	movem.l	(a7)+,d1/a0-a1
	rts

WriteBitmapString				;Writes a Textstring
						;A0=Text
	move.l	a0,-(a7)
.1
	move.b	(a0)+,d0
	beq.s	.2
	bsr	WriteBitmapChar
	bra.s	.1
.2
	move.l	a0,d0
	move.l	(a7)+,a0
	rts

MakeLibrary
	movem.l	d0/a0-a2,-(a7)
	lea	(a6),a1
	lea	Library(pc),a0
	move.l	a0,a2
.1
	move.l	(a0)+,d0
	beq	.2
	add.l	a2,d0
	subq.l	#6,a1
	move.w	#$4ef9,(a1)
	move.l	d0,2(a1)
	bra	.1
.2
	movem.l	(a7)+,d0/a0-a2
	rts

Library
	dc.l	WriteChar-Library
	dc.l	WriteString-Library
	dc.l	ReadKeyboard-Library
	dc.l	ScrollUp-Library
	dc.l	ScrollDown-Library
	dc.l	ReadNumber-Library
	dc.l	ReadDecNumber-Library
	dc.l	ReadNibble-Library
	dc.l	ReadByte-Library
	dc.l	ReadStringII-Library
	dc.l	ReadString-Library
	dc.l	CopyString-Library
	dc.l	WriteASCIIChar-Library
	dc.l	WriteNumber-Library
	dc.l	WriteDecNumber-Library
	dc.l	WriteDecNumberII-Library
	dc.l	WriteByte-Library
	dc.l	WriteWord-Library
	dc.l	WriteLong-Library
	dc.l	ReadMemByte-Library
	dc.l	ReadMemWord-Library
	dc.l	ReadMemLong-Library
	dc.l	WriteMemByte-Library
	dc.l	WriteMemWord-Library
	dc.l	WriteMemLong-Library
	dc.l	ExchangeRam-Library
	dc.l	ClearLine-Library
	dc.l	ClearLineII-Library
	dc.l	ClearToEOL-Library
	dc.l	ClearToTAB-Library
	dc.l	ClearScreen-Library
	dc.l	AllocMem-Library
	dc.l	DeAllocMem-Library
	dc.l	0

	LIBINIT	-6

	LIBDEF	_LVOWriteChar		;(Char)(D0)
	LIBDEF	_LVOWriteString		;(String)(A0)=End
	LIBDEF	_LVOReadKeyboard	;=Key
	LIBDEF	_LVOScrollUp		;
	LIBDEF	_LVOScrollDown		;
	LIBDEF	_LVOReadNumber		;=HexNumber
	LIBDEF	_LVOReadDecNumber	;=DecNumber
	LIBDEF	_LVOReadNibble		;=Nibble
	LIBDEF	_LVOReadByte		;=Byte
	LIBDEF	_LVOReadStringII	;(String)(A0)=Length
	LIBDEF	_LVOReadString		;(String)(A0)=Length
	LIBDEF	_LVOCopyString		;(Source,Dest)(A0,A1)
	LIBDEF	_LVOWriteASCIIChar	;(Char)(D0)
	LIBDEF	_LVOWriteNumber		;(Nibble)(D0)
	LIBDEF	_LVOWriteDecNumber	;(Number,Divisor)(D0,D1)
	LIBDEF	_LVOWriteDecNumberII	;(Number,Divisor)(D0,D1)
	LIBDEF	_LVOWriteByte		;(Byte)(D0)
	LIBDEF	_LVOWriteWord		;(Word)(D0)
	LIBDEF	_LVOWriteLong		;(Long)(D0)
	LIBDEF	_LVOReadMemByte		;(Adress)(A0)=Byte
	LIBDEF	_LVOReadMemWord		;(Adress)(A0)=Word
	LIBDEF	_LVOReadMemLong		;(Adress)(A0)=Long
	LIBDEF	_LVOWriteMemByte	;(Byte,Adress)(D0,A0)
	LIBDEF	_LVOWriteMemWord	;(Word,Adress)(D0,A0)
	LIBDEF	_LVOWriteMemLong	;(Long,Adress)(D0,A0)
	LIBDEF	_LVOExchangeRam		;
	LIBDEF	_LVOClearLine		;
	LIBDEF	_LVOClearLineII		;(Length)(D0)
	LIBDEF	_LVOClearToEOL		;
	LIBDEF	_LVOClearToTAB		;
	LIBDEF	_LVOClearScreen		;
	LIBDEF	_LVOAllocMem		;(Bytes)(D0)=Adress
	LIBDEF	_LVODeAllocMem		;(Bytes,Adress)(D0,A0)
	LIBDEF	_LVOUnused

SaveExitPar				;Saves the Exit Parameters
	movem.l	d0/a0-a1,-(a7)
	cmp.w	#1000,ccs_StartUp(a6)
	beq.s	SaveExitPar1
	cmp.w	#1001,ccs_StartUp(a6)
	beq.s	SaveExitPar1
	cmp.w	#1003,ccs_StartUp(a6)
	beq.s	SaveExitPar1
	bra.s	SaveExitPar5
SaveExitPar1
	move.l	$196(a6),a1
	move.l	$18a(a6),a0
	moveq	#$7f,d0
SaveExitPar2
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar2
	move.l	$18e(a6),a0
	moveq	#$0b,d0
SaveExitPar3
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar3
	lea	$1c(a6),a0
	moveq	#$0f,d0
SaveExitPar4
	move.l	(a0)+,(a1)+
	dbf	d0,SaveExitPar4
	move.l	$8a(a6),(a1)+
	move.w	$8e(a6),(a1)+
	move.l	$90(a6),(a1)+
SaveExitPar5
	movem.l	(a7)+,d0/a0-a1
	rts

LoadExitPar				;Restores the Exit Parameters
	movem.l	d0/a0-a1,-(a7)
	cmp.w	#1000,ccs_StartUp(a6)
	beq.s	LoadExitPar1
	cmp.w	#1001,ccs_StartUp(a6)
	beq.s	LoadExitPar1
	cmp.w	#1003,ccs_StartUp(a6)
	beq.s	LoadExitPar1
	bra.s	LoadExitPar5
LoadExitPar1
	move.l	$196(a6),a1
	move.l	$18a(a6),a0
	moveq	#$7f,d0
LoadExitPar2
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar2
	move.l	$18e(a6),a0
	moveq	#$0b,d0
LoadExitPar3
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar3
	lea	$1c(a6),a0
	moveq	#$0f,d0
LoadExitPar4:
	move.l	(a1)+,(a0)+
	dbf	d0,LoadExitPar4
	move.l	(a1)+,$8a(a6)
	move.w	(a1)+,$8e(a6)
	move.l	(a1)+,$90(a6)
LoadExitPar5:
	movem.l	(a7)+,d0/a0-a1
	rts

ReadAgnus:				;Reads the Custom registers
	movem.l	d0/a0-a2,-(a7)
	move.l	ccs_CustomRegs(a6),a0		;DFF000
	lea	CCSCustomBase,a1		;DFF000 Write Only HARDWARE
	lea	$dff000,a2		;DFF000 Read Only
	move.w	(a2),(a0)		;BLTDDAT
	move.w	$2(a2),d0
	move.w	d0,$002(a0)		;DMACONR
	move.w	d0,$096(a0)		;DMACON
	move.l	$4(a2),d0
	move.l	d0,$004(a0)		;VPOSR
	move.l	d0,$02a(a0)		;VPOSW
	move.w	$8(a2),$008(a0)		;DSKDATR
	move.w	$a(a2),$00a(a0)		;JOY0DAT
	move.w	$c(a2),$00c(a0)		;JOY1DAT
	move.w	$e(a2),$00e(a0)		;CLXDAT
	move.w	$10(a2),d0
	move.w	d0,$010(a0)		;ADKCONR
	move.w	d0,$09e(a0)		;ADKCON
	move.w	$12(a2),$012(a0)	;POT0DAT
	move.w	$14(a2),$014(a0)	;POT1DAT
	move.w	$16(a2),d0
	move.w	d0,$016(a0)		;POTGOR
	move.w	d0,$034(a0)		;POTGO
	move.w	$18(a2),$018(a0)	;SERDATR
	move.w	$1a(a2),$01a(a0)	;DSKBYTR
	move.w	$1c(a2),d0
	move.w	d0,$01c(a0)		;INTENAR
	move.w	d0,$09a(a0)		;INTENA
	move.w	$1e(a2),d0
	move.w	d0,$01e(a0)		;INTREQR
	move.w	d0,$09c(a0)		;INTREQ
	move.l	$20(a1),$020(a0)	;DSKPT
	move.w	$24(a1),$024(a0)	;DSKLEN
	move.w	$26(a1),$026(a0)	;DSKDAT
	move.w	$28(a1),$028(a0)	;REFPTR
	move.w	$2e(a1),$02e(a0)	;COPCON
	move.w	$30(a1),$030(a0)	;SERDAT
	move.w	$32(a1),$032(a0)	;SERPER
	move.w	$36(a1),$036(a0)	;JOYTEST
	move.w	$38(a1),$038(a0)	;STREQU
	move.w	$3a(a1),$03a(a0)	;STRVBL
	move.w	$3c(a1),$03c(a0)	;STRHOR
	move.w	$3e(a1),$03e(a0)	;STRLONG
	move.w	$40(a1),$040(a0)	;BLTCON0
	move.w	$42(a1),$042(a0)	;BLTCON1
	move.w	$44(a1),$044(a0)	;BLTAFWM
	move.w	$46(a1),$046(a0)	;BLTALWM
	move.l	$48(a1),$048(a0)	;BLTCPT
	move.l	$4c(a1),$04c(a0)	;BLTBPT
	move.l	$50(a1),$050(a0)	;BLTAPT
	move.l	$54(a1),$054(a0)	;BLTDPT
	move.w	$58(a1),$058(a0)	;BLTSIZE
	move.w	$60(a1),$060(a0)	;BLTCMOD
	move.w	$62(a1),$062(a0)	;BLTBMOD
	move.w	$64(a1),$064(a0)	;BLTAMOD
	move.w	$66(a1),$066(a0)	;BLTDMOD
	move.w	$70(a1),$070(a0)	;BLTCDAT
	move.w	$72(a1),$072(a0)	;BLTBDAT
	move.w	$74(a1),$074(a0)	;BLTADAT
	move.w	$7e(a1),$07e(a0)	;DSKSYNC
	move.l	$80(a1),$080(a0)	;COP1LC
	move.l	$84(a1),$084(a0)	;COP2LC
	move.w	$88(a1),$088(a0)	;COPJMP1
	move.w	$8a(a1),$08a(a0)	;COPJMP2
	move.w	$8c(a1),$08c(a0)	;COPINS
	move.w	$8e(a1),$08e(a0)	;DIWSTRT
	move.w	$90(a1),$090(a0)	;DIWSTOP
	move.w	$92(a1),$092(a0)	;DDFSTRT
	move.w	$94(a1),$094(a0)	;DDFSTOP
	move.w	$98(a1),$098(a0)	;CLXCON
	move.w	#$00a0,d0		;AUDxLC,-LEN,-PER,-VOL,-DAT
ReadAgnus1
	move.l	$00(a1,d0.w),$00(a0,d0.w)
	move.l	$10(a1,d0.w),$10(a0,d0.w)
	move.l	$20(a1,d0.w),$20(a0,d0.w)
	move.l	$30(a1,d0.w),$30(a0,d0.w)
	addq.l	#4,d0
	cmp.w	#$00ac,d0
	bne.s	ReadAgnus1
	move.w	#$00e0,d0		;BPLxPT
ReadAgnus2
	move.l	0(a1,d0.w),0(a0,d0.w)
	addq.w	#4,d0
	cmp.w	#$00f8,d0
	bne.s	ReadAgnus2
	move.w	$100(a1),$100(a0)	;BPLCON0
	move.w	$102(a1),$102(a0)	;BPLCON1
	move.w	$104(a1),$104(a0)	;BPLCON2
	move.w	$108(a1),$108(a0)	;BPL1MOD
	move.w	$10a(a1),$10a(a0)	;BPL2MOD
	move.w	$110(a1),$110(a0)	;BPL1DAT
	move.w	$112(a1),$112(a0)	;BPL2DAT
	move.w	$114(a1),$114(a0)	;BPL3DAT
	move.w	$116(a1),$116(a0)	;BPL4DAT
	move.w	$118(a1),$118(a0)	;BPL5DAT
	move.w	$11a(a1),$11a(a0)	;BPL6DAT
	move.w	#$0120,d0
ReadAgnus3:
	move.l	0(a1,d0.w),0(a0,d0.w)
	addq.w	#4,d0
	cmp.w	#$01c0,d0
	bne.s	ReadAgnus3
	movem.l	(a7)+,d0/a0-a2
	rts

WriteAgnus:				;Writes back the Custom registers
	movem.l	d0/a0-a1,-(a7)
	move.l	ccs_CustomRegs(a6),a0
	lea	$dff000,a1
	move.l	$20(a0),$20(a1)		;DSKPT
	move.l	$2a(a0),$2a(a1)		;VPOSW
	move.w	$2e(a0),$2e(a1)		;COPCON
	move.l	$30(a0),$30(a1)		;SERDAT,SERPER
	move.l	$34(a0),$34(a1)		;POTGO,JOYTEST
	move.l	$40(a0),$40(a1)		;BLTCON0,BLTCON1
	move.l	$44(a0),$44(a1)		;BLTAFWM,BLTALWM
	move.l	$48(a0),$48(a1)		;BLTCPT
	move.l	$4c(a0),$4c(a1)		;BLTBPT
	move.l	$50(a0),$50(a1)		;BLTAPT
	move.l	$54(a0),$54(a1)		;BLTDPT
	move.l	$60(a0),$60(a1)		;BLTCMOD,BLTBMOD
	move.l	$64(a0),$64(a1)		;BLTAMOD,BLTDMOD
	move.l	$70(a0),$70(a1)		;BLTCDAT,BLTBDAT
	move.w	$74(a0),$74(a1)		;BLTADAT
	move.w	$7e(a0),$7e(a1)		;DSKSYNC
*	move.l	$80(a0),$80(a1)		;COP1LC
*	move.l	$84(a0),$84(a1)		;COP2LC
	move.l	$8e(a0),$8e(a1)		;DIWSTRT,DIWSTOP
	move.l	$92(a0),$92(a1)		;DDFSTRT,DDFSTOP
	move.w	$96(a0),d0
	or.w	#$8000,d0
	move.w	#$07ff,$96(a1)
	move.w	d0,$96(a1)		;DMACON
	move.w	$98(a0),$98(a1)		;CLXCON
	move.w	$9a(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9a(a1)
	move.w	d0,$9a(a1)		;INTENA
	move.w	$9c(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9c(a1)
	move.w	d0,$9c(a1)		;INTREQ
	move.w	$9e(a0),d0
	or.w	#$8000,d0
	move.w	#$7fff,$9e(a1)
	move.w	d0,$9e(a1)		;ADKCON
	move.w	#$00a0,d0		;AUDxLC,-LEN,-PER,-VOL,-DAT
WriteAgnus1
	move.l	$00(a0,d0.w),$00(a1,d0.w)
	move.l	$10(a0,d0.w),$10(a1,d0.w)
	move.l	$20(a0,d0.w),$20(a1,d0.w)
	move.l	$30(a0,d0.w),$30(a1,d0.w)
	addq.l	#4,d0
	cmp.w	#$00ac,d0
	bne.s	WriteAgnus1
	move.w	#$00e0,d0		;BPLxPT
WriteAgnus2:
	move.l	0(a0,d0.w),0(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#$00f8,d0
	bne.s	WriteAgnus2
	move.w	$100(a0),$100(a1)	;BPLCON0
	move.w	$102(a0),$102(a1)	;BPLCON1
	move.w	$104(a0),$104(a1)	;BPLCON2
	move.w	$108(a0),$108(a1)	;BPL1MOD
	move.w	$10a(a0),$10a(a1)	;BPL2MOD
	move.w	$110(a0),$110(a1)	;BPL1DAT
	move.w	$112(a0),$112(a1)	;BPL2DAT
	move.w	$114(a0),$114(a1)	;BPL3DAT
	move.w	$116(a0),$116(a1)	;BPL4DAT
	move.w	$118(a0),$118(a1)	;BPL5DAT
	move.w	$11a(a0),$11a(a1)	;BPL6DAT
	move.w	#$0120,d0
WriteAgnus3:
	move.l	0(a0,d0.w),0(a1,d0.w)
	addq.w	#4,d0
	cmp.w	#$01c0,d0
	bne.s	WriteAgnus3
	movem.l	(a7)+,d0/a0-a1
	rts

ReadCIA:				;Reads the CIA registers
	movem.l	d0-d4/a0-a2,-(a7)
	move.l	$18e(a6),a0		;CIA
	lea	$bfd000,a1		;CIAB Hardware address
	lea	$dff000,a2
	move.w	#$2000,d2		;EXTER
	bsr.s	ReadCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1		;CIAA Hardware address
	move.w	#$0008,d2		;PORTS
	bsr.s	ReadCIA1
	movem.l	(a7)+,d0-d4/a0-a2
	rts

ReadCIA1:
	move.b	$000(a1),$0(a0)		;PRA
	move.b	$100(a1),$1(a0)		;PRB
	move.b	$200(a1),$2(a0)		;DDRA
	move.b	$300(a1),$3(a0)		;DDRB
	move.b	$e00(a1),$e(a0)		;CRA
	move.b	$f00(a1),$f(a0)		;CRB
	moveq	#$00,d4
	move.b	d4,$e00(a1)	;turn off timer a
	move.b	d4,$f00(a1)	;turn off timer b
	move.b	$400(a1),$4(a0)		;TALO
	move.b	$500(a1),$5(a0)		;TAHI
	move.b	$600(a1),$6(a0)		;TBLO
	move.b	$700(a1),$7(a0)		;TBHI
	move.b	$a00(a1),$a(a0)		;Event MSB
	move.b	$900(a1),$9(a0)		;Event 8-15
	move.b	$800(a1),$8(a0)		;Event LSB
	move.b	$c00(a1),$c(a0)		;SDR
	move.b	$d00(a1),$14(a0)	;ICR request
	move.b	#$10,$e00(a1)	;force load timer a
	move.b	#$10,$f00(a1)	;force load timer a
	move.b	$400(a1),$10(a0)	;TALO latch
	move.b	$500(a1),$11(a0)	;TAHI latch
	move.b	$600(a1),$12(a0)	;TBLO latch
	move.b	$700(a1),$13(a0)	;TBHI latch
	moveq	#$00,d1
	move.b	#$10,$d00(a1)
	move.b	d4,$a00(a1)		;Stop TOD
	or.b	#$40,$e00(a1)		;Set Serial to output
	tst.b	$d00(a1)
	move.w	d2,$9c(a2)
	move.b	#$01,$400(a1)
	move.b	d4,$500(a1)
	move.b	#$59,$e00(a1)
	moveq	#$01,d3			;TA
	bsr.s	ReadCIA2
	move.b	#$01,$600(a1)
	move.b	d4,$700(a1)
	move.b	#$19,$f00(a1)
	moveq	#$02,d3			;TB
	bsr.s	ReadCIA2
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	#$01,$800(a1)
	move.b	#$80,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	move.b	d4,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	moveq	#$04,d3			;ALRM
	bsr.s	ReadCIA2
	move.b	#$51,$e00(a1)
	move.b	$c00(a1),$c00(a1)
	moveq	#$08,d3			;SP
	bsr.s	ReadCIA2
	move.b	d1,$d(a0)		;ICR
	move.b	d4,$e00(a1)
	rts

ReadCIA2:
	move.b	$d00(a1),d0
	and.b	d3,d0
	beq.s	ReadCIA2
	and.w	d2,$1e(a2)
	beq.s	ReadCIA3
	or.b	d3,d1
ReadCIA3:
	move.b	d3,$d00(a1)
	move.w	d2,$9c(a2)
	rts

WriteCIA:				;Writes back the CIA registers
	movem.l	d0/a0-a1,-(a7)
	move.l	$18e(a6),a0
	lea	$bfd000,a1
	bsr.s	WriteCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1
	bsr.s	WriteCIA1
	movem.l	(a7)+,d0/a0-a1
	rts
WriteCIA1:
	moveq	#$00,d0
	move.b	d0,$e00(a1)
	move.b	d0,$f00(a1)
	move.b	#$0f,$d00(a1)
	tst.b	$d00(a1)
	move.b	$2(a0),$200(a1)
	move.b	$0(a0),$000(a1)
	move.b	$3(a0),$300(a1)
	move.b	$1(a0),$100(a1)
	move.b	$4(a0),$400(a1)
	move.b	$5(a0),$500(a1)
	move.b	$6(a0),$600(a1)
	move.b	$7(a0),$700(a1)
	move.b	$a(a0),$a00(a1)
	move.b	$9(a0),$900(a1)
	move.b	$8(a0),$800(a1)
	move.b	$e(a0),d0
	or.b	#$10,d0
	move.b	d0,$e00(a1)
	move.b	$f(a0),d0
	or.b	#$10,d0
	move.b	d0,$f00(a1)
	move.b	$10(a0),$400(a1)
	move.b	$11(a0),$500(a1)
	move.b	$12(a0),$600(a1)
	move.b	$13(a0),$700(a1)
	move.b	$d(a0),d0
	or.b	#$80,d0
	move.b	d0,$d00(a1)
	rts

FindROMKeymap				;Find the Rom UsaKeymap
	movem.l	d0/a0-a1/a4,-(a7)
	lea	ccs_KeyDev(a6),a4
	move.l	kb_Map(a4),a0
	move.l	-(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#$75736100,(a1)
	beq.s	.3
	lea	$f80000,a0
.2
	addq.l	#2,a0
	move.l	(a0),d0
	and.l	#$00fffffe,d0
	cmp.l	#$00f00000,d0
	bls.s	.2
	move.l	d0,a1
	cmp.l	#$75736100,(a1)		;usa
	bne.s	.2
.3
	addq.l	#4,a0
	move.l	a0,kb_Map(a4)
	movem.l	(a7)+,d0/a0-a1/a4
	rts

FindROMFont				;Searches for the ROM Topazfont
	movem.l	d0/a0-a1/a4,-(a7)
	lea	ccs_ScreenDev(a6),a4
	move.l	sb_FontBase(a4),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a0
	cmp.l	#$94140008,4(a0)	;topaz 8
	bne.s	.1
	move.l	(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#"topa",(a1)		;topaz.font
	beq.s	.3
.1
	lea	$f80000,a0
.2
	addq.l	#2,a0
	cmp.l	#$94140008,(a0)		;topaz 8
	bne.s	.2
	move.l	-(a0),d0
	and.l	#$00fffffe,d0
	or.l	#$00f00000,d0
	move.l	d0,a1
	cmp.l	#"topa",(a1)		;topaz.font
	bne.s	.2
.3
	move.l	$14(a0),sb_FontBitMap(a4)
	move.l	$1a(a0),sb_FontCharMap(a4)
	move.l	a0,sb_FontBase(a4)
	movem.l	(a7)+,d0/a0-a1/a4
	rts

FindAgnusChip				;Searches for the Custom Chips
	movem.l	d0/a0,-(a7)
	lea	$c00000,a0
.1
	move.w	$6(a0),d0
	cmp.w	$6(a0),d0
	bne.s	.2
	add.l	#$040000,a0
	cmp.l	#$dc0000,a0
	bne.s	.1
.2
	move.l	a0,d0
	subq.l	#1,d0
	move.l	d0,ccs_AgnusBase(a6)
	movem.l	(a7)+,d0/a0
	rts

AllocMem
	move.l	a4,-(a7)
	addq.l	#7,d0
	and.w	#$fff8,d0
	move.l	ccs_MemList(a6),a4
	cmp.l	MH_FREE(a4),d0
	bhi	.5
	lea	MH_FIRST(a4),a1
	move.l	(a1),d1
.1	beq	.5
	move.l	d1,a0
	cmp.l	MC_BYTES(a0),d0
	beq	.3
	bls	.2
	lea	MC_NEXT(a0),a1
	move.l	(a1),d1
	bra	.1
.2
	add.l	d0,(a1)
	move.l	(a1),a1
	move.l	MC_BYTES(a0),MC_BYTES(a1)
	sub.l	d0,MC_BYTES(a1)
	move.l	MC_NEXT(a0),MC_NEXT(a1)
	bra	.4
.3
	move.l	MC_NEXT(a0),(a1)
.4
	sub.l	d0,MH_FREE(a4)
	move.l	(a7)+,a4
	move.l	a0,d0
	rts
.5
	move.l	(a7)+,a4
	moveq	#$00,d0
	rts

DeAllocMem
	move.l	a4,-(a7)
	addq.l	#7,d0
	and.w	#$fff8,d0
	move.l	a0,d1
	addq.l	#7,d1
	and.w	#$fff8,d1
	move.l	d1,a0
	move.l	ccs_MemList(a6),a4
	cmp.l	d1,MH_LOWER(a4)
	bhi	.7
	add.l	d0,d1
	cmp.l	MH_UPPER(a4),d1
	bhi	.7
	lea	MH_FIRST(a4),a1
	move.l	(a1),d1
	bne	.2
.1	move.l	a0,(a1)
	move.l	d1,MC_NEXT(a0)
	move.l	d0,MC_BYTES(a0)
	bra	.5
.2
	cmp.l	d1,a0
	bls	.1
.3
	move.l	d1,a1
	move.l	MC_NEXT(a1),d1
	beq	.4
	cmp.l	d1,a0
	bhi	.3
.4
	move.l	d1,MC_NEXT(a0)
	move.l	a0,MC_NEXT(a1)
	move.l	d0,MC_BYTES(a0)
	move.l	a1,d1
	add.l	MC_BYTES(a1),d1
	cmp.l	d1,a0
	bne	.5
	move.l	MC_NEXT(a0),MC_NEXT(a1)
	move.l	MC_BYTES(a0),d1
	add.l	d1,MC_BYTES(a1)
	move.l	a1,a0
.5
	move.l	MC_NEXT(a0),d1
	beq	.6
	move.l	d1,a1
	move.l	a0,d1
	add.l	MC_BYTES(a0),d1
	cmp.l	d1,a1
	bne	.6
	move.l	MC_NEXT(a1),MC_NEXT(a0)
	move.l	MC_BYTES(a1),d1
	add.l	d1,MC_BYTES(a0)
.6
	add.l	d0,MH_FREE(a4)
.7
	move.l	(a7)+,a4
	rts

MakePrefs				;Makes the Preferences
	move.l	a4,-(a7)

	lea	ccs_SIZEOF(a6),a4
	move.l	a4,ccs_MemList(a6)
	lea	MH_SIZE(a4),a0
	move.l	a0,d0
	addq.l	#7,d0
	and.w	#$fff8,d0
	move.l	d0,a0
	move.l	a0,MH_FIRST(a4)
	move.l	a0,MH_LOWER(a4)
	lea	CCSRAMEnd-CCSStackSize,a1
	move.l	a1,MH_UPPER(a4)
	sub.l	a0,a1
	move.l	a1,MH_FREE(a4)
	clr.l	MC_NEXT(a0)
	move.l	a1,MC_BYTES(a0)

	move.l	#$8740,d0
	bsr	AllocMem
	move.l	d0,ccs_RAMCopy(a6)
	move.l	#$0100,d0
	bsr	AllocMem
	move.l	d0,ccs_StringBuffer(a6)
	move.l	#$0200,d0
	bsr	AllocMem
	move.l	d0,ccs_CustomRegs(a6)
	move.l	#$0030,d0
	bsr	AllocMem
	move.l	d0,ccs_CIARegs(a6)
	move.l	#$0280,d0
	bsr	AllocMem
	move.l	d0,ccs_ExitRegs(a6)
	move.l	#$0020,d0
	bsr	AllocMem
	move.l	d0,ccs_CSISequence(a6)

	lea	ccs_ScreenDev(a6),a4
	lea	cmu_BitMap,a0
	move.l	a0,sb_BitMap(a4)
	move.l	#$0a50,d0
	bsr	AllocMem
	move.l	d0,sb_CharMap(a4)
	lea	cmu_Cursor,a0
	move.l	a0,sb_CursorImage(a4)
	move.l	#$0150,d0
	bsr	AllocMem
	move.l	d0,sb_MarkedMap(a4)
	move.w	#$0021,sb_ScreenLastLine(a4)
	clr.b	sb_Inverse(a4)
	move.w	#$ffff,sb_LastYLine(a4)
	clr.b	sb_InfoEnable(a4)
	clr.b	sb_RasterType(a4)

	move.w	sb_ColorCheckSum(a4),d0		;Checksum
	add.w	sb_BackColor(a4),d0
	add.w	sb_ForeColor1(a4),d0
	add.w	sb_ForeColor2(a4),d0
	add.w	sb_CursorColor(a4),d0
	not.w	d0
	beq.s	.1
	move.w	#$0888,sb_BackColor(a4)
	move.w	#$0ccc,sb_ForeColor1(a4)
	move.w	#$0fff,sb_ForeColor2(a4)
	move.w	#$0444,sb_CursorColor(a4)
.1
	move.w	sb_CursorCheckSum(a4),d0		;Checksum
	add.w	sb_CursorX(a4),d0
	add.w	sb_CursorY(a4),d0
	add.w	sb_ScrollStartLine(a4),d0
	add.w	sb_ScreenLastLine(a4),d0
	not.w	d0
	beq.s	.2
	clr.w	sb_CursorX(a4)
	clr.w	sb_CursorY(a4)
	clr.w	sb_ScrollStartLine(a4)
.2
	lea	ccs_KeyDev(a6),a4
	move.l	#$0100,d0
	bsr	AllocMem
	move.l	d0,kb_Buffer(a4)
	clr.w	kb_BufferIndex(a4)
	clr.b	kb_CapsLock(a4)
	clr.b	kb_Vanilla(a4)
	move.b	#$ff,kb_LastKey(a4)
	clr.w	kb_Repeat(a4)

	lea	ccs_DiskDev(a6),a4
	move.l	#$0200,d0
	bsr	AllocMem
	move.l	d0,db_BlockBuffer(a4)
	move.l	#$0200,d0
	bsr	AllocMem
	move.l	d0,db_RootBlock(a4)
	lea	cmu_Disk,a0
	move.l	a0,db_DMABuffer(a4)
	clr.b	db_Drive0Track(a4)
	clr.b	db_Drive1Track(a4)
	clr.b	db_Drive2Track(a4)
	clr.b	db_Drive3Track(a4)

	move.w	db_DirectoryChecksum(a4),d0	;Checksum
	add.b	db_DirectoryUnit(a4),d0
	add.w	db_DirectoryBlock(a4),d0
	not.w	d0
	beq.s	.3
	move.w	#$ffff,db_DirectoryBlock(a4)
.3
	move.l	#$1600,d0
	bsr	AllocMem
	move.l	d0,db_TrackBuffer(a4)
	move.b	#$ff,db_TrackBufferNr(a4)
	move.w	#$0001,db_DriveMotor(a4)
	clr.w	db_TrackBufferChange(a4)
	move.l	#$0200,d0
	bsr	AllocMem
	move.l	d0,db_BAMBuffer(a4)

	lea	ccs_PointerDev(a6),a4
	lea	cmu_Pointer,a0
	move.l	a0,pb_Sprite(a4)
	move.w	#$0d22,pb_Color1(a4)
	move.w	#$0000,pb_Color2(a4)
	move.w	#$0fca,pb_Color3(a6)

	lea	ccs_EditorDev(a6),a4
	move.l	#$0200,d0
	bsr	AllocMem
	move.l	d0,eb_TextBuffer(a4)
	move.l	#$0a50,d0
	bsr	AllocMem
	move.l	d0,eb_ScreenBackup(a4)
	move.l	#$0050,d0
	bsr	AllocMem
	move.l	d0,eb_FileName(a4)
	move.l	#$0050,d0
	bsr	AllocMem
	move.l	d0,eb_FindString(a4)

	move.l	(a7)+,a4
	rts


MakePrefsCheck				;Checksum the Preferences
	move.l	d0,-(a7)
	moveq	#$ffffffff,d0
	sub.w	$8(a6),d0
	sub.w	$a(a6),d0
	sub.w	$1a2(a6),d0
	sub.w	$1f4(a6),d0
	move.w	d0,$72(a6)
	moveq	#$ffffffff,d0
	sub.w	$5c(a6),d0
	sub.w	$5e(a6),d0
	sub.w	$14a(a6),d0
	sub.w	$14c(a6),d0
	move.w	d0,$192(a6)
	moveq	#$ffffffff,d0
	sub.w	$11e(a6),d0
	sub.b	$11d(a6),d0
	move.w	d0,$194(a6)
	move.l	(a7)+,d0
	rts

FindScreenLastLine			;Checks the TV-System PAL/NTSC
	movem.l	d1-d2/a4,-(a7)
	lea	ccs_ScreenDev(a6),a4
	lea	$dff004,a0
	move.l	#$0001ff00,d2
	move.l	(a0),d1
	and.l	d2,d1
.1
	move.l	d1,d0
	move.l	(a0),d1
	and.l	d2,d1
	cmp.l	d1,d0
	bls.s	.1
	cmp.l	#$00010000,d0
	bls.s	.1
	lsr.l	#8,d0
	sub.w	#$0038,d0
	lsr.w	#3,d0
	move.w	d0,sb_ScreenLastLine(a4)
	addq.w	#1,sb_ScreenLastLine(a4)
	lsl.w	#3,d0
	add.w	#$002c,d0
	move.w	d0,sb_LastRasterLine(a4)
	movem.l	(a7)+,d1-d2/a4
	rts

AdressErrorIRQ:
	moveq	#$0d,d7		;Adress Error
	bra	ErrorHandler

LevelSevenIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSevenIRQExit
	and.w	$001e(a5),d0		;INTREQR
LevelSevenIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

LevelSixIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSixIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#13,d0
	bne.s	CIABIRQ
	btst	#14,d0
	bne.s	MasterIRQ
LevelSixIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

MasterIRQ:
	move.w	#$4000,$009c(a5)	;INTREQ
	bra.s	LevelSixIRQExit

CIABIRQ:
	move.l	a4,-(a7)
	lea	$00c00000,a4
	move.b	$ffffdd00(a4),d0
	or.b	ccs_CIABIRQReq(a6),d0		;CIAB_IRQ_REQ
	move.b	d0,ccs_CIABIRQReq(a6)
CIABIRQ1:
	move.b	ccs_CIABIRQReq(a6),d0
	and.b	ccs_CIABIRQEna(a6),d0		;CIAB_IRQ_ENA
	beq.s	CIABIRQ2
	bclr	#0,ccs_CIABIRQReq(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIABTimerA
	bclr	#1,ccs_CIABIRQReq(a6)
	lsr.b	#1,d0			;TB
	bcs.s	CIABTimerB
	bclr	#2,ccs_CIABIRQReq(a6)
	lsr.b	#1,d0			;ALRM
	bcs.s	RasterIRQ
	bclr	#3,ccs_CIABIRQReq(a6)
	lsr.b	#1,d0			;SP
	bcs	CIABSerialPort
	bclr	#4,ccs_CIABIRQReq(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIABFlag
CIABIRQ2:
	move.w	#$2000,$009c(a5)	;INTREQ
	move.l	(a7)+,a4
	bra.s	LevelSixIRQExit

CIABTimerA:
	or.w	#$0001,ccs_CIATimers(a6)		;Timer A
	and.b	#$fe,$ffffde00(a4)	;Timer A OFF
	move.b	#$01,$ffffdd00(a4)	;Timer A IRQ Disable
	bclr	#0,ccs_CIABIRQEna(a6)
	bra.s	CIABIRQ1

CIABTimerB:
	or.w	#$0002,ccs_CIATimers(a6)		;Timer B
	and.b	#$fe,$ffffdf00(a4)	;Timer B OFF
	move.b	#$02,$ffffdd00(a4)	;Timer B IRQ Disable
	bclr	#1,ccs_CIABIRQEna(a6)
	bra.s	CIABIRQ1

* Raster Type Definition: *
* Bit 0 - Screen Start Line *
* Bit 1 - Screen Wrap Line *
* Bit 2 - Screen Info Line *
* Bit 3 - Screen Wrap+Info Line *
* Bit 4 - Screen End Line *
RasterIRQ:
	move.w	$14e(a6),d1		;RasterLine
	move.b	$1a9(a6),d2
	lsr.b	#1,d2
	bcs.s	RasterIRQ1
	lsr.b	#1,d2
	bcs.s	RasterIRQ2
	lsr.b	#1,d2
	bcs.s	RasterIRQ3
	lsr.b	#1,d2
	bcs.s	RasterIRQ4
	lsr.b	#1,d2
	bcs.s	RasterIRQ5
	bra	CIABIRQ1
RasterIRQ1:				;Start Screen
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ1
	addq.b	#1,$75(a6)		;Screen Blank over
	bra.s	RasterIRQ6
RasterIRQ2:				;Wrap Screen
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ2
	move.l	$00(a6),$e0(a5)
	bra.s	RasterIRQ6
RasterIRQ3:				;Info
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ3
	move.w	$1a2(a6),$182(a5)
	bra.s	RasterIRQ6
RasterIRQ4:				;Swap Screen + Info
	cmp.b	$06(a5),d1
	bne.s	RasterIRQ4
	move.l	$00(a6),$e0(a5)
	move.w	$1a2(a6),$182(a5)
	bra.s	RasterIRQ6
RasterIRQ5:
	clr.b	$75(a6)			;Blank Screen
	bsr	MakeMoButEvents
	tst.b	$6d(a6)
	bmi.s	RasterIRQ6
	addq.w	#1,$6e(a6)
	cmp.w	#$0019,$6e(a6)
	bne.s	RasterIRQ6
	movem.l	d6/d7/a1/a2,-(a7)
	bsr	Keyboardrepeat
	movem.l	(a7)+,d6/d7/a1/a2
	subq.w	#$1,$6e(a6)
RasterIRQ6:
	moveq	#$02,d2
	move.w	$1a6(a6),d1		;Wrap Screen Line
	cmp.w	$14e(a6),d1
	bls.s	RasterIRQ7
	cmp.w	$1a0(a6),d1		;End Line
	beq.s	RasterIRQ7
	cmp.w	$1a4(a6),d1		;RasterLine
	bne.s	RasterIRQ9
	moveq	#$08,d2
	bra.s	RasterIRQ9
RasterIRQ7:
	moveq	#$04,d2
	move.w	$1a4(a6),d1		;Info Line
	cmp.w	$14e(a6),d1
	bls.s	RasterIRQ8
	cmp.w	$1a0(a6),d1
	bne.s	RasterIRQ9
RasterIRQ8:
	moveq	#$10,d2
	move.w	$1a0(a6),d1
RasterIRQ9:
	move.b	d2,$1a9(a6)
	move.w	d1,$14e(a6)
	subq.w	#2,d1
	move.b	d1,$ffffd800(a4)
	move.w	d1,$ffffd900(a4)
	bra	CIABIRQ1

CIABSerialPort:
	bra	CIABIRQ1

CIABFlag:
	bra	CIABIRQ1

LevelFiveIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFiveIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#11,d0
	bne.s	SerialPortFullIRQ
	btst	#12,d0
	bne.s	DiskSyncIRQ
LevelFiveIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

SerialPortFullIRQ:
	move.w	#$0800,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

DiskSyncIRQ:
	move.w	#$1000,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

LevelFourIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFourIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#7,d0
	bne.s	Audio0IRQ
	btst	#8,d0
	bne.s	Audio1IRQ
	btst	#9,d0
	bne.s	Audio2IRQ
	btst	#10,d0
	bne.s	Audio3IRQ
LevelFourIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

Audio0IRQ:
	move.w	#$0080,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio1IRQ:
	move.w	#$0100,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio2IRQ:
	move.w	#$0200,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

Audio3IRQ:
	move.w	#$0400,$009c(a5)	;INTREQ
	bra.s	LevelFourIRQExit

LevelThreeIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelThreeIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#4,d0
	bne.s	CopperIRQ
	btst	#5,d0
	bne.s	VertBlankIRQ
	btst	#6,d0
	bne	BlitterFinIRQ
LevelThreeIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

CopperIRQ:
	move.w	#$0010,$009c(a5)	;INTREQ
	bra.s	LevelThreeIRQExit

VertBlankIRQ:
	move.w	$08(a6),$180(a5)	;COLOR TABLE 00
	move.w	$0a(a6),$182(a5)	;COLOR TABLE 01
	move.w	#$2c81,$8e(a5)		;DIWSTRT
	move.w	$1a0(a6),d0		;LastRasterLine
	lsl.w	#8,d0
	or.w	#$00c1,d0
	move.w	d0,$90(a5)		;DIWSTOP
	move.w	#$003c,$92(a5)		;DDFSTRT
	move.w	#$00d0,$94(a5)		;DDFSTOP
	move.w	#$9200,$100(a5)		;BPLCON0
	clr.w	$102(a5)		;BPLCON1
	move.w	#$0009,$104(a5)		;BPLCON2
	clr.l	$108(a5)		;BPL1MOD
	move.w	#$8300,$96(a5)		;DMACON
	bsr	ShowPointer
	bsr	ShowScreen
	bsr	ReadMouseButtons
	cmp.w	#$1234,$138(a6)
	beq.s	VertBlankIRQ1
	bsr	DiskCheck
VertBlankIRQ1:
	btst	#7,$bfe001
	beq	ProgramDebug
	move.w	#$0020,$009c(a5)	;INTREQ
	bra.s	LevelThreeIRQExit

BlitterFinIRQ:
	move.w	#$0040,$009c(a5)	;INTREQ
	bra	LevelThreeIRQExit

LevelTwoIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelTwoIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#3,d0
	bne.s	CIAAIRQ
LevelTwoIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

CIAAIRQ:
	move.l	a4,-(a7)
	lea	$00c00000,a4
	move.b	$ffffed01(a4),d0
	or.b	ccs_CIAAIRQReq(a6),d0		;CIAB_IRQ_REQ
	move.b	d0,ccs_CIAAIRQReq(a6)
CIAAIRQ1:
	move.b	ccs_CIAAIRQReq(a6),d0
	and.b	ccs_CIAAIRQEna(a6),d0		;CIAB_IRQ_ENA
	beq.s	CIAAIRQ2
	bclr	#0,ccs_CIAAIRQReq(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIAATimerA
	bclr	#1,ccs_CIAAIRQReq(a6)
	lsr.b	#1,d0			;TB
	bcs.s	CIAATimerB
	bclr	#2,ccs_CIAAIRQReq(a6)
	lsr.b	#1,d0			;ALRM
	bcs.s	CIAAAlarm
	bclr	#3,ccs_CIAAIRQReq(a6)
	lsr.b	#1,d0			;SP
	bcs.s	CIAASerialPort
	bclr	#4,ccs_CIAAIRQReq(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIAAFlag
CIAAIRQ2:
	move.w	#$0008,$009c(a5)	;INTREQ
	move.l	(a7)+,a4
	bra.s	LevelTwoIRQExit

CIAATimerA:
	or.w	#$0100,ccs_CIATimers(a6)		;Timer A
	and.b	#$fe,$ffffee01(a4)	;Timer A OFF
	move.b	#$01,$ffffed01(a4)	;Timer A IRQ Disable
	bclr	#0,ccs_CIAAIRQEna(a6)
	bra.s	CIAAIRQ1

CIAATimerB:
	or.w	#$0200,ccs_CIATimers(a6)		;Timer B
	and.b	#$fe,$ffffef01(a4)	;Timer B OFF
	move.b	#$02,$ffffed01(a4)	;Timer B IRQ Disable
	bclr	#1,ccs_CIAAIRQEna(a6)
	bra.s	CIAAIRQ1

CIAAAlarm:
	bra.s	CIAAIRQ1

CIAASerialPort:
	move.l	d0,d1
	move.b	$ffffec01(a4),d0

	and.w	#$fffd,ccs_CIATimers(a6)		;Wait for 85 microsec.
	move.b	#$3c,$ffffd600(a4)	;Timer B Low
	move.b	#$00,$ffffd700(a4)	;Timer B High
	and.b	#$fd,ccs_CIABIRQReq(a6)
	or.b	#$02,ccs_CIABIRQEna(a6)
	move.b	#$82,$ffffdd00(a4)	;Timer B IRQ Enable
	and.b	#$80,$ffffdf00(a4)
	or.b	#$40,$ffffee01(a4)	;Set Serial to output
	or.b	#$11,$ffffdf00(a4)	;Timer B Load & Start

	not.b	d0
	ror.b	#1,d0
	move.b	d0,$6d(a6)		;Last Key
	move.w	#$0000,$6e(a6)		;Repeat Counter
	bsr	Keyboard
CIAASerialPort1:
	move.w	ccs_CIATimers(a6),d0
	and.w	#$0002,d0
	beq.s	CIAASerialPort1
	and.b	#$bf,$ffffee01(a4)	;Set Serial to input
	move.l	d1,d0
	bra	CIAAIRQ1

CIAAFlag:
	bra	CIAAIRQ1

LevelOneIRQ:
	movem.l	d0-d2/a5/a6,-(a7)
	lea	CCSLibBase,a6
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelOneIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#0,d0
	bne.s	SerialPortEmptyIRQ
	btst	#1,d0
	bne.s	DiskBlockIRQ
	btst	#2,d0
	bne.s	SoftwareIRQ
LevelOneIRQExit:
	movem.l	(a7)+,d0-d2/a5/a6
	rte

SerialPortEmptyIRQ:
	move.w	#$0001,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

DiskBlockIRQ:
	move.w	#$0002,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

SoftwareIRQ:
	move.w	#$0004,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

ShowScreen				;Shows the Screen
	movem.l	d0/d1/a0/a3,-(a7)
	lea	ccs_ScreenDev(a6),a3
	and.b	#$7f,$bfdf00
	move.b	#$00,$bfda00
	move.b	$0005(a5),d0		;VPOSR - V8
	and.b	#$01,d0
	move.b	d0,$bfd900
	move.b	$0006(a5),d0
.1
	cmp.b	$0006(a5),d0
	beq.s	.1
	move.b	$0006(a5),$bfd800	;VHPOSR - V7-V0
	or.b	#$80,$bfdf00
	move.w	sb_LastRasterLine(a3),d0
	tst.b	sb_InfoEnable(a3)		;InfoLine Enable
	beq.s	.2
	subq.w	#8,d0
.2
	move.w	d0,sb_InfoRasterLine(a3)
	move.w	$14c(a6),d0
	move.w	$14a(a6),d1
	sub.w	d1,d0
	lsl.w	#3,d0
	add.w	#$002c,d0
	cmp.w	$1a0(a6),d0		;LastRasterLine
	blt.s	.3
	move.w	$1a0(a6),d0
.3
	move.w	d0,$1a6(a6)		;SwapscreenRasterLine
	move.w	#$002c,d0
	move.w	d0,$14e(a6)
	move.b	#$01,$1a9(a6)
	subq.w	#2,d0
	move.b	d0,$bfd800
	move.w	d0,$bfd900
	clr.b	$bfda00
	lsl.w	#7,d1
	move.w	d1,d0
	lsl.w	#2,d1
	add.w	d1,d0
	ext.l	d0
	add.l	$00(a6),d0
	move.l	d0,$00e0(a5)
	movem.l	(a7)+,d0/d1/a0/a3
	rts

ProgramDebug:
	move.l	#$40000,d0
ProgramDebug1:
	subq.l	#1,d0
	bne.s	ProgramDebug1
	movem.l	(a7)+,d0-d2/a5/a6
	bra	Start4

Keyboard:				;Makes Keyboard events
					;D0=Rawkey
	movem.l	d0-d7/a0-a4,-(a7)
	move.l	$60(a6),a0
	move.l	$64(a6),a2		;Keyboardbuffer
	move.w	$68(a6),d7		;Keyboardbuffer index
	move.w	d0,d1
	and.w	#$007f,d1
	cmp.w	#$0060,d1
	bcc	KeyboardVanilla
	tst.b	d0
	bmi	KeyboardExit
	cmp.w	#$000f,d1
	beq	KeyboardKeypad1
	cmp.w	#$001f,d1
	bhi.s	KeyboardNum1
	cmp.w	#$001d,d1
	bge	KeyboardKeypad2
KeyboardNum1:
	cmp.w	#$002f,d1
	bhi.s	KeyboardNum2
	cmp.w	#$002d,d1
	bge	KeyboardKeypad3
KeyboardNum2:
	cmp.w	#$003f,d1
	bhi.s	KeyboardNum3
	cmp.w	#$003c,d1
	bge	KeyboardKeypad4
KeyboardNum3:
	cmp.w	#$0043,d1
	beq	KeyboardKeypad5
	cmp.w	#$004a,d1
	beq	KeyboardKeypad6
	cmp.w	#$005e,d1
	bhi.s	KeyboardNum4
	cmp.w	#$005a,d1
	bge	KeyboardKeypad7
KeyboardNum4:
	cmp.w	#$004f,d1
	bhi.s	KeyboardCur1
	cmp.w	#$004c,d1
	bge	KeyboardCursor1
KeyboardCur1:
	cmp.w	#$0040,d1		;Lo or Hi
	bcs.s	Keyboard1
	lea	$10(a0),a0
	sub.w	#$0040,d1
Keyboard1:
	move.l	$8(a0),a1		;Caps Lock
	move.w	d1,d2
	move.w	d2,d3
	and.w	#$0007,d2
	lsr.w	#3,d3
	lea	0(a1,d3.w),a1
	move.b	$6b(a6),d0
	btst	d2,(a1)
	beq.s	Keyboard2
	move.b	$6c(a6),d0
	and.b	#$01,d0
	or.b	$6b(a6),d0		;d0 = vanillakeys
Keyboard2:
	move.l	$c(a0),a1		;Repeatable
	lea	0(a1,d3.w),a1
	btst	d2,(a1)
	bne.s	Keyboard3
	or.b	#$80,$6d(a6)		;No repeat
Keyboard3:
	move.l	(a0)+,a1		;Keymaptypes
	move.b	0(a1,d1.w),d2
	and.b	d2,d0			;Get valid vanillakeys
	move.l	(a0)+,a1		;Keymap
	lsl.w	#2,d1
	lea	0(a1,d1.w),a1
	btst	#5,d2
	bne.s	KeyboardDead
	btst	#6,d2
	bne.s	KeyboardString
	move.b	d0,d1
	eor.w	#$03,d1
	and.w	#$03,d1
	move.b	0(a1,d1.w),d1
	btst	#2,d0
	beq.s	Keyboard4
	and.b	#$9f,d1
Keyboard4:
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	clr.b	$6a(a6)
	bra	KeyboardExit
KeyboardDead:
	move.l	(a1),a1
	and.w	#$0007,d0
	add.w	d0,d0
	move.b	1(a1,d0.w),d1
	move.b	0(a1,d0.w),d0
	cmp.b	#$01,d0
	beq.s	KeyboardDead1		;MOD
	cmp.b	#$08,d0
	beq.s	KeyboardDead2		;DEAD
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	clr.b	$6a(a6)
	bra	KeyboardExit

KeyboardDead1:
	ext.w	d1
	lea	0(a1,d1.w),a1
	move.b	$6a(a6),d1
	ext.w	d1
	clr.b	$6a(a6)
	move.b	0(a1,d1.w),d1
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit
KeyboardDead2:
	move.b	d1,$6a(a6)
	bra	KeyboardExit
KeyboardString:
	move.l	(a1),a1
	and.w	#$0007,d0
	add.w	d0,d0
	move.b	1(a1,d0.w),d1
	move.b	0(a1,d0.w),d0
	ext.w	d1
	lea	0(a1,d1.w),a1
KeyboardString2:
	move.b	(a1)+,0(a2,d7.w)
	addq.w	#1,d7
	subq.b	#1,d0
	bne.s	KeyboardString2
	bra	KeyboardExit

KeyboardCursor1:		;CRSR UP/DOWN/RIGHT/LEFT
	moveq	#$01,d0
	cmp.w	#$004c,d1
	beq	KeyboardKeypad8
	moveq	#$06,d0
	cmp.w	#$004d,d1
	beq	KeyboardKeypad8
	moveq	#$04,d0
	cmp.w	#$004e,d1
	beq	KeyboardKeypad8
	moveq	#$03,d0
	bra	KeyboardKeypad8

KeyboardKeypad1:		;$0F		,"0"
	moveq	#$30,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	moveq	#$08,d0
	bra	KeyboardKeypad8

KeyboardKeypad2:		;$1D-$1F	;"123"
	move.b	d1,d0
	sub.w	#$001c,d0
	or.w	#$0030,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	addq.b	#4,d0
	bra	KeyboardKeypad8

KeyboardKeypad3:		;$2D-$2F	;"456"
	move.b	d1,d0
	sub.w	#$0029,d0
	or.w	#$0030,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne	KeyboardKeypad10
	cmp.w	#$002e,d1
	beq	KeyboardExit
	moveq	#$03,d0
	cmp.w	#$002d,d1
	beq	KeyboardKeypad8
	moveq	#$04,d0
	bra	KeyboardKeypad8

KeyboardKeypad4:		;$3C-$3F	;".789"
	move.b	d1,d0
	move.b	$6c(a6),d2
	move.b	$6b(a6),d3
	eor.b	d2,d3
	btst	#1,d3
	bne.s	KeyboardKeypad4a
	sub.w	#$003d,d0
	cmp.w	#$003c,d1
	bne.s	KeyboardKeypad8
	moveq	#$09,d0
	bra.s	KeyboardKeypad8
KeyboardKeypad4a:
	sub.w	#$0036,d0
	or.w	#$0030,d0
	cmp.w	#$003c,d1
	bne	KeyboardKeypad10
	moveq	#$2e,d0
	bra	KeyboardKeypad10

KeyboardKeypad5:		;$43		;"Enter"
	moveq	#$0d,d0
	bra	KeyboardKeypad10

KeyboardKeypad6:		;$4A		;"-"
	moveq	#$2d,d0
	bra	KeyboardKeypad10

KeyboardKeypad7:		;$5A-5E		;"()/*+"
	move.b	d1,d0
	btst	#1,$6b(a6)			;ALT
	beq.s	KeyboardKeypad7a
	moveq	#$02,d0
	cmp.w	#$005d,d1
	beq.s	KeyboardKeypad9
	moveq	#$01,d0
	cmp.w	#$005b,d1
	beq.s	KeyboardKeypad9
	cmp.w	#$005a,d1
	bne.s	KeyboardKeypad7a
	bchg	#1,$6c(a6)
	moveq	#$00,d0
	bra.s	KeyboardKeypad9
KeyboardKeypad7a:
	moveq	#$28,d0				;"("
	cmp.w	#$005a,d1
	beq.s	KeyboardKeypad10
	moveq	#$29,d0				;")"
	cmp.w	#$005b,d1
	beq.s	KeyboardKeypad10
	moveq	#$2f,d0				;"/"
	cmp.w	#$005c,d1
	beq.s	KeyboardKeypad10
	moveq	#$2a,d0				;"*"
	cmp.w	#$005d,d1
	beq.s	KeyboardKeypad10
	moveq	#$2b,d0				;"+"
	bra.s	KeyboardKeypad10

KeyboardKeypad8:
	move.b	#$9b,0(a2,d7.w)
	addq.w	#1,d7
	moveq	#$30,d1
	btst	#0,$6b(a6)			;SHFT
	beq.s	KeyboardKeypad8a
	moveq	#$31,d1
KeyboardKeypad8a:
	btst	#2,$6b(a6)			;CTRL
	beq.s	KeyboardKeypad8b
	moveq	#$32,d1
KeyboardKeypad8b:
	move.b	d1,0(a2,d7.w)
	addq.w	#1,d7
	and.b	#$0f,d0
	or.b	#$30,d0
	move.b	d0,0(a2,d7.w)
	addq.w	#1,d7
	move.b	#$01,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit

KeyboardKeypad9:
	move.b	#$9b,0(a2,d7.w)
	addq.w	#1,d7
	moveq	#$33,d1
	bra.s	KeyboardKeypad8b

KeyboardKeypad10:
	move.b	d0,0(a2,d7.w)
	addq.w	#1,d7
	bra	KeyboardExit

KeyboardVanilla:
	move.b	$6b(a6),d1
	cmp.b	#$60,d0
	bne.s	KeybVan1
	bset	#0,d1
KeybVan1:
	cmp.b	#$e0,d0
	bne.s	KeybVan2
	bclr	#0,d1
KeybVan2:
	cmp.b	#$61,d0
	bne.s	KeybVan3
	bset	#0,d1
KeybVan3:
	cmp.b	#$e1,d0
	bne.s	KeybVan4
	bclr	#0,d1
KeybVan4:
	cmp.b	#$62,d0
	bne.s	KeybVan5
	or.b	#$01,$6c(a6)
KeybVan5:
	cmp.b	#$e2,d0
	bne.s	KeybVan6
	and.b	#$fe,$6c(a6)
KeybVan6:
	cmp.b	#$63,d0
	bne.s	KeybVan7
	bset	#2,d1
KeybVan7:
	cmp.b	#$e3,d0
	bne.s	KeybVan8
	bclr	#2,d1
KeybVan8:
	cmp.b	#$64,d0
	bne.s	KeybVan9
	bset	#1,d1
KeybVan9:
	cmp.b	#$e4,d0
	bne.s	KeybVan10
	bclr	#1,d1
KeybVan10:
	cmp.b	#$65,d0
	bne.s	KeybVan11
	bset	#1,d1
KeybVan11:
	cmp.b	#$e5,d0
	bne.s	KeybVan12
	bclr	#1,d1
KeybVan12:
	move.b	d1,$6b(a6)
	or.b	#$80,$6d(a6)		;No repeat

KeybSpecKeys:
	lea	KeybSpecKeysData(pc),a1
KeybSpecKeys1:
	move.b	(a1)+,d1
	move.b	(a1)+,d2
	cmp.b	#$ff,d1
	beq.s	KeyboardExit
	cmp.b	d1,d0
	bne.s	KeybSpecKeys1
	move.b	#$9b,0(a2,d7.w)
	move.b	d2,d1
	lsr.b	#4,d1
	or.b	#$30,d1
	move.b	d1,1(a2,d7.w)
	and.b	#$0f,d2
	or.b	#$30,d2
	move.b	d2,2(a2,d7.w)
	move.b	#$01,3(a2,d7.w)
	addq.w	#4,d7
	bra.s	KeyboardExit
KeybSpecKeysData:
	dc.b	$62,$48,$e2,$49
	dc.b	$67,$44,$e7,$45,$66,$46,$e6,$47,$ff,$ff
*****************************************************************************
*	44	Right Alt Key Pressed
*	45	Right Alt Key Released
*	46	Left Alt Key Pressed
*	47	Left Alt Key Released
*	48	Caps Lock Pressed
*	49	Caps Lock Released
*****************************************************************************
KeyboardExit:
	move.w	$68(a6),d6
	move.l	a2,$64(a6)
	move.w	d7,$68(a6)
	lea	$f0(a2),a1
	sub.w	d6,d7
	move.b	d7,(a1)+
	tst.b	d7
	beq.s	KeyboardExit2
KeyboardExit1:
	move.b	0(a2,d6.w),(a1)+
	addq.w	#1,d6
	subq.w	#1,d7
	bne.s	KeyboardExit1
KeyboardExit2:
	movem.l	(a7)+,d0-d7/a0-a4
	rts

Keyboardrepeat:				;Repeats the last Keyboard event
	move.l	$64(a6),a2
	move.w	$68(a6),d7
	lea	$f0(a2),a1
	move.b	(a1)+,d6
	tst.b	d6
	beq.s	Keyboardrepeat2
Keyboardrepeat1:
	move.b	(a1)+,0(a2,d7.w)
	addq.w	#1,d7
	cmp.w	#$00f0,d7
	beq.s	Keyboardrepeat3
	subq.b	#1,d6
	bne.s	Keyboardrepeat1
Keyboardrepeat2:
	move.w	d7,$68(a6)
Keyboardrepeat3:
	rts

MakeMoButEvents:			;Makes Keyboardchars of Mousebuttons
	movem.l	d0/d7/a2,-(a7)
	move.l	$64(a6),a2
	move.w	$68(a6),d7	
	move.w	$1c0(a6),d0
	and.w	#$000f,d0
	cmp.w	#$0003,d0
	bne.s	MakeMoButEvents1
	move.w	#$3430,d0		;Mouse L Pressed
	bsr.s	MakeMoButEvents5
	bra.s	MakeMoButEvents2
MakeMoButEvents1:
	cmp.w	#$000c,d0
	bne.s	MakeMoButEvents2
	move.w	#$3432,d0		;Mouse L Released
	bsr.s	MakeMoButEvents5
MakeMoButEvents2:
	move.w	$1c2(a6),d0
	and.w	#$000f,d0
	cmp.w	#$0003,d0
	bne.s	MakeMoButEvents3
	move.w	#$3431,d0		;Mouse R Pressed
	bsr.s	MakeMoButEvents5
	bra.s	MakeMoButEvents4
MakeMoButEvents3:
	cmp.w	#$000c,d0
	bne.s	MakeMoButEvents4
	move.w	#$3433,d0		;Mouse R Released
	bsr.s	MakeMoButEvents5
MakeMoButEvents4:
	move.w	d7,$68(a6)
	movem.l	(a7)+,d0/d7/a2
	rts
MakeMoButEvents5:
	cmp.w	#$00ec,d7
	bhi.s	MakeMoButEvents6
	move.b	#$9b,0(a2,d7.w)
	move.b	d0,2(a2,d7.w)
	lsr.w	#8,d0
	move.b	d0,1(a2,d7.w)
	move.b	#$01,3(a2,d7.w)
	addq.w	#4,d7
MakeMoButEvents6:
	rts

ReadMouseButtons:			;Checks the mouse buttons
	movem.l	d0-d1,-(a7)
	move.w	#$0c00,$0034(a5)	;Enable Right Mouse Button
	move.w	$1c0(a6),d1
	move.b	$bfe001,d0
	and.b	#$40,d0
	sub.b	#$40,d0
	roxl.w	#1,d1
	move.w	d1,$1c0(a6)		;Mouse L Button
	move.w	$1c2(a6),d1
	move.w	$0016(a5),d0
	and.w	#$0400,d0
	sub.w	#$0400,d0
	roxl.w	#1,d1
	move.w	d1,$1c2(a6)		;Mouse R Button
	movem.l	(a7)+,d0-d1
	rts

RevCursor:				;Reverses the Cursor position
	movem.l	d1/a0,-(a7)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	RevCursor1
	bsr	CalcYAddr
RevCursor1:
	move.l	$178(a6),a0
	add.w	$5e(a6),a0
	moveq	#$ffffffff,d1
	eor.b	d1,(a0)
	eor.b	d1,$050(a0)
	eor.b	d1,$0a0(a0)
	eor.b	d1,$0f0(a0)
	eor.b	d1,$140(a0)
	eor.b	d1,$190(a0)
	eor.b	d1,$1e0(a0)
	eor.b	d1,$230(a0)
	movem.l	(a7)+,d1/a0
	rts

ShowCursor:				;Shows the Cursor
	movem.l	d0-d2/a0,-(a7)
	bsr	RevCursor
	move.l	$1f0(a6),a0
	move.w	$5e(a6),d2
	lsl.w	#2,d2
	move.w	$5c(a6),d1
	lsl.w	#3,d1
	add.w	#$002c,d1
	add.w	#$0080,d2
	move.b	d1,(a0)
	move.b	d2,3(a0)
	and.b	#$01,3(a0)
	ror.w	#1,d2
	move.b	d2,1(a0)
	btst	#8,d1
	beq.s	ShowCursor1
	bset	#2,3(a0)
ShowCursor1:
	addq.w	#8,d1
	move.b	d1,2(a0)
	btst	#8,d1
	beq.s	ShowCursor2
	bset	#1,3(a0)
ShowCursor2:
	move.l	(a0),$dff150		;SPR2POS & SPR2CTL
	move.l	#$f000f000,d0
	move.l	d0,4(a0)
	move.l	d0,8(a0)
	move.l	d0,12(a0)
	move.l	d0,16(a0)
	move.l	d0,20(a0)
	move.l	d0,24(a0)
	move.l	d0,28(a0)
	move.l	d0,32(a0)
	movem.l	(a7)+,d0-d2/a0
	rts

RemCursor:				;Removes the Cursor
	movem.l	d0/a0,-(a7)
	bsr	RevCursor
	move.l	$1f0(a6),a0
	moveq	#$00,d0
	move.l	d0,4(a0)
	move.l	d0,8(a0)
	move.l	d0,12(a0)
	move.l	d0,16(a0)
	move.l	d0,20(a0)
	move.l	d0,24(a0)
	move.l	d0,28(a0)
	move.l	d0,32(a0)
	movem.l	(a7)+,d0/a0
	rts

MakeCursor:				;Makes the Cursor image
	movem.l	d1/a0,-(a7)
	move.l	$1f0(a6),a0
	clr.l	(a0)+
	moveq	#$07,d1
MakeCursor1:
	move.l	#$f000f000,(a0)+
	dbf	d1,MakeCursor1
	clr.l	(a0)
	movem.l	(a7)+,d1/a0
	rts

MakePointer:				;Makes the Mousepointer image
	movem.l	a0/a1,-(a7)
	lea	PointerData(pc),a0
	move.l	$128(a6),a1
	lea	PointerDataEnd(pc),a2
MakePointer1:
	move.l	(a0)+,(a1)+
	cmp.l	a2,a0
	bne.s	MakePointer1
	move.w	$dff00a,$130(a6)
	movem.l	(a7)+,a0/a1
	rts

PointerData:
	dc.w	$0000,$0000

	dc.w	$0000,$fc00
	dc.w	$7c00,$fe00
	dc.w	$7c00,$8600
	dc.w	$7800,$8c00

	dc.w	$7c00,$8600
	dc.w	$6e00,$9300
	dc.w	$0700,$6980
	dc.w	$0380,$04c0

	dc.w	$01c0,$0260
	dc.w	$0080,$0140
	dc.w	$0000,$0080
PointerDataFinish:
	dc.w	$0000,$0000
PointerDataEnd:

ShowPointer:				;Shows the Mousepointer
	movem.l	d0-d2/a0/a1/a5,-(a7)
	lea	$dff000,a5
	move.l	$128(a6),a0
	lea	PointerDataFinish-PointerData(a0),a1
	move.w	$0a(a5),d1
	move.w	$130(a6),d0
	move.w	d1,$130(a6)
	move.b	d1,d2
	sub.b	d0,d2
	ext.w	d2
	lsr.w	#8,d1
	lsr.w	#8,d0
	sub.b	d0,d1
	ext.w	d1
	add.w	d1,$12c(a6)
	bpl.s	ShowPointer1
	clr.w	$12c(a6)
ShowPointer1:
	move.w	$1a0(a6),d0		;LastRasterLine
	sub.w	#$002d,d0
	cmp.w	$12c(a6),d0
	bhi.s	ShowPointer2
	move.w	d0,$12c(a6)
ShowPointer2:
	add.w	d2,$12e(a6)
	bpl.s	ShowPointer3
	clr.w	$12e(a6)
ShowPointer3:
	cmp.w	#$013f,$12e(a6)
	ble.s	ShowPointer4
	move.w	#$013f,$12e(a6)
ShowPointer4:
	move.w	$12e(a6),d2
	move.w	$12c(a6),d1
	add.w	#$002b,d1
	add.w	#$007f,d2
	move.b	d1,(a0)
	move.b	d2,3(a0)
	and.b	#$01,3(a0)
	ror.w	#1,d2
	move.b	d2,1(a0)
	btst	#8,d1
	beq.s	ShowPointer5
	bset	#2,3(a0)
ShowPointer5:
	add.w	#$000b,d1
	move.b	d1,2(a0)
	btst	#8,d1
	beq.s	ShowPointer6
	bset	#1,3(a0)
ShowPointer6:
	move.l	a0,$120(a5)
	move.l	a1,$124(a5)
	move.l	$1f0(a6),$128(a5)
	move.l	a1,$12c(a5)
	move.l	a1,$130(a5)
	move.l	a1,$134(a5)
	move.l	a1,$138(a5)
	move.l	a1,$13c(a5)
	move.w	#$8020,$96(a5)
	move.w	$132(a6),$1a2(a5)
	move.w	$134(a6),$1a4(a5)
	move.w	$136(a6),$1a6(a5)
	move.w	$1f4(a6),$1ae(a5)
	movem.l	(a7)+,d0-d2/a0/a1/a5
	rts

SetCursor:				;Moves the cursor to Mousepointer
	move.l	d1,-(a7)
	btst	#6,$bfe001
	bne.s	SetCursor2
	addq.b	#1,$75(a6)
SetCursor1:
	tst.b	$75(a6)
	bne.s	SetCursor1
	bsr	ShowCursor
	move.w	$12c(a6),d1
	lsr.w	#3,d1
	move.w	d1,$5c(a6)
	move.w	$12e(a6),d1
	lsr.w	#2,d1
	move.w	d1,$5e(a6)
	bsr	RemCursor
SetCursor2:
	move.l	(a7)+,d1
	rts
	
ReadMousePosition:			;Reads the Mousepointer position
					;D0h=y, D0l=x
	move.w	$12c(a6),d0
	lsr.w	#3,d0
	swap	d0
	move.w	$12e(a6),d0
	lsr.w	#2,d0
	rts

WriteMousePosition:			;Sets the Mousepointer position
					;D0h=y, D0l=x
	lsl.w	#2,d0
	or.w	#$0002,d0
	move.w	d0,$12e(a6)
	swap	d0
	lsl.w	#3,d0
	or.w	#$0004,d0
	move.w	d0,$12c(a6)
	rts

ReadKeyboard:				;Reads next Keyboard char
	movem.l	d1/a0,-(a7)
	moveq	#$00,d0
	move.l	$64(a6),a0
	move.w	$68(a6),d1
	beq.s	ReadKeyboardExit
	move.b	(a0),d0
	move.w	#$2300,SR
	subq.w	#1,$68(a6)
ReadKeyboard2:
	move.b	1(a0),(a0)+
	subq.w	#1,d1
	bne.s	ReadKeyboard2
	move.w	#$2000,SR
ReadKeyboardExit:
	movem.l	(a7)+,d1/a0
	rts

CalcYAddr:				;Calculates the LineAdresses
	movem.l	d1/a0,-(a7)
	move.w	$5c(a6),d1
	move.w	d1,$180(a6)
	add.w	$14a(a6),d1
	cmp.w	$14c(a6),d1
	blt.s	CalcYAddr1
	sub.w	$14c(a6),d1
CalcYAddr1:
	move.l	$04(a6),a0
	lsl.w	#4,d1
	add.w	d1,a0
	add.w	d1,d1
	add.w	d1,d1
	add.w	d1,a0
	move.l	a0,$17c(a6)
	move.l	$00(a6),a0
	add.w	d1,d1
	add.w	d1,a0
	add.w	d1,d1
	add.w	d1,d1
	add.w	d1,a0
	move.l	a0,$178(a6)
	movem.l	(a7)+,d1/a0
	rts

WriteChar:				;Writes a AscII character
	movem.l	d1/a0-a1,-(a7)
	moveq	#$00,d1
	move.b	d0,d1
	bpl.s	WriteChar1
	sub.b	#$20,d1
	bpl	WriteCharSpec
	bra.s	WriteChar2
WriteChar1:
	sub.b	#$20,d1
	bmi	WriteCharSpec
WriteChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteChar3
	bsr	CalcYAddr
WriteChar3:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1
	move.b	d0,0(a1,d1.w)
	move.l	$178(a6),a1
	add.w	d1,a1
	move.b	$74(a6),d1
	beq.s	WriteChar4
	move.b	(a0),d0
	eor.b	d1,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d1,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d1,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d1,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d1,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d1,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d1,d0
	move.b	d0,$0230(a1)
	bra.s	WriteChar5
WriteChar4:
	move.b	(a0),(a1)
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
WriteChar5:
	cmp.w	#$004f,$5e(a6)
	bne.s	WriteChar6
	moveq	#$0a,d0
	bra.s	WriteCharSpec
WriteChar6:
	addq.w	#1,$5e(a6)
	movem.l	(a7)+,d1/a0-a1
	rts

WriteCharSpec:
	move.l	d2,-(a7)
	and.w	#$00ff,d0
	cmp.w	#$0008,d0		;Backspace
	bne	WriteCharSpec3
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteCharSpec1
	bsr	CalcYAddr
WriteCharSpec1:
	move.w	$5e(a6),d1
	beq	WriteCharSpecExit
	subq.w	#1,d1
	move.w	d1,$5e(a6)
	move.w	d1,d2
	move.l	$17c(a6),a0
	add.w	d1,a0
WriteCharSpec2:
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	cmp.w	#$004f,d1
	bne.s	WriteCharSpec2
	move.b	#$20,(a0)
	move.l	$178(a6),a0
	move.w	d2,d1
	add.w	d1,a0
WriteCharSpec2a:
	move.b	$0051(a0),$0050(a0)
	move.b	$00a1(a0),$00a0(a0)
	move.b	$00f1(a0),$00f0(a0)
	move.b	$0141(a0),$0140(a0)
	move.b	$0191(a0),$0190(a0)
	move.b	$01e1(a0),$01e0(a0)
	move.b	$0231(a0),$0230(a0)
	move.b	1(a0),(a0)+
	addq.w	#1,d1
	cmp.w	#$004f,d1
	bne.s	WriteCharSpec2a
	clr.b	(a0)
	clr.b	$0050(a0)
	clr.b	$00a0(a0)
	clr.b	$00f0(a0)
	clr.b	$0140(a0)
	clr.b	$0190(a0)
	clr.b	$01e0(a0)
	clr.b	$0230(a0)
	bra	WriteCharSpecExit

WriteCharSpec3:
	cmp.w	#$0009,d0	;TAB
	bne.s	WriteCharSpec5
	move.w	$5e(a6),d1
	and.w	#$0078,d1
	addq.w	#8,d1
	cmp.w	#$50,d1
	bne.s	WriteCharSpec4
	bra.s	WriteCharSpec6
WriteCharSpec4:
	move.w	d1,$5e(a6)
	bra	WriteCharSpecExit

WriteCharSpec5:
	cmp.w	#$000a,d0	;LF
	bne.s	WriteCharSpec8
WriteCharSpec6:
	clr.w	$5e(a6)
	move.w	$14c(a6),d0	;LastScreenLine
	subq.w	#2,d0
	cmp.w	$5c(a6),d0
	bne.s	WriteCharSpec7
	jsr	_LVOScrollUp(a6)
	bra.s	WriteCharSpecExit
WriteCharSpec7:
	addq.w	#1,$5c(a6)
	bra.s	WriteCharSpecExit

WriteCharSpec8:
	cmp.w	#$000c,d0
	bne.s	WriteCharSpec9
	jsr	_LVOClearScreen(a6)
	bra.s	WriteCharSpecExit

WriteCharSpec9:
	cmp.w	#$000d,d0	;CR
	beq.s	WriteCharSpec6

WriteCharSpecExit:
	move.l	(a7)+,d2
	movem.l	(a7)+,d1/a0-a1
	rts

ScrollUp:				;Scrolls screen upward
	move.l	d0,-(a7)
	move.l	$5c(a6),-(a7)
	move.w	$14c(a6),d0
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	jsr	_LVOClearLine(a6)
	move.w	$14a(a6),d0
	addq.w	#1,d0
	cmp.w	$14c(a6),d0
	blt.s	ScrollUp1
	move.w	#$0000,d0
ScrollUp1:
	tst.b	$75(a6)
	beq.s	ScrollUp1
	clr.b	$75(a6)
	move.w	d0,$14a(a6)
	move.w	#$ffff,$180(a6)
	move.l	(a7)+,$5c(a6)
	move.l	(a7)+,d0
	rts

ScrollDown:				;Scrolls screen downward
	move.l	d0,-(a7)
	move.l	$5c(a6),-(a7)
	move.w	$14c(a6),d0
	subq.w	#1,d0
	move.w	d0,$5c(a6)
	jsr	_LVOClearLine(a6)
	move.w	$14a(a6),d0
	bne.s	ScrollDown1
	move.w	$14c(a6),d0
ScrollDown1:
	tst.b	$75(a6)
	beq.s	ScrollDown1
	clr.b	$75(a6)
	subq.w	#1,d0
	move.w	d0,$14a(a6)
	move.w	#$ffff,$180(a6)
	move.l	(a7)+,$5c(a6)
	move.l	(a7)+,d0
	rts

ReadChar:				;Read one char
					;A5=LineAdress,D7=Index,D0out=char
	moveq	#-1,d0
	cmp.w	#$50,d7
	beq.s	ReadCharEnd
	addq.w	#1,d7
	cmp.w	#$50,d7
	beq.s	ReadCharEnd
	moveq	#$00,d0
	move.b	0(a5,d7.w),d0
ReadCharEnd:
	tst.l	d0
	rts

ReadNumber:				;Reads a hex number,any length
					;D0out=Number
	move.l	d1,-(a7)
	moveq	#$00,d1
ReadNumber1:
	bsr.s	ReadChar
	tst.l	d0
	bmi.s	ReadNumberEnd
	cmp.b	#$20,d0
	beq.s	ReadNumber1
ReadNumber2:
	cmp.b	#$30,d0
	bcs.s	ReadNumberEnd
	cmp.b	#$3a,d0
	bcs.s	ReadNumber3
	and.b	#$5f,d0
	cmp.b	#$41,d0
	bcs.s	ReadNumberEnd
	cmp.b	#$47,d0
	bcc.s	ReadNumberEnd
	subq.b	#7,d0
ReadNumber3:
	and.b	#$0f,d0
	lsl.l	#4,d1
	or.b	d0,d1
	bsr.s	ReadChar
	cmp.b	#$20,d0
	bne.s	ReadNumber2
ReadNumberEnd:
	move.l	d1,d0
	move.l	(a7)+,d1
	rts

ReadDecNumber:				;Reads a decimal number
					;D0out=Number
	movem.l	d1/d2,-(a7)
	moveq	#$00,d1
ReadDecNumber1:
	bsr.s	ReadChar
	tst.l	d0
	bmi.s	ReadDecNumberEnd
	cmp.b	#$2f,d0
	bls.s	ReadDecNumber1
	cmp.b	#$39,d0
	bhi.s	ReadDecNumber1
ReadDecNumber2:
	cmp.b	#$2f,d0
	bls.s	ReadDecNumberEnd
	cmp.b	#$39,d0
	bhi.s	ReadDecNumberEnd
	and.l	#$0f,d0
	move.l	d1,d2
	swap	d2
	mulu	#$000a,d1
	mulu	#$000a,d2
	swap	d2
	add.l	d2,d1
	add.l	d0,d1
	bsr	ReadChar
	bra.s	ReadDecNumber2
ReadDecNumberEnd:
	move.l	d1,d0
	movem.l	(a7)+,d1/d2
	rts

ReadNibble:				;Reads a number 0-F
					;D0out=Nibble
	move.l	d1,-(a7)
	moveq	#-1,d1
ReadNibble1:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadNibbleEnd
	cmp.b	#$20,d0
	beq.s	ReadNibble1
ReadNibble2:
	cmp.b	#$30,d0
	bcs.s	ReadNibbleEnd
	cmp.b	#$3a,d0
	bcs.s	ReadNibble3
	and.b	#$5f,d0
	cmp.b	#$41,d0
	bcs.s	ReadNibbleEnd
	cmp.b	#$47,d0
	bcc.s	ReadNibbleEnd
	subq.b	#7,d0
ReadNibble3:
	and.b	#$0f,d0
	move.l	d0,d1
ReadNibbleEnd:
	move.l	d1,d0
	move.l	(a7)+,d1
	tst.l	d0
	rts

ReadByte:				;Reads a number 00-FF
					;D0out=Byte
	move.l	d1,-(a7)
	bsr.s	ReadNibble
	tst.l	d0
	bmi.s	ReadByteEnd
	lsl.b	#4,d0
	move.b	d0,d1
	bsr.s	ReadNibble
	tst.l	d0
	bmi.s	ReadByteEnd
	or.b	d1,d0
ReadByteEnd:
	move.l	(a7)+,d1
	tst.l	d0
	rts

ReadStringII:				;Reads a string, don't check 
					;A0=Adress
	movem.l	d1/a0,-(a7)
	moveq	#$00,d1
ReadString0:
	bsr	ReadChar
	tst.l	d0
	bmi	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString2
	cmp.w	#$20,d0
	bls.s	ReadString0
	bra	ReadString5a

ReadString:				;Reads a string, checks if number
					;A0=Adress
	movem.l	d1/a0,-(a7)
	moveq	#$00,d1
ReadString1:
	bsr	ReadChar
	tst.l	d0
	bmi	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString2
	cmp.w	#$20,d0
	bls.s	ReadString1
	bra.s	ReadString4
ReadString2:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadString3
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	bra.s	ReadString2
ReadString3:
	clr.b	0(a0,d1.w)
	move.l	d1,d0
	movem.l	(a7)+,d1/a0
	rts
ReadString4:			;String without ""
	cmp.b	#$20,d0
	bls.s	ReadStringEnd
	cmp.b	#$22,d0
	beq.s	ReadStringEnd
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	cmp.b	#$2f,d0
	bls.s	ReadString5
	cmp.b	#$40,d0
	bhi.s	ReadString4a
	cmp.b	#$39,d0
	bhi.s	ReadString5
ReadString4a:
	tst.b	d0
	bmi.s	ReadString5
	and.b	#$5f,d0
	cmp.b	#'F',d0
	bhi.s	ReadString5
	bsr	ReadChar
	tst.l	d0
	bpl.s	ReadString4
	bmi.s	ReadStringEnd
ReadString5:
	bsr	ReadChar
	tst.l	d0
	bmi.s	ReadStringEnd
	cmp.b	#$20,d0
	bls.s	ReadString3
ReadString5a:
	move.b	d0,0(a0,d1.w)
	addq.w	#1,d1
	bra.s	ReadString5
ReadStringEnd:
	moveq	#-1,d0
	movem.l	(a7)+,d1/a0
	rts

WriteString:				;Writes a nullterminated string
					;A0=String
	move.l	a0,-(a7)
WriteString1:
	move.b	(a0)+,d0
	beq.s	WriteStringEnd
	jsr	_LVOWriteChar(a6)
	bra.s	WriteString1
WriteStringEnd:
	move.l	a0,d0
	move.l	(a7)+,a0
	rts

CopyString:				;Copies one nullterminated string
					;A0=SourceString,A1=DestinString
	movem.l	d0/a0-a1,-(a7)
	moveq	#$4f,d0
CopyString1:
	move.b	(a0)+,(a1)+
	dbeq	d0,CopyString1
	movem.l	(a7)+,d0/a0-a1
	rts

WriteASCIIChar:				;Writes AscII 00-FF as characters
					;D0=char
	movem.l	d1-d2/a0/a1,-(a7)
	moveq	#$00,d1
	moveq	#$00,d2
	move.b	d0,d1
	bpl.s	WriteASCIIChar1
	sub.b	#$0020,d1
	bmi.s	WriteASCIIChar2
	moveq	#-1,d2
	add.b	#$0040,d1
	bra.s	WriteASCIIChar2
WriteASCIIChar1:
	sub.b	#$0020,d1
	bpl.s	WriteASCIIChar2
	moveq	#-1,d2
	add.b	#$0040,d1
WriteASCIIChar2:
	add.w	d1,d1
	add.w	d1,d1
	move.l	$10(a6),a0
	move.w	00(a0,d1.w),d1
	lsr.w	#3,d1
	move.l	$0c(a6),a0
	add.w	d1,a0
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	WriteASCIIChar3
	bsr	CalcYAddr
WriteASCIIChar3:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1
	move.b	d0,0(a1,d1.w)
	move.l	$178(a6),a1
	add.w	d1,a1
	tst.b	d2
	beq.s	WriteASCIIChar4
	move.b	(a0),d0
	eor.b	d2,d0
	move.b	d0,(a1)
	move.b	$00c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0050(a1)
	move.b	$0180(a0),d0
	eor.b	d2,d0
	move.b	d0,$00a0(a1)
	move.b	$0240(a0),d0
	eor.b	d2,d0
	move.b	d0,$00f0(a1)
	move.b	$0300(a0),d0
	eor.b	d2,d0
	move.b	d0,$0140(a1)
	move.b	$03c0(a0),d0
	eor.b	d2,d0
	move.b	d0,$0190(a1)
	move.b	$0480(a0),d0
	eor.b	d2,d0
	move.b	d0,$01e0(a1)
	move.b	$0540(a0),d0
	eor.b	d2,d0
	move.b	d0,$0230(a1)
	bra.s	WriteASCIIChar5
WriteASCIIChar4:
	move.b	(a0),(a1)
	move.b	$00c0(a0),$0050(a1)
	move.b	$0180(a0),$00a0(a1)
	move.b	$0240(a0),$00f0(a1)
	move.b	$0300(a0),$0140(a1)
	move.b	$03c0(a0),$0190(a1)
	move.b	$0480(a0),$01e0(a1)
	move.b	$0540(a0),$0230(a1)
WriteASCIIChar5:
	addq.w	#1,$5e(a6)
	movem.l	(a7)+,d1-d2/a0/a1
	rts

WriteNumber:				;Writes the numbers 0-F
					;D0=Number
	and.b	#$0f,d0
	cmp.b	#$0a,d0
	bcs.s	WriteNumber1
	addq.b	#7,d0
WriteNumber1:
	add.b	#$30,d0
	jsr	_LVOWriteChar(a6)
	rts

WriteDecNumber:				;Writes a decimal number, same length
					;d0=number,d1=highestten(1000,100...)
	movem.l	d1-d4,-(a7)
	move.l	d1,d3
	moveq	#$00,d4
WriteDecNumber0:
	moveq	#-1,d2
	add.l	d3,d0
WriteDecNumber1:
	sub.l	d3,d0
	addq.b	#1,d2
	cmp.l	d3,d0
	beq.s	WriteDecNumber1
	bhi.s	WriteDecNumber1
	move.l	d0,d1
	move.b	d2,d0
	tst.b	d4
	bne.s	WriteDecNumber2
	tst.b	d2
	beq.s	WriteDecNumber3
WriteDecNumber2:
	moveq	#$01,d4
	jsr	_LVOWriteNumber(a6)
	bra.s	WriteDecNumber4
WriteDecNumber3:
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
WriteDecNumber4:
	move.l	d1,d0
	move.l	d3,d1
	clr.w	d3
	swap	d3
	divu	#$000a,d3
	swap	d3
	swap	d1
	move.w	d3,d1
	swap	d1
	divu	#$000a,d1
	move.w	d1,d3
	cmp.l	#$00000001,d1
	bne.s	WriteDecNumber0
	bsr.s	WriteNumber
	movem.l	(a7)+,d1-d4
	rts

WriteDecNumberII:			;Writes a decimal number, any length
					;d0=number,d1=highestten(1000,100...)
	movem.l	d1-d4,-(a7)
	move.l	d1,d3
	moveq	#$00,d4
WriteDecNumberII0:
	moveq	#-1,d2
	add.l	d3,d0
WriteDecNumberII1:
	sub.l	d3,d0
	addq.b	#1,d2
	cmp.l	d3,d0
	beq.s	WriteDecNumberII1
	bhi.s	WriteDecNumberII1
	move.l	d0,d1
	move.b	d2,d0
	tst.b	d4
	bne.s	WriteDecNumberII2
	tst.b	d2
	beq.s	WriteDecNumberII3
WriteDecNumberII2:
	moveq	#$01,d4
	jsr	_LVOWriteNumber(a6)
WriteDecNumberII3:
	move.l	d1,d0
	move.l	d3,d1
	clr.w	d3
	swap	d3
	divu	#$000a,d3
	swap	d3
	swap	d1
	move.w	d3,d1
	swap	d1
	divu	#$000a,d1
	move.w	d1,d3
	cmp.l	#$00000001,d1
	bne.s	WriteDecNumberII0
	jsr	_LVOWriteNumber(a6)
	movem.l	(a7)+,d1-d4
	rts

WriteByte:				;Writes hex numbers 00-FF
					;D0=Byte
	move.l	d1,-(a7)
	move.b	d0,d1
	lsr.b	#4,d0
	jsr	_LVOWriteNumber(a6)
	move.b	d1,d0
	jsr	_LVOWriteNumber(a6)
	move.l	(a7)+,d1
	rts

WriteWord:				;Writes hex numbers 0000-FFFF
					;D0=Word
	move.l	d1,-(a7)
	move.w	d0,d1
	lsr.w	#8,d0
	bsr.s	WriteByte
	move.w	d1,d0
	bsr.s	WriteByte
	move.l	(a7)+,d1
	rts

WriteLong:				;Writes hex numbers 00000000-FFFFFFFF
					;D0=LongWord
	move.l	d1,-(a7)
	move.l	d0,d1
	swap	d0
	bsr.s	WriteWord
	move.l	d1,d0
	bsr.s	WriteWord
	move.l	(a7)+,d1
	rts

ReadMemByte:				;Reads a byte in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	ReadMemByte1
	cmpa.l	$14(a6),a0		;Agnus Base Adress
	bhi.s	ReadMemByte2
	cmpa.l	#$bfffff,a0
	bhi.s	ReadMemByte1
	cmpa.l	#$9fffff,a0
	bhi.s	ReadMemByte3
	cmpa.l	#$0053ff,a0
	bhi.s	ReadMemByte1
	adda.l	$0086(a6),a0
	move.b	(a0)+,d0
	suba.l	$0086(a6),a0
	rts
ReadMemByte1:
	move.b	(a0)+,d0
	rts
ReadMemByte2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01ff,d1
	move.l	$18a(a6),a0
	move.b	0(a0,d1.w),d0
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

ReadMemByte3:
	movem.l	d1/a0,-(a7)
	move.l	a0,d1
	move.l	$18e(a6),a0
	lsr.w	#1,d1
	bcs.s	ReadMemByte4
	lsr.w	#7,d1
	btst	#5,d1
	bne.s	ReadMemByte5
	and.w	#$000f,d1
	move.b	0(a0,d1.w),d0
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts
ReadMemByte4:
	lsr.w	#7,d1
	btst	#4,d1
	bne.s	ReadMemByte5
	and.w	#$000f,d1
	move.b	$18(a0,d1.w),d0
ReadMemByte5:
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

ReadMemWord:				;Reads a word in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	ReadMemWord1
	cmpa.l	$14(a6),a0
	bhi.s	ReadMemWord2
	cmpa.l	#$bfffff,a0
	bhi.s	ReadMemWord1
	cmpa.l	#$9fffff,a0
	bhi.s	ReadMemWord3
	cmpa.l	#$0053ff,a0
	bhi.s	ReadMemWord1
	adda.l	$0086(a6),a0
	move.w	(a0)+,d0
	suba.l	$0086(a6),a0
	rts
ReadMemWord1:
	move.w	(a0)+,d0
	rts
ReadMemWord2:
	move.l	a0,-(a7)
	move.w	a0,d0
	and.w	#$01fe,d0
	move.l	$18a(a6),a0
	move.w	0(a0,d0.w),d0
	move.l	(a7)+,a0
ReadMemWord3:
	addq.l	#2,a0
	rts

ReadMemLong:				;Reads a longword in memory
					;A0=Adress
	bsr.s	ReadMemWord
	swap	d0
	bra.s	ReadMemWord

WriteMemByte:				;Writes a byte in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	WriteMemByte1
	cmpa.l	$14(a6),a0
	bhi.s	WriteMemByte2
	cmpa.l	#$bfffff,a0
	bhi.s	WriteMemByte1
	cmpa.l	#$9fffff,a0
	bhi.s	WriteMemByte3
	cmpa.l	#$0053ff,a0
	bhi.s	WriteMemByte1
	adda.l	$0086(a6),a0
	move.b	d0,(a0)+
	suba.l	$0086(a6),a0
	rts	
WriteMemByte1:
	move.b	d0,(a0)+
	rts
WriteMemByte2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01ff,d1
	move.l	$18a(a6),a0
	move.b	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

WriteMemByte3:
	movem.l	d1/a0,-(a7)
	move.l	a0,d1
	move.l	$18e(a6),a0
	lsr.w	#1,d1
	bcs.s	WriteMemByte4
	lsr.w	#7,d1
	btst	#5,d1
	bne.s	WriteMemByte5
	and.w	#$000f,d1
	move.b	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts
WriteMemByte4:
	lsr.w	#7,d1
	btst	#4,d1
	bne.s	WriteMemByte5
	and.w	#$000f,d1
	move.b	d0,$18(a0,d1.w)
WriteMemByte5:
	movem.l	(a7)+,d1/a0
	addq.l	#1,a0
	rts

WriteMemWord:				;Writes a word in memory
					;A0=Adress
	cmpa.l	#$dfffff,a0
	bhi.s	WriteMemWord1
	cmpa.l	$14(a6),a0
	bhi.s	WriteMemWord2
	cmpa.l	#$bfffff,a0
	bhi.s	WriteMemWord1
	cmpa.l	#$9fffff,a0
	bhi.s	WriteMemWord3
	cmpa.l	#$0053ff,a0
	bhi.s	WriteMemWord1
	adda.l	$0086(a6),a0
	move.w	d0,(a0)+
	suba.l	$0086(a6),a0
	rts	
WriteMemWord1:
	move.w	d0,(a0)+
	rts
WriteMemWord2:
	movem.l	d1/a0,-(a7)
	move.w	a0,d1
	and.w	#$01fe,d1
	move.l	$18a(a6),a0
	move.w	d0,0(a0,d1.w)
	movem.l	(a7)+,d1/a0
WriteMemWord3:
	addq.l	#2,a0
	rts

WriteMemLong:				;Writes a longword in memory
					;A0=Adress
	swap	d0
	bsr.s	WriteMemWord
	swap	d0
	bra.s	WriteMemWord

ExchangeRam:				;Exchanges Work and Chip ram
	movem.l	d0-d4/a0-a5,-(a7)
	move.l	$0086(a6),a0
	lea	$0000.w,a1
	move.w	#$053f,d0
ExchangeRam1:
	movem.l	(a0),d1-d4
	movem.l	(a1),a2-a5
	movem.l	a2-a5,(a0)
	lea	$0010(a0),a0
	movem.l	d1-d4,(a1)
	lea	$0010(a1),a1
	dbf	d0,ExchangeRam1
	movem.l	(a7)+,d0-d4/a0-a5
	rts

ClearLine:				;Clears a horisontal line on screen
	movem.l	d1-d4/a0/a1/a5,-(a7)
	lea	$dff000,a5
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ClearLine1
	bsr	CalcYAddr
ClearLine1:
	move.l	$17c(a6),a0		;Charmap
	move.l	$178(a6),a1		;Bitmap
	move.l	#$20202020,d1
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	lea	$0050(a0),a0
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	move.w	#$8440,$96(a5)
	move.l	a1,$54(a5)
	move.l	#$01000000,$40(a5)
	clr.w	$66(a5)
	move.w	#$0140,$58(a5)
ClearLine2:
	btst	#6,$02(a5)
	bne.s	ClearLine2
	move.w	#$0440,$96(a5)
	movem.l	(a7)+,d1-d4/a0/a1/a5
	rts

ClearLineII:				;Clears part of a horisontal line
					;d0 = numbers of chars to clear
	movem.l	d1/d2/a1/a2,-(a7)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ClearLineII1
	bsr	CalcYAddr
ClearLineII1:
	move.w	$5e(a6),d1
	move.l	$17c(a6),a1	;Charmap
	add.w	d1,a1
	move.l	$178(a6),a2	;Bitmap
	add.w	d1,a2
	tst.w	d0
	bmi	ClearLineII6
	move.b	$74(a6),d2	;Inverse ON/OFF
	ext.w	d2
	ext.l	d2
ClearLineII2:
	tst.w	d0
	beq	ClearLineII6
	move.l	a1,d1
	lsr.w	#1,d1
	bcs.s	ClearLineII3	;Odd
	cmp.w	#$0003,d0
	bhi.s	ClearLineII5
	cmp.w	#$0001,d0
	bhi.s	ClearLineII4
ClearLineII3:
	move.b	d2,$230(a2)
	move.b	d2,$1e0(a2)
	move.b	d2,$190(a2)
	move.b	d2,$140(a2)
	move.b	d2,$0f0(a2)
	move.b	d2,$0a0(a2)
	move.b	d2,$050(a2)
	move.b	d2,(a2)+
	move.b	#$20,(a1)+
	subq.w	#1,d0
	bra.s	ClearLineII2
ClearLineII4:
	move.w	d2,$230(a2)
	move.w	d2,$1e0(a2)
	move.w	d2,$190(a2)
	move.w	d2,$140(a2)
	move.w	d2,$0f0(a2)
	move.w	d2,$0a0(a2)
	move.w	d2,$050(a2)
	move.w	d2,(a2)+
	move.w	#$2020,(a1)+
	subq.w	#2,d0
	bra.s	ClearLineII2
ClearLineII5:
	move.l	d2,$230(a2)
	move.l	d2,$1e0(a2)
	move.l	d2,$190(a2)
	move.l	d2,$140(a2)
	move.l	d2,$0f0(a2)
	move.l	d2,$0a0(a2)
	move.l	d2,$050(a2)
	move.l	d2,(a2)+
	move.l	#$20202020,(a1)+
	subq.w	#4,d0
	bra	ClearLineII2
ClearLineII6:
	movem.l	(a7)+,d1/d2/a1/a2
	rts

ClearToEOL:				;Clears to end of the horisontal line
	move.l	d0,-(a7)
	move.w	#$0050,d0
	sub.w	$5e(a6),d0
	jsr	_LVOClearLineII(a6)
	move.l	(a7)+,d0
	rts

ClearToTAB:				;Clears to the next tabulator stop
	move.l	d0,-(a7)
	move.w	$5e(a6),d0
	addq.w	#8,d0
	and.w	#$0078,d0
	sub.w	$5e(a6),d0
	jsr	_LVOClearLineII(a6)
	move.l	(a7)+,d0
	rts

ClearScreen:				;Clears the whole screen
	movem.l	d0-d4/a0/a1/a5,-(a7)
	lea	$dff000,a5
	clr.w	$14a(a6)
	clr.w	$5c(a6)
	clr.w	$5e(a6)
	bsr	CalcYAddr
	move.l	$04(a6),a0
	move.l	$00(a6),a1
	move.l	#$20202020,d1
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	lea	$0a50(a0),a0
	moveq	#$20,d0
ClearScreen1:
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	movem.l	d1/d2/d3/d4,-(a0)
	dbf	d0,ClearScreen1
	move.w	#$8440,$96(a5)
	move.l	a1,$54(a5)
	move.l	#$01000000,$40(a5)
	clr.w	$66(a5)
	move.w	#$2940,$58(a5)
ClearScreen2:
	btst	#6,$02(a5)
	bne.s	ClearScreen2
	move.w	#$0440,$96(a5)
	movem.l	(a7)+,d0-d4/a0/a1/a5
	rts

WaitIfCtrl:				;Waits until Control is released
	btst	#2,$6b(a6)
	bne.s	WaitIfCtrl
	rts

ComError:				;Fatal Command ERROR
	move.w	$dff006,$dff180
	bra.s	ComError
ExecuteCom:				;Executes the command written
	lea	Preferences,a6
	lea	ErrorHandler0(pc),a0
	move.l	a0,$142(a6)
	move.w	$5c(a6),d1
	cmp.w	$180(a6),d1
	beq.s	ExecuteCom1
	bsr	CalcYAddr
ExecuteCom1:
	move.l	$17c(a6),a5		;Charmap
	moveq	#$00,d7
ExecuteCom2:
	cmp.b	#$20,0(a5,d7.w)
	bne.s	ExecuteCom3
	addq.w	#1,d7
	cmp.w	#$4f,d7
	bne.s	ExecuteCom2
	bra.s	ExecuteComEnd
ExecuteCom3:
	lea	Commands1(pc),a2
	lea	Commands(pc),a1
	move.b	0(a5,d7.w),d0
	bmi.s	ExecuteComEnd
	btst	#6,d0
	beq.s	ExecuteCom4
	and.b	#$5f,d0
ExecuteCom4:
	move.w	d7,d6
	move.l	a1,a0
	move.l	(a2)+,a3
	move.b	(a0)+,d1
	beq.s	ExecuteComEnd
	ext.w	d1
	lea	0(a0,d1.w),a1
	move.b	d0,d2
	bra.s	ExecuteCom6
ExecuteCom5:
	move.b	0(a5,d6.w),d2
	bmi.s	ExecuteCom7
	and.b	#$5f,d2
	btst	#6,d2
	beq.s	ExecuteCom7
	tst.w	d1
	beq.s	ExecuteCom4
ExecuteCom6:
	cmp.b	(a0)+,d2
	bne.s	ExecuteCom4
	addq.w	#1,d6
	cmp.w	#$004f,d6
	bhi.s	ExecuteComEnd
	subq.w	#1,d1
	bra.s	ExecuteCom5
ExecuteCom7:
	move.w	d6,d7
	subq.w	#1,d7
	lea	Ecom(pc),a0
	add.l	a0,a3
	jsr	(a3)
Ecom:
	bra	Loop
ExecuteComEnd:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	bra	Loop

Commands:
	dc.b	1,"A"
	dc.b	1,"B"
	dc.b	1,"C",2,"CD",5,"CLOSE"
	dc.b	1,"D",4,"DATE",6,"DELETE",3,"DIR",8,"DISKCOPY"
	dc.b	1,"E"
	dc.b	1,"F",8,"FILENOTE",6,"FORMAT"
	dc.b	1,"G"
	dc.b	1,"H",7,"HUNTDIS"
	dc.b	1,"I",4,"INFO",7,"INSTALL"
	dc.b	1,"J"
	dc.b	1,"L",7,"LOADSEG"
	dc.b	1,"M",7,"MAKEDIR"
	dc.b	1,"N",3,"NEW"
	dc.b	4,"OPEN"
	dc.b	7,"PROTECT"
	dc.b	1,"Q"
	dc.b	1,"R",6,"RENAME",7,"RELABEL"
	dc.b	1,"S",4,"SAVE",7,"SHOWSEG"
	dc.b	1,"T",4,"TYPE"
	dc.b	7,"WORKBUF"
	dc.b	1,"X"
	dc.b	1,","
	dc.b	1,"'"
	dc.b	1,":"
	dc.b	1,";"
	dc.b	0
	even
Commands1:
	dc.l	AssembleCom-Ecom	;A
	dc.l	BreakpointCom-Ecom	;B
	dc.l	CompareCom-Ecom		;C
	dc.l	ChangeDirCom-Ecom	;CD
	dc.l	CloseCom-Ecom		;CLOSE
	dc.l	DisassembleCom-Ecom	;D
	dc.l	DateCom-Ecom		;DATE
	dc.l	DeleteCom-Ecom		;DELETE
	dc.l	DirectoryCom-Ecom	;DIR
	dc.l	DiskCopyCom-Ecom	;DISKCOPY
	dc.l	ExchangeCom-Ecom	;E
	dc.l	FillCom-Ecom		;F
	dc.l	FileNoteCom-Ecom	;FILENOTE
	dc.l	FormatCom-Ecom		;FORMAT
	dc.l	GoCom-Ecom		;G
	dc.l	HuntCom-Ecom		;H
	dc.l	HuntDisCom-Ecom		;HUNTDIS
	dc.l	InterpretCom-Ecom	;I
	dc.l	InfoCom-Ecom		;INFO
	dc.l	InstallCom-Ecom		;INSTALL
	dc.l	JumpCom-Ecom		;J
	dc.l	LoadCom-Ecom		;L
	dc.l	LoadSegCom-Ecom		;LOADSEG
	dc.l	MemoryCom-Ecom		;M
	dc.l	MakeDirCom-Ecom		;MAKEDIR
	dc.l	NewlocatorCom-Ecom	;N
	dc.l	NewCom-Ecom		;NEW
	dc.l	OpenCom-Ecom		;OPEN
	dc.l	ProtectCom-Ecom		;PROTECT
	dc.l	QuickTraceCom-Ecom	;Q
	dc.l	RegisterCom-Ecom	;R
	dc.l	RenameCom-Ecom		;RENAME
	dc.l	RelabelCom-Ecom		;RELABEL
	dc.l	SaveCom-Ecom		;S
	dc.l	SaveTextCom-Ecom	;SAVE
	dc.l	ShowSegCom-Ecom		;SHOWSEG
	dc.l	TransferCom-Ecom	;T
	dc.l	TypeCom-Ecom		;TYPE
	dc.l	WorkBufCom-Ecom		;WORKBUF
	dc.l	ExitCom-Ecom		;X
	dc.l	DisassembleWriteCom-Ecom;,
	dc.l	InterpretWriteCom-Ecom	;'
	dc.l	MemoryWriteCom-Ecom	;:
	dc.l	RegisterWriteCom-Ecom	;;

AssembleCom:
	jsr	_LVOReadNumber(a6)
	subq.w	#1,d7
	move.l	d0,$98(a6)
AssembleComA:
	lea	$b4(a6),a1
	move.l	a1,$a0(a6)
	move.w	#$0010,$a4(a6)
AssembleCom1:
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#$20,d0
	beq.s	AssembleCom1
	bra.s	AssembleCom3
AssembleCom2:
	bsr	ReadChar
	bmi	AssembleComError
AssembleCom3:
	cmp.b	#'.',d0
	beq.s	AssembleCom4
	cmp.b	#$40,d0
	bls.s	AssembleCom6
	and.b	#$5f,d0
	move.b	d0,(a1)+
	bra.s	AssembleCom2
AssembleCom4:
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	moveq	#$08,d1
	cmp.b	#'S',d0
	beq.s	AssembleCom5
	cmp.b	#'B',d0
	beq.s	AssembleCom5
	moveq	#$10,d1
	cmp.b	#'W',d0
	beq.s	AssembleCom5
	moveq	#$20,d1
	cmp.b	#'L',d0
	bne.s	AssembleCom7
AssembleCom5:
	move.w	d1,$a4(a6)
	bra.s	AssembleCom7
AssembleCom6:
	subq.w	#1,d7
AssembleCom7:
	clr.b	(a1)+
	clr.w	$a6(a6)
	clr.l	$a8(a6)
	clr.w	$ac(a6)
	clr.l	$ae(a6)
	clr.l	d6
	lea	AssembleCom8(pc),a2
	lea	$a6(a6),a1
	cmp.l	#'MOVE',$b4(a6)
	bne.s	AssembleCom8
	cmp.b	#'M',$b8(a6)
	bne.s	AssembleCom8
	moveq	#-1,d6
AssembleCom8:
	move.w	d7,d5
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#'#',d0
	beq	AssembleCom21		;Imm
	cmp.b	#'$',d0
	beq	AssembleCom20		;Abs hex,d(An),d(An,Xi)...
	cmp.b	#'(',d0
	beq	AssembleCom16		;(An),(an)+
	cmp.b	#'-',d0
	beq	AssembleCom18		;-(An),-Abs,-d(An)...
	cmp.b	#$2f,d0
	bls.s	AssembleCom8
	cmp.b	#$39,d0
	bls	AssembleCom19		;Abs dec,d(An),d(An,Xi)...
	and.b	#$5f,d0
	cmp.b	#'D',d0
	beq.s	AssembleCom9		;Dn
	cmp.b	#'A',d0
	beq.s	AssembleCom12		;An
	cmp.b	#'C',d0
	beq.s	AssembleCom13		;CCR
	cmp.b	#'S',d0
	beq.s	AssembleCom14		;SR
	cmp.b	#'U',d0
	beq.s	AssembleCom15		;USP
	bra	AssembleComError

AssembleCom9:				;Dn
	move.w	#$0001,(a1)
AssembleCom10:
	tst.l	d6
	bmi	AssembleCom22		;RegListMask
	jsr	_LVOReadNibble(a6)
	bmi	AssembleComError	
	cmp.b	#$07,d0
	bhi	AssembleComError
	move.w	d0,$2(a1)
AssembleCom11:
	bsr	ReadChar
	bmi	AssembleCom23		;Next Operand
	cmp.b	#',',d0
	beq	AssembleCom23		;Next Operand
	bra.s	AssembleCom11
AssembleCom12:				;An
	move.w	#$0002,(a1)
	bra.s	AssembleCom10

AssembleCom13:				;CCR
	move.w	#$2000,(a1)
	bra.s	AssembleCom11

AssembleCom14:				;SR
	move.w	#$4000,(a1)
	bra.s	AssembleCom11

AssembleCom15:				;USP
	move.w	#$8002,(a1)
	bra.s	AssembleCom11

AssembleCom16:				;(An),(An)+
	move.w	#$0004,(a1)
AssembleCom16a:
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	cmp.b	#'A',d0
	bne.s	AssembleCom16
	jsr	_LVOReadNibble(a6)
	move.w	d0,$2(a1)
AssembleCom17:
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#',',d0
	beq	AssembleCom23		;Next operand
	cmp.b	#'+',d0
	bne.s	AssembleCom17
	move.w	#$0008,(a1)		;(An)+
	bra.s	AssembleCom17
AssembleCom18:				;-
	move.w	#$0010,(a1)
	bsr	ReadChar
	cmp.b	#'(',d0
	beq.s	AssembleCom16a		;-(An)
	cmp.b	#'$',d0
	bne.s	AssembleCom18a
	jsr	_LVOReadNumber(a6)
	neg.l	d0
	bra.s	AssembleCom18b
AssembleCom18a:
	subq.w	#1,d7
	jsr	_LVOReadDecNumber(a6)	
	neg.l	d0
AssembleCom18b:
	move.l	d0,$2(a1)
	move.w	#$8100,(a1)		;Abs
	subq.w	#1,d7
AssembleCom18b3:
	move.l	d0,d1
	ext.l	d1
	cmp.l	d1,d0
	bne.s	AssembleCom18c
	move.w	#$8080,(a1)
	bra.s	AssembleCom18c
AssembleCom18b1:
	bsr	ReadChar
	and.b	#$5f,d0
	cmp.b	#'L',d0
	beq.s	AssembleCom18b2
	cmp.b	#'W',d0
	bne	AssembleComError
	move.l	$2(a1),d0
	bra.s	AssembleCom18b3
AssembleCom18b2:	
	move.w	#$8100,(a1)
AssembleCom18c:
	bsr	ReadChar
	bmi	AssembleCom23		;Next operand
	cmp.b	#'.',d0
	beq.s	AssembleCom18b1
	cmp.b	#',',d0
	beq	AssembleCom23		;Next operand
	cmp.b	#'(',d0
	bne.s	AssembleCom18c
	bsr	ReadChar
	and.b	#$5f,d0
	cmp.b	#'P',d0
	beq	AssembleCom18g
	cmp.b	#'A',d0
	bne	AssembleComError
	move.w	#$0020,(a1)		;d(An)
	jsr	_LVOReadNibble(a6)
	move.w	d0,2(a1)
AssembleCom18d:
	bsr	ReadChar
	bmi	AssembleCom11
	cmp.b	#')',d0
	beq	AssembleCom11
	cmp.b	#',',d0
	bne.s	AssembleCom18d
	lsl.w	(a1)		;d(An,Xi),d(PC,Xi)
AssembleCom18e:
	and.w	#$00ff,$4(a1)
	bsr	ReadChar
	and.b	#$5f,d0
	moveq	#$08,d1
	cmp.b	#'A',d0
	beq.s	AssembleCom18f
	cmp.b	#'D',d0
	bne	AssembleComError
	moveq	#$00,d1
AssembleCom18f:
	jsr	_LVOReadNibble(a6)
	add.w	d1,d0
	ror.w	#4,d0
	and.w	#$f000,d0
	or.w	#$0800,d0
	or.w	d0,$4(a1)
	bsr	ReadChar
	bmi	AssembleCom11
	cmp.b	#'.',d0
	bne	AssembleCom11
	bsr	ReadChar
	bmi	AssembleComError
	and.b	#$5f,d0
	cmp.b	#'W',d0
	bne	AssembleCom11
	and.w	#$f7ff,4(a1)
	bra	AssembleCom11
AssembleCom18g:
	move.w	#$0200,(a1)		;d(PC)
	move.l	$98(a6),d0
	sub.l	d0,$2(a1)
	subq.l	#2,$2(a1)
	bra	AssembleCom18d

AssembleCom19:				;Abs dec
	subq.w	#1,d7
	jsr	_LVOReadDecNumber(a6)
	bra	AssembleCom18b

AssembleCom20:				;Abs hex
	jsr	_LVOReadNumber(a6)
	bra	AssembleCom18b

AssembleCom21:				;Imm
	move.w	#$0800,(a1)
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#'$',d0
	beq.s	AssembleCom21b
	cmp.b	#'-',d0
	beq.s	AssembleCom21c
	subq.w	#1,d7
	jsr	_LVOReadDecNumber(a6)
AssembleCom21a:
	move.l	d0,$2(a1)
	subq.w	#1,d7
	bra	AssembleCom11
AssembleCom21b:
	jsr	_LVOReadNumber(a6)
	bra.s	AssembleCom21a
AssembleCom21c:
	bsr	ReadChar
	bmi	AssembleComError
	cmp.b	#'$',d0
	beq.s	AssembleCom21d
	subq.w	#1,d7
	jsr	_LVOReadDecNumber(a6)
	neg.l	d0
	bra.s	AssembleCom21a
AssembleCom21d:
	jsr	_LVOReadNumber(a6)
	neg.l	d0
	bra.s	AssembleCom21a

AssembleCom22:				;RegListMask
	subq.w	#1,d7
	move.w	#$8003,(a1)
	moveq	#$00,d1
AssembleCom22a:
	bsr	ReadChar
	bmi.s	AssembleCom23		;Next operand
	cmp.b	#',',d0
	beq.s	AssembleCom23		;Next operand
	cmp.b	#'-',d0
	beq.s	AssembleCom22c
	cmp.b	#'/',d0
	beq.s	AssembleCom22a
	and.b	#$5f,d0
	moveq	#$00,d2
	cmp.b	#'D',d0
	beq.s	AssembleCom22b
	moveq	#$08,d2
	cmp.b	#'A',d0
	bne.s	AssembleCom22a
AssembleCom22b:
	jsr	_LVOReadNibble(a6)
	add.w	d2,d0
	move.w	d0,d1
	move.w	2(a1),d0
	bset	d1,d0
	move.w	d0,2(a1)
	bra.s	AssembleCom22a
AssembleCom22c:
	bsr	ReadChar
	bmi.s	AssembleComError
	and.b	#$5f,d0
	moveq	#$00,d2
	cmp.b	#'D',d0
	beq.s	AssembleCom22d
	moveq	#$08,d2
	cmp.b	#'A',d0
	bne.s	AssembleCom22c
AssembleCom22d:
	jsr	_LVOReadNibble(a6)
	add.w	d0,d2
	move.w	2(a1),d0
AssembleCom22e:
	addq.w	#1,d1
	bset	d1,d0
	cmp.w	d1,d2
	bne.s	AssembleCom22e
	move.w	d0,2(a1)
	bra.s	AssembleCom22a

AssembleCom23:
	lea	$6(a1),a1
	move.l	a2,a3
	lea	AssembleCom24(pc),a2
	jmp	(a3)

AssembleCom24:
	move.l	$98(a6),a0
	bsr.s	AssembleComFindInstr
	bmi.s	AssembleComError
	clr.w	$5e(a6)			;x cursor
	move.l	$98(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	moveq	#'A',d0
	jsr	_LVOWriteChar(a6)		
	move.l	$9c(a6),d0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
AssembleComExit:
	rts
AssembleComError:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	rts

*****************************************************************************

AssembleComFindInstr:
	move.l	a0,$98(a6)
	lea	AssemblerCodes+$20(pc),a1
AssembleComFindInstr1:
	cmp.l	#AssemblerCodesEnd,a1
	beq	AssembleComFindInstrError
	move.l	$a0(a6),a2
	move.w	(a1)+,d2
	move.w	(a1)+,d1
	move.l	(a1)+,d3
	move.b	(a1)+,d0
	ext.w	d0
	move.l	a1,a4
	add.w	d0,a4
AssembleComFindInstr2:
	move.b	(a2)+,d0
	beq.s	AssembleComFindInstr8
	cmp.b	(a1)+,d0
	beq.s	AssembleComFindInstr2
	move.b	-1(a1),d4
	cmp.b	#'c',d4
	beq.s	AssembleComFindInstr5
AssembleComFindInstr3:
	move.l	a4,a1
	bra.s	AssembleComFindInstr1
AssembleComFindInstr5:
	lea	Assemblerconditions(pc),a3
	moveq	#-1,d4
	move.b	(a2)+,d5
	move.b	(a2)+,d6
	subq.l	#3,a3
AssembleComFindInstr6:
	addq.l	#1,d4
	cmp.b	#$10,d4
	beq.s	AssembleComFindInstr3
	addq.l	#3,a3
	cmp.b	(a3),d0
	bne.s	AssembleComFindInstr6
	cmp.b	1(a3),d5
	bne.s	AssembleComFindInstr6
	tst.b	d5
	beq.s	AssembleComFindInstr7
	tst.b	d6
	bne.s	AssembleComFindInstr6
AssembleComFindInstr7:
	move.w	d4,$b2(a6)
	addq.l	#1,a1
AssembleComFindInstr8:
	cmp.l	a1,a4
	beq.s	AssembleComFindInstr9
	move.b	(a1),d0
	beq.s	AssembleComFindInstr9
	bmi.s	AssembleComFindInstr9
	addq.l	#1,a1
	cmp.b	#'A',d0
	beq.s	AssembleComFindInstr8
	cmp.b	#'I',d0
	beq.s	AssembleComFindInstr8
	cmp.b	#'.',d0
	bne.s	AssembleComFindInstr3	
	move.b	(a1)+,d0
	moveq	#$08,d4
	cmp.b	#'B',d0
	beq.s	AssembleComFindInstr8a
	moveq	#$10,d4
	cmp.b	#'W',d0
	beq.s	AssembleComFindInstr8a
	moveq	#$20,d4
	cmp.b	#'L',d0
	bne.s	AssembleComFindInstr8
AssembleComFindInstr8a:
	cmp.w	$a4(a6),d4
	bne.s	AssembleComFindInstr3
	bra.s	AssembleComFindInstr8

AssembleComFindInstr9:
	move.w	d3,d4
	swap	d3
	move.w	$a6(a6),d5
	cmp.w	#$0800,d5
	bne.s	AssembleComFindInstr9a
	or.w	#$1000,d5
AssembleComFindInstr9a:
	move.w	$ac(a6),d6
	cmp.w	#$8002,d5
	bne.s	AssembleComFindInstr9b
	cmp.w	d3,d5
	bne	AssembleComFindInstr3
AssembleComFindInstr9b:
	cmp.w	#$8002,d6
	bne.s	AssembleComFindInstr9c
	cmp.w	d4,d6
	bne	AssembleComFindInstr3
AssembleComFindInstr9c:
	and.w	d3,d5
	and.w	d4,d6
	moveq	#-1,d7			;- no quickword in d7
	tst.w	d3
	beq.s	AssembleComFindInstr9d
	tst.w	d5
	beq	AssembleComFindInstr3
	tst.w	d4
	beq.s	AssembleComFindInstr9d
	tst.w	d6
	beq	AssembleComFindInstr3
AssembleComFindInstr9d:
	move.w	d5,$a6(a6)
	move.w	d6,$ac(a6)
AssembleComFindInstr10:
	cmp.l	a1,a4
	beq	AssembleComFindInstr38
	move.b	(a1)+,d0
	beq	AssembleComFindInstr38
	cmp.b	#$8c,d0
	beq	AssembleComFindInstr30
	cmp.b	#$8d,d0
	beq	AssembleComFindInstr31
	cmp.b	#$8e,d0
	beq	AssembleComFindInstr32
	cmp.b	#$8f,d0
	beq	AssembleComFindInstr33
	cmp.b	#$90,d0
	beq	AssembleComFindInstr34
	cmp.b	#$9a,d0
	beq	AssembleComFindInstr35
	cmp.b	#$9b,d0
	beq	AssembleComFindInstr37
	tst.w	d2
	bpl.s	AssembleComFindInstr12
AssembleComFindInstr11:
	rol.w	#1,d1
	rol.w	#1,d2
	bmi.s	AssembleComFindInstr11
AssembleComFindInstr12:
	cmp.b	#$80,d0
	beq	AssembleComFindInstr13
	cmp.b	#$81,d0
	beq	AssembleComFindInstr14
	cmp.b	#$82,d0
	beq	AssembleComFindInstr15
	cmp.b	#$83,d0
	beq	AssembleComFindInstr16
	cmp.b	#$84,d0
	beq	AssembleComFindInstr19
	cmp.b	#$85,d0
	beq	AssembleComFindInstr20
	cmp.b	#$86,d0
	beq	AssembleComFindInstr22
	cmp.b	#$87,d0
	beq	AssembleComFindInstr23
	cmp.b	#$88,d0
	beq	AssembleComFindInstr22
	cmp.b	#$89,d0
	beq	AssembleComFindInstr23
	cmp.b	#$94,d0
	beq	AssembleComFindInstr24
	cmp.b	#$95,d0
	beq	AssembleComFindInstr25
	cmp.b	#$96,d0
	beq	AssembleComFindInstr26
	cmp.b	#$99,d0
	beq	AssembleComFindInstr28
	cmp.b	#$9d,d0
	beq	AssembleComFindInstr29
	bra	ComError
	
AssembleComFindInstr13:		;Sz
	rol.w	#2,d1
	rol.w	#2,d2
	move.w	$a4(a6),d0		;Size
	lsr.w	#4,d0
	and.w	#$0003,d0
	or.w	d0,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr14:		;S
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	$a4(a6),d0			;Size
	lsr.w	#5,d0
	and.w	#$0001,d0
	or.w	d0,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr15:		;Inv. S
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	$a4(a6),d0		;Size
	lsr.w	#5,d0
	eor.w	#$0001,d0
	and.w	#$0001,d0
	or.w	d0,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr16:		;Source
	move.w	$a6(a6),d0		;mod
	move.w	$a8(a6),d5		;rrr
	moveq	#-1,d4
AssembleComFindInstr17:
	addq.l	#1,d4
	lsr.w	#1,d0
	bne.s	AssembleComFindInstr17
	cmp.w	#$0006,d4
	bls.s	AssembleComFindInstr18
	move.w	d4,d5
	moveq	#$07,d4
	sub.w	d4,d5
AssembleComFindInstr18:
	rol.w	#3,d1
	rol.w	#3,d2
	and.w	#$0007,d4
	or.w	d4,d1
	rol.w	#3,d1
	rol.w	#3,d2
	and.w	#$0007,d5
	or.w	d5,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr19:		;Destin
	move.w	$ac(a6),d0		;mod
	move.w	$ae(a6),d5		;rrr
	moveq	#-1,d4
	bra.s	AssembleComFindInstr17

AssembleComFindInstr20:		;Tindes
	move.w	$ac(a6),d0		;mod
	move.w	$ae(a6),d4		;rrr
	moveq	#-1,d5
AssembleComFindInstr21:
	addq.l	#1,d5
	lsr.w	#1,d0
	bne.s	AssembleComFindInstr21
	cmp.w	#$0006,d5
	bls.s	AssembleComFindInstr18
	move.w	d5,d4
	moveq	#$07,d5
	sub.w	d5,d4
	bra.s	AssembleComFindInstr18

AssembleComFindInstr22:		;Sar,Sdr
	move.w	$a8(a6),d4
	rol.w	#3,d1
	rol.w	#3,d2
	and.w	#$0007,d4
	or.w	d4,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr23:		;Dar,Ddr
	move.w	$ae(a6),d4
	rol.w	#3,d1
	rol.w	#3,d2
	and.w	#$0007,d4
	or.w	d4,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr24:		;Imm
	move.l	$a8(a6),d4
	rol.w	#3,d1
	rol.w	#3,d2
	and.w	#$0007,d4
	or.w	d4,d1
	move.w	#$1000,$a6(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr25:		;Immediate
	move.l	$a8(a6),d4
	rol.w	#8,d1
	rol.w	#8,d2
	and.w	#$00ff,d4
	or.w	d4,d1
	move.w	#$1000,$a6(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr26:		;Displace
	move.l	$a8(a6),d4
	sub.l	$98(a6),d4
	subq.l	#2,d4
	move.w	d4,d5
	ext.w	d5
	cmp.w	d4,d5
	beq.s	AssembleComFindInstr27
	clr.l	d7
	move.w	d4,d7
	moveq	#$00,d4
AssembleComFindInstr27:
	rol.w	#8,d1
	rol.w	#8,d2
	and.w	#$00ff,d4
	or.w	d4,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr28:		;Vect
	move.l	$a8(a6),d4
	rol.w	#4,d1
	rol.w	#4,d2
	and.w	#$000f,d4
	or.w	d4,d1
	move.w	#$1000,$a6(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr29:		;Cond
	move.w	$b2(a6),d4
	rol.w	#4,d1
	rol.w	#4,d2
	and.w	#$000f,d4
	or.w	d4,d1
	bra	AssembleComFindInstr10

AssembleComFindInstr30:		;Imm Byte
	move.w	#$0008,$a4(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr31:		;Imm Word
	move.w	#$0010,$a4(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr32:		;Displace word
	move.l	$ae(a6),d4
	sub.l	$98(a6),d4
	subq.l	#2,d4
	clr.l	d7
	move.w	d4,d7
	bra	AssembleComFindInstr10

AssembleComFindInstr33:		;Imm Long
	move.w	#$0020,$a4(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr34:		;Imm 5bits
	move.w	#$0005,$a4(a6)
	bra	AssembleComFindInstr10

AssembleComFindInstr35:		;Reglistmask source
	move.w	$a8(a6),d0
	clr.l	d7
	move.w	d0,d7
	cmp.w	#$0010,$ac(a6)
	bne	AssembleComFindInstr10
	move.w	d7,d0
	moveq	#$0f,d4
AssembleComFindInstr36:
	lsr.w	#1,d0
	roxl.w	#1,d7
	dbf	d4,AssembleComFindInstr36
	bra	AssembleComFindInstr10

AssembleComFindInstr37:		;Reglistmask dest
	move.w	$ae(a6),d0
	clr.l	d7
	move.w	d0,d7
	bra	AssembleComFindInstr10

AssembleComFindInstr38:
	move.w	d1,d0
	jsr	_LVOWriteMemWord(a6)
	tst.l	d7
	bmi.s	AssembleComFindInstr39
	move.w	d7,d0
	jsr	_LVOWriteMemWord(a6)
AssembleComFindInstr39:
	move.w	$a6(a6),d0
	cmp.w	#$0020,d0
	beq.s	AssembleComFindInstr42
	cmp.w	#$0040,d0
	beq.s	AssembleComFindInstr42
	cmp.w	#$0080,d0
	beq.s	AssembleComFindInstr43
	cmp.w	#$0100,d0
	beq.s	AssembleComFindInstr44
	cmp.w	#$0200,d0
	beq.s	AssembleComFindInstr42
	cmp.w	#$0400,d0
	beq.s	AssembleComFindInstr42
	cmp.w	#$0800,d0
	beq.s	AssembleComFindInstr45
AssembleComFindInstr40:
	move.w	$ac(a6),d0
	cmp.w	#$0020,d0
	beq	AssembleComFindInstr50
	cmp.w	#$0040,d0
	beq	AssembleComFindInstr50
	cmp.w	#$0080,d0
	beq	AssembleComFindInstr51
	cmp.w	#$0100,d0
	beq	AssembleComFindInstr52
	cmp.w	#$0200,d0
	beq.s	AssembleComFindInstr50
	cmp.w	#$0400,d0
	beq.s	AssembleComFindInstr50
	cmp.w	#$0800,d0
	beq	AssembleComFindInstr53
AssembleComFindInstr41:
	move.l	a0,$9c(a6)
	moveq	#$00,d0
	rts

AssembleComFindInstr42:	;d(An),d(An,Xi),d(PC),d(PC,Xi)
	move.w	$aa(a6),d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	AssembleComFindInstr40

AssembleComFindInstr43:			;Abs.W
	move.l	$a8(a6),d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	AssembleComFindInstr40

AssembleComFindInstr44:			;Abs.L
	move.l	$a8(a6),d0
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	AssembleComFindInstr40

AssembleComFindInstr45:			;Immediate
	move.l	$a8(a6),d0
	move.w	$a4(a6),d1
	cmp.w	#$0005,d1
	beq.s	AssembleComFindInstr47
	cmp.w	#$0008,d1
	beq.s	AssembleComFindInstr48
	cmp.w	#$0010,d1
	beq.s	AssembleComFindInstr49
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	swap	d0
AssembleComFindInstr46:		
	jsr	_LVOWriteMemWord(a6)
	bra	AssembleComFindInstr40
AssembleComFindInstr47:
	and.w	#$001f,d0
AssembleComFindInstr48:
	and.w	#$00ff,d0
AssembleComFindInstr49:
	bra.s	AssembleComFindInstr46

AssembleComFindInstr50:	;d(An),d(An,Xi),d(PC),d(PC,Xi)
	move.w	$b0(a6),d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	AssembleComFindInstr41

AssembleComFindInstr51:			;Abs.W
	move.l	$ae(a6),d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	AssembleComFindInstr41

AssembleComFindInstr52:			;Abs.L
	move.l	$ae(a6),d0
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	bra	AssembleComFindInstr41

AssembleComFindInstr53:			;Immediate
	move.l	$ae(a6),d0
	move.w	$a4(a6),d1
	cmp.w	#$0005,d1
	beq.s	AssembleComFindInstr55
	cmp.w	#$0008,d1
	beq.s	AssembleComFindInstr56
	cmp.w	#$0010,d1
	beq.s	AssembleComFindInstr57
	swap	d0
	jsr	_LVOWriteMemWord(a6)
	swap	d0
AssembleComFindInstr54:		
	jsr	_LVOWriteMemWord(a6)
	bra	AssembleComFindInstr41
AssembleComFindInstr55:
	and.w	#$001f,d0
AssembleComFindInstr56:
	and.w	#$00ff,d0
AssembleComFindInstr57:
	bra.s	AssembleComFindInstr54

AssembleComFindInstrError:
	moveq	#-1,d0
	rts

*****************************************************************************

BreakpointCom:
	rts
CompareCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	CompareComExit1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
CompareCom1:
	moveq	#$7f,d2
CompareCom2:
	jsr	_LVOReadMemByte(a6)
	move.b	d0,d1
	exg	a0,a2
	jsr	_LVOReadMemByte(a6)
	exg	a0,a2
	cmp.b	d0,d1
	beq.s	CompareCom3
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	bsr	WaitIfCtrl
	cmp.w	#$0047,$5e(a6)
	bls.s	CompareCom3
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
CompareCom3:
	cmpa.l	a0,a1
	bls.s	CompareComExit
	dbf	d2,CompareCom2
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	CompareCom1
	move.l	a0,d0
	bsr	UserBreak
CompareComExit:
	tst.w	$5e(a6)
	beq.s	CompareComExit1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
CompareComExit1:
	rts

DisassembleCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	DisassembleCom1b
	move.l	$90(a6),a0
DisassembleCom1b:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
DisassembleCom1:
	movem.l	a0/a1,-(a7)
	bsr.s	DisassembleComFindInstr
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	movem.l	(a7)+,a0/a1
	jsr	_LVOClearLine(a6)
	moveq	#',',d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
DisassembleCom2:
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	jsr	_LVOReadMemWord(a6)
	jsr	_LVOWriteWord(a6)
	cmp.l	$9c(a6),a0
	bne.s	DisassembleCom2
	move.w	#$0023,$5e(a6)			;Cursor x
	move.l	a0,-(a7)
	lea	$b4(a6),a0
	jsr	_LVOWriteString(a6)
	move.l	(a7)+,a0
	bsr	WaitIfCtrl
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	cmpa.l	a0,a1
	bls.s	DisassembleComExit
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	DisassembleCom1
DisassembleComExit:
	rts

*****************************************************************************
DisassembleComFindInstr:
	move.l	a0,$98(a6)
	lea	AssemblerCodes(pc),a1
	jsr	_LVOReadMemWord(a6)
	move.w	d0,d1
	rol.w	#5,d1
	and.w	#$001e,d1
	move.w	0(a1,d1.w),d1
	lea	0(a1,d1.w),a1
	bra.s	DisassembleComFindInstr1a
DisassembleComFindInstrError:
	move.l	a2,a1
DisassembleComFindInstr1:
	move.l	$98(a6),a0
	jsr	_LVOReadMemWord(a6)
DisassembleComFindInstr1a:
	move.w	#$ffff,$a6(a6)		;Enable all EA modes
	move.w	#$ffff,$ac(a6)
DisassembleComFindInstr2:
	move.w	d0,d1
	and.w	(a1),d1
	cmp.w	2(a1),d1
	beq.s	DisassembleComFindInstr4
	addq.l	#8,a1
	move.b	(a1)+,d1
	ext.w	d1
	add.w	d1,a1
	bra.s	DisassembleComFindInstr2
DisassembleComFindInstr4:
	move.w	d0,d1
	move.w	(a1)+,d2
	addq.l	#2,a1
	move.l	(a1)+,d3
	move.b	(a1)+,d0
	ext.w	d0
	move.l	a1,a2
	add.w	d0,a2
	move.l	a1,$a0(a6)		;Name of instr
DisassembleComFindInstr5:
	move.l	a1,$b4(a6)
	cmp.l	a1,a2
	beq.s	DisassembleComFindInstr7
	tst.b	(a1)+
	bmi.s	DisassembleComFindInstr6
	bne.s	DisassembleComFindInstr5
DisassembleComFindInstr6:
	subq.l	#1,a1
DisassembleComFindInstr7:
	cmp.l	a1,a2
	beq	DisassembleComFindInstr40
	move.b	(a1)+,d0
	beq	DisassembleComFindInstr40
	cmp.b	#$8c,d0
	beq	DisassembleComFindInstr29
	cmp.b	#$8d,d0
	beq	DisassembleComFindInstr30
	cmp.b	#$8e,d0
	beq	DisassembleComFindInstr31
	cmp.b	#$8f,d0
	beq	DisassembleComFindInstr32
	cmp.b	#$90,d0
	beq	DisassembleComFindInstr33
	cmp.b	#$9a,d0
	beq	DisassembleComFindInstr34
	cmp.b	#$9b,d0
	beq	DisassembleComFindInstr35
	tst.w	d2
	bpl.s	DisassembleComFindInstr8a
DisassembleComFindInstr8:
	rol.w	#1,d1
	rol.w	#1,d2
	bmi.s	DisassembleComFindInstr8
DisassembleComFindInstr8a:
	cmp.b	#$80,d0
	beq	DisassembleComFindInstr9
	cmp.b	#$81,d0
	beq	DisassembleComFindInstr10
	cmp.b	#$82,d0
	beq	DisassembleComFindInstr11
	cmp.b	#$83,d0
	beq	DisassembleComFindInstr12
	cmp.b	#$84,d0
	beq	DisassembleComFindInstr14
	cmp.b	#$85,d0
	beq	DisassembleComFindInstr16
	cmp.b	#$86,d0
	beq	DisassembleComFindInstr18
	cmp.b	#$87,d0
	beq	DisassembleComFindInstr19
	cmp.b	#$88,d0
	beq	DisassembleComFindInstr18
	cmp.b	#$89,d0
	beq	DisassembleComFindInstr19
	cmp.b	#$8a,d0
	beq	DisassembleComFindInstr20
	cmp.b	#$8b,d0
	beq	DisassembleComFindInstr21
	cmp.b	#$94,d0
	beq	DisassembleComFindInstr22
	cmp.b	#$95,d0
	beq	DisassembleComFindInstr24
	cmp.b	#$96,d0
	beq	DisassembleComFindInstr25
	cmp.b	#$99,d0
	beq	DisassembleComFindInstr27
	cmp.b	#$9d,d0
	beq	DisassembleComFindInstr28
	bra	ComError
	
DisassembleComFindInstr9:		;Sz
	rol.w	#2,d1
	rol.w	#2,d2
	move.w	d1,d4
	and.w	#$0003,d4
	cmp.w	#$0003,d4
	beq	DisassembleComFindInstrError
	moveq	#$08,d0
	lsl.w	d4,d0
	move.w	d0,$a4(a6)		;SIZE OR COND
	bra	DisassembleComFindInstr7

DisassembleComFindInstr10:		;S
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	d1,d4
	and.w	#$0001,d4
	moveq	#$10,d0
	lsl.w	d4,d0
	move.w	d0,$a4(a6)		;SIZE
	bra	DisassembleComFindInstr7

DisassembleComFindInstr11:		;Inv. S
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	d1,d4
	and.w	#$0001,d4
	moveq	#$20,d0
	lsr.w	d4,d0
	move.w	d0,$a4(a6)		;SIZE
	bra	DisassembleComFindInstr7
DisassembleComFindInstr12:		;Source
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d5
	and.w	#$0007,d5
	cmp.w	#$0007,d4
	bne.s	DisassembleComFindInstr13
	add.w	d5,d4
DisassembleComFindInstr13:
	move.w	d5,$a8(a6)		;Register nr
	move.w	#$0001,d5
	lsl.w	d4,d5
	move.w	d5,$a6(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr14:		;Destin
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d5
	and.w	#$0007,d5
	cmp.w	#$0007,d4
	bne.s	DisassembleComFindInstr15
	add.w	d5,d4
DisassembleComFindInstr15:
	move.w	d5,$ae(a6)		;Register nr
	move.w	#$0001,d5
	lsl.w	d4,d5
	move.w	d5,$ac(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr16:		;Tindes
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d5
	and.w	#$0007,d5
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	cmp.w	#$0007,d4
	bne.s	DisassembleComFindInstr17
	add.w	d5,d4
DisassembleComFindInstr17:
	move.w	d5,$ae(a6)		;Register nr
	move.w	#$0001,d5
	lsl.w	d4,d5
	move.w	d5,$ac(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr18:		;Sar,Sdr
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	move.w	d4,$a8(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr19:		;Dar,Ddr
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	move.w	d4,$ae(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr20:		;Sdar
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	d1,d4
	and.w	#$0001,d4
	move.w	#$0002,d5
	lsr.w	d4,d5
	move.w	d5,$a6(a6)
	bra.s	DisassembleComFindInstr18

DisassembleComFindInstr21:		;Ddar
	rol.w	#1,d1
	rol.w	#1,d2
	move.w	d1,d4
	and.w	#$0001,d4
	move.w	#$0002,d5
	lsr.w	d4,d5
	move.w	d5,$ac(a6)
	bra.s	DisassembleComFindInstr19

DisassembleComFindInstr22:		;Imm
	rol.w	#3,d1
	rol.w	#3,d2
	move.w	d1,d4
	and.w	#$0007,d4
	bne.s	DisassembleComFindInstr23
	move.w	#$0008,d4
DisassembleComFindInstr23:
	ext.l	d4
	move.l	d4,$a8(a6)
	move.w	#$0004,$b2(a6)		;Size
	bra	DisassembleComFindInstr7

DisassembleComFindInstr24:		;Immediate
	rol.w	#8,d1
	rol.w	#8,d2
	move.w	d1,d4
	and.w	#$00ff,d4
	ext.w	d4
	ext.l	d4
	move.l	d4,$a8(a6)
	move.w	#$0020,$b2(a6)		;Size
	bra	DisassembleComFindInstr7

DisassembleComFindInstr25:		;Displace
	rol.w	#8,d1
	rol.w	#8,d2
	move.w	d1,d4
	and.w	#$00ff,d4
	ext.w	d4
	bne.s	DisassembleComFindInstr26
	jsr	_LVOReadMemWord(a6)
	move.w	d0,d4
DisassembleComFindInstr26:
	ext.l	d4
	move.l	d4,$a8(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr27:		;Vect
	rol.w	#4,d1
	rol.w	#4,d2
	move.w	d1,d4
	and.w	#$000f,d4
	ext.l	d4
	move.l	d4,$a8(a6)
	move.w	#$0004,$b2(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr28:		;Cond
	rol.w	#4,d1
	rol.w	#4,d2
	move.w	d1,d4
	and.w	#$000f,d4
	move.w	d4,$b2(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr29:		;Imm Byte
	move.w	#$0008,$a4(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr30:		;Imm Word
	move.w	#$0010,$a4(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr31:		;Displace word
	jsr	_LVOReadMemWord(a6)
	ext.l	d0
	move.l	d0,$ae(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr32:		;Imm Long
	move.w	#$0020,$a4(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr33:		;Imm 5bits
	move.w	#$0005,$a4(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr34:		;Reglistmask source
	jsr	_LVOReadMemWord(a6)
	move.w	d0,$a8(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr35:		;Reglistmask dest
	jsr	_LVOReadMemWord(a6)
	move.w	d0,$ae(a6)
	bra	DisassembleComFindInstr7

DisassembleComFindInstr40:
	and.w	d3,$ac(a6)
	swap	d3
	and.w	d3,$a6(a6)
	tst.w	d3
	beq.s	DisassembleComFindInstr41
	tst.w	$a6(a6)
	beq	DisassembleComFindInstrError
DisassembleComFindInstr41:
	swap	d3
	tst.w	d3
	beq.s	DisassembleComFindInstr42
	tst.w	$ac(a6)
	beq	DisassembleComFindInstrError
DisassembleComFindInstr42:		;Read Source Operand
	move.w	$a6(a6),d0
	cmp.w	#$0020,d0
	beq.s	DisassembleComFindInstr45
	cmp.w	#$0040,d0
	beq.s	DisassembleComFindInstr45
	cmp.w	#$0080,d0
	beq.s	DisassembleComFindInstr46
	cmp.w	#$0100,d0
	beq.s	DisassembleComFindInstr47
	cmp.w	#$0200,d0
	beq.s	DisassembleComFindInstr45
	cmp.w	#$0400,d0
	beq.s	DisassembleComFindInstr45
	cmp.w	#$0800,d0
	beq.s	DisassembleComFindInstr48
DisassembleComFindInstr43:
	move.w	$ac(a6),d0
	cmp.w	#$0020,d0
	beq	DisassembleComFindInstr53
	cmp.w	#$0040,d0
	beq	DisassembleComFindInstr53
	cmp.w	#$0080,d0
	beq	DisassembleComFindInstr54
	cmp.w	#$0100,d0
	beq	DisassembleComFindInstr55
	cmp.w	#$0200,d0
	beq.s	DisassembleComFindInstr53
	cmp.w	#$0400,d0
	beq.s	DisassembleComFindInstr53
	cmp.w	#$0800,d0
	beq	DisassembleComFindInstr56
DisassembleComFindInstr44:
	move.l	a0,$9c(a6)
	rts

DisassembleComFindInstr45:	;d(An),d(An,Xi),d(PC),d(PC,Xi)
	jsr	_LVOReadMemWord(a6)
	move.w	d0,$aa(a6)
	bra.s	DisassembleComFindInstr43

DisassembleComFindInstr46:			;Abs.W
	move.l	a0,$b8(a6)	;Address of adress
	jsr	_LVOReadMemWord(a6)
	ext.l	d0
	move.l	d0,$a8(a6)
	bra.s	DisassembleComFindInstr43

DisassembleComFindInstr47:			;Abs.L
	move.l	a0,$b8(a6)	;Address of adress
	jsr	_LVOReadMemWord(a6)
	swap	d0
	jsr	_LVOReadMemWord(a6)
	move.l	d0,$a8(a6)
	bra.s	DisassembleComFindInstr43

DisassembleComFindInstr48:			;Immediate
	jsr	_LVOReadMemWord(a6)
	move.w	$a4(a6),d1
	cmp.w	#$0005,d1
	beq.s	DisassembleComFindInstr50
	cmp.w	#$0008,d1
	beq.s	DisassembleComFindInstr51
	cmp.w	#$0010,d1
	beq.s	DisassembleComFindInstr52
	swap	d0
	jsr	_LVOReadMemWord(a6)
DisassembleComFindInstr49:		
	move.l	d0,$a8(a6)
	bra	DisassembleComFindInstr43
DisassembleComFindInstr50:
	and.w	#$001f,d0
DisassembleComFindInstr51:
	and.w	#$00ff,d0
DisassembleComFindInstr52:
	ext.l	d0
	bra.s	DisassembleComFindInstr49

DisassembleComFindInstr53:	;d(An),d(An,Xi),d(PC),d(PC,Xi)
	jsr	_LVOReadMemWord(a6)
	move.w	d0,$b0(a6)
	bra.s	DisassembleComFindInstr44

DisassembleComFindInstr54:			;Abs.W
	move.l	a0,$bc(a6)	;Address of adress
	jsr	_LVOReadMemWord(a6)
	ext.l	d0
	move.l	d0,$ae(a6)
	bra	DisassembleComFindInstr44

DisassembleComFindInstr55:			;Abs.L
	move.l	a0,$bc(a6)	;Address of adress
	jsr	_LVOReadMemWord(a6)
	swap	d0
	jsr	_LVOReadMemWord(a6)
	move.l	d0,$ae(a6)
	bra	DisassembleComFindInstr44

DisassembleComFindInstr56:			;Immediate
	jsr	_LVOReadMemWord(a6)
	move.w	$a4(a6),d1
	cmp.w	#$0005,d1
	beq.s	DisassembleComFindInstr58	
	cmp.w	#$0008,d1
	beq.s	DisassembleComFindInstr59
	cmp.w	#$0010,d1
	beq.s	DisassembleComFindInstr60
	swap	d0
	jsr	_LVOReadMemWord(a6)
DisassembleComFindInstr57:		
	move.l	d0,$ae(a6)
	bra	DisassembleComFindInstr44
DisassembleComFindInstr58:
	and.w	#$001f,d0
DisassembleComFindInstr59:
	and.w	#$00ff,d0
DisassembleComFindInstr60:
	ext.l	d0
	bra.s	DisassembleComFindInstr57

*****************************************************************************

*****************************************************************************

DisassembleComMakeString:
	lea	8(a0),a2
	move.l	$a0(a6),a1
	move.l	$b4(a6),d2
DisassembleComMakeString1:
	cmp.l	a1,d2
	beq.s	DisassembleComMakeString5
	move.b	(a1)+,d0
	beq.s	DisassembleComMakeString5
	cmp.b	#'s',d0
	beq.s	DisassembleComMakeString2
	cmp.b	#'c',d0
	beq.s	DisassembleComMakeString4
	cmp.b	#$40,d0
	bls.s	DisassembleComMakeString1a
	and.b	#$5f,d0
DisassembleComMakeString1a:
	move.b	d0,(a0)+
	bra.s	DisassembleComMakeString1
DisassembleComMakeString2:			;.s
	move.w	$a4(a6),d0
	moveq	#'L',d1
	cmp.w	#$0020,d0
	beq.s	DisassembleComMakeString3
	moveq	#'W',d1
	cmp.w	#$0010,d0
	beq.s	DisassembleComMakeString3
	moveq	#'B',d1
DisassembleComMakeString3:
	move.b	d1,(a0)+
	bra.s	DisassembleComMakeString5
DisassembleComMakeString4:		;Cond codes
	lea	Assemblerconditions(pc),a1
	move.w	$b2(a6),d0
	and.w	#$000f,d0
	move.w	d0,d1
	add.w	d0,d0
	add.w	d1,d0
	lea	0(a1,d0.w),a1
	bra.s	DisassembleComMakeString1

DisassembleComMakeString5:
	move.b	#$20,(a0)+
	cmp.l	a0,a2
	bne.s	DisassembleComMakeString5
	move.w	$a6(a6),d0
	move.l	$a8(a6),d1
	bsr.s	DisassembleComMakeString6
	move.w	$ac(a6),d0
	beq	DisassembleComMakeString7
	move.b	#',',(a0)+
	move.l	$ae(a6),d1
DisassembleComMakeString6:
	cmp.w	#$0001,d0
	beq	DisassembleComMakeString8
	cmp.w	#$0002,d0
	beq	DisassembleComMakeString9
	cmp.w	#$0004,d0
	beq	DisassembleComMakeString10
	cmp.w	#$0008,d0
	beq	DisassembleComMakeString11
	cmp.w	#$0010,d0
	beq	DisassembleComMakeString12
	cmp.w	#$0020,d0
	beq	DisassembleComMakeString13
	cmp.w	#$0040,d0
	beq	DisassembleComMakeString14
	cmp.w	#$0080,d0
	beq	DisassembleComMakeString17
	cmp.w	#$0100,d0
	beq	DisassembleComMakeString18
	cmp.w	#$0200,d0
	beq	DisassembleComMakeString19
	cmp.w	#$0400,d0
	beq	DisassembleComMakeString20
	cmp.w	#$0800,d0
	beq	DisassembleComMakeString23
	cmp.w	#$1000,d0
	beq	DisassembleComMakeString26
	cmp.w	#$2000,d0
	beq	DisassembleComMakeString28
	cmp.w	#$4000,d0
	beq	DisassembleComMakeString29
	cmp.w	#$8000,d0
	beq	DisassembleComMakeString30
	cmp.w	#$8002,d0
	beq	DisassembleComMakeString31
	cmp.w	#$8003,d0
	beq	DisassembleComMakeString32
DisassembleComMakeString7:
	clr.b	(a0)
	rts
DisassembleComMakeString8:		;Dn
	move.b	#'D',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString7

DisassembleComMakeString9:		;An
	move.b	#'A',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString7
	
DisassembleComMakeString10:		;(An)
	move.b	#'(',(a0)+
	move.b	#'A',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	move.b	#')',(a0)+
	bra.s	DisassembleComMakeString7

DisassembleComMakeString11:		;(An)+
	move.b	#'(',(a0)+
	move.b	#'A',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	move.b	#')',(a0)+
	move.b	#'+',(a0)+
	bra.s	DisassembleComMakeString7

DisassembleComMakeString12:		;-(An)
	move.b	#'-',(a0)+
	move.b	#'(',(a0)+
	move.b	#'A',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	move.b	#')',(a0)+
	bra.s	DisassembleComMakeString7

DisassembleComMakeString13:		;d(An)
	move.b	#'$',(a0)+
	move.w	d1,d0
	bsr	DisassembleComMakeStringWord
	move.b	#'(',(a0)+
	move.b	#'A',(a0)+
	swap	d1
	move.w	d1,d0
	bsr	DisassembleComMakeStringNib
	move.b	#')',(a0)+
	bra	DisassembleComMakeString7
	
DisassembleComMakeString14:		;d(An,Xi)
	move.b	#'$',(a0)+
	move.w	d1,d0
	bsr	DisassembleComMakeStringByte
	move.b	#'(',(a0)+
	move.b	#'A',(a0)+
	move.l	d1,d0
	swap	d0
	bsr	DisassembleComMakeStringNib
	move.b	#',',(a0)+
	moveq	#'A',d0
	tst.w	d1
	bmi.s	DisassembleComMakeString15
	moveq	#'D',d0
DisassembleComMakeString15:
	move.b	d0,(a0)+
	rol.w	#4,d1
	move.w	d1,d0
	and.w	#$0007,d0
	bsr	DisassembleComMakeStringNib
	move.b	#'.',(a0)+
	moveq	#'L',d0
	tst.w	d1
	bmi.s	DisassembleComMakeString16
	moveq	#'W',d0
DisassembleComMakeString16:
	move.b	d0,(a0)+
	move.b	#')',(a0)+
	bra	DisassembleComMakeString7
	
DisassembleComMakeString17:			;Abs.W
	move.b	#'$',(a0)+
	move.l	d1,d0
	bsr	DisassembleComMakeStringLong
	move.b	#'.',(a0)+
	move.b	#'W',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString18:			;Abs.L
	move.b	#'$',(a0)+
	move.l	d1,d0
	bsr	DisassembleComMakeStringLong
	bra	DisassembleComMakeString7

DisassembleComMakeString19:			;d(PC)
	move.b	#'$',(a0)+
	ext.l	d1
	add.l	$98(a6),d1
	addq.l	#2,d1
	move.l	d1,d0
	bsr	DisassembleComMakeStringLong
	move.b	#'(',(a0)+
	move.b	#'P',(a0)+
	move.b	#'C',(a0)+
	move.b	#')',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString20:			;d(PC,Xi)
	move.b	#'$',(a0)+
	move.l	d1,d0
	ext.w	d0
	ext.l	d0
	add.l	$98(a6),d0
	addq.l	#2,d0
	bsr	DisassembleComMakeStringLong
	move.b	#'(',(a0)+
	move.b	#'P',(a0)+
	move.b	#'C',(a0)+
	move.b	#',',(a0)+
	moveq	#'A',d0
	tst.w	d1
	bmi.s	DisassembleComMakeString21
	moveq	#'D',d0
DisassembleComMakeString21:
	move.b	d0,(a0)+
	rol.w	#4,d1
	move.w	d1,d0
	and.w	#$0007,d0
	bsr	DisassembleComMakeStringNib
	move.b	#'.',(a0)+
	moveq	#'L',d0
	tst.w	d1
	bmi.s	DisassembleComMakeString22
	moveq	#'W',d0
DisassembleComMakeString22:
	move.b	d0,(a0)+
	move.b	#')',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString23:			;Immediate
	move.b	#'#',(a0)+
	move.b	#'$',(a0)+
	move.w	$a4(a6),d0
	cmp.w	#$0005,d0
	beq.s	DisassembleComMakeString24
	cmp.w	#$0008,d0
	beq.s	DisassembleComMakeString24
	cmp.w	#$0010,d0
	beq.s	DisassembleComMakeString25
	move.l	d1,d0
	bsr	DisassembleComMakeStringLong
	bra	DisassembleComMakeString7
DisassembleComMakeString24:
	move.b	d1,d0
	bsr	DisassembleComMakeStringByte
	bra	DisassembleComMakeString7
DisassembleComMakeString25:
	move.w	d1,d0
	bsr	DisassembleComMakeStringWord
	bra	DisassembleComMakeString7

DisassembleComMakeString26:			;Quick
	move.b	#'#',(a0)+
	move.b	#'$',(a0)+
	move.w	$b2(a6),d0
	cmp.w	#$0004,d0
	beq.s	DisassembleComMakeString27
	move.l	d1,d0
	bsr	DisassembleComMakeStringLong
	bra	DisassembleComMakeString7
DisassembleComMakeString27:
	move.b	d1,d0
	bsr	DisassembleComMakeStringNib
	bra	DisassembleComMakeString7

DisassembleComMakeString28:			;CCR
	move.b	#'C',(a0)+
	move.b	#'C',(a0)+
	move.b	#'R',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString29:			;SR
	move.b	#'S',(a0)+
	move.b	#'R',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString30:			;PC
	move.b	#'$',(a0)+
	move.l	d1,d0
	add.l	$98(a6),d0
	addq.l	#2,d0
	bsr	DisassembleComMakeStringLong
	bra	DisassembleComMakeString7

DisassembleComMakeString31:			;USP
	move.b	#'U',(a0)+
	move.b	#'S',(a0)+
	move.b	#'P',(a0)+
	bra	DisassembleComMakeString7

DisassembleComMakeString32:			;All rea
	moveq	#$00,d3
	swap	d1
	cmp.w	#$0010,$ac(a6)			;Dest = -(An)
	bne.s	DisassembleComMakeString34
	moveq	#$0f,d0
DisassembleComMakeString33:
	lsr.w	#1,d1
	roxl.w	#1,d2
	dbf	d0,DisassembleComMakeString33
	move.w	d2,d1
DisassembleComMakeString34:
	move.b	#$ff,d2
DisassembleComMakeString35:
	moveq	#$02,d4
DisassembleComMakeString36:
	cmp.b	#$07,d2
	beq.s	DisassembleComMakeString38
	addq.b	#1,d2
	ror.w	#1,d1
	bpl.s	DisassembleComMakeString35
	tst.b	d4
	bne.s	DisassembleComMakeString37
	subq.l	#3,a0
	move.b	#'-',(a0)+
	move.b	#'D',(a0)+
	move.b	d2,d0
	bsr.s	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString36
DisassembleComMakeString37:
	subq.b	#1,d4
	tst.b	d3
	beq.s	DisassembleComMakeString37a
	move.b	#'/',(a0)+
DisassembleComMakeString37a:
	addq.b	#1,d3
	move.b	#'D',(a0)+
	move.b	d2,d0
	bsr.s	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString36
DisassembleComMakeString38:
	move.b	#$ff,d2
DisassembleComMakeString39:
	moveq	#$02,d4
DisassembleComMakeString40:		
	cmp.b	#$07,d2
	beq	DisassembleComMakeString7
	addq.b	#1,d2
	ror.w	#1,d1
	bpl.s	DisassembleComMakeString39
	tst.b	d4
	bne.s	DisassembleComMakeString41
	subq.l	#3,a0
	move.b	#'-',(a0)+
	move.b	#'A',(a0)+
	move.b	d2,d0
	bsr.s	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString40
DisassembleComMakeString41:
	subq.b	#1,d4
	tst.b	d3
	beq.s	DisassembleComMakeString41a
	move.b	#'/',(a0)+
DisassembleComMakeString41a:
	addq.b	#1,d3
	move.b	#'A',(a0)+
	move.b	d2,d0
	bsr.s	DisassembleComMakeStringNib
	bra.s	DisassembleComMakeString40

DisassembleComMakeStringNib:
	move.l	d1,-(a7)
	move.b	d0,d1
	and.b	#$000f,d1
	cmp.b	#$000a,d1
	bcs.s	DisassembleComMakeStringNib1
	addq.b	#7,d1
DisassembleComMakeStringNib1:
	add.b	#$30,d1
	move.b	d1,(a0)+
	move.l	(a7)+,d1
	rts

DisassembleComMakeStringByte:
	move.l	d1,-(a7)
	move.b	d0,d1
	lsr.b	#4,d0
	bsr.s	DisassembleComMakeStringNib
	move.b	d1,d0
	bsr.s	DisassembleComMakeStringNib
	move.l	(a7)+,d1
	rts

DisassembleComMakeStringWord:
	move.l	d1,-(a7)
	move.w	d0,d1
	lsr.w	#8,d0
	bsr.s	DisassembleComMakeStringByte
	move.w	d1,d0
	bsr.s	DisassembleComMakeStringByte
	move.l	(a7)+,d1
	rts

DisassembleComMakeStringLong:
	move.l	d1,-(a7)
	move.l	d0,d1
	swap	d0
	bsr.s	DisassembleComMakeStringWord
	move.l	d1,d0
	bsr.s	DisassembleComMakeStringWord
	move.l	(a7)+,d1
	rts

*****************************************************************************

DisassembleWriteCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	move.l	a0,$98(a6)
	move.l	a0,$9c(a6)
	cmp.w	#$000a,$5e(a6)
	ble.s	DisassembleWriteCom4
	cmp.w	#$0023,$5e(a6)
	beq.s	DisassembleWriteCom4
	cmp.w	#$0023,$5e(a6)
	bhi.s	DisassembleWriteCom3
DisassembleWriteCom1:
	jsr	_LVOReadByte(a6)
	bmi.s	DisassembleWriteCom2
	lsl.w	#8,d0
	move.l	d0,d1
	jsr	_LVOReadByte(a6)
	bmi.s	DisassembleWriteCom2
	or.w	d1,d0
	jsr	_LVOWriteMemWord(a6)
	bra.s	DisassembleWriteCom1
DisassembleWriteCom2:
	clr.w	$5e(a6)
	move.l	$98(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	move.l	$9c(a6),a0
	move.l	a0,a1
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)
	move.w	#$000a,$5e(a6)
	rts
DisassembleWriteCom3:
	move.w	#$0022,d7
	bsr	AssembleComA
	clr.w	$5e(a6)
	move.l	$9c(a6),a0
	bsr	DisassembleCom1
	subq.w	#1,$5c(a6)
	move.w	#$0023,$5e(a6)
	rts
DisassembleWriteCom4:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	rts

ExchangeCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	ExchangeComExit
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
ExchangeCom1:
	moveq	#$7f,d2
ExchangeCom2:
	jsr	_LVOReadMemByte(a6)
	move.b	d0,d1
	exg	a0,a2
	jsr	_LVOReadMemByte(a6)
	exg	d0,d1
	subq.l	#1,a0
	subq.l	#1,a2
	jsr	_LVOWriteMemByte(a6)
	exg	a0,a2
	move.b	d1,d0
	jsr	_LVOWriteMemByte(a6)
	cmpa.l	a0,a1
	bls.s	ExchangeComExit
	dbf	d2,ExchangeCom2
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	ExchangeCom1
	move.l	a0,d0
	bsr	UserBreak
ExchangeComExit:
	rts

FillCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	cmp.w	#$004f,d7
	bhi.s	FillComExit
	move.l	d7,d6
	move.l	a0,-(a7)
	move.l	$76(a6),a0
	jsr	_LVOReadString(a6)
	move.l	(a7)+,a0
	move.l	d0,d1
	bpl.s	FillCom2
	move.l	$76(a6),a2
	moveq	#$00,d1
	move.l	d6,d7
FillCom1:
	jsr	_LVOReadByte(a6)
	tst.l	d0
	bmi.s	FillCom2
	move.b	d0,(a2)+
	addq.w	#1,d1
	bra.s	FillCom1
FillCom2:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	subq.w	#1,d1
	bmi.s	FillComExit
FillCom3:
	moveq	#$7f,d2
FillCom4:
	move.w	d1,d3
	move.l	$76(a6),a2
FillCom5:
	move.b	(a2)+,d0
	jsr	_LVOWriteMemByte(a6)
	cmpa.l	a0,a1
	bls.s	FillComExit
	dbf	d3,FillCom5
	dbf	d2,FillCom4
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	FillCom3
	move.l	a0,d0
	bsr	UserBreak
FillComExit:
	rts

GoCom:
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	GoCom1
	move.l	d0,$90(a6)
GoCom1:	
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	move.w	#$2700,sr
	bsr	MakePrefsCheck
	jsr	_LVOExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$8a(a6),a7
	move.l	$90(a6),-(a7)
	move.w	$8e(a6),-(a7)
	move.l	$58(a6),a0
	move.l	a0,USP
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

HuntCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	cmp.w	#$004f,d7
	bhi	HuntComExit1
	move.l	d7,d6
	move.l	$76(a6),a2
	lea	$50(a2),a3
	move.l	a0,-(a7)
	move.l	a2,a0
	jsr	_LVOReadString(a6)
	move.l	(a7)+,a0
	move.l	d0,d1
	beq	HuntComExit1
	bpl.s	HuntCom3
	moveq	#$00,d1
	move.l	d6,d7
HuntCom1:
	jsr	_LVOReadByte(a6)
	tst.l	d0
	bmi.s	HuntCom2
	move.b	d0,(a2)+
	clr.b	(a3)+
	addq.w	#1,d1
	bra.s	HuntCom1
HuntCom2:
	subq.w	#1,d7
	bsr	ReadChar
	cmp.b	#$3f,d0
	bne.s	HuntCom4
	clr.b	(a2)+
	move.b	d0,(a3)+
	addq.w	#1,d1
	bra.s	HuntCom1
HuntCom3:
	clr.b	(a3)+
	subq.b	#1,d0
	bne.s	HuntCom3
HuntCom4:
	subq.w	#1,d1
	bmi.s	HuntComExit1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
HuntCom5:
	moveq	#$7f,d2
HuntCom6:
	move.w	d1,d3
	move.l	$76(a6),a2
	lea	$50(a2),a3
	move.l	a0,a4
HuntCom7:
	jsr	_LVOReadMemByte(a6)
	move.b	(a2)+,d4
	tst.b	(a3)+
	bne.s	HuntCom8
	cmp.b	d4,d0
	bne.s	HuntCom9
HuntCom8:
	cmpa.l	a0,a1
	bls.s	HuntComExit
	dbf	d3,HuntCom7
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	a4,d0
	jsr	_LVOWriteLong(a6)
	bsr	WaitIfCtrl
	cmp.w	#$0047,$5e(a6)
	bls	HuntCom9
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
HuntCom9:
	move.l	a4,a0
	addq.l	#1,a0
	cmpa.l	a0,a1
	bls.s	HuntComExit
	dbf	d2,HuntCom6
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	HuntCom5
	move.l	a0,d0
	bsr	UserBreak
HuntComExit:
	tst.w	$5e(a6)
	beq.s	HuntComExit1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
HuntComExit1:
	rts

InterpretCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	InterpretCom0
	move.l	$90(a6),a0
InterpretCom0:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
InterpretCom1:
	jsr	_LVOClearLine(a6)
	moveq	#$27,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	addq.w	#1,$5e(a6)	;Space
	moveq	#$3f,d1
InterpretCom2:
	jsr	_LVOReadMemByte(a6)
	jsr	_LVOWriteASCIIChar(a6)
	dbf	d1,InterpretCom2
	bsr	WaitIfCtrl
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	cmpa.l	a0,a1
	bls.s	InterpretComExit
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	InterpretCom1
InterpretComExit:
	rts
InterpretWriteCom:
	jsr	_LVOReadNumber(a6)
	addq.w	#1,d7
	cmp.w	$5e(a6),d7		;Cursor X position
	bge.s	InterpretWriteComExit
	subq.w	#1,d7
	cmp.w	#$004f,d7
	bhi.s	InterpretWriteComExit
	move.l	d0,a0
	move.l	a0,a2
	moveq	#$3f,d1
InterpretWriteCom1:
	bsr	ReadChar
	tst.l	d0
	bmi.s	InterpretWriteCom2
	jsr	_LVOWriteMemByte(a6)
	dbf	d1,InterpretWriteCom1
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr.s	InterpretCom1	;Write Line Again
	moveq	#$27,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	rts
InterpretWriteCom2:
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	InterpretCom1	;Write Line Again
	rts
InterpretWriteComExit:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	rts

JumpCom:
	move.l	$90(a6),a2
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	JumpCom1
	move.l	d0,a2
JumpCom1:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	move.w	#$2700,sr
	bsr	MakePrefsCheck
	jsr	_LVOExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$58(a6),a0		;USP
	move.l	$8a(a6),a7		;SSP
	lea	Start3(pc),a1		;Return adress to Monitor
	btst	#5,$8e(a6)		;Test if Supervisor Mode
	bne.s	JumpCom2
	move.l	$90(a6),-(a0)
	move.l	a1,-(a0)		;Push on USP
	bra.s	JumpCom3
JumpCom2:
	move.l	$90(a6),-(a7)
	move.l	a1,-(a7)		;Push on SSP
JumpCom3:
	move.l	a0,USP
	move.l	a2,-(a7)
	move.w	$8e(a6),-(a7)
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

LoadCom:
	move.l	d7,d6
	move.l	$76(a6),a0
	jsr	_LVOReadString(a6)
	tst.l	d0
	bmi	LoadCom1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	move.l	d0,a2
	bsr	LoadFile
	bra.s	LoadCom2
LoadCom1:
	move.l	d6,d7
	jsr	_LVOReadNumber(a6)
	move.b	d0,$11c(a6)
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,d1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,d2
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadComExit
	move.l	d0,a0
	cmp.w	#1760,d1
	bcc.s	LoadCom2
	move.l	d1,d0
	move.l	d2,d1
	bsr	ReadBlocks
LoadCom2:
	move.l	d0,d1
	lea	LoadComText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
LoadComExit:
	rts

LoadComText1:
	dc.b	$0a,"* End address ",0
	even

MemoryCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	cmp.w	#$004f,d7
	bls.s	MemoryCom1
	move.l	$90(a6),a0
MemoryCom1:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
MemoryCom2:
	jsr	_LVOClearLine(a6)
	moveq	#$3a,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	move.l	$76(a6),a2	;Buffert
	moveq	#$03,d1
MemoryCom3:
	moveq	#$03,d2
MemoryCom4:
	addq.w	#1,$5e(a6)	;Space
	jsr	_LVOReadMemByte(a6)
	move.b	d0,(a2)+
	jsr	_LVOWriteByte(a6)
	dbf	d2,MemoryCom4
	addq.w	#1,$5e(a6)	;Space
	dbf	d1,MemoryCom3
	moveq	#$0f,d1
	move.l	$76(a6),a2	;Buffert
MemoryCom5:
	move.b	(a2)+,d0
	jsr	_LVOWriteASCIIChar(a6)
	dbf	d1,MemoryCom5
	bsr	WaitIfCtrl
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	cmpa.l	a0,a1
	bls.s	MemoryComExit
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	MemoryCom2
MemoryComExit:
	rts

MemoryWriteCom:
	jsr	_LVOReadNumber(a6)
	addq.w	#1,d7
	cmp.w	$5e(a6),d7		;Cursor X position
	bge	MemoryWriteComExit
	subq.w	#1,d7
	cmp.w	#$004f,d7
	bhi	MemoryWriteComExit
	move.l	d0,a0
	move.l	a0,a2
	moveq	#$0f,d1
	add.w	#$0034,d7
	cmp.w	$5e(a6),d7
	beq	MemoryWriteComExit
	subq.w	#1,d7
	cmp.w	$5e(a6),d7
	blt.s	MemoryWriteCom3
	sub.w	#$0033,d7
MemoryWriteCom1:
	jsr	_LVOReadByte(a6)
	tst.l	d0
	bmi.s	MemoryWriteCom2
	jsr	_LVOWriteMemByte(a6)
	dbf	d1,MemoryWriteCom1
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	MemoryCom2	;Write Line Again
	moveq	#$3a,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	rts
MemoryWriteCom2:
	cmp.w	#$000f,d1
	beq.s	MemoryWriteComExit
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	move.l	d1,-(a7)
	bsr	MemoryCom2	;Write Line Again
	move.l	(a7)+,d1
	subq.w	#1,$5c(a6)
	eor.w	#$000f,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d2,d1
	lsr.w	#2,d2
	add.w	d2,d1
	add.w	#$000a,d1
	move.w	d1,$5e(a6)
	rts
MemoryWriteCom3:
	bsr	ReadChar
	tst.l	d0
	bmi.s	MemoryWriteCom2
	jsr	_LVOWriteMemByte(a6)
	dbf	d1,MemoryWriteCom3
	move.l	a0,a1
	move.l	a2,a0
	clr.w	$5e(a6)		;Clear X position
	bsr	MemoryCom2	;Write Line Again
	moveq	#$3a,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	add.w	#$0033,$5e(a6)
	rts
MemoryWriteComExit:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

NewlocatorCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	move.l	d0,d2
	jsr	_LVOReadNumber(a6)
	move.l	d0,d3
	jsr	_LVOReadNumber(a6)
	move.l	d0,d4
	cmp.w	#$004f,d7
	bhi	NewLocatorComExit
	sub.l	d2,d4
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
NewLocatorCom1:
	moveq	#$7f,d2
NewLocatorCom2:
	movem.l	d2-d4/a1,-(a7)
	bsr	DisassembleComFindInstr
	movem.l	(a7)+,d2-d4/a1
	move.l	$a0(a6),a2
	cmp.b	#'?',(a2)
	beq	NewLocatorComError	;False Instruction
	move.w	$a6(a6),d0
	move.w	d0,d1
	and.w	#$0180,d1
	beq.s	NewLocatorCom4
	cmp.l	$a8(a6),d2
	bhi.s	NewLocatorCom4
	cmp.l	$a8(a6),d3
	bls.s	NewLocatorCom4
	add.l	d4,$a8(a6)
	move.l	$b8(a6),d5
	exg	a0,d5
	cmp.w	#$0080,d0
	beq.s	NewLocatorCom3
	move.w	$a8(a6),d0
	jsr	_LVOWriteMemWord(a6)
NewLocatorCom3:
	move.w	$aa(a6),d0
	jsr	_LVOWriteMemWord(a6)
	exg	a0,d5
	*bra.s	NewLocatorCom4
NewLocatorCom4:
	move.w	$ac(a6),d0
	move.w	d0,d1
	and.w	#$0180,d1
	beq.s	NewLocatorCom6
	cmp.l	$ae(a6),d2
	bhi.s	NewLocatorCom6
	cmp.l	$ae(a6),d3
	bls.s	NewLocatorCom6
	add.l	d4,$ae(a6)
	move.l	$bc(a6),d5
	exg	a0,d5
	cmp.w	#$0080,d0
	beq.s	NewLocatorCom5
	move.w	$ae(a6),d0
	jsr	_LVOWriteMemWord(a6)
NewLocatorCom5:
	move.w	$b0(a6),d0
	jsr	_LVOWriteMemWord(a6)
	exg	a0,d5
NewLocatorCom6:
	cmpa.l	a0,a1
	bls.s	NewLocatorComExit
	dbf	d2,NewLocatorCom2
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	NewLocatorCom1
	move.l	a0,d0
	bsr	UserBreak
NewLocatorComExit:
	rts
NewLocatorComError:
	move.l	$98(a6),a0
	suba.l	a1,a1
	bra	DisassembleCom1

QuickTraceCom:
	rts

RegisterCom:
	lea	RegisterString1(pc),a0
	jsr	_LVOWriteString(a6)
	lea	$1c(a6),a0
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	moveq	#$07,d1
RegisterCom1:
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	(a0)+,d0
	jsr	_LVOWriteLong(a6)
	dbf	d1,RegisterCom1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	moveq	#$07,d1
RegisterCom2:
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	(a0)+,d0
	jsr	_LVOWriteLong(a6)
	dbf	d1,RegisterCom2
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	moveq	#";",d0
	jsr	_LVOWriteChar(a6)
	move.l	$8a(a6),d0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	$90(a6),d0
	move.l	d0,a0
	jsr	_LVOWriteLong(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.w	$8e(a6),d0
	jsr	_LVOWriteWord(a6)
	addq.w	#5,$5e(a6)
	bsr	DisassembleComFindInstr
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	lea	$b4(a6),a0
	jsr	_LVOWriteString(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

RegisterString1:
	dc.b	$0a,"  D0 A0 SSP D1 A1 PC D2 A2 SR D3    A3"
	dc.b	" D4    A4 D5    A5 D6    A6 D7   USP",$0a,0
	even

RegisterWriteCom:
	bsr	ReadChar
	cmp.b	#";",d0
	beq.s	RegisterWriteCom1
	lea	$1c(a6),a0
	bra.s	RegisterWriteCom3
RegisterWriteCom1:
	bsr	ReadChar
	cmp.b	#";",d0
	beq.s	RegisterWriteCom2
	lea	$3c(a6),a0
RegisterWriteCom3:
	moveq	#$07,d1
RegisterWriteCom4:
	jsr	_LVOReadNumber(a6)
	move.l	d0,(a0)+
	dbf	d1,RegisterWriteCom4
	bra.s	RegisterWriteComExit
RegisterWriteCom2:
	jsr	_LVOReadNumber(a6)
	move.l	d0,$8a(a6)
	jsr	_LVOReadNumber(a6)
	move.l	d0,$90(a6)
	jsr	_LVOReadNumber(a6)
	move.w	d0,$8e(a6)
RegisterWriteComExit:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	rts	

SaveCom:
	move.l	d7,d6
	move.l	$76(a6),a0
	jsr	_LVOReadString(a6)
	tst.l	d0
	bmi	SaveCom1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	SaveComExit
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	SaveComExit
	move.l	d0,a2
	bsr	SaveFile
	bra.s	SaveCom2
SaveCom1:
	move.l	d6,d7
	jsr	_LVOReadNumber(a6)
	move.b	d0,$11c(a6)
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,d1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,d2
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	SaveComExit
	move.l	d0,a0
	cmp.w	#1760,d1
	bcc.s	SaveCom2
	move.l	d1,d0
	move.l	d2,d1
	bsr	WriteBlocks
	bsr	WriteLastTrack
SaveCom2:
	move.l	d0,d1
	lea	LoadComText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
SaveComExit:
	rts

TransferCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a0
	jsr	_LVOReadNumber(a6)
	move.l	d0,a1
	jsr	_LVOReadNumber(a6)
	move.l	d0,a2
	cmp.w	#$004f,d7
	bhi.s	TransferComExit
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	cmp.l	a2,a0
	bls.s	TransferCom3		;Backwards
TransferCom1:
	moveq	#$7f,d2
TransferCom2:
	jsr	_LVOReadMemByte(a6)
	exg	a0,a2
	jsr	_LVOWriteMemByte(a6)
	exg	a0,a2
	cmpa.l	a0,a1
	bls.s	TransferComExit
	dbf	d2,TransferCom2
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	TransferCom1
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	jsr	_LVOWriteLong(a6)
	bra.s	TransferComExit
TransferCom3:
	add.l	a1,a2
	sub.l	a0,a2
	exg	a0,a1
	subq.l	#1,a0
	subq.l	#1,a1
	subq.l	#1,a2
TransferCom4:
	moveq	#$7f,d2
TransferCom5:
	jsr	_LVOReadMemByte(a6)
	exg	a0,a2
	jsr	_LVOWriteMemByte(a6)
	exg	a0,a2
	subq.l	#2,a0
	subq.l	#2,a2
	cmpa.l	a1,a0
	beq.s	TransferComExit
	dbf	d2,TransferCom5
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne.s	TransferCom4
	move.l	a0,d0
	bsr	UserBreak
TransferComExit:
	rts

WalktraceCom:
	rts
ExitCom:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	move.w	#$2700,sr
	bsr	LoadExitPar
	bsr	MakePrefsCheck
	jsr	_LVOExchangeRam(a6)
	bsr	WriteAgnus
	bsr	WriteCIA
	move.l	$8a(a6),a7
	move.l	$90(a6),-(a7)
	move.w	$8e(a6),-(a7)
	move.l	$58(a6),a0
	move.l	a0,USP
	movem.l	$1c(a6),d0-d7/a0-a6
	rte

ChangeDirCom:				;Change Directory
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bpl.s	ChangeDirCom1
	bsr	ShowCurrentDir
	rts
ChangeDirCom1:
	move.l	$76(a6),a0
	bsr	ChangeDirectory
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

CloseCom:
	move.l	$19c(a6),a0		;Filename
	move.l	$150(a6),a1		;Text Start
	move.l	$154(a6),a2		;Text End
	bsr	SaveFile
	move.l	$150(a6),d0		;EDTEXTSTART
	move.l	d0,$154(a6)		;EDTEXTEND
	move.l	d0,$186(a6)		;EDCUTEND
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

DateCom:				;Set/Read Date
DateCom1:
	jsr	_LVOReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi	DateCom4
	move.l	d0,d2
	subq.w	#1,d7
	bsr	ReadChar
	cmp.b	#'-',d0
	beq.s	DateCom2
	cmp.b	#':',d0
	bne.s	DateCom4
	jsr	_LVOReadDecNumber(a6)
	move.l	d0,d1
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	jsr	_LVOReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	exg	d0,d2
	bsr	WriteTODTime
	bra.s	DateCom1
DateCom2:
	bsr	ReadChar
	and.w	#$005f,d0
	move.w	d0,d1
	lsl.w	#8,d1
	bsr	ReadChar
	or.w	#$0020,d0
	move.b	d0,d1
	lsl.l	#8,d1
	bsr	ReadChar
	or.w	#$0020,d0
	move.b	d0,d1
	lsl.l	#8,d1
	lea	Datecodes2+$c(pc),a0
	moveq	#$00,d0
DateCom3:
	cmp.w	#$000c,d0
	beq.s	DateCom4
	addq.w	#1,d0
	cmp.l	(a0)+,d1
	bne.s	DateCom3
	move.l	d0,d1
	jsr	_LVOReadDecNumber(a6)
	cmp.w	#$004f,d7
	bhi.s	DateCom4
	add.w	#1900,d0
	exg	d0,d2
	bsr	WriteTODDate	
	bra	DateCom1
DateCom4:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	bsr	ShowDay
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	bsr	ShowDate
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	bsr	ShowTime
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

DeleteCom:				;Delete File/Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_LVOReadStringII(a6)
	move.l	$76(a6),a0
	bsr	DeleteFile
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

DirectoryCom:				;See Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_LVOReadStringII(a6)
	move.l	$76(a6),a0
	bsr	ShowDirectory
	rts

DiskCopyCom:				;Format Disk
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	DiskCopyComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	DiskCopyComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,d4			;Source Drive
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	DiskCopyComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	DiskCopyComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,d1			;Destin Drive
	move.b	d4,d0
	bsr	DiskCopy
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
DiskCopyComExit:
	rts

FileNoteCom:				;Set Comment
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	FileNoteComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;Comment
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	FileNoteComExit
	move.l	$76(a6),a0		;FileName
	bsr	FileNote
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
FileNoteComExit:
	rts

FormatCom:				;Format Disk
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	FormatComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	FormatComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)		;Drive nr
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	FormatComExit
	move.l	$76(a6),a0		;Name
	move.l	a0,d0
	bsr	FormatDisk
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
FormatComExit:
	rts

HuntDisCom:
	jsr	_LVOReadNumber(a6)
	move.l	d0,a2
	jsr	_LVOReadNumber(a6)
	move.l	d0,a3
	cmp.w	#$004f,d7
	bhi	HuntDisComExit
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi	HuntDisComExit
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
HuntDisCom1:
	move.b	(a0)+,d0
	beq.s	HuntDisCom2
	btst	#6,d0
	beq.s	HuntDisCom1
	and.b	#$5f,d0			;Convert to capitals
	move.b	d0,-1(a0)
	bra.s	HuntDisCom1
HuntDisCom2:
	moveq	#$7f,d2
HuntDisCom3:
	move.l	a2,a0
	movem.l	d2/a2-a3,-(a7)
	bsr	DisassembleComFindInstr
	move.l	a0,-(a7)
	lea	$b4(a6),a0
	bsr	DisassembleComMakeString
	move.l	(a7)+,a0
	movem.l	(a7)+,d2/a2-a3
	move.l	a0,a2
	lea	$b4(a6),a0
	move.l	$76(a6),a1
	sub.l	a4,a4
HuntDisCom4:
	move.b	(a1)+,d0
	beq.s	HuntDisCom8
	cmp.b	#' ',d0			;Any characters any length
	beq.s	HuntDisCom5
	cmp.b	#'*',d0			;Any characters any length
	beq.s	HuntDisCom5
	cmp.b	#'?',d0			;Any character
	beq.s	HuntDisCom7
	move.b	(a0)+,d1
	beq.s	HuntDisCom10
	cmp.b	d1,d0
	beq.s	HuntDisCom4
	move.l	a4,d0
	beq.s	HuntDisCom10
	move.l	d0,a1
	bra.s	HuntDisCom4
HuntDisCom5:
	move.l	a1,a4
	move.b	(a1)+,d0
	beq.s	HuntDisCom9		;Found
HuntDisCom6:
	move.b	(a0)+,d1
	beq.s	HuntDisCom10
	cmp.b	d1,d0
	bne.s	HuntDisCom6
	bra.s	HuntDisCom4
HuntDisCom7:
	move.b	(a0)+,d1
	bne.s	HuntDisCom4
	bra.s	HuntDisCom10
HuntDisCom8:
	move.b	(a0)+,d1
	beq.s	HuntDisCom9		;Found
	bra.s	HuntDisCom10
HuntDisCom9:
	move.l	$98(a6),a0
	suba.l	a1,a1
	movem.l	d1-d7/a2-a3,-(a7)
	bsr	DisassembleCom1
	movem.l	(a7)+,d1-d7/a2-a3
HuntDisCom10:				;Not Found
	cmpa.l	a2,a3
	bls.s	HuntDisComExit
	dbf	d2,HuntDisCom3
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	bne	HuntDisCom2
	move.l	a2,d0
	bsr	UserBreak
HuntDisComExit:
	rts

InfoCom:				;Show Disk info
	bsr	ShowInfo
	rts

InstallCom:				;Install Disk
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	InstallComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	InstallComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	bsr	InstallDisk
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
InstallComExit:
	rts

LoadSegCom:
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi	LoadSegComExit
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	LoadSegComExit
	move.l	d0,a1
	bsr	LoadSegFile
	move.l	d0,d1
	lea	LoadSegComText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	jsr	_LVOWriteLong(a6)
	lea	LoadSegComText2(pc),a0
	jsr	_LVOWriteString(a6)
	moveq	#$00,d2
LoadSegCom1:
	move.l	d1,a0
	subq.l	#4,a0
	jsr	_LVOReadMemLong(a6)
	move.l	d0,d3
	add.l	d0,d2
	jsr	_LVOReadMemLong(a6)
	add.l	d0,d0
	add.l	d0,d0
	move.l	d0,d1
	bne.s	LoadSegCom1
	subq.l	#8,a0
	move.l	d3,d0
	add.l	a0,d0
	jsr	_LVOWriteLong(a6)
	lea	LoadSegComText3(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d2,d0
	move.l	#1000000000,d1
	jsr	_LVOWriteDecNumberII(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
LoadSegComExit:
	rts

LoadSegComText1:
	dc.b	$0a,"* First segment:",0
LoadSegComText2:
	dc.b	" End adress:",0
LoadSegComText3:
	dc.b	" Total length:",0
	even

MakeDirCom:				;Create Directory
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_LVOReadStringII(a6)
	move.l	$76(a6),a0
	tst.b	(a0)
	beq.s	MakeDirComExit
	bsr	MakeDir
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
MakeDirComExit:
	rts

NewCom:
	move.l	$150(a6),d0		;EDTEXTSTART
	move.l	d0,$154(a6)		;EDTEXTEND
	move.l	d0,$186(a6)		;EDCUTEND
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

OpenCom:
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi	OpenComExit
	move.l	$150(a6),a1		;Text Start
	move.l	$182(a6),a2		;Work End
	moveq	#$0e,d7
	move.l	a2,d1
	sub.l	a1,d1
	beq	ErrorHandler		;No workbuffer
	bcs	ErrorHandler		;No workbuffer
	bsr	GetFileLength
	moveq	#$0f,d7
	cmp.l	d1,d0
	bhi	ErrorHandler		;File too long
	move.l	a1,$154(a6)		;No Textlength
	bsr	LoadFile
	move.l	d0,$154(a6)		;Text End
	move.l	d0,$186(a6)		;Cut End
	clr.l	$158(a6)		;Textline nr
	move.l	d0,d1
	sub.l	a1,d1
	move.l	$19c(a6),a1		;Filename
OpenCom1:
	move.b	(a0)+,(a1)+
	bne.s	OpenCom1
	lea	OpenComText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	move.l	#1000000000,d1
	jsr	_LVOWriteDecNumberII(a6)
	lea	OpenComText2(pc),a0
	jsr	_LVOWriteString(a6)
OpenComExit:
	rts
OpenComText1:
	dc.b	$a,"* File length ",0
OpenComText2:
	dc.b	" bytes",$a,0
	even

ProtectCom:				;Set Protect
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	ProtectComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;Protect
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	ProtectComExit
	move.l	$76(a6),a0		;FileName
	bsr	ProtectFile
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
ProtectComExit:
	rts

RelabelCom:				;ReLabel Disk
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	RelabelComExit
	and.w	#$5f5f,(a0)
	cmp.w	#'DF',(a0)
	bne.s	RelabelComExit
	move.b	2(a0),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)		;Drive nr
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	RelabelComExit
	beq.s	RelabelComExit
	move.l	$76(a6),a0		;Name
	bsr	RelabelDisk
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
RelabelComExit:
	rts

RenameCom:				;Rename File
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	RenameComExit
	move.l	$76(a6),a0
	add.l	d0,a0
	addq.l	#1,a0
	move.l	a0,a1			;New Name
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	RenameComExit
	move.l	$76(a6),a0		;FileName
	bsr	RenameFile
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
RenameComExit:
	rts

SaveTextCom:
	move.l	$76(a6),a0
	jsr	_LVOReadStringII(a6)
	tst.l	d0
	bmi.s	SaveTextCom2		;No Filename specified
	move.l	$19c(a6),a1		;Filename
SaveTextCom1:
	move.b	(a0)+,(a1)+
	bne.s	SaveTextCom1
SaveTextCom2:
	move.l	$19c(a6),a0		;Text FileName
	move.l	$150(a6),a1		;Text Start
	move.l	$154(a6),a2		;Text End
	bsr	SaveFile
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts

ShowSegCom:
	jsr	_LVOReadNumber(a6)
	cmp.w	#$0050,d7
	beq	ShowSegComExit
	move.l	d0,a0
	bsr	ShowSegList
ShowSegComExit:
	rts

TypeCom:				;Type File
	move.l	$76(a6),a0
	clr.b	(a0)
	jsr	_LVOReadStringII(a6)
	move.l	$76(a6),a0
	bsr	TypeFile
	rts

WorkBufCom:
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	WorkBufCom1
	move.l	d0,d1
	jsr	_LVOReadNumber(a6)
	cmp.w	#$004f,d7
	bhi	WorkBufComExit
	move.l	d1,$150(a6)		;EDWORKSTART
	move.l	d1,$154(a6)		;EDTEXTEND
	move.l	d1,$186(a6)		;EDCUTEND
	move.l	d0,$182(a6)		;EDWORKEND
	bra.s	WorkBufCom1
WorkBufComExit:
	rts
WorkBufCom1:
	lea	WorkBufComText1(pc),a0
	move.l	$150(a6),d1
	move.l	$182(a6),d2
	bsr.s	WorkBufCom2
	lea	WorkBufComText2(pc),a0
	move.l	$150(a6),d1
	move.l	$154(a6),d2
	bsr.s	WorkBufCom2
	lea	WorkBufComText3(pc),a0
	move.l	$186(a6),d1
	move.l	$182(a6),d2
	bsr.s	WorkBufCom2
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	rts
WorkBufCom2:
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	jsr	_LVOWriteLong(a6)
	lea	WorkBufComText5(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d2,d0
	jsr	_LVOWriteLong(a6)
	lea	WorkBufComText4(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d2,d0
	sub.l	d1,d0
	move.l	#1000000000,d1
	jsr	_LVOWriteDecNumberII(a6)
	rts

WorkBufComText1:
	dc.b	$a,"* Workbuffer:",$9,0
WorkBufComText2:
	dc.b	$a,"* Source:",$9,0
WorkBufComText3:
	dc.b	$a,"* Free:",$9,$9,0
WorkBufComText4:
	dc.b	" Length:",0
WorkBufComText5:
	dc.b	" - ",0
	even

UserBreak:
	movem.l	d1/a0,-(a7)
	move.l	d0,d1
	tst.w	$5e(a6)
	beq.s	UserBreak1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
UserBreak1:
	lea	UserBreakText(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d1,d0
	jsr	_LVOWriteLong(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	movem.l	(a7)+,d1/a0
	rts

UserBreakText:
	dc.b	"* User-Break at adress ",0
	even

ShowSegList:			;a0=First segment
	movem.l	d1-d3/a0-a1,-(a7)
	move.l	a0,a1
	move.l	#1000000000,d1
	moveq	#$00,d2		;Segnr
	moveq	#$00,d3		;Tot Length
ShowSegList1:
	lea	ShowSegListText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d2,d0
	jsr	_LVOWriteDecNumberII(a6)
	move.w	#$0010,$5e(a6)
	lea	ShowSegListText2(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	a1,d0
	addq.l	#4,d0
	jsr	_LVOWriteLong(a6)
	lea	ShowSegListText3(pc),a0
	jsr	_LVOWriteString(a6)
	lea	-4(a1),a0
	jsr	_LVOReadMemLong(a6)
	add.l	d0,d3
	subq.l	#8,d0
	jsr	_LVOWriteDecNumberII(a6)
	bsr	WaitIfCtrl
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	beq.s	ShowSegListExit
	move.l	a1,a0
	jsr	_LVOReadMemLong(a6)
	tst.l	d0
	beq.s	ShowSegListExit
	move.l	d0,a1
	add.l	a1,a1
	add.l	a1,a1
	addq.l	#1,d2
	bra.s	ShowSegList1
ShowSegListExit:
	lea	ShowSegListText4(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d3,d0
	jsr	_LVOWriteDecNumberII(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	movem.l	(a7)+,d1-d3/a0-a1
	rts

ShowSegListText1:
	dc.b	$a,"* Segment ",0
ShowSegListText2:
	dc.b	" Address ",0
ShowSegListText3:
	dc.b	" Length ",0
ShowSegListText4:
	dc.b	$a,"* Total length ",0
	even


ReadExpression:			;d0out=Answer 32
	movem.l	d1-d7/a0-a6,-(a7)
	moveq	#$00,d0
ReadExpression1:
	bsr	ReadChar
	tst.l	d0
	beq.s	ReadExpressionQuit
	cmp.b	#' ',d0
	beq.s	ReadExpressionQuit1
	cmp.b	#'+',d0
	beq.s	ReadExpression2
	cmp.b	#'-',d0
	beq.s	ReadExpression3
	cmp.b	#'*',d0
	beq.s	ReadExpression4
	cmp.b	#'/',d0
	beq.s	ReadExpression5
	cmp.b	#'(',d0
	beq.s	ReadExpression6
	cmp.b	#')',d0
	beq.s	ReadExpression7
	bsr.s	ReadExpressionLastChar
ReadExpression2:			;"+"
	bsr.s	ReadExpressionNumber
ReadExpression3:			;"+"
ReadExpression4:			;"+"
ReadExpression5:			;"+"
ReadExpression6:			;"+"
ReadExpression7:			;"+"
ReadExpressionQuit1:
	bsr.s	ReadExpressionLastChar
ReadExpressionQuit:
	movem.l	(a7)+,d1-d7/a0-a6
	rts

ReadExpressionLastChar:
	cmp.w	#$004f,d7
	bhi.s	ReadExpressionLastChar1
	subq.w	#1,d7
ReadExpressionLastChar1:
	rts

ReadExpressionThisChar:

ReadExpressionNumber:
	

MultiplyInteger:		;d0=Factor1 32 , d1=Factor2 32
				;d0out=Product 32
	movem.l	d2/d3,-(a7)
	moveq	#$00,d2		;Product
	moveq	#$1f,d3
MultiplyInteger1:
	lsr.l	#1,d1
	bcc.s	MultiplyInteger2
	add.l	d0,d2
MultiplyInteger2:
	lsl.l	#1,d0
	dbf	d3,MultiplyInteger1
	move.l	d2,d0
	movem.l	(a7)+,d2/d3
	rts
		
DivideInteger:			;d0=Dividend 32 , d1=Divisor 32
				;d0out=Quote 32 , d1out=Rest 32
	movem.l	d2-d5,-(a7)
	moveq	#$00,d2
	moveq	#$1f,d4
	moveq	#$00,d5
	move.l	d2,d3
	tst.l	d1
	beq.s	DivideInteger2
DivideInteger1:
	bmi.s	DivideInteger2
	addq.w	#1,d2
	lsl.l	#1,d0
	roxl.l	#1,d3
	lsl.l	#1,d1
	bra.s	DivideInteger1
DivideInteger2:
	lsl.l	#1,d0
	roxl.l	#1,d3
	bcs.s	DivideInteger3
	cmp.l	d3,d1
	bls.s	DivideInteger3
	lsl.l	#1,d5
	bra.s	DivideInteger4
DivideInteger3:
	lsl.l	#1,d5
	bset	#0,d5
	sub.l	d1,d3
DivideInteger4:
	subq.w	#1,d4
	bpl.s	DivideInteger2
DivideInteger5:
	lsr.l	d2,d3
	move.l	d3,d1
	move.l	d5,d0
	movem.l	(a7)+,d2-d5
	rts
		
ReadTODDate:
			;d0out=Day,d1out=Month,d2out=Year
	movem.l	d3/d4/a0,-(a7)
	lea	$dc0036,a0
	and.w	#$fffe,(a0)	;Start Clock
	lea	$dc0018,a0
	bsr.s	ReadTODDate1
	move.l	d3,d0
	bsr.s	ReadTODDate1
	move.l	d3,d1
	bsr.s	ReadTODDate1
	move.l	d3,d2
	add.w	#1900,d2	;Year 1990-1999
	cmp.w	#1989,d2
	bhi.s	ReadTODDate0
	add.w	#100,d2		;Year 2000-2089	!
ReadTODDate0:
	movem.l	(a7)+,d3/d4/a0
	rts

ReadTODDate1:
	move.l	(a0)+,d3
	and.w	#$000f,d3
	move.l	(a0)+,d4
	and.w	#$000f,d4
	mulu	#10,d4
	add.w	d4,d3
	ext.l	d3
	rts

ReadTODTime:
			;d0out=Hours,d1out=Min,d2out=Secs
	movem.l	d3/d4/a0,-(a7)
	lea	$dc0036,a0
	and.w	#$fffe,(a0)		;Start Clock
	lea	$dc0000,a0
	bsr.s	ReadTODTime1
	move.l	d3,d2
	bsr.s	ReadTODTime1
	move.l	d3,d1
	bsr.s	ReadTODTime1
	move.l	d3,d0
	movem.l	(a7)+,d3/d4/a0
	rts

ReadTODTime1:
	move.l	(a0)+,d3
	and.w	#$000f,d3
	move.l	(a0)+,d4
	and.w	#$000f,d4
	mulu	#10,d4
	add.w	d4,d3
	ext.l	d3
	rts

WriteTODTime:
			;d0=Hours,d1=Min,d2=Secs
	movem.l	d3/a0,-(a7)
	lea	$dc003e,a0
	move.w	#$fff1,(a0)		;Clear MicroSeconds
	move.w	#$fff5,(a0)
	move.w	#$fff4,(a0)
	lea	$dc0000,a0
	move.l	d2,d3
	bsr.s	WriteTODTime1
	move.l	d1,d3
	bsr.s	WriteTODTime1
	move.l	d0,d3
	bsr.s	WriteTODTime1
	movem.l	(a7)+,d3/a0
	rts
WriteTODTime1:
	divu	#10,d3
	swap	d3
	move.l	d3,(a0)+
	swap	d3
	move.l	d3,(a0)+
	rts

WriteTODDate:
			;d0=Day,d1=Month,d2=Year
	movem.l	d3/a0,-(a7)
	lea	$dc003e,a0
	move.w	#$fff1,(a0)		;Clear MicroSeconds
	move.w	#$fff5,(a0)
	move.w	#$fff4,(a0)
	lea	$dc0018,a0
	move.l	d0,d3
	bsr.s	WriteTODDate1
	move.l	d1,d3
	bsr.s	WriteTODDate1
	move.l	d2,d3
	ext.l	d3
	divu	#100,d3
	clr.w	d3
	swap	d3
	bsr.s	WriteTODDate1
	movem.l	(a7)+,d3/a0
	rts
WriteTODDate1:
	divu	#10,d3
	swap	d3
	move.l	d3,(a0)+
	swap	d3
	move.l	d3,(a0)+
	rts

ShowDay:
	movem.l	d1/d2/a0,-(a7)
	bsr	ReadTODDate
	bsr	GetDayOfWeek
	move.l	d0,a0
	jsr	_LVOWriteString(a6)
	movem.l	(a7)+,d1/d2/a0
	rts

ShowDate:
	movem.l	d1/d2,-(a7)
	bsr	ReadTODDate
	bsr	WriteDate
	movem.l	(a7)+,d1/d2
	rts

ShowTime:
	movem.l	d1/d2,-(a7)
	bsr	ReadTODTime
	bsr	WriteTime
	movem.l	(a7)+,d1/d2
	rts

WriteTime:		;d0=Hours,d1=Min,d2=Secs
	movem.l	d0-d3,-(a7)
	bsr.s	WriteTime1
	moveq	#':',d0
	jsr	_LVOWriteChar(a6)
	move.l	d1,d0
	bsr.s	WriteTime1
	moveq	#':',d0
	jsr	_LVOWriteChar(a6)
	move.l	d2,d0
	bsr.s	WriteTime1
	movem.l	(a7)+,d0-d3
	rts
WriteTime1:
	divu	#10,d0
	move.l	d0,d3
	swap	d3
	jsr	_LVOWriteNumber(a6)
	move.w	d3,d0
	jsr	_LVOWriteNumber(a6)
	rts

WriteDate:		;d0=Daynr,d1=Month,d2=Year
	movem.l	d0-d4/a0,-(a7)
	divu	#10,d0
	move.l	d0,d4
	swap	d4
	jsr	_LVOWriteNumber(a6)
	move.w	d4,d0
	jsr	_LVOWriteNumber(a6)
	moveq	#'-',d0
	jsr	_LVOWriteChar(a6)
	lea	Datecodes2(pc),a0
	move.b	-1(a0,d1.w),d1
	ext.w	d1
	add.w	d1,a0
	jsr	_LVOWriteString(a6)
	moveq	#'-',d0
	jsr	_LVOWriteChar(a6)
	move.l	d2,d0
	divu	#100,d0
	swap	d0
	ext.l	d0
	divu	#10,d0
	move.l	d0,d4
	swap	d4
	jsr	_LVOWriteNumber(a6)
	move.w	d4,d0
	jsr	_LVOWriteNumber(a6)
	movem.l	(a7)+,d0-d4/a0
	rts

GetDayOfWeek:		;d0=Daynr,d1=Month,d2=Year
			;d0out=DayOfWeek-Name
	movem.l	d1-d3/a0,-(a7)
	move.w	d2,d3
	and.w	#$0003,d3
	bne.s	GetDayOfWeek1
	cmp.w	#$0002,d1
	bhi.s	GetDayOfWeek1
	addq.w	#6,d0
GetDayOfWeek1:
	divu	#100,d2
	lea	Timecodes3(pc),a0
	add.b	0(a0,d2.w),d0		;Century
	swap	d2
	lea	Timecodes4(pc),a0
	add.b	0(a0,d2.w),d0		;Year
	lea	Timecodes2(pc),a0
	add.b	-1(a0,d1.w),d0		;Month
	addq.w	#3,d0
	ext.w	d0
	ext.l	d0
	divu	#$0007,d0
	swap	d0
	lea	Timecodes1(pc),a0
	move.b	0(a0,d0.w),d0
	ext.w	d0
	add.w	d0,a0
	move.l	a0,d0
	movem.l	(a7)+,d1-d3/a0
	rts

*****************************************************************************

WriteProtFlags:		;d0=ProtFlags
	move.l	d1,-(a7)
	move.l	d0,d1
	moveq	#'h',d0
	bsr.s	WriteProtFlags3
	moveq	#'s',d0
	bsr.s	WriteProtFlags3
	moveq	#'p',d0
	bsr.s	WriteProtFlags3
	moveq	#'a',d0
	bsr.s	WriteProtFlags3
	moveq	#'r',d0
	bsr.s	WriteProtFlags1
	moveq	#'w',d0
	bsr.s	WriteProtFlags1
	moveq	#'e',d0
	bsr.s	WriteProtFlags1
	moveq	#'d',d0
	bsr.s	WriteProtFlags1
	move.l	(a7)+,d1
	rts
WriteProtFlags1:
	btst	#7,d1
	beq.s	WriteProtFlags2
	moveq	#'-',d0
WriteProtFlags2:
	jsr	_LVOWriteChar(a6)
	add.l	d1,d1
	rts
WriteProtFlags3:
	btst	#7,d1
	bne.s	WriteProtFlags2
	moveq	#'-',d0
	bra.s	WriteProtFlags2

ConvertTime:		;d0=Min,d1=Seconds*50
			;d0out=Hours,d1out=Min,d2out=Secs
	divu	#50,d1
	move.l	d1,d2
	ext.l	d2
	divu	#60,d0
	move.l	d0,d1
	swap	d1
	ext.l	d1
	ext.l	d0
	rts

ConvertTimeII:		;d0=Hours,d1=Min,d2=Secs
			;d0out=Min,d1out=Seconds*50
	mulu	#60,d0
	add.l	d1,d0
	move.l	d2,d1
	mulu	#50,d1
	rts

AttachDate:
	movem.l	d1/d2/a0,-(a7)
	move.l	d0,a0
	bsr	ReadTODDate
	bsr	ConvertDateII
	move.l	d0,$1a4(a0)	;Days since 01-01-1978
	bsr	ReadTODTime
	bsr	ConvertTimeII
	move.l	d0,$1a8(a0)	;Min+Hours*60
	move.l	d1,$1ac(a0)	;Secs*50
	movem.l	(a7)+,d1/d2/a0
	rts

ConvertDate:		;d0=Days since 01-01-1978
			;d0out=Day,d1out=Month,d2out=Year
	movem.l	d3/d4/a0,-(a7)
	and.l	#$000fffff,d0
	moveq	#$00,d3
	move.l	#1978,d2	;Year
	lea	Datecodes1(pc),a0
ConvertDate1:
	moveq	#$01,d1
ConvertDate2:
	move.b	-1(a0,d1.w),d3
	cmp.b	#28,d3
	bne.s	ConvertDate3
	move.w	d2,d4
	and.w	#$0003,d4
	bne.s	ConvertDate3
	addq.w	#1,d3		;29 days in Feb each 4th year
ConvertDate3:
	cmp.l	d0,d3
	bhi.s	ConvertDate4
	sub.l	d3,d0
	addq.w	#1,d1
	cmp.w	#13,d1
	bne.s	ConvertDate2
	addq.w	#1,d2
	bra.s	ConvertDate1
ConvertDate4:
	addq.w	#1,d0
	movem.l	(a7)+,d3/d4/a0
	rts

ConvertDateII:		;d0=Day,d1=Month,d2=Year
			;d0out=Days since 01-01-1978
	movem.l	d3/d4/a0,-(a7)
	and.l	#$000000ff,d0
	moveq	#$00,d3
	lea	Datecodes1(pc),a0
	subq.l	#1,d0
ConvertDateII1:
	cmp.w	#1978,d2
	bne.s	ConvertDateII2
	cmp.w	#1,d1
	beq.s	ConvertDateII4
ConvertDateII2:
	subq.w	#1,d1
	bne.s	ConvertDateII2a
	moveq	#12,d1
	subq.w	#1,d2
ConvertDateII2a:
	move.b	-1(a0,d1.w),d3
	cmp.b	#28,d3
	bne.s	ConvertDateII3
	move.w	d2,d4
	and.w	#$0003,d4
	bne.s	ConvertDateII3
	addq.w	#1,d3		;29 days in Feb each 4th year
ConvertDateII3:
	add.l	d3,d0
	bra.s	ConvertDateII1
ConvertDateII4:
	movem.l	(a7)+,d3/d4/a0
	rts

ReadBlocks:		;a0=address for blocks , d0=blocknr 0-1760
			;d1=number of blocks
	movem.l	d1-d7/a0-a6,-(a7)
	move.l	d1,d7
	subq.l	#1,d7
	bra.s	ReadBlock1
ReadBlock:		;a0=address for block , d0=blocknr 0-1760
	movem.l	d1-d7/a0-a6,-(a7)
	moveq	#$00,d7
ReadBlock1:
	ext.l	d0
	move.l	d0,d6
	move.w	#$01ff,d1
	move.b	$11c(a6),d2
	cmp.b	$11d(a6),d2
	bne.s	ReadBlock2
	cmp.w	$11e(a6),d0
	bne.s	ReadBlock2
	move.l	$7e(a6),a1
	bra.s	ReadBlock5
ReadBlock2:
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	ReadBlock3
	cmp.b	$125(a6),d4
	beq.s	ReadBlock4
ReadBlock3:
	bsr	WriteLastTrack
	move.w	d4,d0
	cmp.w	#$009f,d0
	bhi	ReadBlock10
	bsr	ReadTrack
ReadBlock4:
	ext.w	d5
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a1
	add.l	d5,a1
ReadBlock5:
	cmp.l	#$00dfffff,a0
	bhi.s	ReadBlock7		;>$e00000
	cmp.l	#$00dfedff,a0	
	bhi	ReadBlock8
	cmp.l	#$00bfffff,a0		;>$c00000
	bhi.s	ReadBlock7
	cmp.l	#$00bfcdff,a0
	bhi	ReadBlock8
	cmp.l	#$000053ff,a0		;>$5400
	bhi.s	ReadBlock7
	cmp.l	#$000051ff,a0
	bhi	ReadBlock8
	add.l	$86(a6),a0		;<$5400
ReadBlock6:
	move.l	a0,d0
	btst	#0,d0
	bne.s	ReadBlock6b
	moveq	#$0f,d1
ReadBlock6a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a2/a3/a4
	movem.l	d0/d2/d3/d4/d5/a2/a3/a4,(a0)
	lea	$0020(a0),a0
	dbf	d1,ReadBlock6a
	sub.l	$86(a6),a0
	bra.s	ReadBlock10
ReadBlock6b:
	move.b	(a1)+,(a0)+
	dbf	d1,ReadBlock6b
	sub.l	$86(a6),a0
	bra.s	ReadBlock10
ReadBlock7:				;Ordinary Mem
	move.l	a0,d0
	btst	#0,d0
	bne.s	ReadBlock7b
	moveq	#$0f,d1
ReadBlock7a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a2/a3/a4
	movem.l	d0/d2/d3/d4/d5/a2/a3/a4,(a0)
	lea	$0020(a0),a0
	dbf	d1,ReadBlock7a
	bra.s	ReadBlock10
ReadBlock7b:
	move.b	(a1)+,(a0)+
	dbf	d1,ReadBlock7b
	bra.s	ReadBlock10
ReadBlock8:				;Special Ram
	move.b	(a1)+,d0
	jsr	_LVOWriteMemByte(a6)
	dbf	d1,ReadBlock8
ReadBlock10:
	addq.w	#1,d6
	move.l	d6,d0
	subq.w	#1,d7
	bpl	ReadBlock1
	move.l	a0,d0
	movem.l	(a7)+,d1-d7/a0-a6
	rts

WriteBlocks:		;a0=address for blocks , d0=blocknr 0-1760
			;d1=number of blocks
	movem.l	d1-d7/a0-a6,-(a7)
	move.l	d1,d7
	subq.l	#1,d7
	bra.s	WriteBlock1
WriteBlock:		;a0=address for block , d0=blocknr 0-1760
	movem.l	d1-d7/a0-a6,-(a7)
	moveq	#$00,d7
WriteBlock1:
	ext.l	d0
	move.w	#$01ff,d1
WriteBlock2:
	move.l	d0,d6
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	WriteBlock3
	cmp.b	$125(a6),d4
	beq.s	WriteBlock4
WriteBlock3:
	bsr	WriteLastTrack
	move.w	d4,d0
	cmp.w	#$009f,d0
	bhi	WriteBlock10
	bsr	ReadTrack
WriteBlock4:
	move.w	#$1234,$138(a6)		;Write Track Buffer !
	ext.w	d5
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a1
	add.l	d5,a1
WriteBlock5:
	cmp.l	#$00dfffff,a0
	bhi.s	WriteBlock7		;>$e00000
	cmp.l	#$00dfedff,a0	
	bhi	WriteBlock8
	cmp.l	#$00bfffff,a0		;>$c00000
	bhi.s	WriteBlock7
	cmp.l	#$00bfcdff,a0
	bhi	WriteBlock8
	cmp.l	#$000053ff,a0		;>$5400
	bhi.s	WriteBlock7
	cmp.l	#$000051ff,a0
	bhi	WriteBlock8
	add.l	$86(a6),a0		;<$5400
WriteBlock6:
	move.l	a0,d0
	btst	#0,d0
	bne.s	WriteBlock6b
	moveq	#$0f,d1
WriteBlock6a:
	movem.l	(a0)+,d0/d2/d3/d4/d5/a2/a3/a4
	movem.l	d0/d2/d3/d4/d5/a2/a3/a4,(a1)
	lea	$0020(a1),a1
	dbf	d1,WriteBlock6a
	sub.l	$86(a6),a0
	bra.s	WriteBlock10
WriteBlock6b:
	move.b	(a0)+,(a1)+
	dbf	d1,WriteBlock6b
	sub.l	$86(a6),a0
	bra.s	WriteBlock10
WriteBlock7:				;Ordinary Mem
	move.l	a0,d0
	btst	#0,d0
	bne.s	WriteBlock7b
	moveq	#$0f,d1
WriteBlock7a:
	movem.l	(a0)+,d0/d2/d3/d4/d5/a2/a3/a4
	movem.l	d0/d2/d3/d4/d5/a2/a3/a4,(a1)
	lea	$0020(a1),a1
	dbf	d1,WriteBlock7a
	bra.s	WriteBlock10
WriteBlock7b:
	move.b	(a0)+,(a1)+
	dbf	d1,WriteBlock7b
	bra.s	WriteBlock10
WriteBlock8:				;Special Ram
	jsr	_LVOReadMemByte(a6)
	move.b	d0,(a1)+
	dbf	d1,WriteBlock8
WriteBlock10:
	move.b	$11c(a6),d0
	cmp.b	$11d(a6),d0
	bne.s	WriteBlock11
	cmp.w	$11e(a6),d6	;Rootblock ?
	bne.s	WriteBlock11
	move.l	$7e(a6),a0
	lea	$fffffe00(a1),a1
	moveq	#$7f,d0
WriteBlock10a:
	move.l	(a1)+,(a0)+
	dbf	d0,WriteBlock10a
WriteBlock11:
	addq.w	#1,d6
	move.l	d6,d0
	subq.w	#1,d7
	bpl	WriteBlock1
	move.l	a0,d0
	movem.l	(a7)+,d1-d7/a0-a6
	rts

HashName:			;d0=length,a0=filename
	movem.l	d1/d2/a0,-(a7)	;OUT:d0=Hashindex*4
	move.w	d0,d2
HashName1:
	mulu	#13,d0
	moveq	#$00,d1
	move.b	(a0)+,d1
	cmp.b	#$61,d1
	bcs.s	HashName2
	cmp.b	#$7b,d1
	bcc.s	HashName2
	eor.b	#$20,d1
HashName2:
	add.w	d1,d0
	and.w	#$07ff,d0
	subq.w	#1,d2
	bne.s	HashName1
	divu	#72,d0
	clr.w	d0
	swap	d0
	add.l	d0,d0
	add.l	d0,d0
	movem.l	(a7)+,a0/d1/d2
	rts

SearchHash:			;a0=HashName,a4=Diskbuffert
				;d0=HashLength
	movem.l	d1-d3/a0-a2,-(a7)
	move.l	a0,a2
	move.l	d0,d3
	beq	SearchHash7	;No Length
	bsr	HashName
	move.w	$6(a4),$13a(a6)
	cmp.l	#$00000001,$1fc(a4)
	bne.s	SearchHash0
	move.w	#$0370,$13a(a6)
SearchHash0:
	move.w	d0,$13c(a6)
	add.w	#$0018,$13c(a6)
	move.l	$18(a4,d0.w),d0
	move.l	$7a(a6),a4
	tst.l	d0
	beq.s	SearchHash6
SearchHash1:
	move.l	a4,a0
	bsr	ReadBlock
	cmp.b	$1b0(a4),d3
	bne.s	SearchHash5
	lea	$1b1(a4),a0
	move.l	a2,a1
	move.l	d3,d2
SearchHash2:
	move.b	(a0)+,d0
	move.b	(a1)+,d1
	cmp.b	#$61,d0
	bcs.s	SearchHash3
	cmp.b	#$7b,d0
	bcc.s	SearchHash3
	eor.b	#$20,d0
SearchHash3:
	cmp.b	#$61,d1
	bcs.s	SearchHash4
	cmp.b	#$7b,d1
	bcc.s	SearchHash4
	eor.b	#$20,d1
SearchHash4:
	cmp.b	d0,d1
	bne.s	SearchHash5
	subq.w	#1,d2
	bne.s	SearchHash2
SearchHash4a:
	movem.l	(a7)+,d1-d3/a0-a2
	moveq	#$00,d0
	rts
SearchHash5:
	move.w	$6(a4),$13a(a6)
	move.w	#$01f0,$13c(a6)
	move.l	$1f0(a4),d0
	bne.s	SearchHash1
SearchHash6:
	movem.l	(a7)+,d1-d3/a0-a2
	moveq	#-1,d0			;Hash not Found
	rts
SearchHash7:
	move.l	$1f4(a4),d0
	beq.s	SearchHash6
	move.l	$7a(a6),a4
	move.l	a4,a0
	bsr	ReadBlock
	bra.s	SearchHash4a

CheckRootBlock:
	movem.l	d7/a0,-(a7)
	cmp.l	$7e(a6),a4
	bne.s	CheckRootBlock1
	cmp.w	#$ffff,$11e(a6)
	bne.s	CheckRootBlock1
	moveq	#$00,d0			;Drive 0
	move.b	d0,$11c(a6)
	move.b	d0,$11d(a6)
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.w	#$0370,$11e(a6)
CheckRootBlock1:
	moveq	#$02,d7
	cmp.l	#$00000002,(a4)
	bne	ErrorHandler	;Not a Dos Disk
	movem.l	(a7)+,d7/a0
	rts

ShowCurrentDir:
	movem.l	a0-a6/d1-d7,-(a7)
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
	bsr	CheckRootBlock
ShowCurrentDir1:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#'D',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'F',d0
	jsr	_LVOWriteChar(a6)
	moveq	#$00,d0
	move.b	$11d(a6),d0
	jsr	_LVOWriteNumber(a6)
	moveq	#':',d0
	jsr	_LVOWriteChar(a6)
	cmp.l	#$00000001,$1fc(a4)
	beq.s	ShowCurrentDir4
	moveq	#$00,d0
	move.l	d0,-(a7)
ShowCurrentDir2:
	move.l	$1f4(a4),d0
	cmp.l	#$00000370,d0
	beq.s	ShowCurrentDir3
	move.l	$4(a4),-(a7)
	move.l	$7a(a6),a4
	move.l	a4,a0
	bsr	ReadBlock
	bra.s	ShowCurrentDir2
ShowCurrentDir3:
	lea	$1b0(a4),a0
	move.l	a0,d0
	bsr	WriteFileName
	move.l	(a7)+,d0
	beq.s	ShowCurrentDir4
	move.l	a4,a0
	bsr	ReadBlock
	moveq	#'/',d0
	jsr	_LVOWriteChar(a6)
	bra.s	ShowCurrentDir3
ShowCurrentDir4:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	movem.l	(a7)+,a0-a6/d1-d7
	rts

ChangeDirectory:				;A0 = DirectoryName
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
ChangeDirectory1:
	tst.b	(a3)
	beq.s	ChangeDirectory3
ChangeDirectory1a:
	move.b	(a3)+,d0
	beq.s	ChangeDirectory2	;Last Directory
	cmp.b	#'/',d0
	beq.s	ChangeDirectory2	;Directory
	cmp.b	#':',d0
	bne.s	ChangeDirectory1a	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	ChangeDirectory1
ChangeDirectory2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	cmp.l	#$00000002,$1fc(a4)
	bhi	ErrorHandler	;Directory not found
	move.l	a3,a0
	tst.b	-1(a3)
	bne.s	ChangeDirectory1
ChangeDirectory3:
	bsr	CheckRootBlock
	cmp.l	#$00000001,$1fc(a4)
	bne.s	ChangeDirectory4
	move.l	#$00000370,$4(a4)
ChangeDirectory4:
	move.l	$4(a4),d0
	move.l	$7e(a6),a0
	bsr	ReadBlock
	move.w	$6(a4),$11e(a6)
	move.b	$11c(a6),$11d(a6)
	movem.l	(a7)+,a0-a6/d1-d7
	rts

ShowDirectory:				;A0 = DirectoryName
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
ShowDirectory1:
	tst.b	(a3)
	beq.s	ShowDirectory2a
ShowDirectory1a:
	move.b	(a3)+,d0
	beq.s	ShowDirectory2	;Last Directory
	cmp.b	#'/',d0
	beq.s	ShowDirectory2	;Directory
	cmp.b	#':',d0
	bne.s	ShowDirectory1a	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	ShowDirectory1
ShowDirectory2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	cmp.l	#$00000002,$1fc(a4)
	bhi	ErrorHandler	;Directory not found
	move.l	a3,a0
	tst.b	-1(a3)
	bne.s	ShowDirectory1
ShowDirectory2a:
	bsr	CheckRootBlock
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	lea	Directorytext1(pc),a0
	jsr	_LVOWriteString(a6)
	lea	$1b0(a4),a0	;DirectoryName
	move.l	a0,d0
	bsr	WriteFileName
	lea	Directorytext2(pc),a0
	jsr	_LVOWriteString(a6)
	bsr	ReadTODDate
	bsr	GetDayOfWeek	;Day of week
	move.l	d0,a0
	jsr	_LVOWriteString(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	bsr	ReadTODDate
	bsr	WriteDate	;Date
	clr.l	$98(a6)		;Nr of Files
	clr.l	$9c(a6)		;Nr of Directories
	clr.l	$a0(a6)		;Nr of Blocks
	cmpa.l	$7e(a6),a4
	bne.s	ShowDirectory2c
	move.l	a4,a3
	move.l	$7a(a6),a4
	move.l	a4,a2
	moveq	#$7f,d2
ShowDirectory2b:
	move.l	(a3)+,(a2)+
	dbf	d2,ShowDirectory2b
ShowDirectory2c:
	moveq	#$00,d2
ShowDirectory3:
	move.w	#$0018,d3
	moveq	#-1,d4
ShowDirectory4:
	move.l	0(a4,d3.w),d0
	cmp.l	d2,d0
	bls.s	ShowDirectory5
	cmp.l	d0,d4
	bls.s	ShowDirectory5
	move.l	d0,d4
	lea	0(a4,d3.w),a2
ShowDirectory5:
	addq.w	#4,d3
	cmp.w	#$138,d3
	bne.s	ShowDirectory4
	tst.l	d4
	bmi	ShowDirectory11
	move.l	d4,d2
	move.l	d4,d0
ShowDirectory6:
	ext.l	d0
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	ShowDirectory7
	cmp.b	$125(a6),d4
	beq.s	ShowDirectory8
ShowDirectory7:
	move.w	d4,d0
	moveq	#$02,d7
	cmp.w	#$009f,d0
	bhi	ErrorHandler		;Load error
	bsr	ReadTrack
ShowDirectory8:
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a1
	add.l	d5,a1
	move.l	$1f0(a1),d6
	lea	$1b0(a1),a0		;FileName
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	bsr	WriteFileName
	move.w	#$0020,$5e(a6)
	cmp.l	#$fffffffd,$1fc(a1)
	beq.s	ShowDirectory9
	addq.l	#1,$9c(a6)		;Nr of Directories
	addq.l	#1,$a0(a6)		;Nr of Blocks
	lea	Directorytext3(pc),a0	;Directory
	jsr	_LVOWriteString(a6)
	bra.s	ShowDirectory10
ShowDirectory9:
	addq.l	#1,$98(a6)		;Nr of Files
	move.l	$144(a1),d0		;FileLength
	move.l	d0,d7
	add.l	#$000001e7,d7
	divu	#$01e8,d7
	ext.l	d7
	add.l	d7,$a0(a6)		;Nr of Blocks
	add.l	#$00000047,d7
	divu	#$0048,d7
	ext.l	d7
	add.l	d7,$a0(a6)
	move.l	#100000,d1
	jsr	_LVOWriteDecNumber(a6)
ShowDirectory10:
	moveq	#' ',d0
	jsr	_LVOWriteChar(a6)
	move.l	$140(a1),d0		;ProtectionFlags
	bsr	WriteProtFlags
	moveq	#' ',d0
	jsr	_LVOWriteChar(a6)
	move.l	d2,d7
	move.l	$1a4(a1),d0		;Date
	bsr	ConvertDate
	bsr	WriteDate
	moveq	#' ',d0
	jsr	_LVOWriteChar(a6)
	move.l	$1a8(a1),d0		;Time
	move.l	$1ac(a1),d1
	bsr	ConvertTime
	bsr	WriteTime
	move.l	d7,d2
	lea	$148(a1),a0		;FileNote
	tst.b	(a0)
	beq.s	ShowDirectory10a
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#$3a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#$20,d0
	jsr	_LVOWriteChar(a6)
	move.l	a0,d0
	bsr	WriteFileName
ShowDirectory10a:
	bsr	WaitIfCtrl
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	beq.s	ShowDirectory11
	move.l	d6,d0
	beq	ShowDirectory3
	swap	d0
	swap	d2
	move.w	d2,d0
	swap	d0
	swap	d2
	move.l	d0,(a2)
	cmp.l	d2,d0
	bhi	ShowDirectory3
	move.l	d0,d6
	move.l	d2,d7
	ext.l	d6
	ext.l	d7
	divu	#11,d6
	divu	#11,d7
	cmp.w	d6,d7
	beq	ShowDirectory6		;On same track
	move.l	d2,d0
	swap	d0
	addq.w	#1,d0
	move.w	d0,(a2)
	bra	ShowDirectory3
ShowDirectory11:
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	move.l	#1000000000,d1
	moveq	#$01,d2
	move.l	$98(a6),d0		;Nr of Files
	beq.s	ShowDirectory12
	jsr	_LVOWriteDecNumberII(a6)
	lea	Directorytext4(pc),a0
	cmp.l	$98(a6),d2
	bne.s	ShowDirectory11a
	lea	Directorytext4a(pc),a0
ShowDirectory11a:
	jsr	_LVOWriteString(a6)
ShowDirectory12:
	move.l	$9c(a6),d0		;Nr of Directories
	beq.s	ShowDirectory13
	jsr	_LVOWriteDecNumberII(a6)
	lea	Directorytext5(pc),a0
	cmp.l	$9c(a6),d2
	bne.s	ShowDirectory12a
	lea	Directorytext5a(pc),a0
ShowDirectory12a:
	jsr	_LVOWriteString(a6)
ShowDirectory13:
	move.l	$a0(a6),d0		;Nr of Blocks
	jsr	_LVOWriteDecNumberII(a6)
	lea	Directorytext6(pc),a0
	cmp.l	$a0(a6),d2
	bne.s	ShowDirectory13a
	lea	Directorytext6a(pc),a0
ShowDirectory13a:
	jsr	_LVOWriteString(a6)
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	movem.l	(a7)+,d1-d7/a0-a6
	rts

WriteFileName:
	movem.l	d1/a0,-(a7)
	move.l	d0,a0
	move.b	(a0)+,d1
WriteFileName1:
	tst.b	d1
	beq.s	WriteFileName2
	move.b	(a0)+,d0
	jsr	_LVOWriteChar(a6)
	subq.b	#1,d1
	bra.s	WriteFileName1
WriteFileName2:
	movem.l	(a7)+,d1/a0
	rts

Directorytext1:
	dc.b	"Directory ",$22,0
Directorytext2:
	dc.b	$22," on ",0
Directorytext3:
	dc.b	"   Dir",0
Directorytext4:
	dc.b	" files - ",0
Directorytext4a:
	dc.b	" file - ",0
Directorytext5:
	dc.b	" directories - ",0
Directorytext5a:
	dc.b	" directory - ",0
Directorytext6:
	dc.b	" blocks used",0
Directorytext6a:
	dc.b	" block used",0
	even

ShowInfo:
	movem.l	d1-d7/a0-a6,-(a7)
	lea	Infotext1(pc),a0
	jsr	_LVOWriteString(a6)
	moveq	#$03,d6
ShowInfo1:
	move.l	d6,-(a7)
	lea	ShowInfo2(pc),a0
	move.l	a0,$142(a6)
	move.l	a7,$146(a6)
	move.b	d6,$11c(a6)		;Drive unit
	move.l	$7a(a6),a0
	move.w	#$0370,d0		;Rootblock
	bsr	ReadBlock
	bra.s	ShowInfo4
ShowInfo2:
	move.l	$146(a6),a7
	move.l	(a7),d6
	cmp.b	#$01,d7
	beq	ShowInfo6		;Next Drive
	lea	Infotext2(pc),a0
	cmp.b	#$09,d7
	beq.s	ShowInfo3		;No Disk in drive
	lea	Infotext4(pc),a0	;Unreadable disk
	cmp.b	#$02,d7
	beq.s	ShowInfo3
	lea	Infotext5(pc),a0	;Disk not validated
ShowInfo3:
	moveq	#'D',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'F',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'0',d0
	add.l	d6,d0
	jsr	_LVOWriteChar(a6)
	jsr	_LVOWriteString(a6)
	bra	ShowInfo6
ShowInfo4:
	move.l	$7a(a6),a4
	lea	Infotext3(pc),a0	;Not a DOS disk
	cmp.l	#$00000002,(a4)
	bne.s	ShowInfo3
	cmp.l	#$00000001,$1fc(a4)
	bne.s	ShowInfo3
	bsr	ReadBamBlock
	move.l	(a7),d6
	moveq	#'D',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'F',d0
	jsr	_LVOWriteChar(a6)
	moveq	#'0',d0
	add.l	d6,d0
	jsr	_LVOWriteChar(a6)
	lea	Infotext8(pc),a0
	jsr	_LVOWriteString(a6)
	move.w	#13,$5e(a6)
	bsr	GetNumUsedBlock
	move.l	d0,d2
	move.l	#1000,d1
	jsr	_LVOWriteDecNumber(a6)
	move.w	#21,$5e(a6)
	move.l	#1758,d0
	sub.l	d2,d0
	jsr	_LVOWriteDecNumber(a6)
	move.w	#26,$5e(a6)
	move.l	#100,d1
	move.l	d2,d0
	mulu	#100,d0
	divu	#1758,d0
	ext.l	d0
	jsr	_LVOWriteDecNumber(a6)
	moveq	#'%',d0
	jsr	_LVOWriteChar(a6)
	move.w	#33,$5e(a6)
	moveq	#'0',d0
	jsr	_LVOWriteChar(a6)
	move.w	#36,$5e(a6)
	bsr	CheckWriteProt
	lea	Infotext6(pc),a0
	tst.l	d0
	beq.s	ShowInfo5
	lea	Infotext7(pc),a0	;WriteProt
ShowInfo5:
	jsr	_LVOWriteString(a6)
	move.w	#47,$5e(a6)
	lea	$1b0(a4),a0
	move.l	a0,d0
	bsr	WriteFileName
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
ShowInfo6:
	move.l	(a7)+,d6
	subq.l	#1,d6
	bpl	ShowInfo1
	movem.l	(a7)+,d1-d7/a0-a6
	rts

Infotext1:
	dc.b	10,"Mounted disks:",10
	dc.b	"Unit Size    Used    Free Full Errs   Status   Name"
*		 01234567890123456789012345678901234567890123456789
*			   1         2         3         4
	dc.b	10,0
Infotext2:
	dc.b	": No disk present",10,0
Infotext3:
	dc.b	": Not a DOS disk",10,0
Infotext4:
	dc.b	": Unreadable disk",10,0
Infotext5:
	dc.b	": Disk not validated",10,0
Infotext6:
	dc.b	"Read/Write",0
Infotext7:
	dc.b	"Read Only ",0
Infotext8:
	dc.b	": 880K",0
	even

InstallDisk:
	movem.l	d1/a0/a1/a6,-(a7)
	moveq	#$00,d0
	move.w	d0,d1		;d4=tracknr 0-159
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	InstallDisk1
	cmp.b	$125(a6),d1
	beq.s	InstallDisk2
InstallDisk1:
	bsr	WriteLastTrack
	move.w	d1,d0
	bsr	ReadTrack
InstallDisk2:
	move.w	#$1234,$138(a6)		;Write Track Buffer !
	move.l	$120(a6),a0
	lea	InstallDiskData(pc),a1
	move.w	#$00ff,d0
InstallDisk3:
	move.l	(a1)+,(a0)+
	dbf	d0,InstallDisk3
	move.l	$120(a6),a0
	move.l	a0,d0
	bsr	CheckSumBootBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,d1/a0/a1/a6
	rts
InstallDiskData:
	dc.l	$444f5300,$00000000,$00000370,$43fa0018
	dc.l	$4eaeffa0,$4a80670a,$20402068,$00167000
	dc.l	$4e7570ff,$60fa646f,$732e6c69,$62726172
	dc.l	$79000000

GetFileLength:		;a0=filename
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
GetFileLength1:
	move.b	(a3)+,d0
	beq.s	GetFileLength3	;FileName
	cmp.b	#'/',d0
	beq.s	GetFileLength2	;Directory
	cmp.b	#':',d0
	bne.s	GetFileLength1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	GetFileLength1
GetFileLength2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	GetFileLength1
GetFileLength3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler	;File not found
	cmp.l	#$fffffffd,$1fc(a4)
	bne	ErrorHandler	;File not found
	move.l	$144(a4),d0
	movem.l	(a7)+,d1-d7/a0-a6
	rts


LoadFile:		;a0=filename, a1=startadress
			;a2=endadress(NULL=End of File)
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
LoadFile1:
	move.b	(a3)+,d0
	beq.s	LoadFile3	;FileName
	cmp.b	#'/',d0
	beq.s	LoadFile2	;Directory
	cmp.b	#':',d0
	bne.s	LoadFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	LoadFile1
LoadFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	LoadFile1
LoadFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler	;File not found
	cmp.l	#$fffffffd,$1fc(a4)
	bne	ErrorHandler	;File not found
	move.l	$10(a4),d0	;first datablock
	move.l	a1,a3
	add.l	$144(a4),a3
	cmp.l	a2,a1
	bcc.s	LoadFile4
	cmp.l	a2,a3
	bcc.s	LoadFile5
LoadFile4:
	move.l	a3,a2
LoadFile5:
	move.l	a1,a0
LoadFile6:
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	LoadFile7
	cmp.b	$125(a6),d4
	beq.s	LoadFile8
LoadFile7:
	move.w	d4,d0
	moveq	#$02,d7
	cmp.w	#$009f,d0
	bhi	ErrorHandler		;Load error
	bsr	ReadTrack
LoadFile8:
	ext.w	d5
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a1
	add.l	d5,a1
	move.l	$0c(a1),d1		;Block length
	move.l	$10(a1),d6		;Next block
	lea	$18(a1),a1		;Start of data
	move.l	a0,a3
	add.l	d1,a3
	cmp.l	a3,a2
	bls	LoadFile12		;Last block	
	moveq	#$02,d7
	cmp.w	#$01e8,d1
	bne	ErrorHandler		;Error in File
	subq.w	#1,d1
	cmp.l	#$00dfffff,a0
	bhi.s	LoadFile10		;>$e00000
	cmp.l	#$00dfedff,a0	
	bhi	LoadFile11
	cmp.l	#$00bfffff,a0		;>$c00000
	bhi.s	LoadFile10
	cmp.l	#$00bfcdff,a0
	bhi	LoadFile11
	cmp.l	#$000053ff,a0		;>$5400
	bhi.s	LoadFile10
	cmp.l	#$00005217,a0
	bhi	LoadFile11
	add.l	$86(a6),a0		;<$5400
LoadFile9:
	move.l	a0,d0
	btst	#0,d0
	bne.s	LoadFile9b
	moveq	#$0e,d1
LoadFile9a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a3/a4/a5	;$0f*$20=$01e0
	movem.l	d0/d2/d3/d4/d5/a3/a4/a5,(a0)
	lea	$0020(a0),a0
	dbf	d1,LoadFile9a
	move.l	(a1)+,(a0)+			;$01e0+$0008=$01e8
	move.l	(a1)+,(a0)+
	sub.l	$86(a6),a0
	bra.s	LoadFile13
LoadFile9b:
	move.b	(a1)+,(a0)+
	dbf	d1,LoadFile9b
	sub.l	$86(a6),a0
	bra.s	LoadFile13
LoadFile10:				;Ordinary Mem
	move.l	a0,d0
	btst	#0,d0
	bne.s	LoadFile10b
	moveq	#$0e,d1
LoadFile10a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a3/a4/a5	;$01e0
	movem.l	d0/d2/d3/d4/d5/a3/a4/a5,(a0)
	lea	$0020(a0),a0
	dbf	d1,LoadFile10a
	move.l	(a1)+,(a0)+			;$0008
	move.l	(a1)+,(a0)+
	bra.s	LoadFile13
LoadFile10b:
	move.b	(a1)+,(a0)+
	dbf	d1,LoadFile10b
	bra.s	LoadFile13
LoadFile11:				;Special Ram
	move.b	(a1)+,d0
	jsr	_LVOWriteMemByte(a6)
	dbf	d1,LoadFile11
	bra.s	LoadFile13
LoadFile12:
	move.b	(a1)+,d0
	jsr	_LVOWriteMemByte(a6)
	cmp.l	a0,a2
	bhi.s	LoadFile12
	clr.l	d6
LoadFile13:
	move.l	d6,d0
	tst.l	d0
	bne	LoadFile6
	move.l	a0,d0
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	

LoadSegFile:		;a0=filename, a1=startadress
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
LoadSegFile1:
	move.b	(a3)+,d0
	beq.s	LoadSegFile3	;FileName
	cmp.b	#'/',d0
	beq.s	LoadSegFile2	;Directory
	cmp.b	#':',d0
	bne.s	LoadSegFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	LoadSegFile1
LoadSegFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	LoadSegFile1
LoadSegFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler	;File not found
	cmp.l	#$fffffffd,$1fc(a4)
	bne	ErrorHandler	;File not found
	move.l	a1,d0
	and.w	#$fffc,d0
	move.l	d0,a2
	move.l	a4,a1
	bsr	LoadSegFileRL2	;Read first longword
	moveq	#$0c,d7		;Not an object module error
	tst.l	d1
	bmi	ErrorHandler
	cmp.l	#$000003f3,d0
	bne	ErrorHandler
	bsr	LoadSegFileRL1	;Start Seg Nr
	tst.l	d1
	bmi	ErrorHandler
	bsr	LoadSegFileRL1	;Tot Nr of Segs in file
	tst.l	d1
	bmi	ErrorHandler	
	tst.l	d0
	beq	ErrorHandler	;Null segs
	bsr	LoadSegFileRL1	;First Seg Nr
	tst.l	d1
	bmi	ErrorHandler
	move.l	d0,d2
	bsr	LoadSegFileRL1	;Last Seg Nr
	tst.l	d1
	bmi	ErrorHandler
	sub.l	d2,d0
	move.l	d0,d2
	bmi	ErrorHandler
	addq.l	#4,a2		;Seg NR 1
	move.l	a2,a3
LoadSegFile4:
	bsr	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	move.l	a3,a0
	add.l	d0,d0
	add.l	d0,d0
	addq.l	#8,d0
	subq.l	#4,a0
	move.l	a0,a3
	add.l	d0,a3
	jsr	_LVOWriteMemLong(a6)
	addq.l	#4,a3
	move.l	a3,d0
	lsr.l	#2,d0
	jsr	_LVOWriteMemLong(a6)
	dbf	d2,LoadSegFile4
	subq.l	#4,a0
	moveq	#$00,d0
	jsr	_LVOWriteMemLong(a6)
	move.l	a2,a3
	addq.l	#4,a3
LoadSegFile5:
	bsr	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	and.l	#$3fffffff,d0
	cmp.l	#$000003e9,d0
	beq.s	LoadSegFile6	;CODE
	cmp.l	#$000003ea,d0
	beq.s	LoadSegFile6	;DATA
	cmp.l	#$000003eb,d0
	beq.s	LoadSegFile8	;BSS
	cmp.l	#$000003ec,d0
	beq.s	LoadSegFile10	;RELOCATE
	cmp.l	#$000003f2,d0
	beq	LoadSegFile14	;ENDOFSEG
	bra	ErrorHandler
LoadSegFile6:			;CODE,DATA
	bsr	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	move.l	d0,d2
	beq	ErrorHandler
	move.l	a3,a0
LoadSegFile7:
	bsr	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	jsr	_LVOWriteMemLong(a6)
	subq.l	#1,d2
	bne.s	LoadSegFile7
	bra.s	LoadSegFile5
LoadSegFile8:			;BSS
	bsr	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	move.l	d0,d2
	beq	ErrorHandler
	move.l	a3,a0
	moveq	#$00,d0
LoadSegFile9:
	jsr	_LVOWriteMemLong(a6)
	subq.l	#1,d2
	bne.s	LoadSegFile9
	bra	LoadSegFile5
LoadSegFile10:			;RELOCATE
	bsr	LoadSegFileRL1	;Number of changes
	tst.l	d1
	bmi	ErrorHandler
	move.l	d0,d2
	beq	LoadSegFile5
	bsr	LoadSegFileRL1	;Seg nr
	tst.l	d1
	bmi	ErrorHandler
	move.l	a2,a0
LoadSegFile11:
	tst.l	d0
	beq.s	LoadSegFile12
	move.l	d0,-(a7)
	jsr	_LVOReadMemLong(a6)
	move.l	d0,a0
	move.l	(a7)+,d0
	add.l	a0,a0
	add.l	a0,a0
	subq.l	#1,d0
	bra.s	LoadSegFile11
LoadSegFile12:
	move.l	a0,d0
	tst.l	d0
	beq	ErrorHandler
	addq.l	#4,a0
	move.l	a0,a4
LoadSegFile13:
	bsr.s	LoadSegFileRL1
	tst.l	d1
	bmi	ErrorHandler
	move.l	a3,a0
	add.l	d0,a0
	jsr	_LVOReadMemLong(a6)
	add.l	a4,d0
	subq.l	#4,a0
	jsr	_LVOWriteMemLong(a6)
	subq.l	#1,d2
	bne.s	LoadSegFile13
	bra.s	LoadSegFile10
LoadSegFile14:			;ENDOFSEG
	movem.l	d0/a0,-(a7)
	lea	-4(a3),a0
	jsr	_LVOReadMemLong(a6)
	move.l	d0,a3
	movem.l	(a7)+,d0/a0
	add.l	a3,a3
	add.l	a3,a3
	move.l	a3,d0
	addq.l	#4,a3
	tst.l	d0
	bne	LoadSegFile5
	move.l	a2,d0
	movem.l	(a7)+,a0-a6/d1-d7
	rts

LoadSegFileRL1:			;Read next Longword
				;A1=Block,D1=Index
	cmp.l	$0c(a1),d1
	beq.s	LoadSegFileRL2	;Next Sector
	bhi.s	LoadSegFileRL5	;Error
	move.l	$18(a1,d1.w),d0
	addq.w	#4,d1
	rts
LoadSegFileRL2:
	move.l	$10(a1),d0	;Next block
	beq.s	LoadSegFileRL5	;Last block
	movem.l	d2/d7,-(a7)
	divu	#11,d0
	move.w	d0,d1		;d1=tracknr 0-159
	swap	d0
	move.w	d0,d2		;d2=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	LoadSegFileRL3
	cmp.b	$125(a6),d1
	beq.s	LoadSegFileRL4
LoadSegFileRL3:
	move.w	d1,d0
	moveq	#$02,d7
	cmp.w	#$009f,d0
	bhi	ErrorHandler		;Load error
	bsr	ReadTrack
LoadSegFileRL4:
	ext.l	d2
	lsl.w	#8,d2
	add.w	d2,d2
	move.l	$120(a6),a1
	add.l	d2,a1
	movem.l	(a7)+,d2/d7
	move.l	$18(a1),d0
	moveq	#$04,d1
	rts
LoadSegFileRL5:
	moveq	#$ffffffff,d1
	rts

SaveFile:		;a0=filename, a1=startadress
			;a2=endadress
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
SaveFile1:
	move.b	(a3)+,d0
	beq.s	SaveFile3	;FileName
	cmp.b	#'/',d0
	beq.s	SaveFile2	;Directory
	cmp.b	#':',d0
	bne.s	SaveFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	SaveFile1
SaveFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	SaveFile1
SaveFile3:
	bsr	CheckRootBlock
	move.l	$4(a4),d4
	cmp.l	#$00000001,$1fc(a4)
	bne.s	SaveFile3a
	move.l	#$00000370,d4
SaveFile3a:
	move.l	a3,d0
	sub.l	a0,d0
	move.l	a0,a3
	subq.l	#1,d0
	move.l	d0,d6
	bsr	SearchHash
	tst.l	d0
	bmi	SaveFile4	;File not found
	moveq	#$04,d7
	cmp.l	#$fffffffd,$1fc(a4)
	bne	ErrorHandler	;Not a file error!
	bsr	DeleteFile3a
SaveFile4:
	bsr	ReadBamBlock
	move.l	d0,-(a7)	;BamBlockNr
	moveq	#$7f,d0
	move.l	a4,a0
SaveFile5:
	clr.l	(a0)+
	dbf	d0,SaveFile5
	move.l	#$00000002,(a4)
	move.l	#$fffffffd,$1fc(a4)
	move.l	a4,d0
	bsr	AttachDate
	move.w	#$0371,d0
	bsr	GetFreeBlockII
	moveq	#$08,d7
	tst.l	d0
	bmi	ErrorHandler		;Disk full error
	move.l	d0,4(a4)		;BlockNr
	move.l	a2,d0
	sub.l	a1,d0
	move.l	d0,$144(a4)		;FileLength
	move.l	d4,$1f4(a4)		;ParentBlock
	move.b	d6,$1b0(a4)		;FileNameLength
	lea	$1b1(a4),a0		;FileName
	subq.l	#1,d6
SaveFile5a:
	move.b	(a3)+,(a0)+
	dbf	d6,SaveFile5a
	move.l	4(a4),d6		;FileInfoBlock
	move.w	#$036f,d0
	bsr	GetFreeBlockI
	moveq	#$08,d7
	tst.l	d0
	bmi	ErrorHandler
	move.l	d0,$10(a4)		;1st Datablock
	moveq	#$01,d3			;Number of Datablock
SaveFile5b:
	cmp.l	#$00000048,$8(a4)
	bne.s	SaveFile5d
	move.l	d0,d1
	move.l	$4(a4),d0
	bsr	GetFreeBlockII
	moveq	#$08,d7
	tst.l	d0
	bmi	ErrorHandler
	move.l	d0,$1f8(a4)
	move.l	d0,d2
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.l	$4(a4),d0
	bsr	WriteBlock
	moveq	#$7f,d0
	move.l	a4,a0
SaveFile5c:
	clr.l	(a0)+
	dbf	d0,SaveFile5c
	move.l	#$00000010,(a4)
	move.l	#$fffffffd,$1fc(a4)
	move.l	d2,$4(a4)
	move.l	d6,$1f4(a4)
	move.l	d1,d0
SaveFile5d:
	moveq	#$47,d1
	sub.l	$8(a4),d1
	addq.l	#1,$8(a4)
	lsl.l	#2,d1
	move.l	d0,$18(a4,d1.w)
SaveFile6:
	movem.l	d0/d3/a4,-(a7)	;Current Datablock
	ext.l	d0
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	SaveFile7
	cmp.b	$125(a6),d4
	beq.s	SaveFile8
SaveFile7:
	bsr	WriteLastTrack
	move.w	d4,d0
	moveq	#$02,d7
	cmp.w	#$009f,d0
	bhi	ErrorHandler		;Save error
	bsr	ReadTrack
SaveFile8:
	move.w	#$1234,$138(a6)		;Write Track Buffer !
	ext.w	d5
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a0
	add.l	d5,a0
	move.l	a2,d1
	sub.l	a1,d1
	cmp.l	#$000001e8,d1
	bls	SaveFile9
	move.l	#$000001e8,d1	
SaveFile9:
	move.l	#$00000008,(a0)
	move.l	d1,$0c(a0)		;Number of bytes
	move.l	d6,$04(a0)		;FileInfoBlock
	move.l	d3,$08(a0)		;Number of Datablock
	move.l	a0,d7
	lea	$18(a0),a0		;Start of data
	subq.w	#1,d1
	cmp.w	#$01e7,d1
	bne	SaveFile11
	cmp.l	#$00dfffff,a1
	bhi.s	SaveFile10		;>$e00000
	cmp.l	#$00dfedff,a1	
	bhi	SaveFile11
	cmp.l	#$00bfffff,a1		;>$c00000
	bhi.s	SaveFile10
	cmp.l	#$00bfcdff,a1
	bhi	SaveFile11
	cmp.l	#$000053ff,a1		;>$5400
	bhi.s	SaveFile10
	cmp.l	#$00005217,a1
	bhi	SaveFile11
	add.l	$86(a6),a1		;<$5400
	move.l	a1,d0
	btst	#0,d0
	bne.s	SaveFile9b
	moveq	#$0e,d1
SaveFile9a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a3/a4/a5	;$0f*$20=$01e0
	movem.l	d0/d2/d3/d4/d5/a3/a4/a5,(a0)
	lea	$0020(a0),a0
	dbf	d1,SaveFile9a
	move.l	(a1)+,(a0)+			;$01e0+$0008=$01e8
	move.l	(a1)+,(a0)+
	sub.l	$86(a6),a1
	bra.s	SaveFile12
SaveFile9b:
	move.b	(a1)+,(a0)+
	dbf	d1,SaveFile9b
	sub.l	$86(a6),a1
	bra.s	SaveFile12
SaveFile10:				;Ordinary Mem
	move.l	a1,d0
	btst	#0,d0
	bne.s	SaveFile10b
	moveq	#$0e,d1
SaveFile10a:
	movem.l	(a1)+,d0/d2/d3/d4/d5/a3/a4/a5	;$01e0
	movem.l	d0/d2/d3/d4/d5/a3/a4/a5,(a0)
	lea	$0020(a0),a0
	dbf	d1,SaveFile10a
	move.l	(a1)+,(a0)+			;$0008
	move.l	(a1)+,(a0)+
	bra.s	SaveFile12
SaveFile10b:
	move.b	(a1)+,(a0)+
	dbf	d1,SaveFile10b
	bra.s	SaveFile12
SaveFile11:				;Special Ram
	exg	a0,a1
	jsr	_LVOReadMemByte(a6)
	exg	a0,a1
	move.b	d0,(a0)+
	dbf	d1,SaveFile11
SaveFile12:
	movem.l	(a7)+,d0/d3/a4		;Current blocknr
	addq.l	#1,d3
	move.l	d7,a0
	cmp.l	a1,a2
	beq.s	SaveFile13
	bsr	GetFreeBlockI
	moveq	#$08,d7
	tst.l	d0
	bmi	ErrorHandler		;Disk full error
	move.l	d0,$10(a0)
	move.l	a0,d0
	bsr	CheckSumBlock
	move.l	$10(a0),d0
	bra	SaveFile5b
SaveFile13:
	clr.l	$10(a0)
	move.l	a0,d0
	bsr	CheckSumBlock
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.l	$4(a4),d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	ReadBlock
	move.w	$13c(a6),d0
	move.l	d6,0(a4,d0.w)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	WriteBlock
	move.l	$13e(a6),a0
	move.l	a0,d0
	bsr	CheckSumBamBlock
	move.l	(a7)+,d0		;Write BamBlock
	bsr	WriteBlock
	bsr	WriteLastTrack
	move.l	a1,d0
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	
MakeDir:		;a0=Directoryname
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
MakeDir1:
	move.b	(a3)+,d0
	beq.s	MakeDir3	;Directory
	cmp.b	#'/',d0
	beq.s	MakeDir2	;Directory
	cmp.b	#':',d0
	bne.s	MakeDir1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	MakeDir1
MakeDir2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	MakeDir1
MakeDir3:
	bsr	CheckRootBlock
	move.l	$4(a4),d4
	cmp.l	#$00000001,$1fc(a4)
	bne.s	MakeDir3a
	move.l	#$00000370,d4
MakeDir3a:
	move.l	a3,d0
	sub.l	a0,d0
	move.l	a0,a3
	subq.l	#1,d0
	move.l	d0,d6
	bsr	SearchHash
	tst.l	d0
	bmi	MakeDir4	;Directory not found
	moveq	#$05,d7
	cmp.l	#$00000002,$1fc(a4)
	bne	ErrorHandler	;Not a Directory error!
	bsr	DeleteFile3a
MakeDir4:
	bsr	ReadBamBlock
	move.l	d0,-(a7)	;BamBlockNr
	moveq	#$7f,d0
	move.l	a4,a0
MakeDir5:
	clr.l	(a0)+
	dbf	d0,MakeDir5
	move.l	#$00000002,(a4)
	move.l	#$00000002,$1fc(a4)
	move.l	a4,d0
	bsr	AttachDate
	move.w	#$0371,d0
	bsr	GetFreeBlockII
	moveq	#$08,d7
	tst.l	d0
	bmi	ErrorHandler		;Disk full error
	move.l	d0,4(a4)		;BlockNr
	move.l	d4,$1f4(a4)		;ParentBlock
	move.b	d6,$1b0(a4)		;FileNameLength
	lea	$1b1(a4),a0		;FileName
	subq.l	#1,d6
MakeDir6:
	move.b	(a3)+,(a0)+
	dbf	d6,MakeDir6
	move.l	4(a4),d6		;FileInfoBlock
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.l	$4(a4),d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	ReadBlock
	move.w	$13c(a6),d0
	move.l	d6,0(a4,d0.w)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	WriteBlock
	move.l	$13e(a6),a0
	move.l	a0,d0
	bsr	CheckSumBamBlock
	move.l	(a7)+,d0		;Write BamBlock
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	
FileNote:		;a0=Directoryname , a1=Comment
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
FileNote1:
	move.b	(a3)+,d0
	beq.s	FileNote3	;File/Directory
	cmp.b	#'/',d0
	beq.s	FileNote2	;Directory
	cmp.b	#':',d0
	bne.s	FileNote1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	FileNote1
FileNote2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	FileNote1
FileNote3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler		;File/Directory not found
	move.l	$4(a4),d4
	cmp.l	#$00000001,$1fc(a4)
	beq	ErrorHandler
	lea	$149(a4),a0		;Comment
	moveq	#$ffffffff,d0
FileNote4:
	addq.l	#1,d0
	move.b	(a1)+,(a0)+
	bne.s	FileNote4
	move.b	d0,$148(a4)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.l	d4,d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,a0-a6/d1-d7
	rts

ProtectFile:		;a0=Filename , a1=Protect
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
ProtectFile1:
	move.b	(a3)+,d0
	beq.s	ProtectFile3	;File/Directory
	cmp.b	#'/',d0
	beq.s	ProtectFile2	;Directory
	cmp.b	#':',d0
	bne.s	ProtectFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	ProtectFile1
ProtectFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	ProtectFile1
ProtectFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler		;File/Directory not found
	move.l	$4(a4),d4
	cmp.l	#$00000001,$1fc(a4)
	beq	ErrorHandler
	moveq	#$0f,d1
ProtectFile4:
	move.b	(a1)+,d0
	beq.s	ProtectFile7
	and.b	#$5f,d0
	moveq	#$07,d2
	cmp.b	#'H',d0
	beq.s	ProtectFile6
	moveq	#$06,d2
	cmp.b	#'S',d0
	beq.s	ProtectFile6
	moveq	#$05,d2
	cmp.b	#'P',d0
	beq.s	ProtectFile6
	moveq	#$04,d2
	cmp.b	#'A',d0
	beq.s	ProtectFile6
	moveq	#$03,d2	
	cmp.b	#'R',d0
	beq.s	ProtectFile5
	moveq	#$02,d2
	cmp.b	#'W',d0
	beq.s	ProtectFile5
	moveq	#$01,d2
	cmp.b	#'E',d0
	beq.s	ProtectFile5
	moveq	#$00,d2
	cmp.b	#'D',d0
	beq.s	ProtectFile5
	bra.s	ProtectFile4
ProtectFile5:
	bclr	d2,d1
	bra.s	ProtectFile4
ProtectFile6:
	bset	d2,d1
	bra	ProtectFile4
ProtectFile7:
	move.l	d1,$140(a4)		;Set Protect
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.l	d4,d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	
RenameFile:		;a0=Filename1 , a1=Filename2
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
RenameFile1:
	move.b	(a3)+,d0
	beq.s	RenameFile3	;File/Directory
	cmp.b	#'/',d0
	beq.s	RenameFile2	;Directory
	cmp.b	#':',d0
	bne.s	RenameFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	RenameFile1
RenameFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	RenameFile1
RenameFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler		;File/Directory not found
	cmp.l	#$00000001,$1fc(a4)
	beq	ErrorHandler
	move.w	$13a(a6),d5
	move.w	$13c(a6),d6
	move.l	$13e(a6),a0
	move.l	$4(a4),d0
	bsr	ReadBlock
	move.l	a1,a3
	move.l	a1,a0
	move.l	$7e(a6),a4		;Rootblock
RenameFile4:
	move.b	(a3)+,d0
	beq.s	RenameFile6	;File/Directory
	cmp.b	#'/',d0
	beq.s	RenameFile5	;Directory
	cmp.b	#':',d0
	bne.s	RenameFile4	;Drive
	moveq	#$0b,d4
	move.b	-2(a3),d0
	and.b	#$03,d0
	cmp.b	$11c(a6),d0
	bne	ErrorHandler
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	RenameFile4
RenameFile5:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	RenameFile4
RenameFile6:
	bsr	CheckRootBlock
	move.l	$4(a4),d4
	cmp.l	#$00000001,$1fc(a4)
	bne.s	RenameFile6a
	move.l	#$00000370,d4
RenameFile6a:
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	move.l	a0,a2
	bsr	SearchHash
	moveq	#$0a,d7
	tst.l	d0
	beq	ErrorHandler		;File/Directory exists !
	move.l	$13e(a6),a3
	lea	$1b1(a3),a1
	moveq	#$ffffffff,d0
RenameFile7:
	addq.w	#1,d0
	move.b	(a2)+,(a1)+
	bne.s	RenameFile7
	move.b	d0,$1b0(a3)
	move.l	d4,$1f4(a3)
	move.w	$13a(a6),d0
	ext.l	d0
	cmp.l	$4(a3),d0
	beq.s	RenameFile8
	move.l	d5,d0
	move.l	a4,a0
	bsr	ReadBlock
	move.l	$1f0(a3),0(a4,d6.w)
	clr.l	$1f0(a3)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	d5,d0
	move.l	a4,a0
	bsr	WriteBlock
	move.w	$13a(a6),d0
	move.l	a4,a0
	bsr	ReadBlock
	move.w	$13c(a6),d0
	move.l	$4(a3),0(a4,d0.w)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.w	$13a(a6),d0
	move.l	a4,a0
	bsr	WriteBlock
RenameFile8:
	move.l	a3,d0
	bsr	CheckSumBlock
	move.l	$4(a3),d0
	move.l	a3,a0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	
RelabelDisk:		;a0=DiskName
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a1
	move.l	$7a(a6),a4		;Rootblock
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	moveq	#$02,d7
	cmp.l	#$00000001,$1fc(a4)
	bne	ErrorHandler
	lea	$1b1(a4),a0		;Name
	moveq	#$ffffffff,d0
RelabelDisk1:
	addq.l	#1,d0
	move.b	(a1)+,(a0)+
	bne.s	RelabelDisk1
	move.b	d0,$1b0(a4)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,a0-a6/d1-d7
	rts
	
TypeFile:		;a0=filename
	movem.l	a0-a6/d1-d7,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
TypeFile1:
	move.b	(a3)+,d0
	beq.s	TypeFile3	;FileName
	cmp.b	#'/',d0
	beq.s	TypeFile2	;Directory
	cmp.b	#':',d0
	bne.s	TypeFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	TypeFile1
TypeFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	TypeFile1
TypeFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler	;File not found
	cmp.l	#$fffffffd,$1fc(a4)
	bne	ErrorHandler	;File not found
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	move.l	$10(a4),d0	;first datablock
TypeFile6:
	divu	#11,d0
	move.w	d0,d4		;d4=tracknr 0-159
	swap	d0
	move.w	d0,d5		;d5=sectornr 0-10
	move.b	$11c(a6),d0
	cmp.b	$124(a6),d0
	bne.s	TypeFile7
	cmp.b	$125(a6),d4
	beq.s	TypeFile8
TypeFile7:
	move.w	d4,d0
	moveq	#$02,d7
	cmp.w	#$009f,d0
	bhi	ErrorHandler		;Load error
	bsr	ReadTrack
TypeFile8:
	ext.w	d5
	ext.l	d5
	lsl.w	#8,d5
	add.w	d5,d5
	move.l	$120(a6),a1
	add.l	d5,a1
	move.l	$0c(a1),d1		;Block length
	beq.s	TypeFile11
	move.l	$10(a1),d6		;Next block
	lea	$18(a1),a1		;Start of data
TypeFile9:
	tst.w	$5e(a6)			;Start of Line
	bne.s	TypeFile10
	bsr	WaitIfCtrl
	jsr	_LVOReadKeyboard(a6)
	cmp.b	#$1b,d0
	beq.s	TypeFile12
TypeFile10:
	move.b	(a1)+,d0
	jsr	_LVOWriteChar(a6)
	subq.w	#1,d1
	bne.s	TypeFile9	
TypeFile11:
	move.l	d6,d0
	tst.l	d0
	bne	TypeFile6
TypeFile12:
	tst.w	$5e(a6)
	beq.s	TypeFile13
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
TypeFile13:
	movem.l	(a7)+,a0-a6/d1-d7
	rts

DeleteFile:			;a0=filename
	movem.l	d1/d5-d7/a0/a3/a4/a6,-(a7)
	move.l	a0,a3
	move.b	$11d(a6),$11c(a6)
	move.l	$7e(a6),a4		;Rootblock
DeleteFile1:
	move.b	(a3)+,d0
	beq.s	DeleteFile3	;FileName
	cmp.b	#'/',d0
	beq.s	DeleteFile2	;Directory
	cmp.b	#':',d0
	bne.s	DeleteFile1	;Drive
	move.b	-2(a3),d0
	and.b	#$03,d0
	move.b	d0,$11c(a6)
	move.l	$7a(a6),a4
	move.l	a4,a0
	move.w	#$0370,d0
	bsr	ReadBlock
	move.l	a3,a0
	bra.s	DeleteFile1
DeleteFile2:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$05,d7
	tst.l	d0
	bmi	ErrorHandler	;Directory not found
	move.l	a3,a0
	bra.s	DeleteFile1
DeleteFile3:
	bsr	CheckRootBlock
	move.l	a3,d0
	sub.l	a0,d0
	subq.l	#1,d0
	bsr	SearchHash
	moveq	#$04,d7
	tst.l	d0
	bmi	ErrorHandler	;File/Directory not found
	bra.s	DeleteFile3b
DeleteFile3a:			;Entry from SaveFile module
	movem.l	d1/d5-d7/a0/a3/a4/a6,-(a7)
DeleteFile3b:
	cmp.l	#$00000002,(a4)
	bne	ErrorHandler	;File/Directory not found
	bsr	ReadBamBlock
	move.l	d0,d5		;BamBlockNr
	move.l	$1f0(a4),d6	;Next Hash
DeleteFile4:
	move.l	$4(a4),d0
	bsr	FreeBlock
	cmp.l	#$00000002,$1fc(a4)
	bne	DeleteFile6	;Not Directory
	moveq	#$18,d0
	moveq	#$07,d7		;Directory not empty error
DeleteFile5:
	tst.l	0(a4,d0.w)
	bne	ErrorHandler
	addq.w	#4,d0
	cmp.w	#$138,d0
	bne.s	DeleteFile5
	bra.s	DeleteFile8
DeleteFile6:
	moveq	#$18,d1
DeleteFile7:
	move.l	0(a4,d1.w),d0
	bsr	FreeBlock
	addq.w	#4,d1
	cmp.w	#$138,d1
	bne.s	DeleteFile7
	move.l	$1f8(a4),d0
	beq.s	DeleteFile8
	move.l	a4,a0
	bsr	ReadBlock
	bra.s	DeleteFile4
DeleteFile8:
	move.l	$13e(a6),a0
	move.l	a0,d0
	bsr	CheckSumBamBlock
	move.l	d5,d0			;Write BamBlock
	bsr	WriteBlock
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	ReadBlock
	move.w	$13c(a6),d0
	move.l	d6,0(a4,d0.w)
	move.l	a4,d0
	bsr	CheckSumBlock
	move.l	a4,a0
	move.w	$13a(a6),d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,d1/d5-d7/a0/a3/a4/a6
	rts

CheckSumBlock:				;d0=address of block
	movem.l	d1/a0,-(a7)
	move.l	d0,a0
	clr.l	$14(a0)
	moveq	#$7f,d0
	moveq	#$00,d1
CheckSumBlock1:
	add.l	(a0)+,d1
	dbf	d0,CheckSumBlock1
	neg.l	d1
	move.l	d1,$fffffe14(a0)
	movem.l	(a7)+,d1/a0
	rts

CheckSumBootBlock:			;d0=adress of bootblock
	movem.l	d1/a0,-(a7)
	move.l	d0,a0
	clr.l	$4(a0)
	move.w	#$00ff,d0
	moveq	#$00,d1
	moveq	#$00,d2
CheckSumBootBlock1:
	add.l	(a0)+,d1
	addx.l	d2,d1
	dbf	d0,CheckSumBootBlock1
	not.l	d1
	move.l	d1,$fffffc04(a0)
	movem.l	(a7)+,d1/a0
	rts

CheckSumBamBlock:			;d0=adress of bamblock
	movem.l	d1/a0,-(a7)
	move.l	d0,a0
	clr.l	(a0)
	moveq	#$7f,d0
	moveq	#$00,d1
CheckSumBamBlock1:
	add.l	(a0)+,d1
	dbf	d0,CheckSumBamBlock1
	neg.l	d1
	move.l	d1,$fffffe00(a0)
	movem.l	(a7)+,d1/a0
	rts

GetFreeBlockI:				;Get Free DataBlock
					;d0=First Block To Search ($36f)
					;d0out=FreeBlockNr
	movem.l	d1-d3/a0/a6,-(a7)
	move.l	$13e(a6),a0
	ext.l	d0
GetFreeBlockI1:
	move.l	d0,d1
	subq.w	#2,d1
	move.l	d1,d2
	and.w	#$001f,d1
	lsr.w	#3,d2
	and.w	#$01fc,d2
	moveq	#$00,d3
	bset	d1,d3
	and.l	4(a0,d2.w),d3
	bne.s	GetFreeBlockI2
	cmp.w	#$0371,d0
	beq.s	GetFreeBlockI3
	subq.w	#1,d0
	cmp.w	#$0001,d0
	bne.s	GetFreeBlockI1
	move.w	#$06df,d0
	bra.s	GetFreeBlockI1
GetFreeBlockI2:
	moveq	#$ffffffff,d3
	bclr	d1,d3
	and.l	d3,4(a0,d2.w)
	movem.l	(a7)+,d1-d3/a0/a6
	rts
GetFreeBlockI3:
	moveq	#$ffffffff,d0		;Disk Full
	movem.l	(a7)+,d1-d3/a0/a6
	rts
	
GetFreeBlockII:				;Get Free InfoBlock
					;d0=First Block To Search ($371)
					;d0out=FreeBlockNr
	movem.l	d1-d3/a0/a6,-(a7)
	move.l	$13e(a6),a0
	ext.l	d0
GetFreeBlockII1:
	move.l	d0,d1
	subq.w	#2,d1
	move.l	d1,d2
	and.w	#$001f,d1
	lsr.w	#3,d2
	and.w	#$01fc,d2
	moveq	#$00,d3
	bset	d1,d3
	and.l	4(a0,d2.w),d3
	bne.s	GetFreeBlockII2
	addq.w	#1,d0
	cmp.w	#$0370,d0
	beq.s	GetFreeBlockII3
	cmp.w	#$06e0,d0
	bne.s	GetFreeBlockII1
	moveq	#$02,d0
	bra.s	GetFreeBlockII1
GetFreeBlockII2:
	moveq	#$ffffffff,d3
	bclr	d1,d3
	and.l	d3,4(a0,d2.w)
	movem.l	(a7)+,d1-d3/a0/a6
	rts
GetFreeBlockII3:
	moveq	#$ffffffff,d0		;Disk Full
	movem.l	(a7)+,d1-d3/a0/a6
	rts

FreeBlock:
					;d0=BlockNr to Free
	movem.l	d1-d3/a0/a6,-(a7)
	move.l	$13e(a6),a0
	ext.l	d0
	move.l	d0,d1
	subq.w	#2,d1
	move.l	d1,d2
	and.w	#$001f,d1
	lsr.w	#3,d2
	and.w	#$01fc,d2
	moveq	#$00,d3
	bset	d1,d3
	or.l	d3,4(a0,d2.w)
	movem.l	(a7)+,d1-d3/a0/a6
	rts

GetNumUsedBlock:
	movem.l	d1-d4/a0/a6,-(a7)
	move.l	$13e(a6),a0
	moveq	#$00,d4
	moveq	#$02,d0
GetNumUsedBlock1:
	ext.l	d0
	move.l	d0,d1
	subq.w	#2,d1
	move.l	d1,d2
	and.w	#$001f,d1
	lsr.w	#3,d2
	and.w	#$01fc,d2
	moveq	#$00,d3
	bset	d1,d3
	and.l	4(a0,d2.w),d3
	bne.s	GetNumUsedBlock2
	addq.l	#1,d4
GetNumUsedBlock2:
	addq.l	#1,d0
	cmp.w	#1760,d0
	bne.s	GetNumUsedBlock1
	move.l	d4,d0
	movem.l	(a7)+,d1-d4/a0/a6
	rts

ReadBamBlock:
	movem.l	a0/a6,-(a7)
	move.l	$13e(a6),a0
	move.w	#$0370,d0		;RootBlock
	bsr	ReadBlock
	moveq	#$06,d7
	cmp.l	#$ffffffff,$138(a0)
	bne	ErrorHandler		;Disk not validated error
	move.l	$13c(a0),d0
	move.l	$13e(a6),a0
	move.l	d0,-(a7)
	bsr	ReadBlock
	move.l	(a7)+,d0
	movem.l	(a7)+,a0/a6
	rts

DiskCopy:				;Copy Disk
	movem.l	d1-d5/a6,-(a7)
	move.l	d0,d4			;Source Drive
	move.l	d1,d5			;Destin Drive
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	move.l	#1000,d1
	moveq	#$00,d3
DiskCopy1:
	clr.w	$5e(a6)
	lea	DiskCopyText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d3,d0
	jsr	_LVOWriteDecNumberII(a6)
	jsr	_LVOClearToEOL(a6)
	move.b 	d4,$11c(a6)
	move.l	d3,d0
	bsr	ReadTrack
	clr.w	$5e(a6)
	lea	DiskCopyText2(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	d3,d0
	jsr	_LVOWriteDecNumberII(a6)
	jsr	_LVOClearToEOL(a6)
	move.b	d5,$11c(a6)
	move.l	d3,d0
	bsr	WriteTrack
	addq.w	#1,d3
	cmp.w	#$00a0,d3
	bne.s	DiskCopy1
	movem.l	(a7)+,d1-d5/a6
	rts

DiskCopyText1:
	dc.b	"* Reading Track ",0
DiskCopyText2:
	dc.b	"* Writing Track ",0
	even

FormatDisk:				;Format Disk
	movem.l	d1/a0-a2/a6,-(a7)
	move.l	d0,a2
	move.b	#$ff,$124(a6)
	move.l	$120(a6),a0		;Track buffer
	move.l	#$444f5300,d0
	move.w	#$057f,d1
FormatDisk1:
	move.l	d0,(a0)+
	addq.b	#1,d0
	dbf	d1,FormatDisk1
	moveq	#$0a,d0
	jsr	_LVOWriteChar(a6)
	moveq	#00,d0
	move.l	#1000,d1
FormatDisk2:
	move.l	d0,-(a7)
	clr.w	$5e(a6)
	lea	FormatDiskText1(pc),a0
	jsr	_LVOWriteString(a6)
	move.l	(a7),d0
	jsr	_LVOWriteDecNumberII(a6)
	jsr	_LVOClearToEOL(a6)
	move.l	(a7)+,d0
	bsr	WriteTrack		;Clean Track
	addq.w	#1,d0
	cmp.w	#$00a0,d0
	bne.s	FormatDisk2
	move.l	$7a(a6),a0		;Blockbuffert
	move.l	a0,a1		
	moveq	#$7f,d0
FormatDisk3:
	clr.l	(a1)+
	dbf	d0,FormatDisk3
	move.l	#$00000002,(a0)
	move.l	#$00000001,$1fc(a0)
	move.l	#$00000048,$c(a0)
	move.l	#$ffffffff,$138(a0)
	move.l	#$00000371,$13c(a0)
	lea	$1b1(a0),a1
	moveq	#$ffffffff,d1
FormatDisk4:
	addq.b	#1,d1
	move.b	(a2)+,(a1)+
	bne.s	FormatDisk4
	move.b	d1,$1b0(a0)
	move.l	a0,d0
	bsr	AttachDate
	move.l	$1a4(a0),$1e4(a0)
	move.l	$1a8(a0),$1e8(a0)
	move.l	$1ac(a0),$1ec(a0)
	move.l	a0,d0
	bsr	CheckSumBlock
	move.w	#$0370,d0
	bsr	WriteBlock
	move.l	$13e(a6),a0		;Bambuffert
	move.l	a0,a1
	moveq	#$37,d0
	moveq	#$ffffffff,d1
FormatDisk5:
	move.l	d1,(a1)+
	dbf	d0,FormatDisk5
	moveq	#$47,d0
FormatDisk6:
	clr.l	(a1)+
	dbf	d0,FormatDisk6
	move.l	#$ffff3fff,$70(a0)
	move.l	#$3fffffff,$dc(a0)
	move.l	a0,d0
	bsr	CheckSumBamBlock
	move.w	#$0371,d0
	bsr	WriteBlock
	bsr	WriteLastTrack
	movem.l	(a7)+,d1/a0-a2/a6
	rts

FormatDiskText1:
	dc.b	"* Formatting Track ",0
	even

*****************************************************************************
	
*****************************************************************************

ReadTrack:				;D0=tracknr
	movem.l	d0-d7/a0-a6,-(a7)
	lea	$dff000,a5
	move.b	#$ff,$124(a6)
	move.w	d0,d4
	move.w	d0,d6
	moveq	#$08,d5		;Number of tries
	bsr	MotorOn
	bsr	CheckHead
	bsr	MoveHead
	bra.s	ReadTrackAgain1
ReadTrackAgain:
	bsr	ClearDMADiskWait
	move.w	#$4000,$0024(a5)
	move.w	#$0010,$96(a5)
	bsr	ExchangeRamDiskII
	bsr	ResetHead
	move.w	d6,d4
	bsr	MoveHead
ReadTrackAgain1:
	moveq	#$02,d7
	subq.w	#1,d5
	bmi	ErrorHandler
	bsr	DiskTick
	moveq	#$09,d7
	btst	#2,$bfe001		;Disk in drive?
	beq	ErrorHandler
	bsr	ExchangeRamDiskI	;Copy from $50c0
	bsr	SelPrecomp
	bsr	MotorReady
	bsr	ClearDMADisk		;Clear DMA buffer
	move.w	#$8010,$96(a5)	;Disk DMA enable
	move.w	#$4489,$7e(a5)	;Disk Sync Word
	move.w	#$1f00,$9e(a5)
	move.w	#$9500,$9e(a5)	;Read on sync enable
	move.l	$82(a6),a0
	move.l	a0,$20(a5)	;DMA buffert
	move.w	#$4000,$24(a5)
	move.w	#$99a0,$24(a5)	;Read $3340 bytes
	move.w	#$99a0,$24(a5)
	move.w	#$0002,$9c(a5)
	move.w	#$0010,$126(a6)	;Motor off 0.32 sec
	lea	$2f00(a0),a1
	move.w	#$07ff,d7
ReadTrack1:
	tst.w	$126(a6)
	beq	ReadTrackAgain
	tst.w	(a0)
	beq.s	ReadTrack1
ReadTrack2:
	cmpa.l	a1,a0
	bhi	ReadTrackAgain		;Cant find All Sectors
ReadTrack2a:
	tst.w	$126(a6)
	beq	ReadTrackAgain
	tst.w	(a0)
	beq.s	ReadTrack2a
	cmp.w	#$4489,(a0)+
	bne.s	ReadTrack2
ReadTrack2b:
	tst.w	$126(a6)
	beq	ReadTrackAgain
	tst.w	(a0)
	beq.s	ReadTrack2b
	cmp.w	#$4489,(a0)
	beq.s	ReadTrack2
	moveq	#$00,d4
	moveq	#$01,d3
	moveq	#$04,d2
	bsr	ReadTrackByte
	cmp.b	d0,d6
	bne.s	ReadTrack2		;Wrong Track
	bsr.s	ReadTrackByte
	cmp.b	#$0a,d0
	bhi.s	ReadTrack2		;Invalid Sector nr
	ext.w	d0
	ext.l	d0
	move.l	d0,a3			;Sector nr
	lsl.w	#8,d0
	add.w	d0,d0
	move.l	$120(a6),a2
	add.l	d0,a2
	bsr.s	ReadTrackByte
	add.l	d2,a0
	moveq	#$0f,d3
	moveq	#$10,d2
	bsr.s	ReadTrackByte
	add.l	d2,a0
	moveq	#$03,d3
	moveq	#$04,d2
	bsr.s	ReadTrackByte
	add.l	d2,a0
	tst.b	d4
	bne.s	ReadTrack2		;Checksum error
	moveq	#$04,d2
	bsr.s	ReadTrackLong
	add.l	d2,a0
	moveq	#$7f,d3
	move.w	#$200,d2
	subq.l	#4,a2
	bsr	ReadTrackLong		;Read Data
	add.l	d2,a0
	tst.l	d4
	bne.s	ReadTrack2		;Checksum error
	move.l	a3,d0
	bclr	d0,d7
	tst.w	d7
	bne	ReadTrack2
	move.b	$11c(a6),$124(a6)
	move.b	d6,$125(a6)
	move.w	#$4000,$24(a5)
	move.w	#$0010,$96(a5)
	move.w	#$0032,$126(a5)		;Drive off 1.0 sec
	bsr	UnselectDrive
	bsr	ClearDMADiskWait
	bsr	ExchangeRamDiskII	;Copy to $50c0
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ReadTrackByte:
	tst.w	$126(a6)
	beq.s	ReadTrackByte1
	tst.b	0(a0,d2.w)
	beq.s	ReadTrackByte		;Wait for Disk DMA !
ReadTrackByte1:
	move.b	(a0)+,d0
	and.b	#$55,d0
	eor.b	d0,d4
	add.b	d0,d0
	move.b	-1(a0,d2.w),d1
	and.b	#$55,d1
	eor.b	d1,d4
	or.b	d1,d0
	subq.w	#1,d3
	bpl.s	ReadTrackByte
	rts

ReadTrackLong:
	tst.w	$126(a6)
	beq.s	ReadTrackLong1
	tst.w	2(a0,d2.w)
	beq.s	ReadTrackLong		;Wait for Disk DMA !
ReadTrackLong1:
	move.l	(a0)+,d0
	and.l	#$55555555,d0
	eor.l	d0,d4
	add.l	d0,d0
	move.l	-4(a0,d2.w),d1
	and.l	#$55555555,d1
	eor.l	d1,d4
	or.l	d1,d0
	move.l	d0,(a2)+
	subq.w	#1,d3
	bpl.s	ReadTrackLong
	rts

WriteLastTrack:
	movem.l	d0/a6,-(a7)
	cmp.w	#$1234,$138(a6)
	bne.s	WriteLastTrack1
	moveq	#$00,d0
	move.b	$125(a6),d0		;Buffer Track nr
	bsr.s	WriteTrack
WriteLastTrack1:
	movem.l	(a7)+,d0/a6
	rts

WriteTrack:				;D0=tracknr
	movem.l	d0-d7/a0-a6,-(a7)
	lea	$dff000,a5
	move.w	d0,d4
	move.w	d0,d6
	moveq	#$08,d5		;Number of tries
	bsr	MotorOn
	bsr	CheckHead
	bsr	MoveHead
	bra.s	WriteTrackAgain1
WriteTrackAgain:
	bsr	ClearDMADiskWait
	move.w	#$4000,$0024(a5)
	move.w	#$0010,$96(a5)
	bsr	ExchangeRamDiskII
	bsr	ResetHead
	move.w	d6,d4
	bsr	MoveHead
WriteTrackAgain1:
	moveq	#$02,d7
	subq.w	#1,d5			;Bad Disk ?
	bmi	ErrorHandler
	bsr	DiskTick
	moveq	#$09,d7
	btst	#2,$bfe001		;Disk in drive?
	beq	ErrorHandler
	moveq	#$03,d7
	btst	#3,$bfe001		;Disk WriteProtected ?
	beq	ErrorHandler
	bsr	ExchangeRamDiskI	;Copy from $50c0,clear DMA
	bsr	SelPrecomp
	bsr	MotorReady
	move.w	#$8010,$96(a5)	;Disk DMA enable
	move.w	#$4489,$7e(a5)	;Disk Sync Word
	move.w	#$1f00,$9e(a5)
	move.w	#$9100,$9e(a5)	;MFM|FAST enable
	move.w	#$4000,$24(a5)
	move.l	$82(a6),a0
	move.l	$120(a6),a2
	move.w	#$011e,d1
	move.l	#$aaaaaaaa,d2
WriteTrack1:
	move.l	d2,(a0)+
	dbf	d1,WriteTrack1
	move.l	$82(a6),$20(a5)	;DMA buffert
	move.w	#$d9a0,$24(a5)	;Write $3340 bytes
	move.w	#$d9a0,$24(a5)
	move.w	#$0002,$9c(a5)
	move.w	#$0010,$126(a6)	;Disk motor on 0.32 sec
	moveq	#$00,d7
WriteTrack2:
	move.l	a0,a1
	move.l	#$aaaaaaaa,(a0)+
	move.l	#$44894489,(a0)+
	move.w	#$ff00,d0		;Format byte
	or.b	d6,d0			;Track nr
	swap	d0
	move.b	d7,d0			;Sector nr
	lsl.w	#8,d0
	move.b	#$0b,d0
	sub.b	d7,d0			;Sector interleave
	moveq	#$04,d2
	moveq	#$00,d3
	moveq	#$00,d4
	bsr	WriteTrackLongII
	add.l	d2,a0
	moveq	#$10,d2
	moveq	#$00,d0
	bsr	WriteTrackLongII
	moveq	#$00,d0
	bsr	WriteTrackLongII
	moveq	#$00,d0
	bsr	WriteTrackLongII
	moveq	#$00,d0
	bsr	WriteTrackLongII
	bsr	CheckTrackLongBits
	add.l	d2,a0
	move.l	d4,d0
	and.l	#$55555555,d0
	moveq	#$04,d2
	bsr	WriteTrackLongII
	add.l	d2,a0
	addq.l	#8,a0
	move.w	#$0200,d2
	moveq	#$7f,d3
	moveq	#$00,d4
	bsr	WriteTrackLong
	bsr	CheckTrackLongBits
	lea	$38(a1),a0
	move.l	d4,d0
	and.l	#$55555555,d0
	moveq	#$04,d2
	bsr	WriteTrackLongII	;Data CheckSum
	add.l	d2,a0
	bsr	CheckTrackLongBits
	lea	$440(a1),a0
	addq.w	#1,d7
	cmp.w	#$000b,d7
	bne	WriteTrack2
	move.l	#$aaaaaaaa,(a0)
	bsr	CheckTrackLongBits
WriteTrack3:
	tst.w	$126(a6)
	beq	WriteTrackAgain
	btst	#1,$1f(a5)
	beq.s	WriteTrack3
	move.w	#$4000,$24(a5)
	move.w	#$9500,$9e(a5)	;Read on sync enable
	bsr	ClearDMADisk	;Clear DMA buffert
	move.l	$82(a6),a0
	move.l	a0,$20(a5)	;DMA buffert
	move.w	#$99a0,$24(a5)	;Read $3340 bytes
	move.w	#$99a0,$24(a5)
	move.w	#$0002,$9c(a5)
	move.w	#$0010,$126(a6)	;Drive off 0.32 sec
	lea	$2f00(a0),a1
	move.w	#$07ff,d7
WriteTrack4:
	tst.w	$126(a6)
	beq	WriteTrackAgain
	tst.w	(a0)
	beq.s	WriteTrack4
WriteTrack5:
	cmpa.l	a1,a0
	bhi	WriteTrackAgain		;Something doesn't match
WriteTrack5a:
	tst.w	$126(a6)
	beq	WriteTrackAgain
	tst.w	(a0)
	beq.s	WriteTrack5a
	cmp.w	#$4489,(a0)+
	bne.s	WriteTrack5
WriteTrack5b:
	tst.w	$126(a6)
	beq	WriteTrackAgain
	tst.w	(a0)
	beq.s	WriteTrack5b
	cmp.w	#$4489,(a0)
	beq.s	WriteTrack5
	moveq	#$00,d4
	moveq	#$01,d3
	moveq	#$04,d2
	bsr	ReadTrackByte
	cmp.b	d0,d6
	bne.s	WriteTrack5		;Wrong Track
	bsr	ReadTrackByte
	cmp.b	#$0a,d0
	bhi.s	WriteTrack5		;Invalid Sector nr
	ext.w	d0
	ext.l	d0
	move.l	d0,a3			;Sector nr
	lsl.w	#8,d0
	add.w	d0,d0
	move.l	$120(a6),a2
	add.l	d0,a2
	bsr	ReadTrackByte
	add.l	d2,a0
	moveq	#$0f,d3
	moveq	#$10,d2
	bsr	ReadTrackByte
	add.l	d2,a0
	moveq	#$03,d3
	moveq	#$04,d2
	bsr	ReadTrackByte
	add.l	d2,a0
	tst.b	d4
	bne.s	WriteTrack5		;Checksum error
	moveq	#$04,d2
WriteTrack6:
	tst.w	$126(a6)
	beq.s	WriteTrack6a
	tst.w	2(a0,d2.w)
	beq.s	WriteTrack6		;Wait for Disk DMA !
WriteTrack6a:
	move.l	(a0)+,d0
	and.l	#$55555555,d0
	eor.l	d0,d4
	add.l	d0,d0
	move.l	-4(a0,d2.w),d1
	and.l	#$55555555,d1
	eor.l	d1,d4
	add.l	d2,a0
	moveq	#$7f,d3
	move.w	#$200,d2
WriteTrack7:
	tst.w	$126(a6)
	beq.s	WriteTrack7a
	tst.w	2(a0,d2.w)
	beq.s	WriteTrack7		;Wait for Disk DMA !
WriteTrack7a:
	move.l	(a0)+,d0
	and.l	#$55555555,d0
	eor.l	d0,d4
	add.l	d0,d0
	move.l	-4(a0,d2.w),d1
	and.l	#$55555555,d1
	eor.l	d1,d4
	or.l	d1,d0
	cmp.l	(a2)+,d0
	bne	WriteTrack5		;Verify Error !
	subq.w	#1,d3
	bpl.s	WriteTrack7
	add.l	d2,a0
	tst.l	d4
	bne	WriteTrack5		;Checksum error
	move.l	a3,d0
	bclr	d0,d7
	tst.w	d7
	bne	WriteTrack5
	clr.w	$138(a6)		;Track Buffer Written !
	move.w	#$4000,$24(a5)
	move.w	#$0010,$96(a5)
	move.w	#$0032,$126(a6)		;Drive off 1.0 sec
	bsr	UnselectDrive
	bsr	ClearDMADiskWait
	bsr	ExchangeRamDiskII	;Copy to $50c0
	movem.l	(a7)+,d0-d7/a0-a6
	rts

WriteTrackLongII:
	movem.l	d5-d7,-(a7)
	move.l	#$55555555,d7
	bra.s	WriteTrackLong1a
WriteTrackLong:
	movem.l	d5-d7,-(a7)
	move.l	#$55555555,d7
WriteTrackLong1:
	move.l	(a2)+,d0
WriteTrackLong1a:
	move.l	d0,d1
	lsr.l	#1,d0
	and.l	d7,d0
	and.l	d7,d1
	move.l	d0,d6
	eor.l	d7,d6
	move.l	d6,d5
	add.l	d6,d6
	lsr.l	#1,d5
	btst	#0,-1(a0)
	bne.s	WriteTrackLong2
	bset	#31,d5
WriteTrackLong2:
	and.l	d5,d6
	or.l	d6,d0
	move.l	d0,(a0)+
	move.l	d1,d6
	eor.l	d7,d6
	move.l	d6,d5
	add.l	d6,d6
	lsr.l	#1,d5
	btst	#0,-5(a0,d2.w)
	bne.s	WriteTrackLong3
	bset	#31,d5
WriteTrackLong3:
	and.l	d5,d6
	or.l	d6,d1
	move.l	d1,-4(a0,d2.w)
	eor.l	d0,d4
	eor.l	d1,d4
	subq.w	#1,d3
	bpl.s	WriteTrackLong1
	movem.l	(a7)+,d5-d7
	rts

CheckTrackLongBits:
	movem.l	d5-d7,-(a7)
	move.l	#$55555555,d7
	move.l	(a0),d0
	and.l	d7,d0
	move.l	d0,d6
	eor.l	d7,d6
	move.l	d6,d5
	add.l	d6,d6
	lsr.l	#1,d5
	btst	#0,-1(a0)
	bne.s	CheckTrackLongBits1
	bset	#31,d5
CheckTrackLongBits1:
	and.l	d5,d6
	or.l	d6,d0
	move.l	d0,(a0)
	movem.l	(a7)+,d5-d7
	rts

ExchangeRamDiskI:			;Move $5400 to buffert
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	$82(a6),a0
	move.l	$86(a6),a1
	add.l	a0,a1
	move.w	#$0199,d0
ExchangeRamDiskI1:
	movem.l	(a0)+,d1/d2/d3/d4/d5/d6/d7/a2
	movem.l	d1/d2/d3/d4/d5/d6/d7/a2,(a1)
	lea	$0020(a1),a1
	dbf	d0,ExchangeRamDiskI1
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ClearDMADisk:
	movem.l	a5/a6,-(a7)
	move.w	#$0400,$96(a5)
	move.w	#$8040,$96(a5)
	move.l	$82(a6),$54(a5)		;Clear DMA buffert
	move.l	#$01000000,$40(a5)
	clr.w	$66(a5)
	move.w	#$3360,$58(a5)
	movem.l	(a7)+,a5/a6
	rts
ClearDMADiskWait:
	move.l	a5,-(a7)
	lea	$dff000,a5
ClearDMADiskWait1:
	btst	#6,$02(a5)
	bne.s	ClearDMADiskWait1
	move.w	#$0040,$96(a5)
	move.l	(a7)+,a5
	rts
	
ExchangeRamDiskII:			;Move buffert to $5400
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	$82(a6),a0
	move.l	$86(a6),a1
	add.l	a0,a1
	move.w	#$0199,d0
ExchangeRamDiskII1:
	movem.l	(a1)+,d1/d2/d3/d4/d5/d6/d7/a2
	movem.l	d1/d2/d3/d4/d5/d6/d7/a2,(a0)
	lea	$0020(a0),a0
	dbf	d0,ExchangeRamDiskII1
	movem.l	(a7)+,d0-d7/a0-a6
	rts

UnselectDrive:
	movem.l	d0/a5/a6,-(a7)
	lea	$bfd100,a5
	move.b	$11c(a6),d0		;Current drive nr
	and.w	#$03,d0
	addq.w	#3,d0
	bset	d0,(a5)
	movem.l	(a7)+,d0/a5/a6
	rts

MotorOn:
	movem.l	d0/d1/d7/a5/a6,-(a7)
	move.w	$126(a6),d1
	lea	$bfd100,a5
	move.b	$11c(a6),d0		;Current drive nr
	and.w	#$03,d0
	addq.w	#3,d0
	or.b	#$78,(a5)
	bclr	#7,(a5)
	bclr	d0,(a5)
	move.w	#$004b,$126(a6)		;Drive motor off 1.5 sec
	movem.l	(a7)+,d0/d1/d7/a5/a6
	rts

MotorReady:
	movem.l	d0/d1/d7/a5/a6,-(a7)
	moveq	#$01,d7			;Disk not present
	move.l	#$20000,d1
MotorReady1:
	subq.l	#1,d1
	beq	ErrorHandler
	btst	#5,$bfe001
	bne.s	MotorReady1
	move.w	#$004b,$126(a6)		;Drive motor off 1.5 sec
	movem.l	(a7)+,d0/d1/d7/a5/a6
	rts

MotorOff:
	movem.l	d0/a5,-(a7)
	lea	$bfd100,a5
	or.b	#$78,(a5)
	bset	#7,(a5)
	and.b	#$87,(a5)
	or.b	#$78,(a5)
	movem.l	(a7)+,d0/a5
	rts

CheckHead:
	movem.l	d1-d3/a4-a6,-(a7)
	lea	$bfe001,a4
	lea	$bfd100,a5
	move.b	$11c(a6),d1		;Current drive nr
	and.w	#$0003,d1
	move.w	d1,d2
	add.w	#$118,d2
	tst.b	0(a6,d2.w)
	bne.s	CheckHead1
	addq.w	#3,d1
	move.b	#$78,d3
	bclr	d1,d3
	or.b	d3,(a5)
	bclr	d1,(a5)
	btst	#4,(a4)
	beq.s	CheckHead1
	bsr.s	ResetHead
CheckHead1:
	movem.l	(a7)+,d1-d3/a4-a6
	rts
	
ResetHead:
	movem.l	d1-d3/a4-a6,-(a7)
	lea	$bfe001,a4
	lea	$bfd100,a5
	move.b	$11c(a6),d1		;Current drive nr
	and.w	#$0003,d1
	move.w	d1,d2
	add.w	#$118,d2
	clr.b	0(a6,d2.w)
	addq.w	#3,d1
	bclr	d1,(a5)
	moveq	#$53,d2
	btst	#4,(a4)
	beq.s	ResetHead6
ResetHead3:
	move.b	(a5),d3
	btst	#4,(a4)
	beq.s	ResetHead5
	bset	#1,(a5)
	bclr	#0,(a5)
	bset	#0,(a5)
	bsr	DiskWaitI
	btst	#1,d3
	bne.s	ResetHead4
	bsr	DiskWaitII		;reversing direction
ResetHead4:
	dbf	d2,ResetHead3
	bset	d1,(a5)
	moveq	#$01,d7			;Device not present
	bra	ErrorHandler
ResetHead5:
	bsr	DiskWaitII		;head settle
ResetHead6:
	movem.l	(a7)+,d1-d3/a4-a6
	rts

DiskCheck:
	movem.l	d0-d2/a4-a6,-(a7)
	lea	$bfd100,a5
	lea	$bfe001,a4
	tst.w	$126(a6)
	bpl.s	DiskCheck1b		;Drive Active
	moveq	#$03,d0
DiskCheck1:
	bsr.s	DiskCheck2
	dbf	d0,DiskCheck1
DiskCheck1b:
	tst.w	$126(a6)
	bmi.s	DiskCheck1a
	subq.w	#1,$126(a6)
	bpl.s	DiskCheck1a
	move.b	(a5),d0
	and.b	#$78,d0
	cmp.b	#$78,d0
	beq.s	DiskCheck1c
	addq.w	#1,$126(a6)		;Drive is selected
	bra.s	DiskCheck1a
DiskCheck1c:
	bsr	MotorOff
DiskCheck1a:
	movem.l	(a7)+,d0-d2/a4-a6
	rts
DiskCheck2:
	move.b	(a5),d1
	and.b	#$78,d1
	cmp.b	#$78,d1
	bne.s	DiskCheck6		;Drive Active
	move.l	d0,d1
	addq.l	#3,d1
	bclr	d1,(a5)
	btst	#2,(a4)
	bne.s	DiskCheck5		;Disk inserted
	cmp.b	$11d(a6),d0	;Rootblock unit
	bne.s	DiskCheck4
	move.w	#$ffff,$11e(a6)	;Rootblock not read
DiskCheck4:
	cmp.b	$124(a6),d0
	bne.s	DiskCheck5
	move.b	#$ff,$125(a6)	;Track buffer empty
DiskCheck5:
	bset	d1,(a5)
DiskCheck6:
	rts

DiskWaitI:			;Wait for 3 milliseconds
	move.l	d0,-(a7)	;Called when stepping head
	move.w	#$0850,d0
	bsr.s	WaitTimer
	bra.s	DiskWait1
DiskWaitII:			;Wait for 15 milliseconds
	move.l	d0,-(a7)	;Called when reversing directions
	move.w	#$2990,d0
	bsr.s	WaitTimer
	bra.s	DiskWait1
DiskWaitIII:			;Wait for 100 microseconds
	move.l	d0,-(a7)	;Called when selecting diskside
	move.w	#$0047,d0	;before writing
	bsr.s	WaitTimer
DiskWait1:
	move.l	(a7)+,d0
	rts

WaitTimer				;d0=number of E cycles
	and.w	#$fffe,ccs_CIATimers(a6)
	move.b	d0,$bfd400		;Timer A Low
	lsr.w	#8,d0
	move.b	d0,$bfd500		;Timer A High
	and.b	#$fe,ccs_CIABIRQReq(a6)
	or.b	#$01,ccs_CIABIRQEna(a6)
	move.b	#$81,$bfdd00		;Timer A IRQ Enable
	move.b	#$11,$bfde00		;Timer A Load & Start
.1
	move.w	ccs_CIATimers(a6),d0
	and.w	#$0001,d0
	beq.s	.1
	rts

SelPrecomp
	movem.l	d0-d1/a4-a5,-(a7)
	lea	$dff000,a5
	lea	ccs_DiskDev(a6),a4
	move.b	db_CurrentUnit(a4),d1
	ext.w	d1
	move.b	db_Drive0Track(a4,d1.w),d1
	move.w	#$8000,d0
	cmp.b	#79,d1
	bls.s	.1
	move.w	#$a000,d0
	cmp.b	#159,d1
	bls.s	.1
	move.w	#$c000,d0
	cmp.b	#239,d1
	bls.s	.1
	move.w	#$e000,d0
.1
	move.w	d0,$9e(a5)
	movem.l	(a7)+,d0-d1/a4-a5
	rts

MoveHead
	movem.l	d0-d4/a5/a4,-(a7)	;d4 = tracknr
	lea	$bfd100,a5
	lea	ccs_DiskDev(a6),a4
	move.b	db_CurrentUnit(a4),d1
	ext.w	d1
	move.w	d1,d2
	addq.w	#3,d1
	move.b	db_Drive0Track(a4,d2.w),d3
	move.b	d4,db_Drive0Track(a4,d2.w)
	and.w	#$00fe,d3
	and.w	#$00fe,d4
	bclr	d1,(a5)
	bset	#2,(a5)
	btst	#0,db_Drive0Track(a4,d2.w)
	beq.s	.0
	bclr	#2,(a5)	
.0
	bsr	DiskWaitIII
	cmp.b	d3,d4
	beq.s	.4
.1
	move.b	(a5),d0
	cmp.b	d3,d4
	beq.s	.3
	bls.s	.2
	bclr	#1,(a5)		;move forward
	bclr	#0,(a5)
	bset	#0,(a5)
	bsr	DiskWaitI
	addq.w	#2,d3
	btst	#1,d0
	beq.s	.1
	bsr	DiskWaitII	;reversing direction
	bra.s	.1
.2
	bset	#1,(a5)		;move backward
	bclr	#0,(a5)
	bset	#0,(a5)
	bsr	DiskWaitI
	subq.w	#2,d3
	btst	#1,d0
	bne.s	.1
	bsr	DiskWaitII	;reversing direction
	bra.s	.1
.3
	bsr	DiskWaitII	;head settle
.4
	movem.l	(a7)+,d0-d4/a5/a4
	rts

DiskTick
	movem.l	d0-d2/a5/a4,-(a7)
	btst	#2,$bfe001
	bne.s	.2		;Disk Inserted
	lea	$bfd100,a5
	lea	ccs_DiskDev(a6),a4
	move.b	db_CurrentUnit(a4),d1
	ext.w	d1
	addq.w	#3,d1
	bclr	d1,(a5)
	move.b	(a5),d0
	bset	#1,(a5)		;move backward
	bclr	#0,(a5)
	bset	#0,(a5)
	bsr	DiskWaitI
	btst	#1,d0
	bne.s	.1
	bsr	DiskWaitII	;reversing direction
.1
	bclr	#1,(a5)		;move forward
	bclr	#0,(a5)
	bset	#0,(a5)
	bsr	DiskWaitI
	bsr	DiskWaitII	;reversing direction
	bsr	DiskWaitII	;head settle
.2
	movem.l	(a7)+,d0-d2/a5/a4
	rts

CheckWriteProt
	movem.l	d1/d3/a3-a5,-(a7)
	lea	$bfe001,a3
	lea	$bfd100,a5
	lea	ccs_DiskDev(a6),a4
	move.b	db_CurrentUnit(a4),d1
	addq.w	#3,d1
	move.b	#$78,d3
	bclr	d1,d3
	or.b	d3,(a5)
	bclr	d1,(a5)
	moveq	#$01,d0
	btst	#3,(a3)
	beq.s	.1
	moveq	#$00,d0
.1
	bset	d1,(a5)
	movem.l	(a7)+,d1/d3/a3-a5
	rts

*****************************************************************************

ErrorHandler:
	bsr	UnselectDrive
	lea	CCSLibBase,a6
	move.l	ccs_ErrorHandler(a6),a0
	jmp	(a0)
ErrorHandler0:
	moveq	#$0d,d0
	jsr	_LVOWriteChar(a6)
	move.l	ccs_StackBase(a6),a7
	lea	Errortext(pc),a0
ErrorHandler1:
	move.b	(a0)+,d0
	cmp.b	#$ff,d0
	beq	ErrorHandler4
	cmp.b	d7,d0
	beq	ErrorHandler3
ErrorHandler2:
	tst.b	(a0)+
	bne.s	ErrorHandler2
	bra.s	ErrorHandler1
ErrorHandler3:
	jsr	_LVOWriteString(a6)
	lea	ccs_ScreenDev(a6),a4
	clr.w	sb_CursorX(a4)
ErrorHandler4:
	lea	ErrorHandler3(pc),a0
	add.l	#Loop-ErrorHandler3,a0
	jmp	(a0)

Errortext:
	dc.b	$01,"* Drive not present error.",0
	dc.b	$02,"* Bad disk error.",0
	dc.b	$03,"* Disk writeprotected error.",0
	dc.b	$04,"* File not found error.",0
	dc.b	$05,"* Directory not found error.",0
	dc.b	$06,"* Disk not validated error.",0
	dc.b	$07,"* Directory not empty error.",0
	dc.b	$08,"* Disk is full error.",0
	dc.b	$09,"* No disk in drive error.",0
	dc.b	$0a,"* File already exists error.",0
	dc.b	$0b,"* Can't rename to another disk error.",0
	dc.b	$0c,"* File is not an object module error.",0
	dc.b	$0d,"* Can't access word at odd adress error.",0
	dc.b	$0e,"* No workbuffer specified error.",0
	dc.b	$0f,"* Workbuffer too small error.",0
	dc.b	$ff
	even

*****************************************************************************

AssemblerCodes:
ac0:
	dc.w	ac1-8-ac0
	dc.w	ac23-8-ac0
	dc.w	ac24-8-ac0
	dc.w	ac24-8-ac0

	dc.w	ac27-8-ac0
	dc.w	ac59-8-ac0
	dc.w	ac63-8-ac0
	dc.w	ac66-8-ac0

	dc.w	ac67-8-ac0
	dc.w	ac73-8-ac0
	dc.w	ac122-8-ac0
	dc.w	ac78-8-ac0

	dc.w	ac83-8-ac0
	dc.w	ac93-8-ac0
	dc.w	ac98-8-ac0
	dc.w	ac122-8-ac0

	dc.w	%1111111100000000,%0000000000000000
	dc.w	$0800,$01fd
ac1:	dc.b	ac2-ac1-9
	dc.b	"ORI.s"
	dc.b	$80,$84
	even
	dc.w	%1111111111111111,%0000000000111100
	dc.w	$0800,$2000
ac2:	dc.b	ac3-ac2-9
	dc.b	"ORI.b"
	dc.b	$8c
	even
	dc.w	%1111111111111111,%0000000001111100
	dc.w	$0800,$4000
ac3:	dc.b	ac4-ac3-9
	dc.b	"ORI.w"
	dc.b	$8d
	even
	dc.w	%1111000111000000,%0000000100000000
	dc.w	$0001,$07fd
ac4:	dc.b	ac5-ac4-9
	dc.b	"BTST"
	dc.b	$88,$84
	even	
	dc.w	%1111000111000000,%0000000101000000
	dc.w	$0001,$01fd
ac5:	dc.b	ac6-ac5-9
	dc.b	"BCHG"
	dc.b	$88,$84
	even
	dc.w	%1111000111000000,%0000000110000000
	dc.w	$0001,$01fd
ac6:	dc.b	ac7-ac6-9
	dc.b	"BCLR"
	dc.b	$88,$84
	even
	dc.w	%1111000111000000,%0000000111000000
	dc.w	$0001,$01fd
ac7:	dc.b	ac8-ac7-9
	dc.b	"BSET"
	dc.b	$88,$84
	even
	dc.w	%1111000110111000,%0000000100001000
	dc.w	$0020,$0001
ac8:	dc.b	ac9-ac8-9
	dc.b	"MOVEP.s"
	dc.b	$89,$81,$86
	even
	dc.w	%1111000110111000,%0000000110001000
	dc.w	$0001,$0020
ac9:	dc.b	ac10-ac9-9
	dc.b	"MOVEP.s"
	dc.b	$88,$81,$87
	even
	dc.w	%1111111100000000,%0000001000000000
	dc.w	$0800,$01fd
ac10:	dc.b	ac11-ac10-9
	dc.b	"ANDI.s"
	dc.b	$80,$84
	even
	dc.w	%1111111111111111,%0000001000111100
	dc.w	$0800,$2000
ac11:	dc.b	ac12-ac11-9
	dc.b	"ANDI.b"
	dc.b	$8c
	even
	dc.w	%1111111111111111,%0000001001111100
	dc.w	$0800,$4000
ac12:	dc.b	ac13-ac12-9
	dc.b	"ANDI.w"
	dc.b	$8d
	even
	dc.w	%1111111100000000,%0000010000000000
	dc.w	$0800,$01fd
ac13:	dc.b	ac14-ac13-9
	dc.b	"SUBI.s"
	dc.b	$80,$84
	even
	dc.w	%1111111100000000,%0000011000000000
	dc.w	$0800,$01fd
ac14:	dc.b	ac15-ac14-9
	dc.b	"ADDI.s"
	dc.b	$80,$84
	even
	dc.w	%1111111111000000,%0000100000000000
	dc.w	$0800,$07fd
ac15:	dc.b	ac16-ac15-9
	dc.b	"BTST"
	dc.b	$84,$90
	even
	dc.w	%1111111111000000,%0000100001000000
	dc.w	$0800,$01fd
ac16:	dc.b	ac17-ac16-9
	dc.b	"BCHG"
	dc.b	$84,$90
	even
	dc.w	%1111111111000000,%0000100010000000
	dc.w	$0800,$01fd
ac17:	dc.b	ac18-ac17-9
	dc.b	"BCLR"
	dc.b	$84,$90
	even
	dc.w	%1111111111000000,%0000100011000000
	dc.w	$0800,$01fd
ac18:	dc.b	ac19-ac18-9
	dc.b	"BSET"
	dc.b	$84,$90
	even
	dc.w	%1111111100000000,%0000101000000000
	dc.w	$0800,$01fd
ac19:	dc.b	ac20-ac19-9
	dc.b	"EORI.s"
	dc.b	$80,$84
	even
	dc.w	%1111111111111111,%0000101000111100
	dc.w	$0800,$2000
ac20:	dc.b	ac21-ac20-9
	dc.b	"EORI.b"
	dc.b	$8c
	even
	dc.w	%1111111111111111,%0000101001111100
	dc.w	$0800,$4000
ac21:	dc.b	ac22-ac21-9
	dc.b	"EORI.w"
	dc.b	$8d
	even
	dc.w	%1111111100000000,%0000110000000000
	dc.w	$0800,$01fd
ac22:	dc.b	ac23-ac22-9
	dc.b	"CMPI.s"
	dc.b	$80,$84
	even
	dc.w	%1111000000000000,%0001000000000000
	dc.w	$0ffd,$01fd
ac23:	dc.b	ac24-ac23-9
	dc.b	"MOVE.B"
	dc.b	$85,$83,$8c
	even
	dc.w	%1110000111000000,%0010000001000000
	dc.w	$0fff,$0002
ac24:	dc.b	ac25-ac24-9
	dc.b	"MOVEA.s"
	dc.b	$82,$87,$83
	even
	dc.w	%1111000000000000,%0010000000000000
	dc.w	$0fff,$01fd
ac25:	dc.b	ac26-ac25-9
	dc.b	"MOVE.L"
	dc.b	$85,$83,$8f
	even
	dc.w	%1111000000000000,%0011000000000000
	dc.w	$0fff,$01fd
ac26:	dc.b	ac27-ac26-9
	dc.b	"MOVE.W"
	dc.b	$85,$83,$8d
	even
	dc.w	%1111111100000000,%0100000000000000
	dc.w	$01fd,$0000
ac27:	dc.b	ac28-ac27-9
	dc.b	"NEGX.s"
	dc.b	$80,$83
	even
	dc.w	%1111111111000000,%0100000011000000
	dc.w	$4000,$01fd
ac28:	dc.b	ac29-ac28-9
	dc.b	"MOVE.W"
	dc.b	$84,$8d
	even
	dc.w	%1111000101000000,%0100000100000000
	dc.w	$0ffd,$0001
ac29:	dc.b	ac30-ac29-9
	dc.b	"CHK.s"
	dc.b	$89,$82,$83
	even
	dc.w	%1111000111000000,%0100000111000000
	dc.w	$07e4,$0002
ac30:	dc.b	ac31-ac30-9
	dc.b	"LEA"
	dc.b	$87,$83
	even
	dc.w	%1111111100000000,%0100001000000000
	dc.w	$01fd,$0000
ac31:	dc.b	ac32-ac31-9
	dc.b	"CLR.s"
	dc.b	$80,$83
	even
	dc.w	%1111111100000000,%0100010000000000
	dc.w	$01fd,$0000
ac32:	dc.b	ac33-ac32-9
	dc.b	"NEG.s"
	dc.b	$80,$83
	even
	dc.w	%1111111111000000,%0100010011000000
	dc.w	$0ffd,$2000
ac33:	dc.b	ac34-ac33-9
	dc.b	"MOVE.w"
	dc.b	$83,$8d
	even
	dc.w	%1111111100000000,%0100011000000000
	dc.w	$01fd,$0000
ac34:	dc.b	ac35-ac34-9
	dc.b	"NOT.s"
	dc.b	$80,$83
	even
	dc.w	%1111111111000000,%0100011011000000
	dc.w	$0ffd,$4000
ac35:	dc.b	ac36-ac35-9
	dc.b	"MOVE.w"
	dc.b	$83,$8d
	even
	dc.w	%1111111111000000,%0100100000000000
	dc.w	$01fd,$0000
ac36:	dc.b	ac37-ac36-9
	dc.b	"NBCD"
	dc.b	$83
	even
	dc.w	%1111111111111000,%0100100001000000
	dc.w	$0001,$0000
ac37:	dc.b	ac38-ac37-9
	dc.b	"SWAP"
	dc.b	$88
	even
	dc.w	%1111111111000000,%0100100001000000
	dc.w	$07e4,$0000
ac38:	dc.b	ac39-ac38-9
	dc.b	"PEA"
	dc.b	$83
	even
	dc.w	%1111111110111000,%0100100010000000
	dc.w	$0001,$0000
ac39:	dc.b	ac40-ac39-9
	dc.b	"EXT.s"
	dc.b	$81,$88
	even
	dc.w	%1111111110000000,%0100100010000000
	dc.w	$8003,$01f4
ac40:	dc.b	ac41-ac40-9
	dc.b	"MOVEM.s"
	dc.b	$81,$84,$9a
	even
	dc.w	%1111111110000000,%0100110010000000
	dc.w	$07ec,$8003
ac41:	dc.b	ac42-ac41-9
	dc.b	"MOVEM.s"
	dc.b	$81,$83,$9b
	even
	dc.w	%1111111100000000,%0100101000000000
	dc.w	$01fd,$0000
ac42:	dc.b	ac43-ac42-9
	dc.b	"TST.s"
	dc.b	$80,$83
	even
	dc.w	%1111111111000000,%0100101011000000
	dc.w	$01fd,$0000
ac43:	dc.b	ac44-ac43-9
	dc.b	"TAS"
	dc.b	$83
	even
	dc.w	%1111111111111111,%0100101011111100
	dc.w	$0000,$0000
ac44:	dc.b	ac45-ac44-9
	dc.b	"ILLEGAL"

	even
	dc.w	%1111111111110000,%0100111001000000
	dc.w	$1000,$0000
ac45:	dc.b	ac46-ac45-9
	dc.b	"TRAP"
	dc.b	$99
	even
	dc.w	%1111111111111000,%0100111001010000
	dc.w	$0002,$0800
ac46:	dc.b	ac47-ac46-9
	dc.b	"LINK.w"
	dc.b	$86,$8d
	even
	dc.w	%1111111111111000,%0100111001011000
	dc.w	$0002,$0000
ac47:	dc.b	ac48-ac47-9
	dc.b	"UNLK"
	dc.b	$86
	even
	dc.w	%1111111111111000,%0100111001100000
	dc.w	$0002,$8002
ac48:	dc.b	ac49-ac48-9
	dc.b	"MOVE"
	dc.b	$86
	even
	dc.w	%1111111111111000,%0100111001101000
	dc.w	$8002,$0002
ac49:	dc.b	ac50-ac49-9
	dc.b	"MOVE"
	dc.b	$87
	even
	dc.w	%1111111111111111,%0100111001110000
	dc.w	$0000,$0000
ac50:	dc.b	ac51-ac50-9
	dc.b	"RESET"

	even
	dc.w	%1111111111111111,%0100111001110001
	dc.w	$0000,$0000
ac51:	dc.b	ac52-ac51-9
	dc.b	"NOP"

	even
	dc.w	%1111111111111111,%0100111001110010
	dc.w	$0800,$0000
ac52:	dc.b	ac53-ac52-9
	dc.b	"STOP"
	dc.b	$8d
	even
	dc.w	%1111111111111111,%0100111001110011
	dc.w	$0000,$0000
ac53:	dc.b	ac54-ac53-9
	dc.b	"RTE"

	even
	dc.w	%1111111111111111,%0100111001110101
	dc.w	$0000,$0000
ac54:	dc.b	ac55-ac54-9
	dc.b	"RTS"

	even
	dc.w	%1111111111111111,%0100111001110110
	dc.w	$0000,$0000
ac55:	dc.b	ac56-ac55-9
	dc.b	"TRAPV"

	even
	dc.w	%1111111111111111,%0100111001110111
	dc.w	$0000,$0000
ac56:	dc.b	ac57-ac56-9
	dc.b	"RTR"

	even
	dc.w	%1111111111000000,%0100111010000000
	dc.w	$07e4,$0000
ac57:	dc.b	ac58-ac57-9
	dc.b	"JSR"
	dc.b	$83
	even
	dc.w	%1111111111000000,%0100111011000000
	dc.w	$07e4,$0000
ac58:	dc.b	ac59-ac58-9
	dc.b	"JMP"
	dc.b	$83
	even
	dc.w	%1111000100000000,%0101000000000000
	dc.w	$1000,$01ff
ac59:	dc.b	ac60-ac59-9
	dc.b	"ADDQ.s"
	dc.b	$94,$80,$84
	even
	dc.w	%1111000011000000,%0101000011000000
	dc.w	$01fd,$0000
ac60:	dc.b	ac61-ac60-9
	dc.b	"Scc"
	dc.b	$9d,$83
	even
	dc.w	%1111000011111000,%0101000011001000
	dc.w	$0001,$8000
ac61:	dc.b	ac62-ac61-9
	dc.b	"DBcc"
	dc.b	$9d,$88,$8e
	even
	dc.w	%1111000100000000,%0101000100000000
	dc.w	$1000,$01ff
ac62:	dc.b	ac63-ac62-9
	dc.b	"SUBQ.s"
	dc.b	$94,$80,$84
	even
	dc.w	%1111111100000000,%0110000000000000
	dc.w	$8000,$0000
ac63:	dc.b	ac64-ac63-9
	dc.b	"BRA"
	dc.b	$96
	even
	dc.w	%1111111100000000,%0110000100000000
	dc.w	$8000,$0000
ac64:	dc.b	ac65-ac64-9
	dc.b	"BSR"
	dc.b	$96
	even
	dc.w	%1111000000000000,%0110000000000000
	dc.w	$8000,$0000
ac65:	dc.b	ac66-ac65-9
	dc.b	"Bcc"
	dc.b	$9d,$96
	even
	dc.w	%1111000100000000,%0111000000000000
	dc.w	$1000,$0001
ac66:	dc.b	ac67-ac66-9
	dc.b	"MOVEQ"
	dc.b	$89,$95
	even
	dc.w	%1111000100000000,%1000000000000000
	dc.w	$0ffd,$0001
ac67:	dc.b	ac68-ac67-9
	dc.b	"OR.s"
	dc.b	$89,$80,$83
	even
	dc.w	%1111000100000000,%1000000100000000
	dc.w	$0001,$01fc
ac68:	dc.b	ac69-ac68-9
	dc.b	"OR.s"
	dc.b	$88,$80,$84
	even
	dc.w	%1111000111000000,%1000000011000000
	dc.w	$0ffd,$0001
ac69:	dc.b	ac70-ac69-9
	dc.b	"DIVU.w"
	dc.b	$89,$83,$8d
	even
	dc.w	%1111000111000000,%1000000111000000
	dc.w	$0ffd,$0001
ac70:	dc.b	ac71-ac70-9
	dc.b	"DIVS.w"
	dc.b	$89,$83,$8d
	even
	dc.w	%1111000111111000,%1000000100000000
	dc.w	$0001,$0001
ac71:	dc.b	ac72-ac71-9
	dc.b	"SBCD"
	dc.b	$89,$88
	even
	dc.w	%1111000111111000,%1000000100001000
	dc.w	$0010,$0010
ac72:	dc.b	ac73-ac72-9
	dc.b	"SBCD"
	dc.b	$87,$86
	even
	dc.w	%1111000100000000,%1001000000000000
	dc.w	$0fff,$0001
ac73:	dc.b	ac74-ac73-9
	dc.b	"SUB.s"
	dc.b	$89,$80,$83
	even
	dc.w	%1111000100000000,%1001000100000000
	dc.w	$0001,$01fc
ac74:	dc.b	ac75-ac74-9
	dc.b	"SUB.s"
	dc.b	$88,$80,$84
	even
	dc.w	%1111000011000000,%1001000011000000
	dc.w	$0fff,$0002
ac75:	dc.b	ac76-ac75-9
	dc.b	"SUBA.s"
	dc.b	$87,$81,$83
	even
	dc.w	%1111000100111000,%1001000100000000
	dc.w	$0001,$0001
ac76:	dc.b	ac77-ac76-9
	dc.b	"SUBX.s"
	dc.b	$89,$80,$88
	even
	dc.w	%1111000100111000,%1001000100001000
	dc.w	$0010,$0010
ac77:	dc.b	ac78-ac77-9
	dc.b	"SUBX.s"
	dc.b	$87,$80,$86
	even
	dc.w	%1111000100000000,%1011000000000000
	dc.w	$0fff,$0001
ac78:	dc.b	ac79-ac78-9
	dc.b	"CMP.s"
	dc.b	$89,$80,$83
	even
	dc.w	%1111000011000000,%1011000011000000
	dc.w	$0fff,$0002
ac79:	dc.b	ac80-ac79-9
	dc.b	"CMPA.s"
	dc.b	$87,$81,$83
	even
	dc.w	%1111000100000000,%1011000100000000
	dc.w	$0001,$01fd
ac80:	dc.b	ac81-ac80-9
	dc.b	"EOR.s"
	dc.b	$88,$80,$84
	even
	dc.w	%1111000100111000,%1011000100001000
	dc.w	$0008,$0008
ac81:	dc.b	ac82-ac81-9
	dc.b	"CMPM.s"
	dc.b	$87,$80,$86
	even
	dc.w	%1111000100111000,%1011000100001000
	dc.w	$0008,$0008
ac82:	dc.b	ac83-ac82-9
	dc.b	"CMP.s"
	dc.b	$87,$80,$86
	even
	dc.w	%1111000100000000,%1100000000000000
	dc.w	$0ffd,$0001
ac83:	dc.b	ac84-ac83-9
	dc.b	"AND.s"
	dc.b	$89,$80,$83
	even
	dc.w	%1111000100000000,%1100000100000000
	dc.w	$0001,$01fc
ac84:	dc.b	ac85-ac84-9
	dc.b	"AND.s"
	dc.b	$88,$80,$84
	even
	dc.w	%1111000111000000,%1100000011000000
	dc.w	$0ffd,$0001
ac85:	dc.b	ac86-ac85-9
	dc.b	"MULU.w"
	dc.b	$89,$83,$8d
	even
	dc.w	%1111000111000000,%1100000111000000
	dc.w	$0ffd,$0001
ac86:	dc.b	ac87-ac86-9
	dc.b	"MULS.w"
	dc.b	$89,$83,$8d
	even
	dc.w	%1111000111111000,%1100000100000000
	dc.w	$0001,$0001
ac87:	dc.b	ac88-ac87-9
	dc.b	"ABCD.b"
	dc.b	$89,$88
	even
	dc.w	%1111000111111000,%1100000100001000
	dc.w	$0010,$0010
ac88:	dc.b	ac89-ac88-9
	dc.b	"ABCD.b"
	dc.b	$87,$86
	even
	dc.w	%1111000111111000,%1100000101000000
	dc.w	$0001,$0001
ac89:	dc.b	ac90-ac89-9
	dc.b	"EXG.l"
	dc.b	$89,$88
	even
	dc.w	%1111000111111000,%1100000101001000
	dc.w	$0002,$0002
ac90:	dc.b	ac91-ac90-9
	dc.b	"EXG.l"
	dc.b	$87,$86
	even
	dc.w	%1111000111111000,%1100000110001000
	dc.w	$0001,$0002
ac91:	dc.b	ac92-ac91-9
	dc.b	"EXG.l"
	dc.b	$88,$87
	even
	dc.w	%1111000111111000,%1100000110001000
	dc.w	$0002,$0001
ac92:	dc.b	ac93-ac92-9
	dc.b	"EXG.l"
	dc.b	$89,$86
	even
	dc.w	%1111000100000000,%1101000000000000
	dc.w	$0fff,$0001
ac93:	dc.b	ac94-ac93-9
	dc.b	"ADD.s"
	dc.b	$89,$80,$83
	even
	dc.w	%1111000100000000,%1101000100000000
	dc.w	$0001,$01fc
ac94:	dc.b	ac95-ac94-9
	dc.b	"ADD.s"
	dc.b	$88,$80,$84
	even
	dc.w	%1111000011000000,%1101000011000000
	dc.w	$0fff,$0002
ac95:	dc.b	ac96-ac95-9
	dc.b	"ADDA.s"
	dc.b	$87,$81,$83
	even
	dc.w	%1111000100111000,%1101000100000000
	dc.w	$0001,$0001
ac96:	dc.b	ac97-ac96-9
	dc.b	"ADDX.s"
	dc.b	$89,$80,$88
	even
	dc.w	%1111000100111000,%1101000100001000
	dc.w	$0008,$0008
ac97:	dc.b	ac98-ac97-9
	dc.b	"ADDX.s"
	dc.b	$87,$80,$86
	even
	dc.w	%1111000100111000,%1110000000000000
	dc.w	$1000,$0001
ac98:	dc.b	ac99-ac98-9
	dc.b	"ASR.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000100000000
	dc.w	$1000,$0001
ac99:	dc.b	ac100-ac99-9
	dc.b	"ASL.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000000100000
	dc.w	$0001,$0001
ac100:	dc.b	ac101-ac100-9
	dc.b	"ASR.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000100100000
	dc.w	$0001,$0001
ac101:	dc.b	ac102-ac101-9
	dc.b	"ASL.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000000001000
	dc.w	$1000,$0001
ac102:	dc.b	ac103-ac102-9
	dc.b	"LSR.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000100001000
	dc.w	$1000,$0001
ac103:	dc.b	ac104-ac103-9
	dc.b	"LSL.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000000101000
	dc.w	$0001,$0001
ac104:	dc.b	ac105-ac104-9
	dc.b	"LSR.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000100101000
	dc.w	$0001,$0001
ac105:	dc.b	ac106-ac105-9
	dc.b	"LSL.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000000010000
	dc.w	$1000,$0001
ac106:	dc.b	ac107-ac106-9
	dc.b	"ROXR.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000100010000
	dc.w	$1000,$0001
ac107:	dc.b	ac108-ac107-9
	dc.b	"ROXL.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000000110000
	dc.w	$0001,$0001
ac108:	dc.b	ac109-ac108-9
	dc.b	"ROXR.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000100110000
	dc.w	$0001,$0001
ac109:	dc.b	ac110-ac109-9
	dc.b	"ROXL.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000000011000
	dc.w	$1000,$0001
ac110:	dc.b	ac111-ac110-9
	dc.b	"ROR.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000100011000
	dc.w	$1000,$0001
ac111:	dc.b	ac112-ac111-9
	dc.b	"ROL.s"
	dc.b	$94,$80,$89
	even
	dc.w	%1111000100111000,%1110000000111000
	dc.w	$0001,$0001
ac112:	dc.b	ac113-ac112-9
	dc.b	"ROR.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111000100111000,%1110000100111000
	dc.w	$0001,$0001
ac113:	dc.b	ac114-ac113-9
	dc.b	"ROL.s"
	dc.b	$88,$80,$89
	even
	dc.w	%1111111111000000,%1110000011000000
	dc.w	$01fc,$0000
ac114:	dc.b	ac115-ac114-9
	dc.b	"ASR.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110000111000000
	dc.w	$01fc,$0000
ac115:	dc.b	ac116-ac115-9
	dc.b	"ASL.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110001011000000
	dc.w	$01fc,$0000
ac116:	dc.b	ac117-ac116-9
	dc.b	"LSR.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110001111000000
	dc.w	$01fc,$0000
ac117:	dc.b	ac118-ac117-9
	dc.b	"LSL.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110010011000000
	dc.w	$01fc,$0000
ac118:	dc.b	ac119-ac118-9
	dc.b	"ROXR.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110010111000000
	dc.w	$01fc,$0000
ac119:	dc.b	ac120-ac119-9
	dc.b	"ROXL.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110011011000000
	dc.w	$01fc,$0000
ac120:	dc.b	ac121-ac120-9
	dc.b	"ROR.w"
	dc.b	$83
	even
	dc.w	%1111111111000000,%1110011111000000
	dc.w	$01fc,$0000
ac121:	dc.b	ac122-ac121-9
	dc.b	"ROL.w"
	dc.b	$83
	even
	dc.w	%0000000000000000,%0000000000000000
	dc.w	$0000,$0000
ac122:	dc.b	AssemblerCodesEnd-ac122-1
	dc.b	"???"
	even
AssemblerCodesEnd:

Assemblerconditions:
	dc.b	"T",0,0
	dc.b	"F",0,0
	dc.b	"HI",0
	dc.b	"LS",0
	dc.b	"CC",0
	dc.b	"CS",0
	dc.b	"NE",0
	dc.b	"EQ",0
	dc.b	"VC",0
	dc.b	"VS",0
	dc.b	"PL",0
	dc.b	"MI",0
	dc.b	"GE",0
	dc.b	"LT",0
	dc.b	"GT",0
	dc.b	"LE",0
	even

*****************************************************************************

*****************************************************************************

Timecodes1:
	dc.b	Tc1-Timecodes1,Tc2-Timecodes1,Tc3-Timecodes1
	dc.b	Tc4-Timecodes1,Tc5-Timecodes1,Tc6-Timecodes1
	dc.b	Tc7-Timecodes1
Tc1:	dc.b	"Monday",0
Tc2:	dc.b	"Tuesday",0
Tc3:	dc.b	"Wednesday",0
Tc4:	dc.b	"Thursday",0
Tc5:	dc.b	"Friday",0
Tc6:	dc.b	"Saturday",0
Tc7:	dc.b	"Sunday",0

Timecodes2:
	dc.b	0,3,3,6,1,4,6,2,5,0,3,5	;Months 1-12 Jan-Dec
Timecodes3:
	dc.b	6,5,4,3,2,1,0		;Century 0-6
	dc.b	6,5,4,3,2,1,0		;7-13
	dc.b	6,5,1,6,4,2,1		;14-20
	dc.b	6,4,2,1,6,4,2		;21-27
	dc.b	1			;28
Timecodes4:
	dc.b	1,2,3,4,6,7		;Year 0-5
	dc.b	1,2,4,5,6,7		;6-11
	dc.b	2,3,4,5,7		;12-16
	dc.b	1,2,3,5,6,7		;17-22
	dc.b	1,3,4,5,6		;23-27
	dc.b	1,2,3,4,6,7		;28-33
	dc.b	1,2,4,5,6,7		;34-39
	dc.b	2,3,4,5,7		;40-44
	dc.b	1,2,3,5,6,7		;45-50
	dc.b	1,3,4,5,6		;51-55
	dc.b	1,2,3,4,6,7		;56-61
	dc.b	1,2,4,5,6,7		;62-67
	dc.b	2,3,4,5,7		;68-72
	dc.b	1,2,3,5,6,7		;73-78
	dc.b	1,3,4,5,6		;79-83
	dc.b	1,2,3,4,6,7		;84-89
	dc.b	1,2,4,5,6,7		;90-95
	dc.b	2,3,4,5			;96-99

Datecodes1:
	dc.b	31,28,31,30,31,30	;Days in month Jan-Dec
	dc.b	31,31,30,31,30,31
	even
Datecodes2:
	dc.b	Dc1-Datecodes2,Dc2-Datecodes2,Dc3-Datecodes2
	dc.b	Dc4-Datecodes2,Dc5-Datecodes2,Dc6-Datecodes2
	dc.b	Dc7-Datecodes2,Dc8-Datecodes2,Dc9-Datecodes2
	dc.b	Dc10-Datecodes2,Dc11-Datecodes2,Dc12-Datecodes2
Dc1:	dc.b	"Jan",0
Dc2:	dc.b	"Feb",0
Dc3:	dc.b	"Mar",0
Dc4:	dc.b	"Apr",0
Dc5:	dc.b	"May",0
Dc6:	dc.b	"Jun",0
Dc7:	dc.b	"Jul",0
Dc8:	dc.b	"Aug",0
Dc9:	dc.b	"Sep",0
Dc10:	dc.b	"Oct",0
Dc11:	dc.b	"Nov",0
Dc12:	dc.b	"Dec",0
*****************************************************************************

	END

	STRUCTURE	CCSLibrary,0
	APTR	ccs_AgnusBase
	APTR	ccs_MemList
	APTR	ccs_StackBase
	APTR	ccs_RAMCopy
	APTR	ccs_CustomRegs
	APTR	ccs_CIARegs
	APTR	ccs_ExitRegs
	SCRUCT	ccs_M68000Regs,m68_SIZEOF
	STRUCT	ccs_ScreenDev,sb_SIZEOF
	STRUCT	ccs_KeyDev,kb_SIZEOF
	STRUCT	ccs_PointerDev,pb_SIZEOF
	STRUCT	ccs_DiskDev,db_SIZEOF
	STRUCT	ccs_EditorDev,eb_SIZEOF
	STRUCT	ccs_MenuDev,mb_SIZEOF
	STRUCT	ccs_WindowDev,wb_SIZEOF
	STRUCT	ccs_Assembler,$20
	APTR	ccs_StringBuffer
	UWORD	ccs_StartUp
	APTR	ccs_ErrorHandler
	APTR	ccs_ErrorHandlerStack
	UWORD	ccs_CIATimers
	UBYTE	ccs_CIAAIRQReq
	UBYTE	ccs_CIAAIRQEna
	UBYTE	ccs_CIABIRQReq
	UBYTE	ccs_CIABIRQEna
	UWORD	ccs_LeftMouseShift
	UWORD	ccs_RightMouseShift
	APTR	ccs_CSISequence
	LABEL	ccs_SIZEOF

	STRUCTURE	ChipMemUsage,0
	STRUCT	cmu_M68000,$c0
	STRUCT	cmu_BitMap,$5280
	STRUCT	cmu_Pointer,$40
	STRUCT	cmu_Cursor,$80
	STRUCT	cmu_Disk,$3340
	LABEL	cmu_SIZEOF

	STRUCTURE	ScreenBase,0
	APTR	sb_FontBase
	APTR	sb_FontBitMap
	APTR	sb_FontCharMap
	APTR	sb_BitMap
	APTR	sb_CharMap
	UWORD	sb_BackColor
	UWORD	sb_ForeColor1
	UWORD	sb_ColorCheckSum
	UWORD	sb_CursorY
	UWORD	sb_CursorX
	UWORD	sb_CursorCheckSum
	UBYTE	sb_Inverse
	UBYTE	sb_VertBlank
	UWORD	sb_ScrollStartLine
	UWORD	sb_ScreenLastLine
	UWORD	sb_RasterLine
	APTR	sb_BitmapLineAddr
	APTR	sb_CharLineAddr
	UWORD	sb_LastYLine
	UWORD	sb_ForeColor2
	UWORD	sb_LastRasterLine
	UWORD	sb_InfoRasterLine
	UWORD	sb_SwapRasterLine
	UBYTE	sb_InfoEnable
	UBYTE	sb_RasterType
	APTR	sb_CursorImage
	UWORD	sb_CursorColor
	APTR	sb_MarkedMap
	LABEL	sb_SIZEOF
	
	STRUCTURE	KeyboardBase,0
	APTR	kb_Map
	APTR	kb_Buffer
	UWORD	kb_BufferIndex
	UBYTE	kb_Mode
	UBYTE	kb_Vanilla
	UBYTE	kb_CapsLock
	UBYTE	kb_LastKey
	UWORD	kb_Repeat
	LABEL	kb_SIZEOF

	STRUCTURE	PointerBase,0
	APTR	pb_Sprite
	UWORD	pb_Y
	UWORD	pb_X
	UWORD	pb_Mouse
	UWORD	pb_Color1
	UWORD	pb_Color2
	UWORD	pb_Color3
	LABEL	pb_SIZEOF

	STRUCTURE	DiskBase,0
	APTR	db_BlockBuffer
	APTR	db_RootBlock
	APTR	db_DMABuffer
	UBYTE	db_Drive0Track
	UBYTE	db_Drive1Track
	UBYTE	db_Drive2Track
	UBYTE	db_Drive3Track
	UBYTE	db_CurrentUnit
	UBYTE	db_DirectoryUnit
	UWORD	db_DirectoryBlock
	APTR	db_TrackBuffer
	BYTE	db_TrackBufferUnit
	BYTE	db_TrackBufferNr
	WORD	db_DriveMotor
	WORD	db_TrackBufferChange
	UWORD	db_HashBlock
	UWORD	db_HashIndex
	APTR	db_BAMBuffer
	UWORD	db_DirectoryChecksum
	LABEL	db_SIZEOF

	STRUCTURE	M68000Regs,0
	LONG	m68_D0
	LONG	m68_D1
	LONG	m68_D2
	LONG	m68_D3
	LONG	m68_D4
	LONG	m68_D5
	LONG	m68_D6
	LONG	m68_D7
	LONG	m68_A0
	LONG	m68_A1
	LONG	m68_A2
	LONG	m68_A3
	LONG	m68_A4
	LONG	m68_A5
	LONG	m68_A6
	LONG	m68_A7
	LONG	m68_SSP
	WORD	m68_SR
	LONG	m68_PC
	LABEL	m68_SIZEOF

	STRUCTURE	EditorBase,0
	APTR	eb_TextStart
	APTR	eb_TextEnd
	ULONG	eb_CurrentLine
	ULONG	eb_CurrentBufferLine
	APTR	eb_TextBuffer
	UWORD	eb_TextBufferLength
	UWORD	eb_CurrentTextColumn
	UWORD	eb_TextBufferOldLength
	UWORD	eb_TextBufferChanged
	UWORD	eb_TextBufferIndex
	UWORD	eb_StartColumn
	APTR	eb_FirstTextLine
	APTR	eb_ScreenBackup
	APTR	eb_WorkbufferEnd
	APTR	eb_CutbufferEnd
	APTR	eb_Filename
	APTR	eb_MarkBegin
	APTR	eb_MarkEnd
	UWORD	eb_MarkMode
	APTR	eb_RemLineAddr
	UWORD	eb_RemLineLength
	UWORD	eb_RemLineY
	APTR	eb_Stackpointer
	UBYTE	eb_TextSaved
	UBYTE	eb_EditorActive
	APTR	eb_LastFind
	APTR	eb_FindString
	UWORD	eb_FindParameters
	LABEL	eb_SIZEOF

	STRUCTURE	MenuBase,0
	UWORD	mb_HeadItem
	UWORD	mb_SubItem
	APTR	mb_Routine
	APTR	mb_HeadInfo
	LABEL	mb_SIZEOF
	
	STRUCTURE	WindowBase,0
	APTR	wb_Coords
	APTR	wb_Info
	UBYTE	wb_InputStartX
	UBYTE	wb_InputCursorX
	UBYTE	wb_CurrentObject
	UBYTE	wb_InputWidth
	LABEL	wb_SIZEOF

Preferences:			;Usage: $10000 bytes
	dc.l	$0000C0		;0	Screenmemory Bitmap
	dc.l	prend		;4	Screenmemory Chars
	dc.w	$0888		;8	Background Color
	dc.w	$0ccc		;A	Foreground Color
	dc.l	$0		;C	Fontpointer Bitmap
	dc.l	$0		;10	Fontpointer Chars 20-FF
	dc.l	$0		;14	Agnus Chip Base adress
	dc.l	$0		;18	Fontpointer BASE
	blk.l	$10,0		;1C	68000 Register A0-A7/D0-D7
	dc.w	$0		;5C	Cursor Y
	dc.w	$0		;5E	Cursor X
	dc.l	$0		;60	Keymap
	dc.l	prend+$a50	;64	Keyboardbuffer length 100
	dc.w	$0		;68	Keyboardbuffer ,index
	dc.b	$0		;6a	Keyboardmode 00-05
	dc.b	$0		;6b	Keyboardvanillakeys 00-07
	dc.b	$0		;6c	Keyboard Caps Lock Key +/-
	dc.b	$ff		;6d	Keyboard Last Key
	dc.w	$0		;6e	Keyboard Repeat counter
	dc.w	$0		;70	Startupcode
	dc.w	$0		;72	Color Checksum (8,A)
	dc.b	$0		;74	Inverse Chars 00/FF
	dc.b	$0		;75	Vertical Blank Event
	dc.l	prend+$b50	;76	Stringbuffert length 100
	dc.l	prend+$c50	;7a	Diskbuffert length 200
	dc.l	prend+$e50	;7e	Diskbuffert length 200 Rootblock
	dc.l	$005400		;82	Diskbuffert DMA length $3340
	dc.l	prend+$2650	;86	Ram Saver Address $0-$8740
	dc.l	$0		;8a	Supervisor Stack Pointer
	dc.w	$0		;8e	Status Register
	dc.l	$0		;90	Program Counter
	dc.l	prefs+$10000	;94	Monitor Stack Pointer
	blk.l	$20,0		;98	Assembler workarea
	dc.b	$0		;118	Drive 0 Track
	dc.b	$0		;119	Drive 1 Track
	dc.b	$0		;11a	Drive 2 Track
	dc.b	$0		;11b	Drive 3 Track
	dc.b	$0		;11c	Current Drive Unit
	dc.b	$0		;11d	Directory Drive Unit
	dc.w	$FFFF		;11e	Directory Block nr
	dc.l	prend+$1050	;120	Track buffer $1600
	dc.b	$0		;124	Drive nr of track in buffer
	dc.b	$FF		;125	Track nr of track in buffer
	dc.w	$0		;126	Drive motor off counter
	dc.l	$005340		;128	SpritePointer
	dc.w	$0		;12c	Sprite Y
	dc.w	$0		;12e	Sprite X
	dc.w	$0		;130	Last Mouse Value
	dc.w	$0d22		;132	Pointer Color 1
	dc.w	$0000		;134	Pointer Color 2
	dc.w	$0fca		;136	Pointer Color 3
	dc.w	$0000		;138	Write Track Buffer? ($1234=Yes)
	dc.w	0		;13a	BlockNr of Hashpointer
	dc.w	0		;13c	Index of Hashpointer
	dc.l	prend+$ad90	;13e	BAMbuffert $200
	dc.l	0		;142	ErrorHandler
	dc.l	0		;146	ErrorHandler Stackpointer
	dc.w	0		;14a	ScreenScrollStartLine
	dc.w	$21		;14c	ScreenLastLine
	dc.w	0		;14e	RasterLine
	dc.l	0		;150	ED:TextStart
	dc.l	0		;154	ED:TextEnd
	dc.l	0		;158	ED:CurrentTextLine
	dc.l	0		;15c	ED:CurrentTextLine in Buffer
	dc.l	prend+$af90	;160	ED:TextBuffer ($200 bytes)
	dc.w	0		;164	ED:TextBuffer Length
	dc.w	0		;166	ED:CurrentTextColumn
	dc.w	0		;168	ED:TextBuffer OldLength
	dc.w	0		;16a	ED:TextBuffer Changed ($1234=Yes)
	dc.w	0		;16c	ED:TextBuffer Index
	dc.w	0		;16e	ED:StartColumn on Screen
	dc.l	0		;170	ED:First TextLine Addr
	dc.l	prend+$b190	;174	ED:ScreenBackup ($a50 bytes)
	dc.l	0		;178	Bitmap Line Addr
	dc.l	0		;17c	Chars Line Addr
	dc.w	$ffff		;180	Last Y Line
	dc.l	0		;182	ED:Workbuffer END
	dc.l	0		;186	ED:Cutbuffer END
	dc.l	prend+$bbe0	;18a	DFF000 Registers ($200 bytes)
	dc.l	prend+$bde0	;18e	CIA Registers ($30 bytes)
	dc.w	0		;192	Cursor Checksum (5C,5E,14A)
	dc.w	0		;194	Directory Checksum (11D,11E)
	dc.l	prend+$be10	;196	Exit Parameters ($280 bytes)
	dc.w	0		;19a	CIA Timers (Bit 9,8,1,0)
	dc.l	prend+$c090	;19c	ED:Filename ($50 bytes)
	dc.w	0		;1a0	LastRasterLine
	dc.w	$0fff		;1a2	Second Forground Color
	dc.w	0		;1a4	InfoRasterLine
	dc.w	0		;1a6	SwapscreenRasterLine
	dc.b	0		;1a8	Infoline enable
	dc.b	0		;1a9	Rastertype nr
	dc.l	0		;1aa	ED:Mark Begin
	dc.l	0		;1ae	ED:Mark End
	dc.w	0		;1b2	ED:Mark mode
	dc.l	0		;1b4	ED:Rem Line Addr
	dc.w	0		;1b8	ED:Rem Line Length
	dc.w	0		;1ba	ED:Rem Line Y
	dc.b	0		;1bc	CIAA IRQ Request Register
	dc.b	0		;1bd	CIAA IRQ Enable Register
	dc.b	0		;1be	CIAB IRQ Request Register
	dc.b	0		;1bf	CIAB IRQ Enable Register
	dc.w	0		;1c0	Mouse Left Button Shift Reg.
	dc.w	0		;1c2	Mouse Right Button Shift Reg.
	dc.l	prend+$c0e0	;1c4	CSI Sequence (char,nr,pars)($20bytes)
	dc.w	0		;1c8	Menu Head Item Nr
	dc.w	0		;1ca	Menu Sub Item Nr
	dc.l	0		;1cc	Menu Routine
	dc.l	0		;1d0	Menu Head Info
	dc.l	0		;1d4	Window Coords
	dc.l	0		;1d8	Window Info
	dc.b	0		;1dc	Window Inputline Start X
	dc.b	0		;1dd	Window Inputline Cursor X
	dc.b	0		;1de	Window Current Object Nr
	dc.b	0		;1df	Window Inputline Width
	dc.l	0		;1e0	ED:Edit Stackpointer
	dc.b	0		;1e4	ED:Text Saved
	dc.b	0		;1e5	ED:Editor Active
	dc.l	0		;1e6	ED:Last Find
	dc.l	prend+$c100	;1ea	ED:Find String ($50 bytes)
	dc.w	0		;1ee	ED:Find Parameters
	dc.l	$005380		;1f0	Cursor Image
	dc.w	$0444		;1f4	Cursor Color
	dc.l	prend+$c150	;1f6	Screenmemory Marked ($0150 bytes)
prend:
