{$N+,A+,G+,F+,D-,E+,L-,R-,S-,Q-,Y-}
{
Classic ROTOZOOMER effect, optimized for 80486, MS-DOS.

A version of the routine with block-based rasterization (16x16),
using standard (full) calculation precision.

Use Borland Pascal 7.0 (DOS) for compilation this programm ;)

Code: bitl/7dump

}

procedure set60hz;
begin
    port  [$3D4]:= $11;
    port  [$3D5]:= port[$3D5] and $7F;
    port  [$3C2]:= $E3;
    portw [$3D4]:= $0B06;
    portw [$3D4]:= $3E07;
    portw [$3D4]:= $C310;
    portw [$3D4]:= $8C11;
    portw [$3D4]:= $8F12;
    portw [$3D4]:= $9015;
    portw [$3D4]:= $0B16;
end;

procedure HirezTimer(ON:byte);
begin { freq to 1/291.3 sec.}
if ON=1 then
asm
mov al, 34h
out 43h, al
mov al, 4096 and 0ffh  {1193180/freq}
out 40h, al
mov al, 4096 shr 8
out 40h, al
end
else
asm { freq to 1/18.2 sec.}
mov al, 34h
out 43h, al
mov al, 65535 and 0ffh
out 40h, al
mov al, 65535 shr 8
out 40h, al
end;
end;

Procedure WaitVR; Assembler;
ASM
  mov  dx, 3DAh
@w1:
    in   al, dx
    test al, 8h
  jnz  @w1
@w2:
    in   al, dx
    test al, 8h
  jz   @w2
End;


Procedure LoadTga(TgaName:string; size:longint; where:word);
Var
InF: File of byte;
n: word;
pal:array[0..767] of byte;
begin
  Assign(Inf,TgaName);
  Reset(Inf);
  seek(Inf, 18);
  for n:=0 to 767 do read(Inf,pal[n]);
  for n:=0 to size-1 do read(Inf, mem[where:n]);
  Close(Inf);
  port[$3C8]:=0;
  n:=0;
  while n<767 do {set palette}
    begin
      port[$3C9]:=pal[n+2] shr 2;
      port[$3C9]:=pal[n+1] shr 2;
      port[$3C9]:=pal[n]   shr 2;
      n:=n+3;
    end;
end;



procedure Rotozoomer(CenterX, CenterY:integer; Angle, Scale:real; texture, output:word);
var
xr0, yr0, tsin8c, tcos8c,tsin8,tcos8,tcos,tsin, xsin,xcos, ycos, ysin:integer;
c,l,vdi:word;
begin

Tcos := round(cos(angle)*scale *256);
Tsin := round(sin(angle)*scale *256);

xcos := Tcos*(-centerX);
xsin := Tsin*(-centerX);

ysin := Tsin*(-centerY);
ycos := Tcos*(-centerY);

xr0:= xcos + ysin;
yr0:= xsin - ycos;

tcos8:=tcos*16;
tsin8:=tsin*16;

asm
  push ds
  mov es, output
  mov ds, texture

{--------self-modyfing-----------}
  mov ax, Tsin
  mov bx, Tcos

  imul dx, Tcos, 15 {Tsin - Tcos*15}
  sub ax, dx
  mov cs:[offset @tsin+2], ax

  imul dx, Tsin, 15 {Tcos + Tsin*15}
  add bx, dx
  mov cs:[offset @tcos+2], bx
{--------------------------------}

mov l, 11 {block lines (12 block 16*16)}
@l: {for l:=0 to 11 do begin}

{tsin8l:=tsin*16*l;}
{tcos8c:=xr0 + tsin8l;}
mov ax, tsin
shl ax, 4
mov bx, l
db $0f,$af,$c3 {imul ax, bx}
add ax, xr0
mov tcos8c, ax

{tcos8l:=tcos*16*l;}
{tsin8c:=yr0 - tcos8l;}
mov ax, tcos
shl ax, 4
mov bx, l
db $0f,$af,$c3 {imul ax, bx}
mov bx, yr0
sub bx, ax
mov tsin8c, bx


{vdi:=(12-l)*16*320 - (16*320+4);}
mov ax, 12
sub ax, l
imul ax, ax, (16*320)
sub ax, 16*320+4     -320*4{ <----vertical align:}
mov vdi, ax

mov c, 19     {block column  (20 block 16x16)}
@c:{for c:=0 to 39 do begin}

{--------------self-modyfing------------------}
  mov ax, vdi
  mov cs:[offset @d12+4], ax
  sub ax, 4
  mov cs:[offset @d8+4], ax
  sub ax, 4
  mov cs:[offset @d4+4], ax
  sub ax, 4
  mov cs:[offset @d0+4], ax
  jmp @clear_prefetch; @clear_prefetch:
{---------------------------------------------}

mov cx, tcos8c {xr:=tcos8c;}
mov dx, tsin8c {yr:=tsin8c;}

mov ax, tcos8 {tcos8c:=tcos8c + tcos8;}
add tcos8c, ax
mov ax, tsin8 {tsin8c:=tsin8c + tsin8;}
add tsin8c, ax

mov di, 16*320

push bp
mov si, tcos
mov bp, tsin

  @y: {draw block 16x16}
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      db $66; shl ax, 16
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      @d12: db $66; mov es:[di+1234h+12], ax
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      db $66; shl ax, 16
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      @d8: db $66; mov es:[di+123h+8], ax
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      db $66; shl ax, 16
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      @d4: db $66; mov es:[di+1234h+4], ax
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov al, ds:[bx]
      db $66; shl ax, 16
      mov bl, ch; mov bh, dh; add cx, si; add dx, bp; mov ah, ds:[bx]
      mov bl, ch; mov bh, dh; mov al, ds:[bx]
      @d0: db $66; mov es:[di+1234], ax

      {xr := xr+Tsin;}
      @Tsin: add cx, 1234h
      {yr := yr-Tcos;}
      @Tcos: sub dx, 1234h

      sub di, 320
  jnz @y

pop bp

sub vdi, 16

dec word ptr c
jns @c

dec word ptr l
jns @l

pop ds
end;
end;


var
timer: Longint ABSOLUTE $0040:$006C;
TextureSeg1, TextureSeg2, frames, T1:word;
PTexture1, PTexture2:pointer;
n, angle, texture, output:word;
scale_speed, rotate_speed, rotate,scale, pi180:real;
SetMode60hz, Vsync:byte;

begin

rotate_speed:=0.2;
scale_speed:=0.001;

SetMode60Hz:=0;

Vsync:=0;


GetMem(PTexture1, 65535);
TextureSeg1:=Seg(PTexture1^);


asm
mov ax, 13h
int 10h
end;
if SetMode60hz=1 then set60hz;{}

LoadTga('pouet.tga', 256*256, TextureSeg1);

output:=$a000;
pi180:=pi/180;
frames:=0; T1:=Timer;

HirezTimer(1);

repeat

      rotate:= (timer * rotate_speed) * pi180;
      scale := 1.2+cos(timer * scale_speed)*0.5;

      Rotozoomer(160,100, rotate, scale, TextureSeg1, output);

      if Vsync=1 then WaitVR;

      Inc(frames);

until port[$60]=1;

HirezTimer(0);

asm
mov ax, 03h
int 10h
end;

T1:=Timer-T1;
WriteLn(Frames/(T1/291.3) :1:2,' Frames per second');

end.