
#include <D3D8.h>
#include "D3DU8.h"

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "Rand.h"

#define D3DFVF_DOTLIGHTS_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2)

typedef struct _DOTLIGHTS_VERTEX1
  {
    D3DVECTOR Vertex;
    DWORD Diffuse;
    FLOAT TexU, TexV;
   } DOTLIGHTS_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 DotLights_VertexBuffer1 = NULL;
DOTLIGHTS_VERTEX1 *DotLights_LockedVertexBuffer1, DotLights_ConstVertex1[] =
  {{{ 0.0f, 0.0f, 0.0f }, 0x00FFFFFF, 0.0f, 0.0f },
    {{ 0.0f, 0.0f, 0.0f }, 0x00FFFFFF, 0.0f, 1.0f },
    {{ 0.0f, 0.0f, 0.0f }, 0x00FFFFFF, 1.0f, 1.0f },
    {{ 0.0f, 0.0f, 0.0f }, 0x00FFFFFF, 1.0f, 0.0f }};

LPDIRECT3DINDEXBUFFER8 DotLights_IndexBuffer1 = NULL;
WORD *DotLights_LockedIndexBuffer1;

LPDIRECT3DTEXTURE8 DotLights_Texture1 = NULL;
static TXGEN_LAYER *TxLayer1;

extern "C" BYTE Flare64[64*64*4];

D3DMATERIAL8 DotLights_Material1;

#define DOTNUM 384
D3DVECTOR CamVector, CamX, CamY, DotLights_Field[DOTNUM];

// ------------------------------------------------------------------------------------------------

int DotLights_Initialize( void )
  {
    // --- VertexBuffer.

    if ( Direct3DDevice->CreateVertexBuffer( DOTNUM * 4 * sizeof( DOTLIGHTS_VERTEX1 ), 0, D3DFVF_DOTLIGHTS_VERTEX1, 
      D3DPOOL_DEFAULT, &DotLights_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( DotLights_VertexBuffer1->Lock( 0, DOTNUM * 4 * sizeof( DOTLIGHTS_VERTEX1 ), (BYTE**) &DotLights_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    RandSeed = 54;
    for ( int I=0; I<DOTNUM; I++ )
      {
        DotLights_Field[I].x = (float) ( 512 - ( Rand() & 1023 )) / 96.0f;
        DotLights_Field[I].y = (float) ( Rand() & 511 ) / 128.0f;
        DotLights_Field[I].z = (float) ( 512 - ( Rand() & 1023 )) / 96.0f;

        DotLights_LockedVertexBuffer1[ I*4+0 ] = DotLights_ConstVertex1[ 0 ];
        DotLights_LockedVertexBuffer1[ I*4+1 ] = DotLights_ConstVertex1[ 1 ];
        DotLights_LockedVertexBuffer1[ I*4+2 ] = DotLights_ConstVertex1[ 2 ];
        DotLights_LockedVertexBuffer1[ I*4+3 ] = DotLights_ConstVertex1[ 3 ];
       }

    DotLights_VertexBuffer1->Unlock();

    // --- IndexBuffer.

    if ( Direct3DDevice->CreateIndexBuffer( DOTNUM * 6 * sizeof( WORD ), D3DUSAGE_WRITEONLY, D3DFMT_INDEX16, 
      D3DPOOL_DEFAULT, &DotLights_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( DotLights_IndexBuffer1->Lock( 0, DOTNUM * 6 * sizeof( WORD ), (BYTE**) &DotLights_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    for ( I=0; I<DOTNUM; I++ )
      {
        DotLights_LockedIndexBuffer1[ I*6 + 0 ] = I*4 + 0;
        DotLights_LockedIndexBuffer1[ I*6 + 1 ] = I*4 + 1;
        DotLights_LockedIndexBuffer1[ I*6 + 2 ] = I*4 + 2;
        DotLights_LockedIndexBuffer1[ I*6 + 3 ] = I*4 + 0;
        DotLights_LockedIndexBuffer1[ I*6 + 4 ] = I*4 + 2;
        DotLights_LockedIndexBuffer1[ I*6 + 5 ] = I*4 + 3;
       }

    DotLights_IndexBuffer1->Unlock();

    // --- Texture.

    Direct3DDevice->CreateTexture( 64, 64, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &DotLights_Texture1 );

    TxLayer1 = TxGen_LayerInitialize( 64, 64 );
    memcopy( TxLayer1->Ptr, Flare64, 64*64*4 );
    TxGen_SetTexture( DotLights_Texture1, TxLayer1 );    
    TxGen_LayerCleanup( TxLayer1 );

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void DotLights_Cleanup( void )
  {
    if ( DotLights_VertexBuffer1 ) DotLights_VertexBuffer1->Release();
    if ( DotLights_IndexBuffer1 ) DotLights_IndexBuffer1->Release();
    if ( DotLights_Texture1 ) DotLights_Texture1->Release();
   }

// ------------------------------------------------------------------------------------------------

static float Light, CentX, CentY, DX, DY, DZ, Dist, DTime, PrevTime = -1.0f;

void DotLights_Render( float Time )
  {
    int I;

    // --- Timer.
    
    if ( PrevTime < 0.0f ) PrevTime = Time;
    DTime = ( Time - PrevTime ) * 0.01f;
    PrevTime = Time;

    // --- Setup World Matrix.
    D3DUMatrixCopy( &D3DMatrix_World0, &D3DUMatrixIdentity );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );

    // --- Setup View Matrix.
    D3DUVec3Create( &D3DVector_CameraPosition, Fsin( Time * 0.00063f ), 6.0f + 0.3f * Fsin( Time * 0.00021f ), Fsin( Time * 0.00037f ));
    D3DUVec3Create( &D3DVector_CameraTarget, 0.2f * Fsin( Time * 0.00012f ), 0.0f, 0.2f * Fsin( Time * 0.00017f ) );
    D3DUVec3Create( &D3DVector_Up, 0.0f, 0.0f, -1.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    // --- Setup Texture Matrix.
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DUMatrixIdentity );

    // --- Setup Texture.
    Direct3DDevice->SetTexture( 0, DotLights_Texture1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TFACTOR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetVertexShader( D3DFVF_DOTLIGHTS_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, FALSE );

    // --- Setup Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    // --- Update Vertices.

    D3DUVec3Sub( &CamVector, &D3DVector_CameraTarget, &D3DVector_CameraPosition );
    D3DUVec3Cross( &CamX, &CamVector, &D3DVector_Up );
    D3DUVec3Cross( &CamY, &CamVector, &CamX );

    D3DUVec3Normalize( &CamX, &CamX );
    D3DUVec3Scale( &CamX, &CamX, 0.4f );
    D3DUVec3Normalize( &CamY, &CamY );
    D3DUVec3Scale( &CamY, &CamY, 0.4f );

    CentX = 3.0f * Fsin( Time * 0.06f ); 
    CentY = 3.0f * Fcos( Time * 0.07f ); 

    if ( DotLights_VertexBuffer1->Lock( 0, DOTNUM * 4 * sizeof( DOTLIGHTS_VERTEX1 ), (BYTE**) &DotLights_LockedVertexBuffer1, 0 ) == D3D_OK )
      {
        for ( I=0; I<DOTNUM; I++ )
          {
            DX = CentX - DotLights_Field[ I ].x;
            DY = CentY - DotLights_Field[ I ].z;
            DZ = DotLights_Field[ I ].y;

            Dist = DTime / ( 0.02f + Fsqr( DX/8 ) + Fsqr( DY/8 ) + Fsqr( DZ/6 ));
            DotLights_Field[ I ].x = CentX - Fcos( Dist ) * DX + Fsin( Dist ) * DY;
            DotLights_Field[ I ].z = CentY - Fsin( Dist ) * DX - Fcos( Dist ) * DY;

            D3DUVec3Add( &DotLights_LockedVertexBuffer1[ I*4+0 ].Vertex, &DotLights_Field[ I ], &CamX );
            D3DUVec3Add( &DotLights_LockedVertexBuffer1[ I*4+1 ].Vertex, &DotLights_Field[ I ], &CamY );
            D3DUVec3Sub( &DotLights_LockedVertexBuffer1[ I*4+2 ].Vertex, &DotLights_Field[ I ], &CamX );
            D3DUVec3Sub( &DotLights_LockedVertexBuffer1[ I*4+3 ].Vertex, &DotLights_Field[ I ], &CamY );
           }
        DotLights_VertexBuffer1->Unlock();
       }

    Light = Fsqrt( 0.5f * ( 1.0f - Fcos(( Time - 384.0f ) / 128.0f * Fmath_2Pi )));
//*
    for ( I=0; I<3; I++ )
      {
        if ( I == 2 )
          Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 15 * Light )); else
          Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 2 * ( I+1 ) * Light ));
//*/
        // --- Setup Projection Matrix.
        D3DUMatrixPerspectiveFovLH( &D3DMatrix_Projection, D3DU_PI * ( 0.3f + 0.005f * I ), 1.778f, 0.1f, 100.0f );
        Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );
        // --- Render.
        Direct3DDevice->SetStreamSource( 0, DotLights_VertexBuffer1, sizeof( DOTLIGHTS_VERTEX1 ));
        Direct3DDevice->SetIndices( DotLights_IndexBuffer1, 0 );
        Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, DOTNUM*4, 0, DOTNUM*2 );
//*
       }
//*/
   }