
// --------------------------------------------------------------------------
//  Synth.h - SoftSynth.
//  Copyright (c) 2001. Remage / Fresh!mindworkz.
// --------------------------------------------------------------------------
// http://www.smartelectronix.com/musicdsp

#define SAMPLERATE 44100

// --------------------------------------------------------------------------

#define SYNTH_CTRL_FLOAT 0 // Value
#define SYNTH_CTRL_ENV_LINEAR 4 // Time1, Value1, Time2, Value2, ...
#define SYNTH_CTRL_ENV_SPLINE 8
#define SYNTH_CTRL_ENV_LOG 12 // Value0, Value1, Length, Curve
#define SYNTH_CTRL_LFO_SINE 16 // Value, Width, Freq
#define SYNTH_CTRL_LFO_TRIANGLE 20

// --------------------------------------------------------------------------

#define SYNTH_FILTER_STATE_LOW12 0
#define SYNTH_FILTER_STATE_BAND12 4
#define SYNTH_FILTER_STATE_HIGH12 8
#define SYNTH_FILTER_STATE_NOTCH12 12

#define SYNTH_FILTER_MOOG1_LOW24 16

#define SYNTH_FILTER_MOOG2_LOW24 20
#define SYNTH_FILTER_MOOG2_BAND6 24
#define SYNTH_FILTER_MOOG2_HIGH6 28

#define SYNTH_FILTER_MOOG3_LOW24 32

// --------------------------------------------------------------------------

#define SYNTH_WAVE_SINE 0 // Waveforms.
#define SYNTH_WAVE_PULSE 4
#define SYNTH_WAVE_SAW 8
#define SYNTH_WAVE_TRIANGLE 12

#define SYNTH_WAVE_SAMPLE 16 // Special, Custom Sample Interpolation.

// --------------------------------------------------------------------------

typedef struct 
  { 
    char Type;
    float Values[32];
   } SYNTH_CONTROL;

typedef struct
  {
    unsigned int Length;
    float *Ptr;
   } SYNTH_BUFFER;

// --------------------------------------------------------------------------

extern "C" int __stdcall Synth_Initialize( void );
extern "C" void __stdcall Synth_Cleanup( void );

SYNTH_BUFFER *Synth_BufferInitialize( float Length );
SYNTH_BUFFER *Synth_BufferCopy( SYNTH_BUFFER *SrcBuf );
void Synth_BufferCleanup( SYNTH_BUFFER *Buf );

void Synth_Amplify( SYNTH_BUFFER *Buf, float Ampl );
void Synth_Normalize( SYNTH_BUFFER *Buf );

float Synth_Interpolate_Spline( float F0, float F1, float F2, float F3, float Time );

float Synth_ControlValue( SYNTH_CONTROL *Ctrl, float Time );

void Synth_GenerateWave( SYNTH_BUFFER *Buf, char Wave, unsigned char NoiseFreq, float NoiseAmpl, SYNTH_CONTROL *FreqCtrl, SYNTH_CONTROL *DistCtrl, SYNTH_CONTROL *AmplCtrl, SYNTH_CONTROL *PanCtrl );
void Synth_DistortWave( SYNTH_BUFFER *Buf, SYNTH_CONTROL *DistCtrl, SYNTH_CONTROL *DryWetCtrl );
void Synth_FilterWave( SYNTH_BUFFER *Buf, char Type, SYNTH_CONTROL *Cutoff, SYNTH_CONTROL *Resonance, SYNTH_CONTROL *DryWetCtrl );

void Synth_Reverb( SYNTH_BUFFER *Buf, SYNTH_CONTROL *RoomSizeCtrl, SYNTH_CONTROL *WidthCtrl, SYNTH_CONTROL *DampCtrl, SYNTH_CONTROL *FeedBackCtrl, SYNTH_CONTROL *DryWetCtrl );

void Synth_ChorusFlange( SYNTH_BUFFER *Buf, SYNTH_CONTROL *DelayCtrl, SYNTH_CONTROL *FeedBackCtrl, SYNTH_CONTROL *DryWetCtrl );
