# Features & Roadmap

## ✅ What's Already Working (v1.0 Prototype)

### Core Functionality
- [x] **Netflix-style browse interface** with horizontal rows
- [x] **Remote control navigation** (D-pad up/down/left/right)
- [x] **Focus-based UI** optimized for TV viewing
- [x] **YouTube video playback** in fullscreen
- [x] **Multiple category rows** (Farbrausch, 64k, Amiga, etc.)
- [x] **Real demo metadata** from pouet.net
- [x] **Working YouTube links** for all demos
- [x] **Thumbnail loading** with Glide
- [x] **Production info display** (group, year, platform, type)

### Pre-Loaded Content
- [x] **15+ legendary demos** hardcoded
- [x] **5 category rows**:
  - Farbrausch Classics
  - Top Rated 64k Intros
  - Amiga Legends  
  - Modern PC Demos
  - 4k Intros
- [x] **Real productions** including:
  - fr-043: rove
  - fr-041: debris
  - Elevated
  - State of the Art
  - Chaos Theory
  - And more!

### Technical Features
- [x] **Android TV Leanback library** integration
- [x] **WebView-based YouTube player**
- [x] **Image caching** with Glide
- [x] **Kotlin coroutines** ready for async API calls
- [x] **OkHttp** dependency ready for pouet.net API
- [x] **Gson** for JSON parsing
- [x] **Material Design 3** theming
- [x] **Landscape-only** orientation lock
- [x] **TV launcher intent** configured

### UI/UX
- [x] **10-foot interface design**
- [x] **Large, readable text**
- [x] **High-contrast colors** (blue/cyan on black)
- [x] **Card-based demo display** with thumbnails
- [x] **Smooth focus animations**
- [x] **Proper back button handling**

## 🚧 Phase 2: Live Data Integration

### pouet.net API Integration
- [ ] **API client implementation**
  - [ ] Production search endpoint
  - [ ] Production details endpoint
  - [ ] Party listings endpoint
  - [ ] Group listings endpoint
  - [ ] Platform filtering
- [ ] **Replace mock data** with live API calls
- [ ] **Caching strategy** (Room database)
- [ ] **Offline mode** with cached data
- [ ] **Error handling** for API failures
- [ ] **Loading states** with proper UI feedback

### Enhanced Categories
- [ ] **Dynamic categories** from API
- [ ] **More platform options**:
  - [ ] MS-DOS
  - [ ] Atari ST
  - [ ] C64
  - [ ] ZX Spectrum
  - [ ] Modern platforms (WebGL, etc.)
- [ ] **Party-based categories**:
  - [ ] Assembly
  - [ ] Revision
  - [ ] Evoke
  - [ ] Function
  - [ ] Deadline
- [ ] **Type-based categories**:
  - [ ] Musicdisks
  - [ ] Wild compo
  - [ ] Oldskool demos
  - [ ] Newskool demos

## 🎯 Phase 3: Search & Discovery

### Search Features
- [ ] **Text search** with on-screen keyboard
- [ ] **Voice search** ("Find Farbrausch demos")
- [ ] **Filter by**:
  - [ ] Platform
  - [ ] Year/decade
  - [ ] Group
  - [ ] Party
  - [ ] Rating
  - [ ] Type
- [ ] **Search history**
- [ ] **Search suggestions** as you type

### Discovery Features
- [ ] **Trending demos** (most viewed this week/month)
- [ ] **New releases** (latest additions to pouet.net)
- [ ] **Random demo** button
- [ ] **Related demos** after watching
- [ ] **"More from this group"** links
- [ ] **"More from this party"** links
- [ ] **Similar demos** recommendations

## 💾 Phase 4: Personalization

### User Features
- [ ] **Favorites/Watchlist**
  - [ ] Add to favorites
  - [ ] Organize into lists
  - [ ] Sync across devices (optional)
- [ ] **Watch history**
  - [ ] Continue watching
  - [ ] Recently watched row
  - [ ] Clear history option
- [ ] **Viewing preferences**
  - [ ] Default video quality
  - [ ] Auto-play next
  - [ ] Default platform filter
  - [ ] Theme options (dark/light/retro)

### Social Features
- [ ] **Ratings integration** from pouet.net
- [ ] **Comments display** from pouet.net
- [ ] **Share demo** via Android share sheet
- [ ] **Add to party queue** (for demoparty organizers)

## 🎬 Phase 5: Enhanced Playback

### Video Features
- [ ] **Native YouTube player** (instead of WebView)
- [ ] **Picture-in-Picture** mode
- [ ] **Queue system**:
  - [ ] Add demos to queue
  - [ ] Play queue in order
  - [ ] Shuffle queue
- [ ] **Auto-play next** in category
- [ ] **Playback controls overlay**:
  - [ ] Pause/Play
  - [ ] Skip forward/backward
  - [ ] Speed control
  - [ ] Quality selection
- [ ] **Chromecast support** (cast to other TVs)
- [ ] **Audio-only mode** (for musicdisks)

### Alternative Sources
- [ ] **Direct downloads** (link to production files)
- [ ] **Multiple YouTube captures** (choose quality)
- [ ] **scene.org integration** for original files
- [ ] **Archive.org links** for preservation

## 📱 Phase 6: Multi-Platform

### Android Devices
- [ ] **Android mobile version** (phone/tablet)
  - [ ] Touch-optimized UI
  - [ ] Portrait mode support
  - [ ] Mobile navigation patterns
- [ ] **Android tablet optimization**
  - [ ] Two-pane layout
  - [ ] Landscape/portrait
- [ ] **Chromecast sender** from phone

### Other Platforms
- [ ] **Fire TV support** (Amazon Fire Stick)
- [ ] **Google TV specific features**
- [ ] **Web version** (React/Vue app)
- [ ] **Desktop app** (Electron)
- [ ] **iOS/tvOS** (if using React Native)

## 🎨 Phase 7: Polish & Features

### UI Enhancements
- [ ] **Custom app banner** (320x180)
- [ ] **Custom launcher icon**
- [ ] **Animated background** (procedural demo-style)
- [ ] **Smooth transitions** between screens
- [ ] **Hero demo** auto-play preview
- [ ] **Featured demo** of the week
- [ ] **Seasonal themes** (Christmas, demoparty time, etc.)

### Advanced Features
- [ ] **Parental controls** (for explicit wild compo entries)
- [ ] **Download for offline** (cache YouTube videos)
- [ ] **Party mode** (big screen display for events)
- [ ] **Kiosk mode** (for demoparty info screens)
- [ ] **Multiple user profiles**
- [ ] **Kids mode** (curated safe content)

### Notifications
- [ ] **New demo alerts** from favorite groups
- [ ] **Party starting soon** notifications
- [ ] **New releases** weekly digest
- [ ] **Recommended demos** based on watch history

## 🔧 Phase 8: Developer Features

### API & Integration
- [ ] **Public API** for the app itself
- [ ] **Export watchlist** as JSON/CSV
- [ ] **Import from pouet.net** user account
- [ ] **Backup/restore** user data
- [ ] **Statistics dashboard** (personal viewing stats)

### Customization
- [ ] **Plugin system** for custom sources
- [ ] **Theme engine** for custom UI
- [ ] **Custom category builder**
- [ ] **CSV import** for custom demo lists

## 📊 Analytics & Insights (Optional)

### User-Friendly Stats
- [ ] **Your watching stats**:
  - [ ] Total demos watched
  - [ ] Favorite platform
  - [ ] Favorite group
  - [ ] Watch time
  - [ ] Most watched categories
- [ ] **Discover insights**:
  - [ ] "You might like..." suggestions
  - [ ] "Based on your history..."
  - [ ] Viewing patterns

### Respect Privacy
- [ ] All stats **local only** (no tracking)
- [ ] Opt-in anonymous usage stats
- [ ] Clear data option
- [ ] Export your data

## 🌍 Community Features

### Demoparty Integration
- [ ] **Live party schedules**
- [ ] **Streaming integration** (watch compos live)
- [ ] **Results integration** (show winners)
- [ ] **Party countdown** timers
- [ ] **Vote integration** (if available)

### Scene Community
- [ ] **Group profiles** with all their demos
- [ ] **Scener profiles** (if pouet.net supports)
- [ ] **Follow favorite groups**
- [ ] **Community highlights**
- [ ] **Demo of the month** (community voted)

## 🎯 What's Realistic?

### Can Do Solo
✅ **Phase 2**: pouet.net API integration (2-4 weeks)
✅ **Phase 3**: Search & basic discovery (2-3 weeks)
✅ **Phase 4**: Favorites & history (1-2 weeks)
✅ **Phase 7**: UI polish (ongoing)

### Would Need Help
⚠️ **Phase 5**: Advanced video features (complex)
⚠️ **Phase 6**: Multi-platform (different skillsets)
⚠️ **Phase 8**: Plugin system (architectural)

### Community Collaboration
🤝 **Content curation**: Which demos to feature
🤝 **Testing**: On different TV devices
🤝 **Translations**: Multi-language support
🤝 **Design**: Better icons/branding
🤝 **API**: pouet.net partnership

## 🚀 Realistic 6-Month Roadmap

### Month 1-2: Core Features
- pouet.net API integration
- Live data loading
- More categories
- Basic search

### Month 3-4: User Features
- Favorites/watchlist
- Watch history
- Better player controls
- UI polish

### Month 5-6: Discovery
- Recommendations
- Trending/new
- Related demos
- Community feedback integration

### Ongoing
- Bug fixes
- Performance optimization
- Community requests
- New demos as they release

## 💡 The Vision

A **one-stop app** where:
- Sceners can **browse their favorite demos** comfortably on TV
- **New people** can discover the demoscene easily
- **Demoparties** can showcase productions on big screens
- The **scene's history** is preserved and accessible
- **Modern demos** get the big-screen treatment they deserve

All while respecting:
- ✅ Original creators (proper attribution)
- ✅ pouet.net (using their API correctly)
- ✅ User privacy (no tracking)
- ✅ Scene culture (free, open, community-driven)

---

**Current Status**: ✅ **Phase 1 Complete**
**Next Up**: 🚧 **Phase 2 - pouet.net API**
**Dream Goal**: 🌟 Full-featured demoscene streaming platform
