# Quick Setup Guide for DemoScene TV

## 🚀 Getting Started in 5 Minutes

### Option 1: Android Studio (Easiest)

1. **Download Android Studio**: https://developer.android.com/studio
2. **Open the project**: 
   - Launch Android Studio
   - Click "Open"
   - Navigate to the DemoSceneTV folder
   - Click OK
3. **Wait for Gradle sync** (first time takes a few minutes)
4. **Create an Android TV emulator**:
   - Tools → Device Manager
   - Create Device → TV
   - Select "1080p Android TV" profile
   - Click Next → Download system image (API 33)
   - Finish
5. **Run the app**: Click the green Run button ▶️

### Option 2: Build APK for Real TV

1. Open project in Android Studio
2. Build → Build Bundle(s) / APK(s) → Build APK(s)
3. Wait for build to complete
4. Find APK at: `app/build/outputs/apk/debug/app-debug.apk`
5. Transfer to your Android TV via USB or network
6. Install using file manager or ADB

### Option 3: ADB Install (Advanced)

```bash
# Connect to your Android TV
adb connect YOUR_TV_IP:5555

# Build and install
./gradlew assembleDebug
adb install app/build/outputs/apk/debug/app-debug.apk

# Launch
adb shell am start -n com.demoscene.tv/.MainActivity
```

## 📱 First Time Using the App

1. **App launches** to main browse screen
2. **Use TV remote** D-pad to navigate:
   - Up/Down = Switch between rows
   - Left/Right = Browse demos
   - Center/OK = Select
3. **Select a demo** to see details
4. **Press "Play"** to watch on YouTube
5. **Press Back** on remote to return

## 🎮 Controls

| Button | Action |
|--------|--------|
| D-Pad Up/Down | Navigate between category rows |
| D-Pad Left/Right | Scroll through demos in row |
| Center/OK | Select demo or action |
| Back | Return to previous screen |
| Home | Exit to TV home screen |

## 🔧 Troubleshooting

### "Gradle sync failed"
- Check internet connection
- Tools → SDK Manager → ensure Android SDK Platform 34 is installed

### "No devices found"
- Create Android TV emulator (see Option 1, step 4)
- Or enable ADB on your real Android TV

### "YouTube not loading"
- Emulator: Use system image with Google Play
- Real device: Ensure internet connection

### "App crashes on launch"
- Check logcat in Android Studio
- Ensure minSdk is 21+ in build.gradle

## 📦 What's Included

- **15+ Real Demos** with YouTube links:
  - Farbrausch (rove, debris, .the .product)
  - Future Crew (Second Reality, Unreal)
  - Classic Amiga demos
  - Modern masterpieces
- **5 Categories** ready to browse
- **Full YouTube integration** for playback
- **TV-optimized UI** with remote control support

## 🎯 Next Steps

After you get it running, you can:

1. **Add more demos** in `DemoDataProvider.kt`
2. **Create new categories** by editing the category list
3. **Integrate pouet.net API** for dynamic data
4. **Customize colors** in `res/values/colors.xml`
5. **Add your own features**!

## 💡 Tips

- **Use emulator keyboard** if you don't have a TV remote:
  - Arrow keys = D-pad
  - Enter = OK/Select
  - Esc = Back

- **Background changes** when you hover over demos (cool effect!)

- **YouTube embeds** work best with hardware acceleration enabled

## 🐛 Known Issues (It's a Prototype!)

- No real pouet.net API integration (hardcoded data)
- Missing proper error handling
- No loading indicators
- Placeholder images need to be added
- Search not implemented yet

This is a "dirty" prototype - it works but needs polish for production!

## 📚 Learn More

- **Android TV Development**: https://developer.android.com/training/tv
- **Leanback Library**: https://developer.android.com/reference/androidx/leanback/package-summary
- **pouet.net**: https://www.pouet.net
- **Scene.org**: https://www.scene.org

---

Enjoy watching demos on your TV! 🎨📺
