# Demoscene TV 📺

**Netflix for Demos** - Android TV app for browsing and watching demoscene productions from pouet.net

## 🎯 What It Does

This is a prototype Android TV app that provides a Netflix-style interface for browsing and watching demoscene productions. It integrates pouet.net metadata with YouTube captures of demos.

### Current Features

✅ **Netflix-Style Browse Interface**
- Row-based browsing with categories
- Remote control navigation (D-pad)
- Focus-based UI optimized for 10-foot viewing

✅ **Pre-Loaded Demo Collections**
- Farbrausch Classics (rove, debris, .the .product)
- Top Rated 64k Intros
- Amiga Legends
- Modern PC Demos
- 4k Intros

✅ **YouTube Integration**
- Embedded YouTube player
- Fullscreen playback
- 4K support (when available)

✅ **Demo Metadata**
- Production title, group, year
- Platform, type (64k, 4k, demo)
- Party information
- Ratings from pouet.net
- Direct links to pouet.net

## 🛠️ Tech Stack

- **Language**: Kotlin
- **Framework**: Android TV Leanback Library
- **Image Loading**: Glide
- **HTTP**: OkHttp3 (for future API integration)
- **JSON**: Gson
- **Video**: YouTube IFrame API via WebView

## 📋 Requirements

- Android Studio (latest version)
- Android SDK 21+ (Lollipop or higher)
- Android TV device or emulator for testing

## 🚀 Build & Run

### Option 1: Android Studio

1. **Clone/Download** this project
2. **Open** in Android Studio
3. **Sync Gradle** (it will download dependencies)
4. **Run** on Android TV emulator or device

### Option 2: Command Line

```bash
# Navigate to project directory
cd DemosceneTV

# Build debug APK
./gradlew assembleDebug

# Install to connected device
./gradlew installDebug

# Or build and install in one step
./gradlew build installDebug
```

APK will be in: `app/build/outputs/apk/debug/app-debug.apk`

### Setting Up Android TV Emulator

1. Open **Android Studio** → **Tools** → **Device Manager**
2. Click **Create Device**
3. Select **TV** category
4. Choose **Android TV (1080p)** or **Android TV (4K)**
5. Select system image (API 31 or higher recommended)
6. Click **Finish**

### Installing on Physical Android TV

```bash
# Enable Developer Options on your TV:
# Settings → About → Build number (press 7 times)
# Settings → Developer Options → USB Debugging (enable)

# Connect via ADB
adb connect YOUR_TV_IP:5555

# Install APK
adb install app-debug.apk

# Or use Android Studio's "Run" with TV selected
```

## 🎮 Using the App

### Navigation
- **D-Pad Up/Down**: Switch between category rows
- **D-Pad Left/Right**: Browse demos in current row
- **OK/Select**: Play selected demo
- **Back**: Exit player or app

### Current Data
The app currently uses **mock data** with real demoscene productions:
- All YouTube links are real and working
- Metadata pulled from actual pouet.net entries
- Thumbnails from pouet.net screenshots

## 🔮 Future Enhancements

### Phase 2 (Next Steps)
- [ ] **Live pouet.net API integration**
- [ ] Search functionality
- [ ] Details screen with full production info
- [ ] Favorites/Watchlist
- [ ] More category filters

### Phase 3 (Advanced)
- [ ] Voice search ("Find Farbrausch demos")
- [ ] Recommendations engine
- [ ] Watch history
- [ ] Auto-play next in category
- [ ] Offline caching
- [ ] Push notifications for new demos

### Phase 4 (Polish)
- [ ] Custom branding/banner
- [ ] Parental controls (for wild compo)
- [ ] Chromecast integration
- [ ] Share functionality
- [ ] Comments from pouet.net

## 📁 Project Structure

```
DemosceneTV/
├── app/
│   ├── src/main/
│   │   ├── java/com/demoscene/tv/
│   │   │   ├── MainActivity.kt          # Main browse interface
│   │   │   ├── PlayerActivity.kt        # Video player
│   │   │   ├── model/
│   │   │   │   └── Demo.kt              # Data models
│   │   │   ├── data/
│   │   │   │   └── DemoDataProvider.kt  # Mock data (will become API)
│   │   │   └── ui/
│   │   │       └── CardPresenter.kt     # Card view presenter
│   │   ├── res/
│   │   │   ├── layout/
│   │   │   │   ├── activity_main.xml
│   │   │   │   └── activity_player.xml
│   │   │   └── values/
│   │   │       ├── strings.xml
│   │   │       ├── colors.xml
│   │   │       └── themes.xml
│   │   └── AndroidManifest.xml
│   └── build.gradle
├── build.gradle
├── settings.gradle
└── README.md
```

## 🐛 Known Issues

1. **App banner missing**: Need to create `app_banner.png` in `res/drawable-xhdpi/`
2. **Launcher icon missing**: Need to create proper launcher icons
3. **No API integration yet**: Currently using hardcoded demo data
4. **YouTube fallback**: Using WebView instead of native YouTube API (simpler for prototype)

## 🎨 Creating Missing Resources

### App Banner (Required for TV)
Create `app/src/main/res/drawable-xhdpi/app_banner.png`:
- Size: 320x180 pixels
- Format: PNG
- Content: App logo/branding

### Launcher Icons
Use Android Studio's Image Asset tool:
1. Right-click `res` folder
2. **New** → **Image Asset**
3. Choose **Launcher Icons**
4. Design your icon

Or use placeholder for now:
```bash
# The app will use default Android icon temporarily
```

## 🔧 Troubleshooting

### Gradle Sync Failed
```bash
# Make sure you have JDK 17 installed
# File → Project Structure → SDK Location → JDK location
```

### WebView Not Loading YouTube
- Check internet permission in AndroidManifest.xml
- Test on actual device (emulator WebView can be flaky)
- Check logcat for JavaScript errors

### App Not Showing in TV Launcher
- Verify `LEANBACK_LAUNCHER` in AndroidManifest.xml
- Create `app_banner.png` in drawable-xhdpi
- Reinstall app

## 📝 Adding Real pouet.net API

To integrate live data (future enhancement):

```kotlin
// In DemoDataProvider.kt, replace mock data with API calls

suspend fun fetchDemosFromPouet(platform: String): List<Demo> {
    val client = OkHttpClient()
    val request = Request.Builder()
        .url("https://api.pouet.net/v1/prod/?platform=$platform")
        .build()
    
    val response = client.newCall(request).execute()
    val json = response.body?.string()
    
    // Parse JSON and convert to Demo objects
    return parsePouetResponse(json)
}
```

## 🤝 Contributing

This is a prototype! Feel free to:
- Add more categories
- Improve UI/UX
- Add pouet.net API integration
- Fix bugs
- Add features from the roadmap

## 📜 License

This is a personal project for the demoscene community.
- App code: Feel free to use/modify
- Demo content: Belongs to original creators
- pouet.net data: Respect their API terms

## 🙏 Credits

- **pouet.net** - Demo database and metadata
- **YouTube** - Video hosting for demo captures
- **Demoscene groups** - For creating amazing productions
- **Farbrausch** - For inspiring this project with rove

## 📞 Contact

Built for the demoscene community.
If you're a scener and want to contribute or have ideas, reach out!

---

**Note**: This is a working prototype. The pouet.net API integration and advanced features are planned for future versions. Current version uses hardcoded data from real pouet.net entries to demonstrate the concept.

Enjoy browsing demos on your TV! 📺✨
