package com.demoscene.tv.ui
import android.graphics.Color
import android.graphics.drawable.Drawable
import android.view.ViewGroup
import androidx.leanback.widget.ImageCardView
import androidx.leanback.widget.Presenter
import com.bumptech.glide.Glide
import com.demoscene.tv.model.Demo
import kotlin.properties.Delegates
class CardPresenter : Presenter() {
    private var mDefaultCardImage: Drawable? = null
    override fun onCreateViewHolder(parent: ViewGroup): ViewHolder {
        val cardView = object : ImageCardView(parent.context) {
            override fun setSelected(selected: Boolean) {
                if (selected) {
                    setInfoAreaBackgroundColor(Color.parseColor("#CC1565C0"))
                } else {
                    setInfoAreaBackgroundColor(Color.parseColor("#CC000000"))
                }
                super.setSelected(selected)
            }
        }
        cardView.isFocusable = true
        cardView.isFocusableInTouchMode = true
        cardView.setInfoAreaBackgroundColor(Color.parseColor("#CC000000"))
        return ViewHolder(cardView)
    }
    override fun onBindViewHolder(viewHolder: ViewHolder, item: Any) {
        val demo = item as Demo
        val cardView = viewHolder.view as ImageCardView
        cardView.titleText = demo.title
        cardView.contentText = demo.group + " (" + demo.year.toString() + ") - " + demo.platform
        cardView.setMainImageDimensions(CARD_WIDTH, CARD_HEIGHT)
        Glide.with(viewHolder.view.context)
            .load(demo.thumbnailUrl)
            .centerCrop()
            .error(mDefaultCardImage)
            .into(cardView.mainImageView!!)
    }
    override fun onUnbindViewHolder(viewHolder: ViewHolder) {
        val cardView = viewHolder.view as ImageCardView
        cardView.badgeImage = null
        cardView.mainImage = null
    }
    companion object {
        private const val CARD_WIDTH = 313
        private const val CARD_HEIGHT = 176
    }
}
