# DemoScene TV - Android TV App

A Netflix-style browser for demoscene productions with YouTube integration.

## 🎯 Features

- **Netflix-Style Interface**: Browse demos in horizontal rows by category
- **YouTube Integration**: Watch demo captures directly on your TV
- **Remote Control Navigation**: Full D-pad support for TV remotes
- **Categories**: 
  - Farbrausch Classics
  - Top Rated 64k Intros
  - Classic PC Demos
  - Amiga Classics
  - Modern Masterpieces

## 🚀 Quick Start

### Prerequisites
- Android Studio Arctic Fox or later
- Android SDK 21+ (Lollipop)
- Android TV device or emulator

### Building

1. Open the project in Android Studio
2. Sync Gradle files
3. Build the APK: `Build > Build Bundle(s) / APK(s) > Build APK(s)`
4. Or run directly: `Run > Run 'app'`

### Installation

**On Android TV Device:**
```bash
adb install app/build/outputs/apk/debug/app-debug.apk
```

**Using Android Studio:**
1. Connect Android TV device via ADB
2. Click Run button
3. Select your TV from the device list

## 📱 Usage

### Navigation
- **D-Pad Up/Down**: Move between category rows
- **D-Pad Left/Right**: Scroll through demos in a row
- **Select/OK**: Open demo details or play
- **Back**: Return to previous screen

### Watching Demos
1. Browse through categories
2. Select a demo to see details
3. Click "Play" to watch on YouTube
4. Press Back to return to browsing

## 🏗️ Project Structure

```
DemoSceneTV/
├── app/
│   ├── src/main/
│   │   ├── java/com/demoscene/tv/
│   │   │   ├── MainActivity.kt          # Entry point
│   │   │   ├── MainFragment.kt          # Browse fragment
│   │   │   ├── CardPresenter.kt         # Demo card display
│   │   │   ├── DetailsActivity.kt       # Demo details
│   │   │   ├── DetailsFragment.kt       # Details fragment
│   │   │   ├── PlaybackActivity.kt      # YouTube player
│   │   │   ├── model/
│   │   │   │   └── Demo.kt             # Data model
│   │   │   └── data/
│   │   │       └── DemoDataProvider.kt  # Demo data
│   │   ├── res/
│   │   │   ├── layout/                  # XML layouts
│   │   │   ├── values/                  # Colors, strings
│   │   │   └── drawable/                # Images
│   │   └── AndroidManifest.xml
│   └── build.gradle
└── README.md
```

## 🎨 Current Demo Data

The app includes curated demos from:
- **Farbrausch**: fr-043: rove, fr-041: debris, fr-08: .the .product
- **Future Crew**: Second Reality, Unreal
- **The Black Lotus**: Tint
- **Rgba & TBC**: Elevated
- And many more classics!

All demos have real YouTube links for immediate playback.

## 🔧 Technical Details

### Libraries Used
- **AndroidX Leanback**: TV UI components
- **Glide**: Image loading and caching
- **Retrofit**: HTTP client (for future pouet.net API)
- **Kotlin Coroutines**: Async operations
- **WebView**: YouTube playback

### YouTube Integration
Uses embedded YouTube player via WebView with:
- Autoplay enabled
- Fullscreen support
- Minimal controls for TV viewing
- No ads (YouTube embedded player policy)

## 🚧 Future Enhancements

### Short Term
- [ ] Add search functionality
- [ ] Implement favorites/watchlist
- [ ] Add more demo categories
- [ ] Voice search support

### Medium Term
- [ ] Real pouet.net API integration
- [ ] Dynamic data loading
- [ ] User preferences
- [ ] Watch history

### Long Term
- [ ] Chromecast support
- [ ] Offline viewing
- [ ] Push notifications for new demos
- [ ] Community features
- [ ] Party schedule integration

## 🌐 pouet.net API Integration

Currently uses hardcoded demo data. To integrate with pouet.net API:

1. Add Retrofit interface for pouet.net
2. Parse API responses
3. Map to Demo model
4. Update DemoDataProvider to fetch live data

Example API endpoints:
- `https://api.pouet.net/v1/prod/?id=DEMO_ID`
- `https://api.pouet.net/v1/search/?query=SEARCH_TERM`

## 📝 Notes

### Why WebView for YouTube?
The official YouTube Android Player API is deprecated. Using WebView with embedded player is the recommended approach and works well on Android TV.

### Performance
- Images are cached by Glide
- Lazy loading for demo cards
- Background changes are debounced (300ms)

### Compatibility
- Tested on Android TV 9.0+
- Works on Google TV (Chromecast)
- Compatible with Nvidia Shield
- Should work on Fire TV with minor adjustments

## 🤝 Contributing

This is a proof-of-concept "dirty" prototype. To make it production-ready:

1. Implement real pouet.net API integration
2. Add proper error handling
3. Improve UI/UX polish
4. Add analytics and crash reporting
5. Optimize for performance
6. Add unit and integration tests
7. Create proper icon and banner assets
8. Implement background services for updates

## 📄 License

This is a prototype app for the demoscene community. 

**Important**: Demo content and metadata belong to their respective creators and are pulled from public sources (YouTube, pouet.net). This app is a viewer only and does not host any content.

## 🎬 Credits

- **Demoscene Groups**: All the amazing groups whose demos are featured
- **pouet.net**: For maintaining the demoscene database
- **YouTube**: For hosting demo captures
- **Scene.org**: For preserving demoscene history

---

**Made for the demoscene community** 🎨

Watch demos on the big screen they deserve!
