/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.BDFileSystem;
import java.io.File;
import java.io.IOException;
import org.videolan.BDJSecurityManager;
import org.videolan.LockFile;
import org.videolan.Logger;

class CacheDir {
    private static File cacheRoot = null;
    private static LockFile lockFile = null;
    private static File baseDir = null;
    private static final Logger logger = Logger.getLogger(CacheDir.class.getName());

    CacheDir() {
    }

    private static LockFile lockCache(String path) {
        return LockFile.create(path + File.separator + "lock");
    }

    private static synchronized void InitializeBaseDir() throws IOException {
        if (baseDir == null) {
            try {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"), "libbluray-bdj-cache");
                baseDir = new File(tmpDir.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error("Error in initializing baseDir " + e);
                throw e;
            }
        }
    }

    private static void cleanupCache() throws IOException {
        CacheDir.InitializeBaseDir();
        String[] files = BDFileSystem.nativeList(baseDir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                LockFile lock;
                File dir = new File(baseDir, files[i]);
                if (!dir.isDirectory() || (lock = CacheDir.lockCache(dir.getPath())) == null) continue;
                lock.release();
                CacheDir.removeImpl(dir);
            }
        }
    }

    private static synchronized File getCacheRoot() throws IOException {
        BDJSecurityManager sm = (BDJSecurityManager)System.getSecurityManager();
        if (cacheRoot != null) {
            if (sm != null) {
                sm.setCacheRoot(cacheRoot.getPath());
            }
            return cacheRoot;
        }
        if (sm != null) {
            CacheDir.InitializeBaseDir();
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            sm.setCacheRoot(tmpDir.getCanonicalPath());
            if (!baseDir.isDirectory() && !baseDir.mkdirs()) {
                logger.error("Error creating directory " + baseDir.getPath());
            }
            sm.setCacheRoot(baseDir.getCanonicalPath());
        }
        CacheDir.cleanupCache();
        for (int i = 0; i < 100; ++i) {
            File tmpDir = new File(baseDir, Long.toHexString(System.nanoTime() + (long)i));
            if ((tmpDir = new File(tmpDir.getCanonicalPath())).mkdirs()) {
                cacheRoot = tmpDir;
                lockFile = CacheDir.lockCache(cacheRoot.getPath());
                logger.info("Created cache in " + tmpDir.getPath());
                if (sm != null) {
                    sm.setCacheRoot(cacheRoot.getPath());
                }
                return cacheRoot;
            }
            logger.error("error creating " + tmpDir.getPath());
        }
        logger.error("failed to create temporary cache directory");
        throw new IOException();
    }

    public static synchronized File create(String domain) throws IOException {
        File tmpDir = new File(CacheDir.getCacheRoot(), domain);
        if (!tmpDir.isDirectory() && !tmpDir.mkdirs()) {
            logger.error("Error creating directory " + tmpDir.getPath());
            throw new IOException();
        }
        return tmpDir;
    }

    public static File create(String domain, String name) throws IOException {
        return CacheDir.create(domain + File.separator + name);
    }

    private static void removeImpl(File dir) {
        String[] files = BDFileSystem.nativeList(dir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (file.isDirectory()) {
                    CacheDir.removeImpl(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.info("Error removing " + file.getPath());
            }
        }
        if (!dir.delete()) {
            logger.error("Error removing " + dir.getPath());
        }
    }

    public static synchronized void remove(File dir) {
        String path = dir.getPath();
        if (path.indexOf(cacheRoot.getPath()) != 0) {
            logger.error("Error removing " + dir.getPath() + ": not inside cache !");
            return;
        }
        if (path.indexOf("..") >= 0) {
            logger.error("Error removing " + dir.getPath() + ": not canonical path !");
            return;
        }
        CacheDir.removeImpl(dir);
    }

    public static synchronized void remove() {
        if (lockFile != null) {
            lockFile.release();
            lockFile = null;
        }
        if (cacheRoot != null) {
            CacheDir.remove(cacheRoot);
            cacheRoot = null;
        }
    }
}

